jQuery(document).ready(function($){
    const Home = Dejavo_vars.home_url;
    const Dej_Ajax = Home + "/dej_ajax";

    $(document).on('submit', 'form.dejavo_change_pass', function (e) {
        e.preventDefault();

        const dej_url = Dej_Ajax + "/dej_change_pass/";
        let pass1 = $('input[name="dej_password_1"]');
        let pass2 = $('input[name="dej_password_2"]');
        let nonc = $('input[name="dejavo_pass_change-nonce"]');

        $.ajax({
            type: 'POST',
            url: dej_url,
            data: { pass1: pass1.val(), pass2: pass2.val(), nonce: nonc.val() },
            beforeSend: function () {
                $('.dejavo_change_pass').removeClass('success error');
                $('.dejavo_change_pass button').html(Dejavo_vars.sending);
            },
            success: function (resp) {
                $('.dejavo_change_pass button').html(Dejavo_vars.save_p);
                $('.dejavo_change_pass .dej_status').html(resp.data.text);
                $('.dejavo_change_pass').addClass('success');
            },
            error: function( xhr ){
                let message = xhr.responseJSON !== undefined ? xhr.responseJSON.data.text : 'حطا';
                $('.dejavo_change_pass button').html(Dejavo_vars.save_p);
                $('.dejavo_change_pass').addClass('error');
                $('.dejavo_change_pass .dej_status').html(message);
            },
        });
    });

    $(document).on('submit', 'form.dejavo_bank_info', function (e) {
        e.preventDefault();

        const sub_url = Dej_Ajax + "/dej_bank_info/";
        let b_name = $('input[name="bank_name"]');
        let b_cart = $('input[name="bank_cart_num"]');
        let b_sheba = $('input[name="bank_sheba"]');
        let b_num = $('input[name="bank_num"]');
        let nonc = $('input[name="dejavo-nonce"]');

        $.ajax({
            type: 'POST',
            url: sub_url,
            data: { name: b_name.val(), cart: b_cart.val(), sheba: b_sheba.val(), num: b_num.val(), nonce: nonc.val() },
            beforeSend: function () {
                $('.dejavo_bank_info').removeClass('success error');
                $('.dejavo_bank_info button').html(Dejavo_vars.sending);
            },
            success: function (resp) {
                $('.dejavo_bank_info button').html(Dejavo_vars.save_p);
                $('.dejavo_bank_info .dej_status').html(resp.data.text);
                $('.dejavo_bank_info').addClass('success');
            },
            error: function( xhr ){
                let message = xhr.responseJSON !== undefined ? xhr.responseJSON.data.text : 'حطا';
                $('.dejavo_bank_info button').html(Dejavo_vars.save_p);
                $('.dejavo_bank_info').addClass('error');
                $('.dejavo_bank_info .dej_status').html(message);
            },
        });
    });

    $(document).on('submit', 'form.dejavo_edit_account', function (e) {
        e.preventDefault();
        const edit_url = Dej_Ajax + "/dej_edit_account/";
        var edit_data = new FormData(this);
        $.ajax({
            type: 'POST',
            url: edit_url,
            cache: false,
            contentType: false,
            processData: false,
            data: edit_data,
            beforeSend: function () {
                $('.dejavo_edit_account').removeClass('success error');
                $('.dejavo_edit_account button').html(Dejavo_vars.sending);
            },
            success: function (resp) {
                $('.dejavo_edit_account button').html(Dejavo_vars.save_set);
                $('.dejavo_edit_account .dej_status').html(resp.data.text);
                $('.dejavo_edit_account').addClass('success');
            },
            error: function( xhr ){
                let message = xhr.responseJSON !== undefined ? xhr.responseJSON.data.text : 'حطا';
                $('.dejavo_edit_account button').html(Dejavo_vars.save_set);
                $('.dejavo_edit_account').addClass('error');
                $('.dejavo_edit_account .dej_status').html(message);
            },
        });
    });

});