'use strict';

window.DejavoVS = {};

(function(DejavoVS, $) {
  DejavoVS = DejavoVS || {};

  $.extend(DejavoVS, {
    Swatches: {
      init: function() {
        var $term = $('.DejavoVS-term'),
            $active_term = $('.DejavoVS-term:not(.DejavoVS-disabled)');

        // load default value
        $term.each(function() {
          var $this = $(this),
              term = $this.attr('data-term'),
              attr = $this.closest('.DejavoVS-terms').attr('data-attribute'),
              $select = $this.closest('.DejavoVS-terms').
              parent().find('select#' + attr);

          if (!$select.length) {
            $select = $this.closest('.DejavoVS-terms').parent().
            find('select[data-attribute_name="attribute_' + attr + '"]');
          }

          if (!$select.length) {
            $select = $this.closest('.DejavoVS-terms').parent().
            find('select[name="attribute_' + attr + '"]');
          }

          if ($select.length) {
            if ($select.val() !== '' && term === $select.val()) {
              $(this).addClass('DejavoVS-selected').find('input[type="radio"]').
              prop('checked', true);
            }
          }
        });

        $active_term.unbind('click touch').on('click touch', function(e) {
          if ($(this).hasClass('DejavoVS-disabled')) {
            return false;
          }

          var $this = $(this),
              term = $this.attr('data-term'),
              title = $this.attr('title'),
              attr = $this.closest('.DejavoVS-terms').attr('data-attribute'),
              $select = $this.closest('.DejavoVS-terms').parent().
              find('select#' + attr);

          if (!$select.length) {
            $select = $this.closest('.DejavoVS-terms').parent().
            find('select[data-attribute_name="attribute_' + attr + '"]');
          }

          if (!$select.length) {
            $select = $this.closest('.DejavoVS-terms').parent().
            find('select[name="attribute_' + attr + '"]');
          }

          if (!$select.length) {
            return false;
          }

          if (!$this.hasClass('DejavoVS-selected')) {
            $select.val(term).trigger('change');

            $this.closest('.DejavoVS-terms').
            find('.DejavoVS-selected').
            removeClass('DejavoVS-selected').
            find('input[type="radio"]').
            prop('checked', false);

            $this.addClass('DejavoVS-selected').
            find('input[type="radio"]').
            prop('checked', true);

            $(document).trigger('DejavoVS_selected', [attr, term, title]);
          } else {
            if (DejavoVS_vars.second_click === 'yes') {
              // second click
              $select.val('').trigger('change');

              $this.closest('.DejavoVS-terms').
              find('.DejavoVS-selected').
              removeClass('DejavoVS-selected').
              find('input[type="radio"]').
              prop('checked', false);

              $(document).trigger('DejavoVS_reset', [attr, term, title]);
            }
          }

          e.preventDefault();
        });

        // tooltip
        if (DejavoVS_vars.tooltip_lib === 'tippy') {
          tippy('.tippy-tooltip', {
            allowHTML: true,
            interactive: true,
          });
        }

        $(document).trigger('DejavoVS_init');
      },
    },
  });
}).apply(this, [window.DejavoVS, jQuery]);

(function(DejavoVS, $) {
  $(document).on('wc_variation_form', function() {
    if (typeof DejavoVS.Swatches !== 'undefined') {
      DejavoVS.Swatches.init();
    }
    $(document).trigger('DejavoVS_variation_form');
  });

  $(document).on('woocommerce_update_variation_values',
      function(e) {
        $(e['target']).find('select').each(function() {
          var $this = $(this);
          var $terms = $this.parent().parent().find('.DejavoVS-terms');

          $terms.find('.DejavoVS-term').
          removeClass('DejavoVS-enabled').
          addClass('DejavoVS-disabled');

          $this.find('option.enabled').each(function() {
            var val = $(this).val();

            $terms.find(
                '.DejavoVS-term[data-term="' + val + '"]').
            removeClass('DejavoVS-disabled').
            addClass('DejavoVS-enabled');
          });
        });
        $(document).trigger('DejavoVS_update_variation_values', [e]);
      });

  $(document).on('found_variation','', function(e, t) {
    if ($(e['target']).closest('.DejavoVS_archive').length &&
        $(e['target']).closest(DejavoVS_vars.archive_product).length) {
      var $product = $(e['target']).closest(DejavoVS_vars.archive_product);
      var $atc = $product.find(DejavoVS_vars.archive_atc);
      var $atc_text = $product.find(DejavoVS_vars.archive_atc_text);
      var $image = $product.find(DejavoVS_vars.archive_image);
      var $price = $product.find('.price');

      if ($atc.length) {
        $atc.addClass('DejavoVS_add_to_cart').
        attr('data-variation_id', t['variation_id']).
        attr('data-product_sku', t['sku']);

        if (!t['is_purchasable'] || !t['is_in_stock']) {
          $atc.addClass('disabled wc-variation-is-unavailable');
        } else {
          $atc.removeClass('disabled wc-variation-is-unavailable');
        }

        $atc.removeClass('added error loading');
      }

      $product.find('a.added_to_cart').remove();

      // if($('.add-to-cart').text().length > 0) {
      //   if ($atc_text.length) {
      //   //  $atc_text.text(DejavoVS_vars.add_to_cart);
      //   }
      // } else

      if ($atc_text.length) {
        $atc_text.attr("aria-label",DejavoVS_vars.add_to_cart);
      }


      if ($image.length) {
        // product image
        if ($image.attr('data-src') == undefined) {
          $image.attr('data-src', $image.attr('src'));
        }

        if ($image.attr('data-srcset') == undefined) {
          $image.attr('data-srcset', $image.attr('srcset'));
        }

        if (t['image']['thumb_src'] != undefined &&
            t['image']['thumb_src'] != '') {
          $image.attr('src', t['image']['thumb_src']);
        }

        if (t['image']['srcset'] != undefined &&
            t['image']['srcset'] != '') {
          $image.attr('srcset', t['image']['thumb_src']);
        } else {
          $image.attr('srcset', '');
        }

      }

      if ($price.length) {
        // product price
        if ($price.attr('data-price') == undefined) {
          $price.attr('data-price', $price.html());
        }

        if (t['price_html']) {
          $price.html(t['price_html']);
        }
      }

      $(document).trigger('DejavoVS_archive_found_variation', [t]);
    }
  });

  $(document).on('reset_data', '', function(e) {
    var $this = $(e['target']);

    $this.find('.DejavoVS-selected').
    removeClass('DejavoVS-selected').
    find('input[type="radio"]').
    prop('checked', false);

    $this.find('select').each(function() {
      var attr = $(this).attr('id');
      var title = $(this).find('option:selected').text();
      var term = $(this).val();

      if (term != '') {
        $(this).parent().parent().
        find('.DejavoVS-term[data-term="' + term + '"]').
        addClass('DejavoVS-selected').find('input[type="radio"]').
        prop('checked', true);

        $(document).trigger('DejavoVS_reset', [attr, term, title]);
      }
    });

    $(document).trigger('DejavoVS_reset_data', [$this]);

    // archive
    if ($this.closest('.DejavoVS_archive').length &&
        $this.closest(DejavoVS_vars.archive_product).length) {
      var $product = $this.closest(DejavoVS_vars.archive_product);
      var $atc = $product.find(DejavoVS_vars.archive_atc);
      var $atc_text = $product.find(DejavoVS_vars.archive_atc_text);
      var $image = $product.find(DejavoVS_vars.archive_image);
      var $price = $product.find('.price');

      if ($atc.length) {
        $atc.removeClass(
            'DejavoVS_add_to_cart disabled wc-variation-is-unavailable').
        attr('data-variation_id', '0').
        attr('data-product_sku', '');

        $atc.removeClass('added error loading');
      }

      $product.find('a.added_to_cart').remove();

      if ($atc_text.length) {
        // add to cart button text

        $atc_text.attr("aria-label",DejavoVS_vars.select_options);

      }

      if ($image.length) {
        // product image
        $image.attr('src', $image.attr('data-src'));
        $image.attr('srcset', $image.attr('data-srcset'));
        $image.attr('sizes', $image.attr('data-sizes'));
      }

      if ($price.length) {
        // product price
        $price.html($price.attr('data-price'));
      }

      $(document).trigger('DejavoVS_archive_reset_data');
    }
  });

  $(document).on('click touch', '.DejavoVS_add_to_cart', function(e) {
    e.preventDefault();
    var $btn = $(this);
    var $product = $btn.closest(DejavoVS_vars.archive_product);
    var attributes = {};

    $btn.removeClass('added error').addClass('loading');

    if ($product.length) {
      $product.find('a.added_to_cart').remove();

      $product.find('[name^="attribute"]').each(function() {
        attributes[$(this).attr('data-attribute_name')] = $(this).val();
      });

      var data = {
        action: 'DejavoVS_add_to_cart',
        nonce: DejavoVS_vars.nonce,
        product_id: $btn.attr('data-product_id'),
        variation_id: $btn.attr('data-variation_id'),
        quantity: $btn.attr('data-quantity'),
        attributes: JSON.stringify(attributes),
      };

      $.post(DejavoVS_vars.ajax_url, data, function(response) {
        if (response) {
          if (response.error && response.product_url) {
            window.location = response.product_url;
            return;
          }

          if ((typeof wc_add_to_cart_params !== 'undefined') &&
              (wc_add_to_cart_params.cart_redirect_after_add === 'yes')) {
            window.location = wc_add_to_cart_params.cart_url;
            return;
          }
          $btn.removeClass('loading').
          addClass('added');
          $(document.body).
          trigger('added_to_cart',
              [response.fragments, response.cart_hash, $btn]).
          trigger('wc_fragment_refresh');
        } else {
          $btn.removeClass('loading').addClass('error');
        }
      });

      $(document).trigger('DejavoVS_add_to_cart', [$btn, $product, attributes]);
    }
  });
}).apply(this, [window.DejavoVS, jQuery]);