jQuery(document).ready(function($){
    const Home = Dejavo_vars.home_url;
    const Dej_Ajax = Home + "/dej_ajax";
    $(document).on('submit', 'form.dejavo_track_order', function (e) {
        e.preventDefault();
        const dej_url = Dej_Ajax + "/dej_order_tracking/";
        let o_id = $('input[name="order_id"]').val();
        let o_mobile = $('input[name="mobile"]').val();
        let nonc = $('input[name="dej-order-tracking-nonce"]').val();

        let perNumPattern = /[\u06F0-\u06F9]/g; // matches all Persian digits
        let enNumMapping = {'۰': '0', '۱': '1', '۲': '2', '۳': '3', '۴': '4', '۵': '5', '۶': '6', '۷': '7', '۸': '8', '۹': '9'};
        let enPhone = o_mobile.replace(perNumPattern, function (match) {
            return enNumMapping[match];
        });
        let enID = o_id.replace(perNumPattern, function (match) {
            return enNumMapping[match];
        });

        $.ajax({
            type: 'POST',
            url: dej_url,
            data: { order_id: enID, mobile: enPhone, nonce: nonc },
            beforeSend: function () {
                $('.dejavo_track_order').removeClass('success error');
                $('.dejavo_ot_result').html('');
                $('.dejavo_track_order button').html(Dejavo_vars.sending);
            },
            success: function (resp) {

                $('.dejavo_ot_result').html(resp);
                $('.dejavo_track_order button').html(Dejavo_vars.order_track);
                $('.dejavo_track_order .dej_status').html(resp.data.text);
                $('.dejavo_track_order').addClass('success');

            },
            error: function( xhr ){
                let message = xhr.responseJSON !== undefined ? xhr.responseJSON.data.text : 'حطا';
                $('.dejavo_track_order button').html(Dejavo_vars.order_track);
                $('.dejavo_track_order').addClass('error');
                $('.dejavo_track_order .dej_status').html(message);
            },
        });
    });


    $(document).on('click touch', '.mfp-close', (function () {
        let videos = $('#dejavo_video').find('video');
        $(videos).each(function() {
            let video = $(this).get(0);
            video.pause();
            video.currentTime = 0;
        });
    }))

    $(document).on('click touch', '.dej_empty_cart', function(e) {
        e.preventDefault();
        const url = Dej_Ajax + "/dej_empty_cart/";
        let nonce = $('input[name="woocommerce-cart-nonce"]').val();
        $.ajax({
            type: 'POST',
            url: url,
            data: { nonce: nonce },
            beforeSend: function () {
                $( "[name='update_cart']" ).trigger( 'click' );
                $('.dej_empty_cart').html(Dejavo_vars.removing);
            },
            success: function (resp) {
                $(document.body).trigger('wc_update_cart');
                setTimeout(function () {
                    location.reload();
                }, 0);
                $("html, body").animate({scrollTop: 100}, 1500);
            },
            error: function( xhr ){
                let message = xhr.responseJSON !== undefined ? xhr.responseJSON.data.text : 'حطا';
                $('.dej_empty_cart').html(message);
            },
        });

    });

    $(document).on('change keyup', 'table.cart .qty', function() {
        const url = Dej_Ajax + "/dej_update_qty/";
        let nonce = $('input[name="woocommerce-cart-nonce"]').val();
        let item_key = $(this).closest('.woocommerce-cart-form__cart-item').attr('data-key');
        let item_qty = $(this).val();
        $.ajax({
            type: 'POST',
            url: url,
            data: { nonce: nonce, key: item_key, qty: item_qty },
            success: function (resp) {
                $(document.body).trigger('wc_update_cart');
            },
        });
    });


    $(document).on('click touch', 'table.cart .remove', function() {
        const url = Dej_Ajax + "/dej_remove_item/";
        let nonce = $('input[name="woocommerce-cart-nonce"]').val();
        let item_key = $(this).closest('.woocommerce-cart-form__cart-item').attr('data-key');
        $.ajax({
            type: 'POST',
            url: url,
            data: { nonce: nonce, key: item_key },
            success: function (resp) {
                $(document.body).trigger('wc_update_cart');
                if (resp.data.count === 0) {
                    $('.dejavo_wrapper').html('<div class="woocommerce">' + resp.data.content + '</div>');
                    $("html, body").animate({scrollTop: 0});
                }
            },
        });
    });

});



(function ($) { 'use strict';
    $(document).ready(function () {
        jQuery('.dej-product-gallery-slider img').removeAttr('srcset');
        $('.single-product-main-image img').load(function () {
            var imageObj = $('.single-product-main-image img');
            if (!(imageObj.width() == 1 && imageObj.height() == 1)) {
                $('.dej-thumb-main-image').attr('src', imageObj.attr('src'));
                $('.dej-thumb-main-image').trigger('click');
            }
        });
        var get_thumb_first = $(document).find('.dej-thumb-main-image');
        var get_main_first = $(document).find('.single-product-main-image');
        get_main_first.find('img').removeAttr('srcset');
        jQuery(this).on('show_variation', 'form.cart',function (event, variation) {
            get_thumb_first.removeAttr('srcset');
            var thumb_src = variation.image.gallery_thumbnail_src, variable_image_caption, first_thumb_src = get_main_first.find('img').attr("src");
            get_main_first.find('img').attr('src', variation.image.src);
            get_main_first.find('img').removeAttr('srcset');
            get_thumb_first.find('img').attr('src', thumb_src);
            $('.single-product-main-image .wp-post-image').on('load', function () {
                $('.dej-image').slick('slickGoTo', 0);
                $('.single-product-main-image').find('.zoomImg').attr('src', variation.image.url);
                if (get_main_first.find('.wp-post-image').data("o_img") == get_main_first.find('.wp-post-image').attr("src")) {
                    get_main_first.find('.woocommerce-product-gallery__lightbox').data('caption', get_main_first.find('.wp-post-image').data('caption'));
                    get_thumb_first.find('img').attr('src', get_thumb_first.find('img').data("thumb"));
                    $('.single-product-main-image').find('.zoomImg').attr('src', get_main_first.find('.wp-post-image').data("zoom_image"));
                }
            });
        });

    });
})(jQuery);


jQuery(document).on( 'click', '.woocommerce-widget-layered-nav-list__item a, .woocommerce-pagination a.page-numbers,.widget_layered_nav_filters a, .wc-layered-nav-rating a, .dej_orderby li a, .dejavo_filter_color li a, .dejavo_filter_brand li a', function(event) {

    var page_url = jQuery(this).attr('href');
    event.preventDefault();
    jQuery(".dej_shop_wrapper").addClass('loading');
    jQuery('html, body').animate({scrollTop:140},700);

    jQuery('.dej_shop_wrapper').load(page_url + ' .dej_shop_wrapper', function(responseTxt, statusTxt, xhr){

        jQuery(".dej_shop_wrapper").removeClass('loading');

        if(statusTxt == "success"){
            window.history.pushState({path:page_url},'',page_url);
            change_price_filter();
        }
        if(statusTxt == "error"){
            alert("Error: " + xhr.status + ": " + xhr.statusText);
        }
    });
});



jQuery(document).on( 'click', '.widget_price_filter .price_slider_wrapper .button', function( event ) {
    event.preventDefault();
    var href = '';
    var t    = jQuery(this);
    var form = t.parents('form'),
        l = window.location,
        shop_uri = l.origin + l.pathname,
        is_filtered = shop_uri != l.href,
        search = l.search,
        min_price = jQuery('.price_slider_amount #min_price').val(),
        max_price = jQuery('.price_slider_amount #max_price').val(),
        regex_min = new RegExp('^min_price', 'i'),
        regex_max = new RegExp('^max_price', 'i');
    href = l.href;

    if (is_filtered == true) {
        href = RemoveParaFromUrl(href, 'min_price');
        href = RemoveParaFromUrl(href, 'max_price');
    }

    var concat = shop_uri == href  ? '?' : '&';

    href = href + concat + jQuery.param(
        {
            min_price: min_price,
            max_price: max_price
        }
    );

    jQuery('html, body').animate({scrollTop:140},700);
    jQuery(".dej_shop_wrapper").addClass('loading');
    jQuery('.dej_shop_wrapper').load(href + ' .dej_shop_wrapper', function(responseTxt, statusTxt, xhr){
        jQuery(".dej_shop_wrapper").removeClass('loading');
        if(statusTxt == "success"){
            window.history.pushState({path:href},'',href);
            change_price_filter();
        }
        if(statusTxt == "error"){
            alert("Error: " + xhr.status + ": " + xhr.statusText);
        }
    });
});

function RemoveParaFromUrl(url, parameter) {
    return url
        .replace(new RegExp('[?&]' + parameter + '=[^&#]*(#.*)?$'), '$1')
        .replace(new RegExp('([?&])' + parameter + '=[^&]*&'), '$1');
}


function change_price_filter(){

    jQuery( function( $ ) {

        // woocommerce_price_slidr_params is required to continue ajax
        if ( typeof woocommerce_price_slider_params === 'undefined' ) {
            return false;
        }
        $( document.body ).bind( 'price_slider_create price_slider_slide', function( event, min, max ) {

            $( '.price_slider_amount span.from' ).html( accounting.formatMoney( min, {
                symbol:    woocommerce_price_slider_params.currency_format_symbol,
                decimal:   woocommerce_price_slider_params.currency_format_decimal_sep,
                thousand:  woocommerce_price_slider_params.currency_format_thousand_sep,
                precision: woocommerce_price_slider_params.currency_format_num_decimals,
                format:    woocommerce_price_slider_params.currency_format
            } ) );

            $( '.price_slider_amount span.to' ).html( accounting.formatMoney( max, {
                symbol:    woocommerce_price_slider_params.currency_format_symbol,
                decimal:   woocommerce_price_slider_params.currency_format_decimal_sep,
                thousand:  woocommerce_price_slider_params.currency_format_thousand_sep,
                precision: woocommerce_price_slider_params.currency_format_num_decimals,
                format:    woocommerce_price_slider_params.currency_format
            } ) );

            $( document.body ).trigger( 'price_slider_updated', [ min, max ] );
        });

        function init_price_filter() {
            $( 'input#min_price, input#max_price' ).hide();
            $( '.price_slider, .price_label' ).show();

            var min_price       = $( '.price_slider_amount #min_price' ).data( 'min' ),
                max_price         = $( '.price_slider_amount #max_price' ).data( 'max' ),
                step              = $( '.price_slider_amount' ).data( 'step' ) || 1,
                current_min_price = $( '.price_slider_amount #min_price' ).val(),
                current_max_price = $( '.price_slider_amount #max_price' ).val();

            $( '.price_slider:not(.ui-slider)' ).slider({
                range: true,
                animate: true,
                min: min_price,
                max: max_price,
                step: step,
                values: [ current_min_price, current_max_price ],
                create: function() {

                    $( '.price_slider_amount #min_price' ).val( current_min_price );
                    $( '.price_slider_amount #max_price' ).val( current_max_price );

                    $( document.body ).trigger( 'price_slider_create', [ current_min_price, current_max_price ] );
                },
                slide: function( event, ui ) {

                    $( 'input#min_price' ).val( ui.values[0] );
                    $( 'input#max_price' ).val( ui.values[1] );

                    $( document.body ).trigger( 'price_slider_slide', [ ui.values[0], ui.values[1] ] );
                },
                change: function( event, ui ) {

                    $( document.body ).trigger( 'price_slider_change', [ ui.values[0], ui.values[1] ] );
                }
            });
        }

        init_price_filter();

        var hasSelectiveRefresh = (
            'undefined' !== typeof wp &&
            wp.customize &&
            wp.customize.selectiveRefresh &&
            wp.customize.widgetsPreview &&
            wp.customize.widgetsPreview.WidgetPartial
        );
        if ( hasSelectiveRefresh ) {
            wp.customize.selectiveRefresh.bind( 'partial-content-rendered', function() {
                init_price_filter();
            } );
        }
    });
}


