'use strict';
const $ = jQuery;
const dejMarkedStories = dejStoryGetSeenedStories();
function dejStoryGetSeenedStories() {
    var itemStr = localStorage.getItem("dej_stories");
    if (!itemStr) return null;
    var item = JSON.parse(itemStr), now = new Date;
    return $.each(item.marked, (function (key, value) {
        now.getTime() > value && delete item.marked[key]
    })), item.marked
}
function dejStoryMarkSeened(index) {
    setTimeout(function (){
        $(".dej_story_elements").find("[data-story-index='" + index + "']").addClass("seen");
    },2000);
    var now = new Date, marked = dejStoryGetSeenedStories(), item = {
        marked: {}
    };
    null === marked && (marked = {}), Object.assign(item.marked, marked), item.marked[index] = now.getTime() + 5184e6, localStorage.setItem("dej_stories", JSON.stringify(item));
}
if (dejMarkedStories !== null) {
    $.each(dejMarkedStories, function (index) {
        $(".dej_story_elements").find("[data-story-index='" + index + "']").addClass("seen");
    });
    $('.dej_story_elements .dej_story_el_item:not(.seen)').prependTo('.dej_story_elements .swiper-wrapper');
}

jQuery(document).ready(function (){
    setVolume();
});

let swiperOpenedStory = new Swiper(".dejavoOpenStory", {
    changeDirection: 'rtl',
    effect: 'cube',
    speed: 400,
    autoplay: {
        delay: 6000,
        disableOnInteraction:false,
    },
    on: {
        afterInit: function () {
            this.autoplay.stop();
        },
        autoplayTimeLeft: function (swiper, timeLeft, percentage) {
            let p = percentage * 100;
            let width = 100 - p;
            if (width > 0 && width < 100 && (this.autoplay.running && !this.autoplay.paused)) {
                $('.swiper-pagination.dejOpenStory .swiper-pagination-bullet-active > span').css('width',width + '%');
            }
        },
        autoplayPause:function (){
            let activeSlide = this.slides[this.activeIndex];
            let btn = $('.dej_story_play_pause');
            let storyItem = $(activeSlide).find('.dej_story_item');
            let videoTag = storyItem.find('video').get(0);
            btn.removeClass('playing');
            if (videoTag){
                videoTag.pause();
            }
        },
        autoplayResume: function (){
            let activeSlide = this.slides[this.activeIndex];
            let btn = $('.dej_story_play_pause');
            let storyItem = $(activeSlide).find('.dej_story_item');
            let videoTag = storyItem.find('video').get(0);
            btn.addClass('playing');
            if (videoTag){
                videoTag.play();
                $('.dej_story_voice').addClass('visible');
            }
        },
        autoplayStart: function (){
            let activeSlide = this.slides[this.activeIndex];
            let storyItem = $(activeSlide).find('.dej_story_item');
            let videoTag = storyItem.find('video').get(0);

            if(storyItem.hasClass('video') && videoTag && document.readyState === 'complete'){
                videoTag.play();
                $('.dej_story_voice').addClass('visible');
            }
        },
        autoplayStop: function (){
        },
        slideChange:function (){
            dejStoryMarkSeened(this.activeIndex);
            let activeSlide = this.slides[this.activeIndex];
            let storyItem = $(activeSlide).find('.dej_story_item');
            let videoTag = storyItem.find('video').get(0);
            let playBtn = $('.dej_story_play_pause');
            let timeout = 0;
            if (!$('.dej_story_wrapper').hasClass('show')) timeout = 1000;
            stopVideos();
            $('.swiper-pagination.dejOpenStory .swiper-pagination-bullet > span').css('width',0 + '%');
            if (storyItem.hasClass('video') && videoTag){
                $('.dej_story_voice').addClass('visible');
                videoTag.addEventListener('loadeddata', function() {
                    setTimeout(function (){
                        videoTag.play();
                        playBtn.addClass('playing');
                    },timeout);
                });

            }else{
                $('.dej_story_voice').removeClass('visible');
            }
        }
    },
    cubeEffect: {
        slideShadows: true,
    },
    pagination: {
        el: '.swiper-pagination.dejOpenStory',
        type: 'bullets',
        clickable:true,
        renderBullet: function (index, className) {
            return '<span class="' + className + '"><span></span></span>';
        }
    },
    navigation: {
        nextEl: '.dej_story_next',
        prevEl: '.dej_story_prev',
        enabled:false
    },
    breakpoints:{
        0:{
            navigation: {
                nextEl: '.dej_story_next_m',
                prevEl: '.dej_story_prev_m',
                enabled:true
            }
        },
        576:{
            navigation: {
                nextEl: '.dej_story_next',
                prevEl: '.dej_story_prev',
                enabled:true
            }
        }
    }
});

jQuery(document).on('click touch','.dej_story_el_item',function (e){
    e.preventDefault();
    let index = $(this).attr('data-story-index');
    $(this).addClass("loading");
    setTimeout((() => {
        $(".dej_story_box").addClass("opened"), $(this).removeClass("loading")
    }), 1800);
    let clickedStory = $(swiperOpenedStory.slides[index]).find('.dej_story_item');
    let video = undefined;
    if (clickedStory.hasClass('video')){
        $('.dej_story_voice').addClass('visible');
        let videoTag = clickedStory.find('video');
        if (videoTag){
            video = videoTag.get(0);
            video.load();
        }
    }
    setTimeout(function(){
        if(swiperOpenedStory.realIndex !== index){
            swiperOpenedStory.slideTo(index,0,false);
        }
        swiperOpenedStory.autoplay.start();
    },1800);
    dejStoryMarkSeened(index);
});

jQuery('video.dej_story_content').on('ended',function(){
    swiperOpenedStory.slideNext();
});

function setVolume(){
    let allVideos = $(swiperOpenedStory.slides).find('video');
    let buttons = $(".dej_story_voice");
    let volume = localStorage.getItem("volume");
    if (volume === "0"){
        buttons.addClass('muted');
        $(allVideos).each(function() {
            let video = $(this).get(0);
            video.volume = 0;
        });
    }
}

jQuery(document).on('click touch','.dej_story_voice',function (e){
    e.preventDefault();
    let btn = $(this);
    let storyItem = $('.swiper-slide-active .dej_story_item');
    let videoTag = storyItem.find('video').get(0);
    let allVideos = $(swiperOpenedStory.slides).find('video');
    if(btn.hasClass('muted')){
        videoTag.volume = 1;
        $('.dej_story_voice').removeClass('muted');
        localStorage.setItem("volume","1");
        $(allVideos).each(function() {
            let video = $(this).get(0);
            video.volume = 1;
        });
    }else{
        videoTag.volume = 0;
        $('.dej_story_voice').addClass('muted');
        localStorage.setItem("volume","0");
        $(allVideos).each(function() {
            let video = $(this).get(0);
            video.volume = 0;
        });
    }
});

jQuery(document).on('click touch','.dej_story_play_pause',function (){
    if(swiperOpenedStory.autoplay.paused){
        swiperOpenedStory.autoplay.resume();
    }else{
        swiperOpenedStory.autoplay.pause();
    }
});

$(document).on('click touch', '.dej_story_close', (function (e) {
    e.preventDefault();
    closeStory();
}))

document.addEventListener('DOMContentLoaded', function() {
    const storiesWrapper = document.querySelector('.dej_story_box');
    if (storiesWrapper){
        storiesWrapper.addEventListener('click', function(event) {
            if (event.target === storiesWrapper) {
                closeStory();
            }
        });
    }
});

function closeStory(){
    stopVideos();
    $(".dej_story_box").removeClass("opened")
    swiperOpenedStory.autoplay.stop();
}

function stopVideos(){
    let videos = $(swiperOpenedStory.slides).find('video');
    $(videos).each(function() {
        let video = $(this).get(0);
        video.pause();
        video.currentTime = 0;
    });
}
