<?php
/**
 * Dokan Seller Single product tab Template
 *
 * @since 2.4
 *
 * @package dokan
 */

$vendor_id = get_post_field('post_author', get_the_id());// Get the WP_User object (the vendor) from author ID
$author = new WP_User($vendor_id);
$store_info = dokan_get_store_info($vendor_id);
if(!$author || $author->ID == null){
    return;
}
$vendor = dokan()->vendor->get( $vendor_id );
$store_name = $vendor->get_shop_name();
$store_url = $vendor->get_shop_url();
$is_store_featured  = $vendor->is_featured();
$featured_label = '';
$store_rating  = $vendor->get_rating();
$store_rating_percentage  = (floatval($store_rating['rating']))*20;
$store_rating_count = $store_rating['count'];
$store_rating_percentage_label = '';

?>
<div class="dej_seller">
    <div class="store-avatar">
        <a href="<?php echo esc_url( $store_url ); ?>">
            <img src="<?php echo esc_url( $vendor->get_avatar() ); ?>" alt="<?php echo esc_attr( $store_name ); ?>">
        </a>
    </div>
    <ul class="store_info">
        <?php
    if (class_exists('WeDevs_Dokan')) {

        if ( $is_store_featured ) {
            $featured_label = '<span class="tag featured"><i class="dej-badge-check"></i>' . ' '. __( 'منتخب', 'dejavo' ) . ' </span>';
        }
        if ( $store_rating_percentage ) {
            $store_rating_percentage_label = '<span class="tag percentage"><i class="dej-star"></i>' . ' '. $store_rating_percentage .  __( '٪ رضایت', 'dejavo' ) . ' </span>';
        }
        if (!empty($store_name)) { ?>
            <div class="seller-info">
                <div class="tag name"><i class="dej-shop"></i> <?php if (!dej_is_mobile()) { echo __( 'فروشنده :', 'dejavo' ); } ?> <?php echo '<a href="' . $store_url .'">'. $store_name .'</a>'; ?></div>
                <?php if ( $store_rating_percentage || $featured_label ) {  echo $store_rating_percentage_label . $featured_label; }
                else { ?> <span class="tag new"><i class="dej-tag"></i> <?php echo __( 'جدید', 'dejavo' ) ?></span> <?php } ?>
            </div>
        <?php }

    }
?>
        <div class="dok_rating"><?php echo wp_kses_post( dokan_get_readable_seller_rating( $author->ID ) ); ?></div>
        <?php echo '<a class="dok_more" href="' . $store_url .'"><i class="dej-angle-double-left"></i></a>';
       // do_action( 'dokan_product_seller_tab_start', $author, $store_info );
       // do_action( 'dokan_product_seller_tab_end', $author, $store_info ); ?>
</ul>
</div>