<?php
defined('ABSPATH') || exit;
//VERSION = '5.4.5';
if (dej_opt('dej_show_fix_cart', 1)  and dej_purchasable()) {
class DejavoFC
{
    protected static $settings = [];
    protected static $instance = null;

    public static function instance()
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    function __construct()
    {
        self::$settings = (array)get_option('DejavoFC_settings', []);

        add_action('wp_footer', [$this, 'footer']);

        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);


        add_action('admin_init', [$this, 'register_settings']);
        add_action('admin_menu', [$this, 'admin_menu']);
        add_filter('woocommerce_add_to_cart_fragments', [$this, 'cart_fragment']);
        add_filter('woocommerce_update_order_review_fragments', [$this, 'cart_fragment']);

        // ajax
        add_action('wp_ajax_DejavoFC_update_qty', [$this, 'update_qty']);
        add_action('wp_ajax_nopriv_DejavoFC_update_qty', [$this, 'update_qty']);
        add_action('wp_ajax_DejavoFC_remove_item', [$this, 'remove_item']);
        add_action('wp_ajax_nopriv_DejavoFC_remove_item', [$this, 'remove_item']);
        add_action('wp_ajax_DejavoFC_undo_remove', [$this, 'undo_remove']);
        add_action('wp_ajax_nopriv_DejavoFC_undo_remove', [$this, 'undo_remove']);
        add_action('wp_ajax_DejavoFC_empty_cart', [$this, 'empty_cart']);
        add_action('wp_ajax_nopriv_DejavoFC_empty_cart', [$this, 'empty_cart']);


    }

    public static function get_settings()
    {
        return self::$settings;
    }

    public static function get_setting($name, $default = false)
    {
        if (!empty(self::$settings)) {
            if (isset(self::$settings[$name])) {
                $setting = self::$settings[$name];
            } else {
                $setting = $default;
            }
        } else {
            $setting = get_option('_DejavoFC_' . $name, $default);
        }

        return $setting;
    }


    function enqueue_scripts()
    {
        $auto_show = 'yes';
        if (did_action('elementor/loaded')) {
            if (\Elementor\Plugin::$instance->preview->is_preview_mode()) {
                $auto_show = 'no';
            } else {
                $auto_show = self::get_setting('auto_show_ajax', 'yes');
            }
        }

        // css
        wp_enqueue_style('DejavoFC-frontend', DEJ_TUI . '/assets/css/fixcart.css', [], DEJ_VERSION);
        // js
        wp_enqueue_script('DejavoFC-frontend', DEJ_TUI . '/assets/js/fixcart.js', [
            'jquery',
            'wc-cart-fragments'
        ], DEJ_VERSION, true);
        wp_localize_script('DejavoFC-frontend', 'DejavoFC_vars', [
                'ajax_url' => admin_url('admin-ajax.php'),
                'nonce' => wp_create_nonce('DejavoFC-security'),
                'auto_show' => $auto_show,
                'undo_remove' => self::get_setting('undo_remove', 'yes'),
                'confirm_remove' => self::get_setting('confirm_remove', 'no'),
                'confirm_empty' => self::get_setting('confirm_empty', 'no'),
                'confirm_empty_text' => __('Do you want to empty the cart?', 'dejavo'),
                'confirm_remove_text' => __('Do you want to remove this item?', 'dejavo'),
                'undo_remove_text' => __('Undo?', 'dejavo'),
                'removed_text' => esc_html__('%s was removed.', 'dejavo'),
                'manual_show' => '.header-cart-icon',
                'reload' => self::get_setting('reload', 'yes'),
                'is_cart' => is_cart(),
                'is_checkout' => is_checkout(),
                'cart_url' => ((self::get_setting('hide_cart_checkout', 'no') === 'yes') && (is_cart() || is_checkout())) ? wc_get_cart_url() : '',
                'hide_count_empty' => self::get_setting('count_hide_empty', 'no'),
            ]
        );
    }


    function register_settings()
    {
        // settings
        register_setting('DejavoFC_settings', 'DejavoFC_settings');

    }

    function admin_menu()
    {
        add_submenu_page('future', __('Fly Cart', 'dejavo'), __('Fly Cart', 'dejavo'), 'manage_options', 'future-DejavoFC', array(
            $this,
            'admin_menu_content'
        ));
    }

    function admin_menu_content()
    {
        if (is_admin()) {
            $active_tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'settings';
            ?>
            <div class="dejavo_settings_page wrap">

                <?php if (isset($_GET['settings-updated']) && $_GET['settings-updated']) { ?>
                    <div class="notice notice-success is-dismissible">
                        <p><?php _e('Settings updated.', 'dejavo'); ?></p>
                    </div>
                <?php } ?>
                <div class="dejavo_settings_page_content">
                    <?php if ($active_tab === 'settings') {
                        if (\Elementor\Plugin::$instance->preview->is_preview_mode()) {
                            $auto_show_ajax = 'no';
                        } else {
                            $auto_show_ajax = self::get_setting('auto_show_ajax', 'yes');
                        }
                        $auto_show_normal = self::get_setting('auto_show_normal', 'yes');
                        $reverse_items = self::get_setting('reverse_items', 'yes');
                        $overlay_layer = self::get_setting('overlay_layer', 'yes');
                        $close = self::get_setting('close', 'yes');
                        $link = self::get_setting('link', 'yes');
                        $price = self::get_setting('price', 'price');
                        $data = self::get_setting('data', 'no');
                        $plus_minus = self::get_setting('plus_minus', 'yes');
                        $remove = self::get_setting('remove', 'yes');
                        $save_for_later = self::get_setting('save_for_later', 'yes');
                        $subtotal = self::get_setting('subtotal', 'yes');
                        $total = self::get_setting('total', 'yes');
                        $buttons = self::get_setting('buttons', '01');
                        $empty = self::get_setting('empty', 'yes');
                        $confirm_empty = self::get_setting('confirm_empty', 'no');
                        $continue = self::get_setting('continue', 'yes');
                        $confirm_remove = self::get_setting('confirm_remove', 'no');
                        $undo_remove = self::get_setting('undo_remove', 'yes');
                        $reload = self::get_setting('reload', 'no');
                        $hide_cart_checkout = self::get_setting('hide_cart_checkout', 'no');
                        $count = self::get_setting('count', 'yes');
                        $count_position = self::get_setting('count_position', 'bottom-left');
                        $count_hide_empty = self::get_setting('count_hide_empty', 'no');
                        ?>
                        <form method="post" action="options.php">
                            <table class="form-table">
                                <tr class="heading">
                                    <th><?php _e('General', 'dejavo'); ?></th>
                                    <td><?php _e('General settings for the fly cart.', 'dejavo'); ?></td>
                                </tr>
                                <tr>
                                    <th><?php _e('Open on AJAX add to cart', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[auto_show_ajax]">
                                            <option value="yes" <?php selected($auto_show_ajax, 'yes'); ?>><?php _e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($auto_show_ajax, 'no'); ?>><?php _e('No', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Open on normal add to cart', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[auto_show_normal]">
                                            <option value="yes" <?php selected($auto_show_normal, 'yes'); ?>><?php _e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($auto_show_normal, 'no'); ?>><?php _e('No', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Reverse items', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[reverse_items]">
                                            <option value="yes" <?php selected($reverse_items, 'yes'); ?>><?php _e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($reverse_items, 'no'); ?>><?php _e('No', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Overlay layer', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[overlay_layer]">
                                            <option value="yes" <?php selected($overlay_layer, 'yes'); ?>><?php _e('Show', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($overlay_layer, 'no'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <th><?php _e('Close button', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[close]">
                                            <option value="yes" <?php selected($close, 'yes'); ?>><?php _e('Show', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($close, 'no'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Show/hide the close button.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Link to individual product', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[link]">
                                            <option value="yes" <?php selected($link, 'yes'); ?>><?php _e('Yes, open in the same tab', 'dejavo'); ?></option>
                                            <option value="yes_blank" <?php selected($link, 'yes_blank'); ?>><?php _e('Yes, open in the new tab', 'dejavo'); ?></option>
                                            <option value="yes_popup" <?php selected($link, 'yes_popup'); ?>><?php _e('Yes, open quick view popup', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($link, 'no'); ?>><?php _e('No', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Item price', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[price]">
                                            <option value="no" <?php selected($price, 'no'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                            <option value="price" <?php selected($price, 'price'); ?>><?php _e('Price', 'dejavo'); ?></option>
                                            <option value="subtotal" <?php selected($price, 'subtotal'); ?>><?php _e('Subtotal', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Show/hide the item price or subtotal under title.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Item data', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[data]">
                                            <option value="yes" <?php selected($data, 'yes'); ?>><?php _e('Show', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($data, 'no'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Show/hide the item data under title.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Plus/minus button', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[plus_minus]">
                                            <option value="yes" <?php selected($plus_minus, 'yes'); ?>><?php _e('Show', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($plus_minus, 'no'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Show/hide the plus/minus button.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Item remove', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[remove]">
                                            <option value="yes" <?php selected($remove, 'yes'); ?>><?php _e('Show', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($remove, 'no'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Show/hide the remove button for each item.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Save for later', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[save_for_later]">
                                            <option value="yes" <?php selected($save_for_later, 'yes'); ?>><?php _e('Show', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($save_for_later, 'no'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Subtotal', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[subtotal]">
                                            <option value="yes" <?php selected($subtotal, 'yes'); ?>><?php _e('Show', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($subtotal, 'no'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <th><?php _e('Total', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[total]">
                                            <option value="yes" <?php selected($total, 'yes'); ?>><?php _e('Show', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($total, 'no'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Action buttons', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[buttons]">
                                            <option value="01" <?php selected($buttons, '01'); ?>><?php _e('Cart & Checkout', 'dejavo'); ?></option>
                                            <option value="02" <?php selected($buttons, '02'); ?>><?php _e('Cart only', 'dejavo'); ?></option>
                                            <option value="03" <?php selected($buttons, '03'); ?>><?php _e('Checkout only', 'dejavo'); ?></option>
                                            <option value="hide" <?php selected($buttons, 'hide'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>


                                <tr>
                                    <th><?php _e('Empty cart', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[empty]">
                                            <option value="yes" <?php selected($empty, 'yes'); ?>><?php _e('Show', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($empty, 'no'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Show/hide the empty cart button under the product list.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Confirm empty', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[confirm_empty]">
                                            <option value="yes" <?php selected($confirm_empty, 'yes'); ?>><?php _e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($confirm_empty, 'no'); ?>><?php _e('No', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Enable/disable confirm before emptying the cart.', 'dejavo'); ?></span>
                                    </td>
                                </tr>

                                <tr>
                                    <th><?php _e('Continue shopping', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[continue]">
                                            <option value="yes" <?php selected($continue, 'yes'); ?>><?php _e('Show', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($continue, 'no'); ?>><?php _e('Hide', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Show/hide the continue shopping button at the end of fly cart.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Continue shopping URL', 'dejavo'); ?></th>
                                    <td>
                                        <input type="url" class="regular-text code"
                                               name="DejavoFC_settings[continue_url]"
                                               value="<?php echo self::get_setting('continue_url', ''); ?>"/>
                                        <span class="description"><?php _e('Custom URL for "continue shopping" button. By default, only close the fly cart when clicking on this button.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Confirm remove', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[confirm_remove]">
                                            <option value="yes" <?php selected($confirm_remove, 'yes'); ?>><?php _e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($confirm_remove, 'no'); ?>><?php _e('No', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Enable/disable confirm before removing a product.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Undo remove', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[undo_remove]">
                                            <option value="yes" <?php selected($undo_remove, 'yes'); ?>><?php _e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($undo_remove, 'no'); ?>><?php _e('No', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Enable/disable undo after removing a product.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Reload the cart', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[reload]">
                                            <option value="yes" <?php selected($reload, 'yes'); ?>><?php _e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($reload, 'no'); ?>><?php _e('No', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('The cart will be reloaded when opening the page? If you use the cache for your site, please turn on this option.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Hide on Cart & Checkout', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[hide_cart_checkout]">
                                            <option value="yes" <?php selected($hide_cart_checkout, 'yes'); ?>><?php _e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($hide_cart_checkout, 'no'); ?>><?php _e('No', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Hide the fly cart on the Cart and Checkout page.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr class="heading">
                                    <th><?php _e('Bubble', 'dejavo'); ?></th>
                                    <td><?php _e('Settings for the bubble.', 'dejavo'); ?></td>
                                </tr>
                                <tr>
                                    <th><?php _e('Enable', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[count]">
                                            <option value="yes" <?php selected($count, 'yes'); ?>><?php _e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($count, 'no'); ?>><?php _e('No', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Position', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[count_position]">
                                            <option value="top-left" <?php selected($count_position, 'top-left'); ?>><?php _e('Top Left', 'dejavo'); ?></option>
                                            <option value="top-right" <?php selected($count_position, 'top-right'); ?>><?php _e('Top Right', 'dejavo'); ?></option>
                                            <option value="bottom-left" <?php selected($count_position, 'bottom-left'); ?>><?php _e('Bottom Left', 'dejavo'); ?></option>
                                            <option value="bottom-right" <?php selected($count_position, 'bottom-right'); ?>><?php _e('Bottom Right', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Icon', 'dejavo'); ?></th>
                                    <td>
                                        <select id="DejavoFC_count_icon" name="DejavoFC_settings[count_icon]">
                                            <?php

                                            if (self::get_setting('count_icon', 'dej-shopping-bag') === 'dej-shopping-bag') {
                                                echo '<option value="dej-shopping-bag" selected>shopping-bag</option>';
                                                echo '<option value="dej-shopping-cart">shopping-cart</option>';
                                            } else {
                                                echo '<option value="dej-shopping-cart">shopping-cart</option>';
                                                echo '<option value="dej-shopping-bag">shopping-bag</option>';
                                            }

                                            ?>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th><?php _e('Hide if empty', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoFC_settings[count_hide_empty]">
                                            <option value="yes" <?php selected($count_hide_empty, 'yes'); ?>><?php _e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($count_hide_empty, 'no'); ?>><?php _e('No', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php _e('Hide the bubble if the cart is empty?', 'dejavo'); ?></span>
                                    </td>
                                </tr>

                                <tr class="submit">
                                    <th colspan="2">
                                        <?php settings_fields('DejavoFC_settings'); ?><?php submit_button(); ?>
                                    </th>
                                </tr>
                            </table>
                        </form>
                    <?php } ?>
                </div>
            </div>
            <?php
        }
    }

    function update_qty()
    {
        $key = sanitize_text_field($_POST['cart_item_key']) ?? '';
        $qty = sanitize_text_field($_POST['cart_item_qty']) ?? '';
        $nonce = sanitize_key($_POST['security']) ?? '';
        if (!isset($nonce) || !wp_verify_nonce($nonce, 'DejavoFC-security')) {
            die();
        }
        if (isset($key, $qty) && !empty($key)) {
            if (WC()->cart->get_cart_item(($key))) {
                if ((float)($qty) > 0) {
                    WC()->cart->set_quantity(($key), (float)$qty);
                } else {
                    WC()->cart->remove_cart_item(($key));
                }
            }
            echo json_encode(['action' => 'update_qty']);
            wp_die();
        }
    }

    function remove_item()
    {
        if (!isset($_POST['security']) || !wp_verify_nonce(sanitize_key($_POST['security']), 'DejavoFC-security')) {
            die();
        }
        if (isset($_POST['cart_item_key'])) {
            WC()->cart->remove_cart_item(sanitize_text_field($_POST['cart_item_key']));
            WC_AJAX::get_refreshed_fragments();

            wp_die();
        }
    }

    function undo_remove()
    {
        if (isset($_POST['item_key'])) {
            if (WC()->cart->restore_cart_item(sanitize_text_field($_POST['item_key']))) {
                echo 'true';
            } else {
                echo 'false';
            }

            wp_die();
        }
    }

    function empty_cart()
    {

        if (!isset($_POST['security']) || !wp_verify_nonce(sanitize_key($_POST['security']), 'DejavoFC-security')) {
            die();
        }

        WC()->cart->empty_cart();
        WC_AJAX::get_refreshed_fragments();
        wp_die();
    }

    function get_cart_area()
    {
        if (!isset(WC()->cart)) {
            return '';
        }

        // settings
        $link = self::get_setting('link', 'yes');
        $plus_minus = self::get_setting('plus_minus', 'yes') === 'yes';
        $remove = self::get_setting('remove', 'yes') === 'yes';


        ob_start();

        // global product
        global $product;
        $global_product = $product;

        echo '<div class="DejavoFC-inner DejavoFC-cart-area">';
        echo '<div class="DejavoFC-area-top"><span class="DejavoFC-area-heading">' . __('Shopping cart', 'dejavo') . '<span class="DejavoFC-area-count">' . WC()->cart->get_cart_contents_count() . '</span></span>';
        if (self::get_setting('close', 'yes') === 'yes') {
            echo '<div class="DejavoFC-close hint--left" aria-label="' . esc_attr(__('Close', 'dejavo')) . '"><i class="dej-cross-small"></i></div>';
        }

        echo '</div><!-- DejavoFC-area-top -->';
        echo '<div class="DejavoFC-area-mid DejavoFC-items">';

        // notices
        $notices = wc_print_notices(true);
        if (!empty($notices)) {
            echo '<div class="DejavoFC-notices">' . $notices . '</div>';
        }

        $items = WC()->cart->get_cart();

        if (is_array($items) && (count($items) > 0)) {
            if (self::get_setting('reverse_items', 'yes') === 'yes') {
                $items = array_reverse($items);
            }

            foreach ($items as $cart_item_key => $cart_item) {
                if (!isset($cart_item['bundled_by'])) {
                    $product = $cart_item['data'];
                    $product_id = $cart_item['product_id'];
                    $product_link = $product->is_visible() ? $product->get_permalink($cart_item) : '';
                    $item_class = $remove ? 'DejavoFC-item DejavoFC-item-has-remove' : 'DejavoFC-item';


                    echo '<div class="' . esc_attr($item_class) . '" data-key="' . esc_attr($cart_item_key) . '" data-name="' . esc_attr($product->get_name()) . '">';

                    echo '<div class="DejavoFC-item-inner">';
                    echo '<div class="DejavoFC-item-thumb">';

                    if (($link !== 'no') && !empty($product_link)) {
                        $cart_item_thumbnail = sprintf('<a ' . ($link === 'yes_popup' ? 'class="DejavoQV-link" data-id="' . esc_attr($product_id) . '" data-context="DejavoFC"' : '') . ' href="%s" ' . ($link === 'yes_blank' ? 'target="_blank"' : '') . '>%s</a>', esc_url($product_link), $product->get_image());
                    } else {
                        $cart_item_thumbnail = $product->get_image();
                    }

                    echo $cart_item_thumbnail;
                    echo '</div><!-- /.DejavoFC-item-thumb -->';

                    echo '<div class="DejavoFC-item-info">';

                    echo '<span class="DejavoFC-item-title">';

                    if (($link !== 'no') && !empty($product_link)) {
                        $cart_item_name = sprintf('<a ' . ($link === 'yes_popup' ? 'class="DejavoQV-link" data-id="' . esc_attr($product_id) . '" data-context="DejavoFC"' : '') . ' href="%s" ' . ($link === 'yes_blank' ? 'target="_blank"' : '') . '>%s</a>', esc_url($product_link), $product->get_name());
                    } else {
                        $cart_item_name = $product->get_name();
                    }

                    echo $cart_item_name;
                    echo '</span><!-- /.DejavoFC-item-title -->';

                    if (self::get_setting('data', 'no') === 'yes') {
                        echo '<span class="DejavoFC-item-data">' . wc_get_formatted_cart_item_data($cart_item, true) . '</span>';
                    }

                    if (self::get_setting('price', 'price') === 'price') {
                        echo '<span class="DejavoFC-item-price">' . WC()->cart->get_product_price($product) . '</span>';
                    } elseif (self::get_setting('price', 'price') === 'subtotal') {
                        echo '<span class="DejavoFC-item-price">' . WC()->cart->get_product_subtotal($product, $cart_item['quantity']) . '</span>';
                    }


                    echo '</div><!-- /.DejavoFC-item-info -->';

                    $min_value = $product->get_min_purchase_quantity();
                    $max_value = $product->get_max_purchase_quantity();

                    if ($product->is_sold_individually() || ($max_value && $min_value === $max_value)) {
                        $cart_item_quantity = $cart_item['quantity'];
                    } else {
                        $cart_item_qty = isset($cart_item['quantity']) ? wc_stock_amount(wp_unslash($cart_item['quantity'])) : $product->get_min_purchase_quantity();
                        $cart_item_quantity_input = woocommerce_quantity_input([
                            'classes' => ['input-text', 'DejavoFC-qty', 'qty', 'text'],
                            'input_name' => 'DejavoFC_qty_' . $cart_item_key,
                            'input_value' => $cart_item_qty,
                            'min_value' => $min_value,
                            'max_value' => $max_value,
                            'DejavoFC_qty' => [
                                'input_value' => $cart_item_qty,
                                'min_value' => $min_value,
                                'max_value' => $max_value
                            ]
                        ], $product, false);

                        if ($plus_minus) {
                            $cart_item_quantity = '<span class="DejavoFC-item-qty-minus">-</span>' . $cart_item_quantity_input . '<span class="DejavoFC-item-qty-plus">+</span>';
                        } else {
                            $cart_item_quantity = $cart_item_quantity_input;
                        }
                    }

                    echo '<div class="DejavoFC-item-qty ' . ($plus_minus ? 'DejavoFC-item-qty-plus-minus' : '') . '"><div class="DejavoFC-item-qty-inner">' . $cart_item_quantity . '</div></div><!-- /.DejavoFC-item-qty -->';

                    if ($remove) {
                        echo '<span class="DejavoFC-item-remove"><span class="hint--left" aria-label="' . esc_attr(__('Remove', 'dejavo')) . '"><i class="dej-cross-small"></i></span></span>';
                    }

                    echo '</div><!-- /.DejavoFC-item-inner -->';

                    echo '</div><!-- /.DejavoFC-item -->';
                }
            }
        } else {
            echo '<div class="DejavoFC-no-item">' . __('There are no products in the cart!', 'dejavo') . '</div>';
        }

        echo '</div><!-- DejavoFC-area-mid -->';

        echo '<div class="DejavoFC-area-bot">';
        if (!empty($items)) {
            if (self::get_setting('empty', 'yes') === 'yes') {
                // enable empty
                echo '<div class="DejavoFC-link">';

                if (self::get_setting('empty', 'yes') === 'yes') {
                    echo '<div class="DejavoFC-empty"><span class="DejavoFC-empty-cart">' . __('Empty cart', 'dejavo') . '</span></div>';
                }


                echo '</div>';
            }

            if (self::get_setting('subtotal', 'yes') === 'yes') {
                echo '<div class="DejavoFC-data"><div class="DejavoFC-data-left">' . __('Subtotal', 'dejavo') . '</div><div id="DejavoFC-subtotal" class="DejavoFC-data-right">' . WC()->cart->get_cart_subtotal() . '</div></div>';
            }


            if (self::get_setting('total', 'yes') === 'yes') {
                echo '<div class="DejavoFC-data"><div class="DejavoFC-data-left">' . __('Total', 'dejavo') . '</div><div id="DejavoFC-total" class="DejavoFC-data-right">' . WC()->cart->get_total() . '</div></div>';
            }
            $discount_total = 0;
            foreach (WC()->cart->get_cart() as $cart_item_key => $values) {
                $product = $values['data'];
                if ($product->is_on_sale()) {
                    $regular_price = $product->get_regular_price();
                    $sale_price = $product->get_sale_price();
                    $discount = ((float)$regular_price - (float)$sale_price) * (int)$values['quantity'];
                    $discount_total += $discount;
                }
            }
            if ($discount_total > 0) {
                echo '<div class="DejavoFC-data"><div class="DejavoFC-data-left">' . __('سود شما از این خرید', 'dejavo') . '</div><div id="DejavoFC-total" class="DejavoFC-data-right">' . wc_price($discount_total + WC()->cart->get_discount_total()) . '</div></div>';
            }

            if (self::get_setting('buttons', '01') === '01') {
                // both buttons
                echo '<div class="DejavoFC-action"><div class="DejavoFC-action-inner"><div class="DejavoFC-action-left"><a class="DejavoFC-action-cart" href="' . wc_get_cart_url() . '">' . __('Cart', 'dejavo') . '</a></div><div class="DejavoFC-action-right"><a class="DejavoFC-action-checkout" href="' . wc_get_checkout_url() . '">' . __('Checkout', 'dejavo') . '</a></div></div></div>';
            } else {
                if (self::get_setting('buttons', '01') === '02') {
                    // cart
                    echo '<div class="DejavoFC-action"><div class="DejavoFC-action-inner"><div class="DejavoFC-action-full"><a class="DejavoFC-action-cart" href="' . wc_get_cart_url() . '">' . __('Cart', 'dejavo') . '</a></div></div></div>';
                }

                if (self::get_setting('buttons', '01') === '03') {
                    // checkout
                    echo '<div class="DejavoFC-action"><div class="DejavoFC-action-inner"><div class="DejavoFC-action-full"><a class="DejavoFC-action-checkout" href="' . wc_get_checkout_url() . '">' . __('Checkout', 'dejavo') . '</a></div></div></div>';
                }
            }


        }

        if (self::get_setting('continue', 'yes') === 'yes') {
            echo '<div class="DejavoFC-continue"><span class="DejavoFC-continue-url" data-url="' . esc_url(self::get_setting('continue_url', '')) . '">' . __('Continue shopping', 'dejavo') . '</span></div>';
        }

        echo '</div><!-- DejavoFC-area-bot -->';

        echo '</div>';

        $product = $global_product;

        return ob_get_clean();
    }

    function get_cart_count()
    {
        if (!isset(WC()->cart)) {
            return '';
        }

        $count = WC()->cart->get_cart_contents_count();
        $icon = self::get_setting('count_icon', 'dej-shopping-bag');
        $count_class = 'DejavoFC-count DejavoFC-count-' . self::get_setting('count_position', 'bottom-left');

        if ((self::get_setting('hide_cart_checkout', 'no') === 'yes')) {
            $count_class .= ' DejavoFC-count-hide-cart-checkout';
        }

        if ((self::get_setting('count_hide_empty', 'no') === 'yes') && ($count <= 0)) {
            $count_class .= ' DejavoFC-count-hide-empty';
        }

        ob_start();

        echo '<div id="DejavoFC-count" class="' . esc_attr($count_class) . '">';
        echo '<i class="' . esc_attr($icon) . '"></i>';
        echo '<span id="DejavoFC-count-number" class="DejavoFC-count-number">' . esc_attr($count) . '</span>';
        echo '</div>';

        return ob_get_clean();
    }

    function get_cart_menu()
    {
        if (!isset(WC()->cart)) {
            return '';
        }
        $count = WC()->cart->get_cart_contents_count();
        $subtotal = WC()->cart->get_cart_subtotal();
        $icon = self::get_setting('count_icon', 'dej-shopping-bag');
        return '<li class="menu-item DejavoFC-menu-item menu-item-type-DejavoFC"><a href="' . wc_get_cart_url() . '"><span class="DejavoFC-menu-item-inner" data-count="' . esc_attr($count) . '"><i class="' . esc_attr($icon) . '"></i> <span class="DejavoFC-menu-item-inner-subtotal">' . $subtotal . '</span></span></a></li>';
    }

    function footer()
    {

        if ((self::get_setting('hide_cart_checkout', 'no') === 'yes') && (is_cart() || is_checkout())) {
            return;
        }

        echo '<div id="DejavoFC-area" class="DejavoFC-area">';
        echo self::get_cart_area();

        echo '</div>';

        if (self::get_setting('count', 'yes') === 'yes') {
            echo self::get_cart_count();
        }

        if (self::get_setting('overlay_layer', 'yes') === 'yes') {
            echo '<div class="DejavoFC-overlay"></div>';
        }

        if ((isset($_POST['add-to-cart']) || isset($_GET['add-to-cart'])) && (self::get_setting('auto_show_normal', 'yes') === 'yes')) {
            ?>
            <script>
                jQuery(document).ready(function () {
                    setTimeout(function () {
                        DejavoFC_show_cart();
                    }, 1000);
                });
            </script>
            <?php
        }
    }

    function cart_fragment($fragments)
    {
        ob_start();
        echo self::get_cart_count();
        $fragments['.DejavoFC-count'] = ob_get_clean();

        ob_start();
        echo self::get_cart_menu();
        $fragments['.DejavoFC-menu-item'] = ob_get_clean();

        ob_start();
        echo self::get_cart_link();
        $fragments['.DejavoFC-cart-link'] = ob_get_clean();

        ob_start();
        echo self::get_cart_area();
        $fragments['.DejavoFC-cart-area'] = ob_get_clean();

        return $fragments;
    }

    public static function get_cart_link($echo = false)
    {
        if (!isset(WC()->cart)) {
            return '';
        }

        $count = WC()->cart->get_cart_contents_count();
        $subtotal = WC()->cart->get_cart_subtotal();
        $icon = self::get_setting('count_icon', 'dej-shopping-bag');
        $cart_link = '<span class="DejavoFC-cart-link"><a href="' . wc_get_cart_url() . '"><span class="DejavoFC-cart-link-inner" data-count="' . esc_attr($count) . '"><i class="' . esc_attr($icon) . '"></i> <span class="DejavoFC-cart-link-inner-subtotal">' . $subtotal . '</span></span></a></span>';

        if ($echo) {
            echo $cart_link;
        } else {
            return $cart_link;
        }
    }

    public static function DejavoFC_get_cart_link($echo = false)
    {
        self::get_cart_link($echo);
    }
}
return DejavoFC::instance();
}


