<?php
defined('ABSPATH') || exit;
if (dej_opt('dej_show_sticky_add_tc', 1) and !is_front_page()) {
class DejavoSA
{
    protected static $localization = array();
    function __construct()
    {
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));
        add_action('woocommerce_before_add_to_cart_button', array($this, 'add_to_cart_button'));
        add_action('wp_footer', array($this, 'footer'));
    }

    function enqueue_scripts()
    {
        if (is_singular('product')) {
            wp_enqueue_script('DejavoSA-frontend', DEJ_JS . 'sticky-add-to-cart.js', array('jquery'), '1', true);
        }
    }


    function add_to_cart_button()
    {
        global $product;
        if ($product) {
            echo '<span class="DejavoSA-id DejavoSA-id-' . esc_attr($product->get_id()) . '" data-product_id="' . esc_attr($product->get_id()) . '"></span>';
        }
    }

    function footer()
    {
        $custom_product_id = apply_filters('DejavoSA_custom_product_id', false);
        if (!is_singular('product') && !$custom_product_id) {
            return;
        }

        if ($custom_product_id) {
            $product_id = $custom_product_id;
            $product = wc_get_product($product_id);
        } else {
            global $product;

            if ($product) {
                $product_id = $product->get_id();
            } else {
                $product_id = 0;
            }
        }

        if (!$product || !$product_id) {
            return;
        }
        $title = wp_trim_words($product->get_name(), 15, '..');
        ?>
        <style>
            <?php if ( dej_opt('show_add_to_cart_instead_nav', 0) and dej_is_mobile()) { ?>
            .DejavoSA-wrapper {
                visibility: visible;
                opacity: 1;
                display: flex;
                z-index: 1505;
                padding: 10px 0 !important;
            }

            <?php } ?>
            .BackToTop {
                bottom: 80px;
            }

            .DejavoFC-count {
                bottom: 145px;
            }

            .DejavoFC-count:hover {
                bottom: 141px;
            }

            @media (max-width: 576px) {
                .DejavoFC-count {
                    bottom: 130px;
                }

                .DejavoFC-count:hover {
                    bottom: 127px;
                }

                .DejavoSA-product-name {
                    height: 44px;
                    white-space: normal;
                    overflow: hidden;
                    display: -webkit-box;
                    -webkit-line-clamp: 2;
                    -webkit-box-orient: vertical;
                    text-overflow: ellipsis;
                }
            }
        </style>
        <div class="DejavoSA-wrapper DejavoSA-wrapper-bottom">
            <div class="DejavoSA-container">
                <div class="DejavoSA-product">
                    <div class="DejavoSA-product-info">
                        <div class="DejavoSA-product-image">
                            <div class="DejavoSA-image-ori">
                                <?php
                                echo apply_filters('DejavoSA_product_image', wp_kses($product->get_image(), array(
                                    'img' => array(
                                        'src' => array(),
                                        'class' => array(),
                                        'id' => array()
                                    )
                                )), $product);

                                ?>
                            </div>
                            <div class="DejavoSA-image-new">
                            </div>
                        </div>
                        <div class="DejavoSA-product-data">
                            <div class="DejavoSA-product-name">
                                <?php echo apply_filters('DejavoSA_product_name', esc_html($title), $product); ?>
                            </div>
                            <div class="DejavoSA-product-btn">
                                <?php
                                if (class_exists('DejavoCP')) {
                                    echo DejavoCP::cp_btn($product_id);
                                }
                                if (class_exists('DejavoWL')) {
                                    echo DejavoWL::wl_btn($product_id);
                                }
                                ?>
                            </div>
                            <div class="DejavoSA-product-price">
                                <div class="DejavoSA-price-ori"><?php echo $product->get_price_html(); ?></div>
                                <div class="DejavoSA-price-new"></div>
                            </div>
                        </div>
                    </div>
                    <div class="DejavoSA-product-action">
                        <?php

                        if (zero_quantity_or_empty_price($product) !== true and dej_purchasable()) { ?>
                            <div class="DejavoSA-add-to-cart" data-product_id="<?php echo esc_attr($product_id); ?>">
                                <div class="DejavoSA-atc">
                                    <button type="button"
                                            class="DejavoSA-btn button alt"><?= $product->single_add_to_cart_text() ?></button>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}

new DejavoSA();

}


