<?php
defined('ABSPATH') || exit;
require_once get_template_directory() . '/includes/dej-icons.php';
add_filter('elementor/frontend/print_google_fonts', '__return_false');
class dejavo_Elementor_Widgets
{
    private static $_instance = null;

    public static function instance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;

    }

    public function register_widgets($widgets_manager)
    {

        require_once(__DIR__ . '/elementor/header/menu.php');
        require_once(__DIR__ . '/elementor/header/logo.php');
        require_once(__DIR__ . '/elementor/header/search.php');
        require_once(__DIR__ . '/elementor/banner/banner-1.php');
        require_once(__DIR__ . '/elementor/banner/banner-2.php');
        require_once(__DIR__ . '/elementor/banner/banner-3.php');
        require_once(__DIR__ . '/elementor/main/title.php');
        require_once(__DIR__ . '/elementor/main/category.php');
        require_once(__DIR__ . '/elementor/slider/slider-1.php');
        require_once(__DIR__ . '/elementor/slider/slider-2.php');
        require_once(__DIR__ . '/elementor/slider/slider-3.php');
        require_once(__DIR__ . '/elementor/main/icon-box.php');
        require_once(__DIR__ . '/elementor/main/blog-slider.php');
        require_once(__DIR__ . '/elementor/main/blog-slider-2.php');
        require_once(__DIR__ . '/elementor/main/blog-grid.php');
        require_once(__DIR__ . '/elementor/main/logo-slider.php');
        require_once(__DIR__ . '/elementor/main/story.php');
        require_once(__DIR__ . '/elementor/main/breadcrumb.php');
        require_once(__DIR__ . '/elementor/footer/social-icons.php');
        require_once(__DIR__ . '/elementor/footer/namad-slider.php');
        require_once(__DIR__ . '/elementor/footer/list-icons.php');
        require_once(__DIR__ . '/elementor/footer/about-us.php');
        if (dej_woo_activated()) {
            require_once(__DIR__ . '/elementor/header/icons.php');
            require_once(__DIR__ . '/elementor/header/cart.php');
            require_once(__DIR__ . '/elementor/main/product-slider.php');
            require_once(__DIR__ . '/elementor/main/product-slider-2.php');
            require_once(__DIR__ . '/elementor/main/product-slider-3.php');
            require_once(__DIR__ . '/elementor/main/product-slider-4.php');
            require_once(__DIR__ . '/elementor/main/product-slider-5.php');
            require_once(__DIR__ . '/elementor/main/amazing-offer.php');
            require_once(__DIR__ . '/elementor/main/random-product.php');
            require_once(__DIR__ . '/elementor/main/product-list.php');
            require_once(__DIR__ . '/elementor/main/product-list-slider.php');
            require_once(__DIR__ . '/elementor/main/product-column.php');
            require_once(__DIR__ . '/elementor/main/product-grid.php');
            require_once(__DIR__ . '/elementor/product/gallery.php');
            require_once(__DIR__ . '/elementor/product/tabs.php');
            require_once(__DIR__ . '/elementor/product/label.php');
            require_once(__DIR__ . '/elementor/product/warranty.php');
            require_once(__DIR__ . '/elementor/product/send.php');
            require_once(__DIR__ . '/elementor/product/alarm.php');
            require_once(__DIR__ . '/elementor/product/actions.php');
            require_once(__DIR__ . '/elementor/product/en-title.php');
            require_once(__DIR__ . '/elementor/product/countdown.php');
            require_once(__DIR__ . '/elementor/product/stock-bar.php');
            require_once(__DIR__ . '/elementor/product/star-rate.php');
            require_once(__DIR__ . '/elementor/product/meta.php');
            require_once(__DIR__ . '/elementor/product/related.php');
            require_once(__DIR__ . '/elementor/product/up-sells.php');
            require_once(__DIR__ . '/elementor/product/recommend.php');
            require_once(__DIR__ . '/elementor/product/discount.php');
            require_once(__DIR__ . '/elementor/product/brand-image.php');
            require_once(__DIR__ . '/elementor/product/add-to-cart.php');
            require_once(__DIR__ . '/elementor/product/attr-short.php');
            require_once(__DIR__ . '/elementor/product/price.php');
            require_once(__DIR__ . '/elementor/product/update-time.php');

        }
        require_once(__DIR__ . '/elementor/post/title.php');
        require_once(__DIR__ . '/elementor/post/related.php');
        require_once(__DIR__ . '/elementor/post/meta.php');
        require_once(__DIR__ . '/elementor/post/share.php');
        require_once(__DIR__ . '/elementor/post/tags.php');


        $widgets_manager->register(new dej_HeaderMenu_1());
        $widgets_manager->register(new dej_Headerlogo_1());
        $widgets_manager->register(new dej_HeaderSearch_1());
        $widgets_manager->register(new dej_IconBox_1());
        $widgets_manager->register(new dej_Title());
        $widgets_manager->register(new dej_CategoryBox_1());
        $widgets_manager->register(new dej_Slider_1());
        $widgets_manager->register(new dej_Slider_2());
        $widgets_manager->register(new dej_Slider_3());
        $widgets_manager->register(new dej_Banner_1());
        $widgets_manager->register(new dej_Banner_2());
        $widgets_manager->register(new dej_Banner_3());
        $widgets_manager->register(new dej_LogoSlider_1());
        $widgets_manager->register(new dej_BlogSlider_1());
        $widgets_manager->register(new dej_BlogSlider_2());
        $widgets_manager->register(new dej_BlogGrid_1());
        $widgets_manager->register(new dej_SocialIcons_1());
        $widgets_manager->register(new dej_Story());
        $widgets_manager->register(new dej_NamadSlider_1());
        $widgets_manager->register(new dej_ListIcons_1());
        $widgets_manager->register(new dej_AboutUs());
        if (dej_woo_activated()) {
            $widgets_manager->register(new dej_HeaderIcon_1());
            $widgets_manager->register(new dej_Cart());
            $widgets_manager->register(new dej_ProductSlider_1());
            $widgets_manager->register(new dej_ProductSlider_2());
            $widgets_manager->register(new dej_ProductSlider_3());
            $widgets_manager->register(new dej_ProductSlider_4());
            $widgets_manager->register(new dej_ProductSlider_5());
            $widgets_manager->register(new dej_AmazingOffer_1());
            $widgets_manager->register(new dej_RandomProduct_1());
            $widgets_manager->register(new dej_Productlist_1());
            $widgets_manager->register(new dej_ProductlistSlider_1());
            $widgets_manager->register(new dej_ProductColumn_1());
            $widgets_manager->register(new dej_ProductGrid_1());
            $widgets_manager->register(new dej_BreadCrumb());
            //        single product widget

            $widgets_manager->register(new dej_ProductImageGallery());
            $widgets_manager->register(new dej_ProductTabs());
            $widgets_manager->register(new dej_ProductLabel());
            $widgets_manager->register(new dej_ProductWarranty());
            $widgets_manager->register(new dej_ProductSendDuration());
            $widgets_manager->register(new dej_ProductAlarm());
            $widgets_manager->register(new dej_ActionIcons());
            $widgets_manager->register(new dej_ProductEnTitle());
            $widgets_manager->register(new dej_ProductCountDown());
            $widgets_manager->register(new dej_ProductStockBar());
            $widgets_manager->register(new dej_ProductStarRate());
            $widgets_manager->register(new dej_ProductMeta());
            $widgets_manager->register(new dej_ProductRelated());
            $widgets_manager->register(new dej_ProductUpSells());
            $widgets_manager->register(new dej_ProductRecommend());
            $widgets_manager->register(new dej_ProductDiscount());
            $widgets_manager->register(new dej_ProductBrandImage());
            $widgets_manager->register(new dej_ProductAddToCart());
            $widgets_manager->register(new dej_ProductAttrShort());
            $widgets_manager->register(new dej_ProductPrice());
            $widgets_manager->register(new dej_ProductUpdateTime());
        }
        $widgets_manager->register(new dej_PostTitle());
        $widgets_manager->register(new dej_PostRelated());
        $widgets_manager->register(new dej_PostMeta());
        $widgets_manager->register(new dej_PostShare());
        $widgets_manager->register(new dej_PostTags());


    }

    public function init()
    {
        add_action('elementor/widgets/register', [$this, 'register_widgets']);

    }

    public function add_elementor_widget_categories($elements_manager)
    {


        $categories = [];
        $categories['dejavo'] = [
            'title' => esc_html__('دژاوو', 'dejavo'),
            'icon' => 'fa fa-plug',
        ];
        $categories['dejavo-header'] = [
            'title' => esc_html__('دژاوو - هدر', 'dejavo'),
            'icon' => 'fa fa-plug',
        ];
        $categories['dejavo-footer'] = [
            'title' => esc_html__('دژاوو - فوتر', 'dejavo'),
            'icon' => 'fa fa-plug',
        ];
        $categories['dejavo-single-product'] = [
            'title' => esc_html__('دژاوو - صفحه محصول', 'dejavo'),
            'icon' => 'fa fa-plug',
        ];

        $categories['dejavo-post'] = [
            'title' => esc_html__('دژاوو - وبلاگ', 'dejavo'),
            'icon' => 'fa fa-plug',
        ];


        $old_categories = $elements_manager->get_categories();
        $categories = array_merge($categories, $old_categories);
        $set_categories = function ($categories) {
            $this->categories = $categories;
        };

        $set_categories->call($elements_manager, $categories);

    }

    public function add_custom_icons_tab($tabs = array())
    {

        $tabs['my-custom-icons'] = array(
            'name' => 'dejavo-custom-icons',
            'label' => esc_html__('آیکن های قالب دژاوو', 'dejavo'),
            'labelIcon' => 'eicon-pojome',
            'prefix' => '',
            'displayPrefix' => '',
            'icons' => dejavo_font_icons(),
            'ver' => '1.0.0',
        );

        return $tabs;
    }

    public function dejavo_editor_stylesheets()
    {

        wp_register_style('dejavo-icons', DEJ_CSS . 'icons.min.css');
        wp_enqueue_style('dejavo-icons');

        wp_dequeue_style('e-animations');
        wp_enqueue_style('e-animations');

        wp_dequeue_style('swiper');
        wp_deregister_style('swiper');
        wp_register_style('dej-swiper', DEJ_LIB . 'swiper/swiper-bundle.min.css', '', '9.0.5');
        wp_enqueue_style('dej-swiper');

    }
    public function dejavo_editor_scripts()
    {

        wp_register_script('countdown', DEJ_JS . 'jquery.countdown.min.js', array('jquery'), '2.2', true);
        wp_enqueue_script('countdown');

        wp_dequeue_script('swiper');
        wp_deregister_script('swiper');
        wp_register_script('dej-swiper', DEJ_LIB . 'swiper/swiper-bundle.min.js', array('jquery'), '9.0.5');
        wp_enqueue_script('dej-swiper');

        wp_register_script('Dejavo-Theme', DEJ_JS . 'dejavo.js', array('jquery'), DEJ_VERSION, true);
        wp_enqueue_script('Dejavo-Theme');

        wp_register_script('magnific-popup', DEJ_TUI . '/assets/libs/magnific-popup/jquery.magnific-popup.min.js', array('jquery'), '1.1');
        wp_enqueue_script('magnific-popup');

    }

    public function dejavo_register_elementor_locations($elementor_theme_manager)
    {

        $elementor_theme_manager->register_all_core_location();

    }
    public function __construct()
    {

        add_action('elementor/elements/categories_registered', [$this, 'add_elementor_widget_categories']);
        add_action('elementor/theme/register_locations', [$this, 'dejavo_register_elementor_locations']);
        add_action('elementor/icons_manager/additional_tabs', [$this, 'add_custom_icons_tab']);
        add_action('elementor/editor/before_enqueue_styles', [$this, 'dejavo_editor_stylesheets']);
        add_action('elementor/editor/before_enqueue_scripts', [$this, 'dejavo_editor_scripts']);
        add_action('elementor/init', [$this, 'init']);

    }
}

dejavo_Elementor_Widgets::instance();
