<?php
defined('ABSPATH') || exit;
class dej_Banner_2 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_banner2';
    }

    public function get_title()
    {
        return esc_html__('بنر 2', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-picture';
    }


    public function get_categories()
    {
        return ['dejavo'];
    }


    public function get_keywords()
    {
        return ['بنر', 'banner'];
    }
    protected function is_dynamic_content(): bool {
        return false;
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'dejavo'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__('لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('کپشن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('متن کپشن', 'dejavo'),
                'label_block' => true,

            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'hover_animation',
            [
                'label' => esc_html__('هاور انیمیشن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->add_control(
            'anim_duration',
            [
                'label' => esc_html__('مدت انیمیشن (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 4000,
                'step' => 100,
                'default' => 1200,
                'selectors' => [
                    '{{WRAPPER}} .banner2 a' => 'transition-duration: {{SIZE}}ms !important',
                ],
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .banner2',
            ]
        );

        $this->add_control(
            'more_options2',
            [
                'label' => esc_html__('رنگ روکش تصویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'overlay-background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .banner2 .overlay:before',
            ]
        );

        $this->add_responsive_control(
            'margin',
            [
                'label' => esc_html__('فاصله بیرونی کپشن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner2 .caption' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله درونی کپشن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner2 .caption' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر بنر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner2, {{WRAPPER}} .banner2 > a img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'cap_b_radius',
            [
                'label' => esc_html__('کادر کپشن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner2 .caption' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ کپشن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner2 .caption a' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'cap_bg',
            [
                'label' => esc_html__('پس زمینه کپشن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner2 .caption' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'font-size-h3',
            [
                'label' => esc_html__('سایز فونت کپشن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 14,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner2 .caption a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'shadow',
                'selector' => '{{WRAPPER}} .banner2',
            ]
        );
        $this->add_control(
            'shadow_h2',
            [
                'label' => esc_html__( 'هاور سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_shadow',
                'selector' => '{{WRAPPER}} .banner2:hover',
            ]
        );


        $this->end_controls_section();


    }


    protected function render()
    {
        $data = $this->get_settings_for_display();

        if (!empty($data['link']['url'])) {
            $this->add_link_attributes('link', $data['link']);
        }

        $animClass = '';
        if ($data['hover_animation']) {
            $animClass .= 'elementor-animation-' . $data['hover_animation'];
        }
        ?>
        <div class="banner2">
            <a class="overlay <?= $animClass ?>" <?php echo $this->get_render_attribute_string('link'); ?>>
                <?php if ($data['image']) {
                    echo wp_get_attachment_image($data['image']['id'], 'original');
                } ?>
            </a>
            <?php if (!empty($data['title'])) { ?>
            <div class="caption">
                <a <?php echo $this->get_render_attribute_string('link'); ?>>
                    <?= $data['title'] ?>
                </a>
            </div>
        <?php } ?>
        </div>
        <?php
    }

}
