<?php
defined('ABSPATH') || exit;
class dej_AboutUs extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'dej_about_us';
    }

    public function get_title()
    {
        return esc_html__('درباره ما', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-text';
    }

    public function get_categories()
    {
        return ['dejavo-footer', 'dejavo'];
    }

    protected function is_dynamic_content(): bool {
        return false;
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'default' => esc_html__('درباره فروشگاه اینترنتی دژاوو', 'dejavo'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__('آیکن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-shop',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'accordion',
            [
                'label' => esc_html__('آکاردئون', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'about_content',
            [
                'label' => esc_html__('Description', 'dejavo'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.', 'dejavo'),
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'main_style',
            [
                'label' => esc_html__('کلی', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_responsive_control(
            'accordion_height',
            [
                'label' => esc_html__('حداکثر ارتفاع حالت آکاردئون', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 600,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us.accordion .content' => 'max-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_head',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .dej_about_us',
            ]
        );

        $this->add_control(
            'bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'w_bg',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us, {{WRAPPER}} .dej_about_us .short_text_btn, {{WRAPPER}} .dej_about_us .short_text_btn:before' => 'background: {{VALUE}} ;',
                ],
            ]
        );
        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dej_about_us',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .w_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'i_title_padding',
            [
                'label' => esc_html__('فاصله از داخل آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .w_title i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_border_radius',
            [
                'label' => esc_html__('کادر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .w_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'i_title_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .w_title i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_bor_head',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'title_border',
                'selector' => '{{WRAPPER}} .dej_about_us .w_title',
            ]
        );

        $this->add_control(
            'title_bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('پس زمینه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .w_title' => 'background-color: {{VALUE}} ;',
                ],
            ]
        );

        $this->add_control(
            'title_icon_bg',
            [
                'label' => esc_html__('پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .w_title i' => 'background-color: {{VALUE}}'
                ]
            ]
        );
        $this->add_control(
            'title_icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .w_title i' => 'color: {{VALUE}}'
                ]
            ]
        );
        $this->add_control(
            'title_w_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .w_title' => 'color: {{VALUE}} ;',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_font_s',
            [
                'label' => esc_html__('سایز فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us h2.w_title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_icon_font_s',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .w_title i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('محتوا', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_align',
            [
                'label' => esc_html__( 'Alignment', 'elementor' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__( 'Right', 'elementor' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Right', 'elementor' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                    'left' => [
                        'title' => esc_html__( 'Left', 'elementor' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elementor' ),
                        'icon' => 'eicon-text-align-center',
                    ],

                ],
                'default' => 'justify',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .content' => 'text-align: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'content_font_size',
            [
                'label' => esc_html__('سایز فونت مت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .content' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('رنگ متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_about_us .content, {{WRAPPER}} .dej_about_us .content p, {{WRAPPER}} .dej_about_us .short_text_btn .outer' => 'color: {{VALUE}} ;',
                ],
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $title = $data['title'];
        $accordion = $data['accordion'];
        $title_icon = $data['title_icon']['value'] ?? '';
        $content = $data['about_content']; ?>
        <div class="dej_about_us <?php if ($accordion) { ?> accordion <?php } ?>">
            <?php if ($title) { ?>
                <h2 class="w_title"><?php if ($title_icon) { ?> <i class="<?= $title_icon ?>"></i><?php }
                echo $title; ?></h2><?php } ?>
            <div class="content">
                <?= $content ?>
            </div>
        </div>
        <?php

    }
}
