<?php
defined('ABSPATH') || exit;
class dej_ListIcons_1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_list_icons_1';
    }

    public function get_title()
    {
        return esc_html__('لیست آیکن', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-list';
    }

    public function get_categories()
    {
        return ['dejavo', 'dejavo-footer', 'dejavo-header'];
    }

    public function has_widget_inner_wrapper(): bool {
        return false;
    }
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'default' => esc_html__('لیست آیکن', 'dejavo'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__('آیکن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-minus-small',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'mob_accordion',
            [
                'label' => esc_html__('آکاردئون در حالت موبایل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $list_icon = new \Elementor\Repeater();

        $list_icon->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('اینستاگرام', 'dejavo'),
                'label_block' => true,
            ]
        );

        $list_icon->add_control(
            'icon',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );
        $list_icon->add_control(
            'link',
            [
                'label' => esc_html__('لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
            ]
        );


        $this->add_control(
            'icons',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $list_icon->get_controls(),           /* Use our repeater */
                'default' => [
                    [
                        'title' => esc_html__('تهران خیابان 1 کوچه 2 پلاک 3', 'dejavo'),
                        'icon' => [
                            'value' => 'dej-marker',
                        ],
                        'link' => [
                            'url' => '#',
                            'is_external' => true,
                            'nofollow' => true,
                            'custom_attributes' => '',
                        ],
                    ],

                    [
                        'title' => esc_html__('info@yoursite.ir', 'dejavo'),
                        'icon' => [
                            'value' => 'dej-envelope',
                        ],
                        'link' => [
                            'url' => 'mailto:info@yoursite.ir',
                            'is_external' => true,
                            'nofollow' => true,
                            'custom_attributes' => '',
                        ],
                    ],
                    [
                        'title' => esc_html__('021000000', 'dejavo'),
                        'icon' => [
                            'value' => 'dej-phone-call',
                        ],
                        'link' => [
                            'url' => 'tel:021000000',
                            'is_external' => true,
                            'nofollow' => true,
                            'custom_attributes' => '',
                        ],
                    ],

                    [
                        'title' => esc_html__('09120000000', 'dejavo'),
                        'icon' => [
                            'value' => 'dej-smartphone',
                        ],
                        'link' => [
                            'url' => 'tel:09120000000',
                            'is_external' => true,
                            'nofollow' => true,
                            'custom_attributes' => '',
                        ],
                    ],

                ],
                'title_field' => '{{{ title }}}',
            ]
        );


        $this->end_controls_section();





        $this->start_controls_section(
            'main_style',
            [
                'label' => esc_html__('کلی', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_head',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .list_icons_1',
            ]
        );

        $this->add_control(
            'bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .list_icons_1',
            ]
        );

        $this->end_controls_section();







        $this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'title_width',
            [
                'label' => esc_html__( 'غرض', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'auto' => [
                        'title' => esc_html__( 'در متن', 'dejavo' ),
                        'icon' => 'dej-align-right',
                    ],
                    '100%' => [
                        'title' => esc_html__( 'تمام عرض', 'dejavo' ),
                        'icon' => 'dej-align-justify',
                    ],
                ],
                'default' => '100%',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title' => 'width: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_flex_dir',
            [
                'label' => esc_html__( 'جهت عنوان و محتوا', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'column' => [
                        'title' => esc_html__( 'عمودی', 'dejavo' ),
                        'icon' => 'dej-arrows-alt-v',
                    ],
                    'row' => [
                        'title' => esc_html__( 'افقی', 'dejavo' ),
                        'icon' => 'dej-arrows-alt-h',
                    ],
                ],
                'default' => 'column',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1' => 'flex-direction: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_justify_co',
            [
                'label' => esc_html__( 'چیدمان عنوان و محتوا', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'flex-start',
                'condition' => [
                    'flex_dir' => 'row',
                ],
                'options' => [
                    '' => esc_html__( 'Default', 'dejavo' ),
                    'flex-start' => esc_html__( 'start', 'dejavo' ),
                    'flex-end'  => esc_html__( 'end', 'dejavo' ),
                    'center' => esc_html__( 'center', 'dejavo' ),
                    'space-between' => esc_html__( 'between', 'dejavo' ),
                    'space-around' => esc_html__( 'around', 'dejavo' ),
                    'space-evenly' => esc_html__( 'evenly', 'dejavo' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_justify',
            [
                'label' => esc_html__( 'چیدمان عنوان', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'flex-start',
                'options' => [
                    '' => esc_html__( 'Default', 'dejavo' ),
                    'flex-start' => esc_html__( 'start', 'dejavo' ),
                    'flex-end'  => esc_html__( 'end', 'dejavo' ),
                    'center' => esc_html__( 'center', 'dejavo' ),
                    'space-between' => esc_html__( 'between', 'dejavo' ),
                    'space-around' => esc_html__( 'around', 'dejavo' ),
                    'space-evenly' => esc_html__( 'evenly', 'dejavo' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title' => 'justify-content: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'i_title_padding',
            [
                'label' => esc_html__('فاصله از داخل آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title .head i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_border_radius',
            [
                'label' => esc_html__('کادر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'i_title_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title .head i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_bor_head',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'title_border',
                'selector' => '{{WRAPPER}} .list_icons_1 .w_title',
            ]
        );

        $this->add_control(
            'title_bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('پس زمینه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title' => 'background-color: {{VALUE}} ;',
                ],
            ]
        );

        $this->add_control(
            'mob_title_bg',
            [
                'label' => esc_html__('پس زمینه عنوان در حالت آکاردئونی موبایل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1.mob_accordion .w_title' => 'background-color: {{VALUE}} ;',
                ],
            ]
        );

        $this->add_control(
            'title_icon_bg',
            [
                'label' => esc_html__('پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title .head i' => 'background-color: {{VALUE}}'
                ]
            ]
        );
        $this->add_control(
            'title_icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title .head i' => 'color: {{VALUE}}'
                ]
            ]
        );
        $this->add_control(
            'title_w_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title' => 'color: {{VALUE}} ;',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_font_s',
            [
                'label' => esc_html__('سایز فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title .head' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_icon_font_s',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .w_title .head i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();








        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('آیتم ها', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );



        $this->add_responsive_control(
            'flex_dir',
            [
                'label' => esc_html__( 'جهت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'column' => [
                        'title' => esc_html__( 'عمودی', 'dejavo' ),
                        'icon' => 'dej-arrows-alt-v',
                    ],
                    'row' => [
                        'title' => esc_html__( 'افقی', 'dejavo' ),
                        'icon' => 'dej-arrows-alt-h',
                    ],
                ],
                'default' => 'column',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .content' => 'flex-direction: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'justify_content',
            [
                'label' => esc_html__( 'چیدمان', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'flex-start',
                'options' => [
                    '' => esc_html__( 'Default', 'dejavo' ),
                    'flex-start' => esc_html__( 'start', 'dejavo' ),
                    'flex-end'  => esc_html__( 'end', 'dejavo' ),
                    'center' => esc_html__( 'center', 'dejavo' ),
                    'space-between' => esc_html__( 'between', 'dejavo' ),
                    'space-around' => esc_html__( 'around', 'dejavo' ),
                    'space-evenly' => esc_html__( 'evenly', 'dejavo' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .content' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'align_items',
            [
                'label' => esc_html__( 'چیدمان', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'Default', 'dejavo' ),
                    'flex-start' => esc_html__( 'start', 'dejavo' ),
                    'flex-end'  => esc_html__( 'end', 'dejavo' ),
                    'center' => esc_html__( 'center', 'dejavo' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .content' => 'align-items: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'flex_gap',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 7,
                ],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .content' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'flex_gap_item',
            [
                'label' => esc_html__('فاصله بین آیکن و متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 40,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 4,
                ],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );




        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('فاصله از داخل آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__('فاصله از داخل آیکن ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );



        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_border_radius',
            [
                'label' => esc_html__('کادر آیکن ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'bor_head_before',
            [
                'label' => esc_html__('مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .list_icons_1 .item',
            ]
        );

        $this->add_control(
            'hover_border_color',
            [
                'label' => esc_html__('رنگ هاور مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'bor_head_after',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'item_bg',
            [
                'label' => esc_html__('پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item' => 'background-color: {{VALUE}} ;',
                ],
            ]
        );


        $this->add_control(
            'hover_item_bg',
            [
                'label' => esc_html__('هاور پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item:hover' => 'background-color: {{VALUE}} ;',
                ],
            ]
        );



        $this->add_control(
            'icon_bg',
            [
                'label' => esc_html__('پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item .icon' => 'background-color: {{VALUE}}'
                ]
            ]
        );
        $this->add_control(
            'hover_icon_bg',
            [
                'label' => esc_html__('هاور پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item:hover .icon' => 'background-color: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item .icon' => 'color: {{VALUE}}'
                ]
            ]
        );
        $this->add_control(
            'hover_icon_color',
            [
                'label' => esc_html__('رنگ هاور آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item:hover .icon' => 'color: {{VALUE}}'
                ]
            ]
        );




        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item .title' => 'color: {{VALUE}} ;',
                ],
            ]
        );


        $this->add_control(
            'hover_title_color',
            [
                'label' => esc_html__('رنگ هاور عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item:hover .title' => 'color: {{VALUE}} ;',
                ],
            ]
        );


        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .list_icons_1 .item .title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه آیکن ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .list_icons_1 .item .icon',
            ]
        );
        $this->add_control(
            'shadow_h2',
            [
                'label' => esc_html__( 'هاور سایه آیکن ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_shadow',
                'selector' => '{{WRAPPER}} .list_icons_1 .item:hover .icon',
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $items = $data['icons'];
        $title = $data['title'];
        $mob_accordion = $data['mob_accordion'];
        $title_icon = $data['title_icon']['value'] ?? '';
        if ($items) { ?>
            <div class="list_icons_1 <?php if ($mob_accordion == 'yes' and dej_is_mobile()) { ?> mob_accordion <?php } ?>">
                <?php if ($title) { ?>
                <div class="w_title"><div class="head"><?php if ($title_icon) { ?> <i class="<?= $title_icon ?>"></i><?php } echo $title; ?></div>  <?php if ($mob_accordion ==='yes' and dej_is_mobile()) { ?> <i class="dej-angle-down"></i> <?php } ?></div>
                <?php } ?>
                <div class="accordion">
                <div class="content">
                <?php foreach ($items as $item) {
                    $link = $item['link']['url'];
                    $is_external = $item['link']['is_external'] ? 'target="_blank"' : '';
                    $before_url = !empty($link) ? '<a ' . $is_external . ' href="' . $link . '">' : '';
                    $after_url = !empty($link) ? '</a>' : ''; ?>
                    <?= $before_url ?>
                    <div class="item elementor-repeater-item-<?= esc_attr($item['_id']) ?>">
                        <div class="icon"><i class="<?= $item['icon']['value'] ?>"></i></div>
                        <?php if ($item['title']) {
                            echo '<div class="title">' . $item['title'] . '</div>';
                        } ?>
                    </div>
                    <?= $after_url ?>
                <?php } ?>
                    </div>
                    </div>
            </div>
            <?php
        }

    }
}
