<?php
defined('ABSPATH') || exit;
class dej_SocialIcons_1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_social_icons_1';
    }

    public function get_title()
    {
        return esc_html__('آیکن های شبکه های اجتماعی', 'dejavo');
    }

    public function get_icon()
    {
        return 'dejbrand-instagram';
    }

    public function get_categories()
    {
        return ['dejavo-footer'];
    }
    protected function is_dynamic_content(): bool {
        return false;
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('آیکن باکس', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $Social_icon = new \Elementor\Repeater();

        $Social_icon->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('اینستاگرام', 'dejavo'),
                'label_block' => true,
            ]
        );

        $Social_icon->add_control(
            'icon',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );
        $Social_icon->add_control(
            'link',
            [
                'label' => esc_html__('لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
            ]
        );


        $Social_icon->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} a .icon i' => 'color: {{VALUE}}'
                ]
            ]
        );

        $Social_icon->add_control(
            'hover_icon_color',
            [
                'label' => esc_html__('رنگ  هاور آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} a:hover .icon i' => 'color: {{VALUE}}'
                ]
            ]
        );


        $this->add_control(
            'icons',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $Social_icon->get_controls(),           /* Use our repeater */
                'default' => [

                    'title' => esc_html__('عنوان', 'dejavo'),
                    'icon' => [
                        'value' => 'dejbrand-instagram',
                    ],
                    'link' => [
                        'url' => '',
                        'is_external' => true,
                        'nofollow' => true,
                        'custom_attributes' => '',
                    ],

                ],
                'title_field' => '{{{ title }}}',
            ]
        );


        $this->end_controls_section();
        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'hover_animation',
            [
                'label' => esc_html__('انیمیش هاور آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ANIMATION,
            ]
        );
        $this->add_control(
            'anim_duration',
            [
                'label' => esc_html__('مدت انیمیشن (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 4000,
                'step' => 100,
                'default' => 1200,
                'selectors' => [
                    '{{WRAPPER}} .social_icons_1 .item .icon' => 'transition-duration: {{SIZE}}ms !important; animation-duration: {{SIZE}}ms !important',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .social_icons_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('فاصله از داخل آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .social_icons_1 .item a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .social_icons_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .social_icons_1 .item a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'more_options',
            [
                'label' => esc_html__('مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .social_icons_1 .item a',
            ]
        );

        $this->add_control(
            'hover_border_color',
            [
                'label' => esc_html__('رنگ هاور مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social_icons_1 .item a:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .social_icons_1',
            ]
        );

        $this->add_control(
            'item_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social_icons_1 .item a' => 'background-color: {{VALUE}} ;',
                ],
            ]
        );


        $this->add_control(
            'hover_item_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social_icons_1 .item a:hover' => 'background-color: {{VALUE}} ;',
                ],
            ]
        );

        $this->add_control(
            'title-color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social_icons_1 .item a .title' => 'color: {{VALUE}} ;',
                ],
            ]
        );


        $this->add_control(
            'hover-item-color',
            [
                'label' => esc_html__('رنگ هاور عناوین', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social_icons_1 .item a:hover .title' => 'color: {{VALUE}} ;',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .item a .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 13,
                ],
                'selectors' => [
                    '{{WRAPPER}} .item a:hover .title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .social_icons_1 .item a',
            ]
        );
        $this->add_control(
            'shadow_h2',
            [
                'label' => esc_html__( 'هاور سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_shadow',
                'selector' => '{{WRAPPER}} .social_icons_1 .item:hover a',
            ]
        );




        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $items = $data['icons'];
        if ($items) { ?>
            <div class="social_icons_1">
                <?php foreach ($items as $item) {
                    $link = $item['link']['url'];
                    $is_external = $item['link']['is_external'] ? 'target="_blank"' : '';
                    $before_url = !empty($link) ? '<a ' . $is_external . ' href="' . $link . '">' : '<a href="#">';
                    ?>
                    <div class="item elementor-repeater-item-<?= esc_attr($item['_id']) ?>">
                        <?= $before_url ?>
                        <div class="icon"><i class="<?= $item['icon']['value'] ?>"></i></div>
                        <?php if ($item['title']) {
                            echo '<div class="title">' . $item['title'] . '</div>';
                        } ?>
                        </a>
                    </div>
                <?php } ?>
            </div>
            <script>
                jQuery(document).ready(function ($) {
                    var social_item = $('.social_icons_1 a');
                    social_item.mouseover(function () {
                        $(this).children('.icon').addClass('<?= $data['hover_animation'] ?>');
                    });
                    social_item.mouseout(function () {
                        $(this).children('.icon').removeClass('<?= $data['hover_animation'] ?>');
                    });
                });
            </script>
            <?php
        }

    }
}
