<?php
defined('ABSPATH') || exit;
class dej_HeaderLogo_1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_logo';
    }

    public function get_title()
    {
        return esc_html__('لوگو', 'dejavo');
    }


    public function get_icon()
    {
        return 'dej-flag-alt';
    }


    public function get_categories()
    {
        return ['dejavo-header'];
    }


    public function get_keywords()
    {
        return ['لوگو', 'logo'];
    }

    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );



        $this->add_responsive_control(
            'logo_max_width',
            [
                'label' => esc_html__('حداکثر عرض', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 400,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_logo img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'logo_margin',
            [
                'label' => esc_html__('فاصله بیرونی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_logo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'logo_padding',
            [
                'label' => esc_html__('فاصله درونی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_logo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dejavo_logo',
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $logo_anime = dej_opt('logo_anime', 1) ? 'shimmer': '';
        $main_logo = dej_opt('dej_main_logo'); ?>
        <a class="dejavo_logo <?= $logo_anime ?>" href="<?php bloginfo('url'); ?>">
            <?php if ($main_logo) { ?><img alt="<?php bloginfo('name') ?>" src="<?= $main_logo ?>">
            <?php } if (empty($main_logo) ) { bloginfo('name'); } ?></a>
        <?php
    }
}
