<?php
defined('ABSPATH') || exit;
class dej_HeaderSearch_1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_search';
    }

    public function get_title()
    {
        return esc_html__('جست و جو', 'dejavo');
    }


    public function get_icon()
    {
        return 'dej-search';
    }


    public function get_categories()
    {
        return ['dejavo-header'];
    }


    public function get_keywords()
    {
        return ['جست و جو', 'search'];
    }

    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'placeholder',
            [
                'label' => esc_html__('متن نگهدارنده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('جست و جو کنید ...', 'dejavo'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'show_cats',
            [
                'label' => esc_html__('نمایش دسته بندی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_control(
            'style',
            [
                'label' => esc_html__('سبک نمایش ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('یک', 'dejavo'),
                    '2' => esc_html__('دو', 'dejavo'),
                    '3' => esc_html__('سه', 'dejavo'),
                    '4' => esc_html__('چهار', 'dejavo'),
                ],
            ]
        );


        $this->add_responsive_control(
            'logo_margin',
            [
                'label' => esc_html__('فاصله بیرونی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_search' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر گوشه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '.DejavoSE-area, {{WRAPPER}} .DejavoSE_search_cats, {{WRAPPER}} .dejavo_search input, {{WRAPPER}} .dejavo_search.style1 .dejavo_search_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'input_height',
            [
                'label' => esc_html__('سرعت تعویض', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 30,
                'max' => 80,
                'step' => 1,
                'default' => 40,
                'selectors' => [
                    '{{WRAPPER}} ' => 'border-radius: {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
            'height',
            [
                'label' => esc_html__('ارتفاع', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 100,
                        'step' => 1,
                    ],

                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_search' => '--dej-search-height: {{SIZE}}{{UNIT}};',
                    '.DejavoSE-popular-keywords' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'max_width',
            [
                'label' => esc_html__('حداکثر عرض', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 800,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_search' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'bg_head',
            [
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'widget_bg',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .dejavo_search input',
            ]
        );
        $this->add_control(
            'txt_color',
            [
                'label' => esc_html__('رنگ متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_search input, {{WRAPPER}} .dejavo_search input::placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .dejavo_search input::placeholder' => 'opacity: 0.6',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_search_btn, {{WRAPPER}} .search_cats_btn, {{WRAPPER}} .dej_search_btn_simple' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'cats_bg',
            [
                'label' => esc_html__('رنگ پس زمینه انخاب دسته استایل 1', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_search.style1 .DejavoSE_search_cats ' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'cats_color',
            [
                'label' => esc_html__('رنگ متن انخاب دسته استایل 1', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_search.style1 .DejavoSE_search_cats' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'btn_bg',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_search_btn' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_btn_bg',
            [
                'label' => esc_html__('رنگ پس زمینه هاور دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_search_btn:hover' => 'background: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'bor_head_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dejavo_search input',
            ]
        );


        $this->add_control(
            'bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'bor_head_be2',
            [
                'label' => esc_html__('مرز دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} .dejavo_search_btn',
            ]
        );


        $this->add_control(
            'bor_head_af2',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $style = $data['style'] ?? '1';
        $placeholder = $data['placeholder'];
        $show_cats = false;

        $taxonomy = '';
        if (dej_woo_activated() and (is_product() || is_home() || is_product_taxonomy() || is_shop() || is_page()))  {
            $taxonomy = 'product_cat';
        } else {
            $taxonomy = 'category';
        }
        $category_args = apply_filters('DejavoSE_search_category_args', [
            'name' => 'search-cats',
            'id' => 'DejavoSE_search_cats',
            'class' => 'DejavoSE_search_cats',
            'taxonomy'     => $taxonomy,
            'orderby'            => 'ID',
            'order'              => 'ASC',
            'show_count'         => 1,
            'hide_empty'         => 1,
            'child_of'           => 0,
            'depth'              => 1,
            'value_field' => 'id',
            'show_option_all' => esc_html__('All categories', 'dejavo'),
            'show_option_none' => '',
        ]);

        if ($data['show_cats'] and class_exists('DejavoSearch') and DejavoSearch::get_setting('search_category', 'yes') === 'yes') {
            $show_cats = true;
        }
        ?>

        <form class="dejavo_search style<?= $style ?> search-form" action="<?= home_url( '/' ); ?>" method="get">
            <input type="search" name="s" value="<?= esc_attr(apply_filters('the_search_query', get_search_query())); ?>" class="form"  placeholder="<?php
        if ($placeholder) {
            echo $placeholder;
        } else {
            echo 'جست و جو در ';  bloginfo('name'); echo ' ...';
        } ?>" aria-label="Search">
            <?php  if ($show_cats) {
            if ($style !== '1') {
                echo '<div class="search_cats_btn"><i class="dej-settings-sliders"></i></div>';
            }
             wp_dropdown_categories($category_args);
        }

        if (dej_woo_activated() and (is_product() || is_home() || is_product_taxonomy() || is_shop() || is_page())) {
            echo '<input type="hidden" name="post_type" value="product">';
        }

        if ($style === '4') {
            echo '<button class="dej_search_btn_simple" type="submit"><i class="dej-search"></i></button></form>';
        } else {
            echo '<button class="dejavo_search_btn" type="submit"><i class="dej-search"></i></button></form>';
        }


    }


}
