<?php
defined('ABSPATH') || exit;
class dej_AmazingOffer_1 extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'dej_amazing_offer';
    }

    public function get_style_depends(): array {
        return [ 'dej-amazing-offer', 'dej-animations'];
    }

    public function get_title()
    {
        return esc_html__('پیشنهادات شگفت انگیز', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-magic-wand';
    }

    public function get_categories()
    {
        return ['dejavo'];
    }

    public function get_keywords()
    {
        return ['شگفت انگیز'];
    }

    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {

        $product_cat = [];
        $cats = get_terms("product_cat");
        if (!is_wp_error($cats) && !empty($cats)) {
            foreach ($cats as $cat) {
                $product_cat[$cat->term_id] = $cat->name;
            }
        }
        $product_tag = [];
        $tags = get_terms("product_tag");
        if (!is_wp_error($tags) && !empty($tags)) {
            foreach ($tags as $tag) {
                $product_tag[$tag->term_id] = $tag->name;
            }
        }

        $product_attr = [];
        foreach (wc_get_attribute_taxonomies() as $attr) {
            $product_attr[$attr->attribute_id] = $attr->attribute_label;
        }


        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('اسلایدر', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'default' => esc_html__('پیشنهاد شگفت انگیز', 'dejavo'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'important_note',
            [
                'label' => esc_html__('نکنه مهم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::RAW_HTML,
                'raw' => esc_html__('برای نمایش فیلد های دلخواه از ویژگی ها انتخب کنید همچین برای ویژگی ها از نامک انگلیسی استفاده کنید', 'dejavo'),
            ]
        );
        $this->add_control(
            'important_note2',
            [
                'label' => esc_html__('نکته مهم 2', 'dejavo'),
                'type' => \Elementor\Controls_Manager::RAW_HTML,
                'raw' => esc_html__('در صورت نمایش توضیحات کوتاه امکان نمایش ویژگی ها وجود ندارد', 'dejavo'),
            ]
        );
        $this->add_control(
            'short_desc',
            [
                'label' => esc_html__('نمایش توضیحات کوتاه ؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );


        $this->add_control(
            'attr',
            [
                'label' => esc_html__('ویژگی ها جهت نمایش', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $product_attr,
                'multiple' => true,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'short_desc',
                            'operator' => '!==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'variations',
            [
                'label' => esc_html__('نمایش متغیر ها ؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'only_display_var',
            [
                'label' => esc_html__('نمایش متغیر ها به صورت نمایشی ؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'variations' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__('تعداد مطالب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 20,
                'step' => 1,
                'default' => 8,
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('ترتیب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC' => esc_html__('نزولی', 'dejavo'),
                    'ASC' => esc_html__('صعودی', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('روش ترتیب بندی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'rand' => esc_html__('تصادفی', 'dejavo'),
                    'date' => esc_html__('تاریخ', 'dejavo'),
                    'modified' => esc_html__('بروزرسانی', 'dejavo'),
                ],
            ]
        );



        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('فیلتر دسته بندی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'category',
            [
                'label' => esc_html__('دسته بندی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_cat' => 'yes',
                ],
                'options' => $product_cat,
                'multiple' => true,
            ]
        );
        $this->add_control(
            'show_tag',
            [
                'label' => esc_html__('فیلتر برچسب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'tags',
            [
                'label' => esc_html__('برچسب ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_tag' => 'yes',
                ],
                'options' => $product_tag,
                'multiple' => true,
            ]
        );

        $this->add_control(
            'show_in_stock',
            [
                'label' => esc_html__('فقط نمایش موجود در انبار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('چرخش خودکار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'change_delay',
            [
                'label' => esc_html__('زمان تاخیر اسکرول خودکار (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3000,
                'max' => 12000,
                'step' => 200,
                'default' => 6000,
            ]
        );
        $this->add_control(
            'change_speed',
            [
                'label' => esc_html__('سرعت تعویض (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 300,
                'max' => 2000,
                'step' => 100,
                'default' => 700,
            ]
        );
        $this->add_responsive_control(
            'arrow-top',
            [
                'label' => esc_html__('فاصله فلش ها از بالا (موبایل)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['%', 'px', 'em'],
                'range' => [
                    '%' => [
                        'min' => 5,
                        'max' => 95,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 33,
                ],
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1 .dejavo_prev_Arrow, {{WRAPPER}} .amazing_offer1  .dejavo_next_Arrow' => 'top: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_control(
            'change_animation',
            [
                'label' => esc_html__('انیمیشن تعویض', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'fade',
                'options' => [
                    'fade' => esc_html__('fade', 'elementor'),
                    'slide' => esc_html__('slide', 'dejavo'),
                    'cube' => esc_html__('cube', 'dejavo'),
                    'coverflow' => esc_html__('coverflow', 'dejavo'),
                    'flip' => esc_html__('flip', 'dejavo'),
                    'cards' => esc_html__('cards', 'dejavo'),
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله درونی ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'widget_bg',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'widget_bg',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .amazing_offer1',
            ]
        );

        $this->add_responsive_control(
            'slide_padding',
            [
                'label' => esc_html__('فاصله درونی محتوا', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1 .slides .item .left' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'tab_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه تب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1 .tabs' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'tab_bg',
            [
                'label' => esc_html__('رنگ پس زمینه تب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tab_background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .amazing_offer1 .tabs',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1 > .title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('رنگ پس زمینه عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1 > .title' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'shape_color',
            [
                'label' => esc_html__('رنگ حاشیه بالا و پایین', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer::after, {{WRAPPER}} .amazing_offer::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'h3-title-color',
            [
                'label' => esc_html__('رنگ عنوان آیتم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1 .slides h3 a' => 'color: {{VALUE}} ; border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'list-color',
            [
                'label' => esc_html__('رنگ لیست ویژگی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1 .list ul li a, {{WRAPPER}} .amazing_offer1 .list ul li, {{WRAPPER}} .amazing_offer1 .product_sale_info' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'price_color',
            [
                'label' => esc_html__('رنگ قیمت بدون تخفیف', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_price .price > .woocommerce-Price-amount' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'price_bg',
            [
                'label' => esc_html__('رنگ پس زمینه قیمت بدون تخفیف', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_price .price > .woocommerce-Price-amount' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'ins_price_color',
            [
                'label' => esc_html__('رنگ قیمت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_price ins' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'ins_price_bg',
            [
                'label' => esc_html__('رنگ پس زمینه قیمت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_price ins' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'del_price_color',
            [
                'label' => esc_html__('رنگ قیمت خط خورده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_price del' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'del_price_bg',
            [
                'label' => esc_html__('رنگ پس زمینه قیمت خط خورده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_price del' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icons_color',
            [
                'label' => esc_html__('رنگ آیکن ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1 .icons a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icons_hover_color',
            [
                'label' => esc_html__('رنگ هاور آیکن ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1 .icons a:hover, {{WRAPPER}} .amazing_offer1 .list ul li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'w_head_bor',
            [
                'label' => esc_html__('مرز ویجت ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'w_border',
                'selector' => '{{WRAPPER}} .amazing_offer1',
            ]
        );


        $this->add_control(
            'w_head_bor_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'bor_tab_head',
            [
                'label' => esc_html__('مرز تب ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tab_border',
                'selector' => '{{WRAPPER}} .amazing_offer1 .tabs',
            ]
        );

        $this->add_control(
            'bor_img_head',
            [
                'label' => esc_html__('مرز تصویر اسلاید', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'img_border',
                'selector' => '{{WRAPPER}} .amazing_offer1 .slides .image img',
            ]
        );

        $this->add_control(
            'bor_tab_img_head',
            [
                'label' => esc_html__('مرز تصویر تب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tab_img_border',
                'selector' => '{{WRAPPER}} .amazing_offer1 .tabs .tab_item',
            ]
        );

        $this->add_control(
            'tab_active_bor_color',
            [
                'label' => esc_html__('رنگ مرز آیتم تب اکتیو', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .amazing_offer1 .tabs .tab_item.swiper-slide-thumb-active' => 'border-color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .amazing_offer1',
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $title = $data['title'];
        $in_stock = $data['show_in_stock'] ?? '';
        $only_display_var = $data['only_display_var'] =='yes' ? true : '';
        $shop_page_url = get_permalink(wc_get_page_id('shop')) ?? '#';
        $wid_id = $this->get_id_int();
        $in_stock_arr = [];
        if ($in_stock == 'yes') {
            $in_stock_arr = [
                'relation' => 'OR',
                ['key' => '_stock_status', 'value' => 'instock',],
                ['key' => '_backorders', 'value' => 'yes',],
            ];
        }
        $product_ids_on_sale = wc_get_product_ids_on_sale();
        $args = ['post_type' => 'product', 'post_status' => 'publish', 'posts_per_page' => $data['number'], 'order' => $data['order'],
            'orderby' => $data['orderby'], 'post__in' => $product_ids_on_sale, 'meta_query' => [$in_stock_arr],];
        if ($data['show_cat'] == "yes" && !empty($data['category'])) {
            $args['tax_query'] = [['taxonomy' => 'product_cat', 'field' => 'term_id', 'terms' => $data['category'],]];
        } elseif ($data['show_tag'] == "yes" && !empty($data['tags'])) {
            $args['tax_query'] = [['taxonomy' => 'product_tag', 'field' => 'term_id', 'terms' => $data['tags'],]];
        }
        $loop = new WP_Query($args); ?>
        <div class="amazing_offer">
            <div class="amazing_offer1">
                <h3 class="title"><a href="<?php echo $shop_page_url . '?stock_status=onsale'; ?>"><?= $title ?></a>
                </h3>
                <div class="tabs">
                    <div class="tabs_slider">
                    <div dir="rtl" thumbsSlider="" class="swiper swiper-thumbs <?php echo ' slider_tab_' . $wid_id; ?> ">
                        <div class="swiper-wrapper">
                            <?php if (dej_woo_activated()) {
                                while ($loop->have_posts()): $loop->the_post();
                                    global $product; ?>
                                    <div class="swiper-slide">
                                    <div class="tab_item">
                                        <?= $product->get_image('woocommerce_thumbnail') ?>
                                    </div>
                                    </div>
                                <?php endwhile;
                                wp_reset_postdata();
                            } ?>
                        </div>
                    </div>
                    </div>
                </div>
                <div class="slides">
                    <div dir="rtl" class="swiper <?= ' amazing_offer_' . $wid_id; ?>">
                        <div class="swiper-wrapper">
                            <?php while ($loop->have_posts()): $loop->the_post();
                                global $product;
                                $product_title = $product->get_title();
                                $product_id = $product->get_id();
                                ?>
                                <div class="item dej_var_product swiper-slide">
                                    <div class="right">
                                        <div class="image">

                                            <a href="<?php the_permalink(); ?>"><?php dejavo_product_box_image(); ?></a>
                                            <?php if (dejavo_contdown_timer()) { ?>
                                                <div class="timer">
                                                    <div class="countdown_time"
                                                         data-times="<?= dejavo_contdown_timer(); ?>"></div>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="left">
                                        <div class="top">
                                        <h3><a href="<?php the_permalink(); ?>"> <i class="dej-bell-ring"></i>
                                                <?= wp_trim_words($product_title, 16, '..') ?> </a></h3>
                                        <?php if ($data['short_desc'] === 'yes' and !dej_is_mobile()) { ?>
                                        <div class="short_desc"> <?= $product->get_short_description(); ?> </div>
                                            <?php
                                        } elseif ($data['attr'] and !dej_is_mobile()) {
                                        $attr_slugs = [];
                                        $attr_labels = [];
                                        foreach ($data['attr'] as $attr) {
                                            $selected_attr = wc_get_attribute($attr);
                                            $attr_slugs[] = $selected_attr->slug;
                                            $attr_labels[] = $selected_attr->name;
                                        }
                                        $attrs = array_combine($attr_slugs, $attr_labels);

                                        if ($attrs) { ?>
                                            <div class="list">
                                                <ul>
                                                    <?php
                                                    foreach ($attrs as $slug => $lebel) {
                                                        global $product;
                                                        $values = $product->get_attribute($slug);
                                                        if (!empty($values)) {
                                                            ?>
                                                            <li><i class="dej-circle-small"></i><span> <?= $lebel . ' : ' . $values ?></span></li>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </ul>
                                            </div>
                                            <?php
                                        }
                                        } ?>
                                        <div class="dej_price">
                                            <?php if ($product->is_on_sale() and dejavo_out_of_stock($product) !== true) { woocommerce_show_product_sale_flash(); }
                                            woocommerce_template_loop_price(); ?>
                                        </div>
                                        <?php if ($data['variations'] === 'yes' and !dej_is_mobile()) { dejavo_variation($only_display_var); } ?>
                                        </div>
                                        <div class="bottom">
                                        <ul class="icons">
                                            <?= sprintf('<li class="hint--top-left" aria-label="%s"><a href="%s" data-quantity="1" class="%s" %s><i class="dej-shopping-bag"></i></a></li>',
                                                esc_html($product->add_to_cart_text()),
                                                esc_url($product->add_to_cart_url()),
                                                esc_attr(implode(' ', array_filter(array(
                                                    '', 'product_type_' . $product->get_type(),
                                                    $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                                    $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
                                                )))),
                                                wc_implode_html_attributes(array(
                                                    'data-product_id' => $product_id,
                                                    'data-product_sku' => $product->get_sku(),
                                                    'aria-label' => $product->add_to_cart_description(),
                                                    'rel' => 'nofollow',
                                                ))
                                            );
                                            ?>
                                            <?php if (class_exists('DejavoWL')) { ?>
                                                <li class="hint--top"
                                                    aria-label="<?php _e('علاقه مندی', 'dejavo') ?>"><?= DejavoWL::wl_btn($product_id) ?></li><?php } ?>
                                            <?php if (class_exists('DejavoCP')) { ?>
                                                <li class="hint--top"
                                                    aria-label="<?php _e('مقایسه', 'dejavo') ?>"><?= DejavoCP::cp_btn($product_id) ?></li><?php } ?>
                                            <?php if (class_exists('DejavoQV')) { ?>
                                                <li class="hint--top-right"
                                                    aria-label="<?php _e('نمایش سریع', 'dejavo') ?>"><?= DejavoQV::qv_btn($product_id) ?></li><?php } ?>
                                        </ul>
                                        <?php dejavo_product_sale_info(); ?>
                                        </div>

                                    </div>
                                </div>
                            <?php endwhile;
                            wp_reset_postdata(); ?>
                        </div>
                    </div>
                    <div class="dejavo_next_Arrow id<?= $wid_id; ?>"></div>
                    <div class="dejavo_prev_Arrow id<?= $wid_id; ?>"></div>
                </div>
                <script>

                    var swiper<?php echo $wid_id; ?> = new Swiper(
                        "<?php echo '.slider_tab_' . $wid_id; ?>", {
                            spaceBetween: 5,
                            slidesPerView: 3.3,
                            centerInsufficientSlides: true,
                            mousewheel:{enabled: true},
                            breakpoints: {
                                0: { direction: "horizontal", slidesPerView: 5,},
                                768: { direction: "vertical", slidesPerView: 3.3,},
                            },
                        });
                    var swiper2 = new Swiper("<?= '.amazing_offer_' . $wid_id; ?>", {
                        spaceBetween: 30,
                        slidesPerView: 1,
                        watchSlidesProgress: true,
                        speed: <?= $data['change_speed'] ?>,
                        <?php if ($data['autoplay'] == 'yes') { ?> autoplay: {
                            delay: <?= $data['change_delay'] ?>,
                            disableOnInteraction: false,
                            pauseOnMouseEnter: true,
                        },
                        <?php }  ?>
                        effect: "<?= $data['change_animation'] ?>",
                        navigation: {
                            nextEl: ".dejavo_next_Arrow.id<?= $wid_id; ?>",
                            prevEl: ".dejavo_prev_Arrow.id<?= $wid_id; ?>",
                        },
                        thumbs: {
                            swiper: swiper<?php echo $wid_id; ?>,
                        },
                    });

                </script>
            </div>
        </div>

        <?php
    }
}