<?php
defined('ABSPATH') || exit;
class dej_BlogGrid_1 extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'dej_blog_grid';
    }
    public function get_title()
    {
        return esc_html__('وبلاگ شبکه ای', 'dejavo');
    }
    public function get_icon()
    {
        return 'dej-layout-fluid';
    }

    public function get_categories()
    {
        return ['dejavo'];
    }
    public function get_keywords()
    {
        return ['بلاگ', 'وبلاگ'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }
    protected function register_controls()
    {
        $post_cat = [];
        $cats = get_terms("category");
        if (!is_wp_error($cats) && !empty($cats)) {
            foreach ($cats as $cat) {
                $post_cat[$cat->term_id] = $cat->name;
            }
        }

        $this->start_controls_section(
            'content_section', [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'default' => esc_html__('مجله بلاگی', 'dejavo'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'order',
            [
                'label' => esc_html__('مرتب سازی بر اساس', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC' => esc_html__('نزولی', 'dejavo'),
                    'ASC' => esc_html__('صعودی', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('مرتب سازی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'rand' => esc_html__('تصادفی', 'dejavo'),
                    'date' => esc_html__('تاریخ', 'dejavo'),
                    'modified' => esc_html__('بروزرسانی', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('فیلتر دسته بندی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'category',
            [
                'label' => esc_html__('دسته بندی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'condition' => [
                    'show_cat' => 'yes',
                ],
                'options' => $post_cat,
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('متن دکمه', 'dejavo'),
                'default' => esc_html__('مشاهده همه', 'dejavo'),
                'label_block' => true,

            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('لینک دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('/blog', 'dejavo'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__('سبک نمایش', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('یک', 'dejavo'),
                    '2' => esc_html__('دو', 'dejavo'),
                    '3' => esc_html__('سه', 'dejavo'),
                ],
            ]
        );

        $this->add_control(
            'img_zoom',
            [
                'label' => esc_html__('بزرگنمایی هاور تصویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => true,
            ]
        );


        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .blog_grid_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title-padding',
            [
                'label' => esc_html__('فاصله از داخل عنوان و دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_pad',
            [
                'label' => esc_html__('فاصله درونی آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_pad',
            [
                'label' => esc_html__('فاصله درونی دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .blog_grid_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .blog_grid_1 .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__('مرز ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .blog_grid_1',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'item_bor_opt_be',
            [
                'label' => esc_html__('مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .blog_grid_1 .item',
            ]
        );

        $this->add_control(
            'item_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'more_bor_opt_be',
            [
                'label' => esc_html__('مرز دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'more_border',
                'selector' => '{{WRAPPER}} .blog_grid_1 .more_link',
            ]
        );

        $this->add_control(
            'more_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'title_bor_opt_be',
            [
                'label' => esc_html__('مرز عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'title_border',
                'selector' => '{{WRAPPER}} .blog_grid_1 .title',
            ]
        );

        $this->add_control(
            'title_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .blog_grid_1',
            ]
        );


        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('رنگ پس زمینه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'more_color',
            [
                'label' => esc_html__('رنگ متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'more_hover_color',
            [
                'label' => esc_html__('رنگ هاور متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link:hover' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'more_bg',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_more_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_more_bor',
            [
                'label' => esc_html__('رنگ هاور مرز دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'h3_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 16,
                ],
                'tablet_default' => [
                    'size' => 15,
                ],

                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'h3_line_height',
            [
                'label' => esc_html__('ارتفاع متن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'h3_font_weight',
            [
                'label' => esc_html__('وزن فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 300,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'size' => 500,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-weight: {{SIZE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'more_font_size',
            [
                'label' => esc_html__('سایز فونت متن مشاهده همه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 14,
                ],
                'tablet_default' => [
                    'size' => 13,
                ],
                'mobile_default' => [
                    'size' => 12,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'head_options',
            [
                'label' => esc_html__('نوار عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'bor_title_line1',
            [
                'label' => esc_html__( 'مرز میانی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'line_border',
                'selector' => '{{WRAPPER}} .dej_heading_1 .line',
            ]
        );

        $this->add_control(
            'bor_title_line2',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__('آیکن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-book-alt',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'more_icon',
            [
                'label' => esc_html__('آیکن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-arrow-left',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .blog_grid_1',
            ]
        );

        $this->add_control(
            'item_shadow_h',
            [
                'label' => esc_html__( 'سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'shadow',
                'selector' => '{{WRAPPER}} .post_card_1',
            ]
        );
        $this->add_control(
            'item_shadow_h2',
            [
                'label' => esc_html__( 'هاور سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_shadow',
                'selector' => '{{WRAPPER}} .post_card_1:hover',
            ]
        );


        $this->end_controls_section();


    }


    protected function render()
    {
        global $post;

        $data = $this->get_settings_for_display();
        $title = $data['title'];
        $btn_url = $data['btn_link']['url'];
        $title_icon = $data['title_icon']['value'] ?? '';
        $more_icon = $data['more_icon']['value'] ?? '';
        $img_zoom = $data['img_zoom'] ? 'img_zoom' : '';
        $style = $data['style'] ?? 1;
        ?>

        <div class="blog_grid_1">

            <?php if ($title) { ?>
                <div class="dej_heading_1">
                    <div class="title">
                        <?php if ($title_icon) { ?>
                            <div class="icon"><i class="<?= $title_icon ?>"></i></div><?php } ?>
                        <h3><?= $title ?></h3>
                    </div>
                    <div class="line"></div>
                    <?php if (!empty($btn_url)) { ?>
                        <a class="more_link" href="<?= $btn_url ?>"><?= $data['btn_title'] ?> <?php if ($more_icon) { ?><i class="<?= $more_icon ?>"></i><?php } ?></a>
                    <?php } ?>
                </div>
            <?php } ?>

            <div class="dej_grid_1 style<?= $style ?>">
                <?php
                // The Query

                $args = array(
                    'post_type' => 'post', 'post_status' => 'publish', 'posts_per_page' => 5, 'order' => $data['order'], 'orderby' => $data['orderby'],
                );
                if (!empty($data['category'])) {
                    $args['tax_query'] = array(
                        array('taxonomy' => 'category', 'field' => 'term_id', 'terms' => $data['category'],)
                    );
                }
                $loop = new \WP_Query($args);
                if ($loop->have_posts()) {
                    while ($loop->have_posts()) {
                        $loop->the_post();
                        $category_detail = get_the_category($post->ID);
                        $cat_opt = get_term_meta($category_detail[0]->term_id, 'dej_category_options', true);
                        $post_id = $post->ID;
                        ?>
                        <div class="post_card_1 item item<?= $post_id ?> <?= $img_zoom ?>" style="cursor:pointer" onclick="window.location.href='<?php the_permalink(); ?>'">
                            <?php echo '<div class="cat">' . $category_detail[0]->cat_name . '</div>'; ?>
                            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('medium_large'); ?></a>
                            <h3 class="title"><a href="<?php the_permalink(); ?>"><?php the_title() ?></a></h3>
                        </div>
                        <?php if ($cat_opt && $cat_opt['dej_cat_color']) { ?>
                            <style>
                                <?= '.post_card_1.item' . $post_id .':hover' ?>
                                {
                                    border-color: <?= $cat_opt['dej_cat_color'] ?> !important
                                ;
                                }

                                <?= '.post_card_1.item' .  $post_id . ' .cat' ?>
                                {
                                    background: <?= $cat_opt['dej_cat_color'] ?> !important
                                ;
                                }
                            </style>

                        <?php } ?>


                        <?php
                    }

                } else { ?>
                    <p class="not_found">موردی یافت نشد</p>
                <?php }
                wp_reset_postdata(); ?>

            </div>

        </div>

        <?php
    }


}
