<?php
defined('ABSPATH') || exit;

class dej_BreadCrumb extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_breadcrumb';
    }

    public function get_title()
    {
        return esc_html__('مسیر صفحه', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-home-location-alt';
    }

    public function get_categories()
    {
        return ['dejavo'];
    }

    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'show_title',
            [
                'label' => esc_html__('نمایش عنوان ؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-marker',
                    'library' => '',
                ],
            ]
        );


        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .dejavo_breadcrumb',
            ]
        );
        $this->add_control(
            'color',
            [
                'label' => esc_html__('رنگ مسیر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_breadcrumb a, {{WRAPPER}} .dejavo_breadcrumb a, .woocommerce .woocommerce-breadcrumb' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_color',
            [
                'label' => esc_html__('رنگ هاور مسیر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_breadcrumb a:hover, {{WRAPPER}} .dejavo_breadcrumb a:hover, .woocommerce .woocommerce-breadcrumb:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_breadcrumb h2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_title_color',
            [
                'label' => esc_html__('رنگ هاور عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_breadcrumb h2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bor_head_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dejavo_breadcrumb',
            ]
        );


        $this->add_control(
            'bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_breadcrumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_breadcrumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'font_size',
            [
                'label' => esc_html__('اندازه فونت مسیر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 13,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_breadcrumb a, {{WRAPPER}} .dejavo_breadcrumb' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_font_size',
            [
                'label' => esc_html__('اندازه فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_breadcrumb h2 a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('اندازه فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_breadcrumb i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dejavo_breadcrumb',
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        $data = $this->get_settings_for_display();
        $icon = $data['icon']['value'] ?? '';
        ?>
        <div class="dejavo_breadcrumb">
                <div class="breadcrumb">
                    <?php
                    if (dej_woo_activated() and (is_product() || is_product_category() || is_shop() || is_product_taxonomy())) {
                        ?> <a href="<?php bloginfo('url'); ?>"><i class="<?= $icon; ?>"></i></a> <?php
                        woocommerce_breadcrumb();
                    } elseif (dej_woo_activated() and class_exists('WeDevs_Dokan') and dokan_is_store_page()) { ?>

                        <a href="<?php bloginfo('url'); ?>"><i class="<?= $icon; ?>"></i><?php bloginfo('name'); ?></a>

                        <?php $store_user = dokan()->vendor->get(get_query_var('author'));
                        echo esc_html_e('Store', 'dokan-lite') . ' ' . $store_user->get_shop_name();
                    } else { ?>
                        <a href="<?php bloginfo('url'); ?>"><?php bloginfo('name'); ?></a>
                        <?php echo ' / ';  if (!is_archive() && !is_search() && !is_page() && !is_home()) {
                             the_category(' / '); echo ' / ';
                        }
                        if (is_archive()) { the_archive_title(); }
                        elseif (is_search()) {  the_search_query(); }
                        else { echo '<a href="' . get_the_permalink() . '">' . get_the_title() . '</a>'; } ?>
                    <?php } ?>
                </div>
                <?php if ($data['show_title']) { ?>
                    <h2>
                        <?php
                        if (is_home()) {
                            echo get_the_title(get_option('page_for_posts', true));
                        } elseif (is_archive()) {
                            the_archive_title();
                        } elseif (is_search()) {
                            echo 'نتایج جست و جو برای : ';
                            the_search_query();
                        } elseif (class_exists('WeDevs_Dokan') && dokan_is_store_page()) {
                            $store_user = dokan()->vendor->get(get_query_var('author'));
                            echo esc_html_e('Store', 'dokan-lite') . ' : ' . $store_user->get_shop_name();
                        } else {
                            echo '<a href="' . get_the_permalink() . '">' . get_the_title() . '</a>';
                        } ?>
                    </h2>
                <?php } ?>

        </div>
        <?php

    }

}
