<?php
defined('ABSPATH') || exit;
class dej_LogoSlider_1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_logo_slider_1';
    }

    public function get_title()
    {
        return esc_html__('اسلایدر لوگو 1', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-menu-dots';
    }

    public function get_categories()
    {
        return ['dejavo'];
    }

    public function get_keywords()
    {
        return ['لوگو'];
    }

    protected function is_dynamic_content(): bool {
        return false;
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('اسلایدر لوگو', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        /* Start repeater */

        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'dejavo'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('عنوان ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('لوگو', 'dejavo'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('لینک ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
            ]
        );


        /* End repeater */

        $this->add_control(
            'sliders',
            [
                'label' => esc_html__('اسلاید', 'dejavo'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),           /* Use our repeater */
                'default' => [

                    'title' => esc_html__('لوگو', 'elementor'),
                    'link' => [
                        'url' => '#',
                        'is_external' => true,
                        'nofollow' => true,
                        'custom_attributes' => '',
                    ],
                    'image' => ['url' => \Elementor\Utils::get_placeholder_image_src(),],

                ],
                'title_field' => '{{{ title }}}',
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'show_title',
            [
                'label' => esc_html__('نمایش عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $this->add_control(
            'active-grayscale-filter',
            [
                'label' => esc_html__('روکش خاکستری', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__('تعداد در دسکتاپ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 12,
                'step' => 1,
                'default' => 6,
            ]
        );
        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('نمایش فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_dots',
            [
                'label' => esc_html__('نمایش نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('چرخش خودکار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'scroll-time',
            [
                'label' => esc_html__('زمان هر اسلاید (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3000,
                'max' => 12000,
                'step' => 200,
                'default' => 6000,
            ]
        );
        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 60,
                'step' => 1,
                'default' => 30,
            ]
        );



        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل اسلایدر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .swiper-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_pad',
            [
                'label' => esc_html__('فاصله از داخل آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => esc_html__('فاصله از داخل فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .dejavo_next_Arrow, {{WRAPPER}} .logo_slider_1 .dejavo_prev_Arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر گوشه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر گوشه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .item, {{WRAPPER}} .logo_slider_1 .item .title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_radius',
            [
                'label' => esc_html__('کادر گوشه عنوان ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .item .title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_bor_rad1',
            [
                'label' => esc_html__('کادر فلش راست', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .dejavo_next_Arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'arrow_bor_rad2',
            [
                'label' => esc_html__('کادر فلش چپ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .dejavo_prev_Arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__( 'مرز ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .logo_slider_1',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'item_bor_opt_be',
            [
                'label' => esc_html__( 'مرز آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .logo_slider_1 .item',
            ]
        );

        $this->add_control(
            'item_bor_hover',
            [
                'label' => esc_html__('رنگ هاور مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .item:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .logo_slider_1',
            ]
        );

        $this->add_control(
            'item_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .item' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'item_bg_hover',
            [
                'label' => esc_html__('رنگ هاور پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .item:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .item .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('رنگ پس زمینه عنوان ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .item .title' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'ho_title_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه عنوان ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .item:hover .title' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'next_icon',
            [
                'label' => esc_html__('آیکن بعدی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-right',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label' => esc_html__('آیکن قبلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-left',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => esc_html__('رنگ فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .dejavo_next_Arrow i, {{WRAPPER}} .logo_slider_1 .dejavo_prev_Arrow i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_arrow_color',
            [
                'label' => esc_html__('رنگ هاور فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .dejavo_next_Arrow:hover i, {{WRAPPER}} .logo_slider_1 .dejavo_prev_Arrow:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg',
            [
                'label' => esc_html__('رنگ پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .dejavo_next_Arrow, {{WRAPPER}} .logo_slider_1 .dejavo_prev_Arrow' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_icon_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .dejavo_next_Arrow:hover, {{WRAPPER}} .logo_slider_1 .dejavo_prev_Arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'bullet_bg',
            [
                'label' => esc_html__('رنگ نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrows_font_size',
            [
                'label' => esc_html__('سایز فونت فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .logo_slider_1 .dejavo_next_Arrow i, {{WRAPPER}} .logo_slider_1 .dejavo_prev_Arrow i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_shadow_h',
            [
                'label' => esc_html__( 'سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .logo_slider_1 .item',
            ]
        );
        $this->add_control(
            'item_shadow_h2',
            [
                'label' => esc_html__( 'هاور سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_shadow',
                'selector' => '{{WRAPPER}} .logo_slider_1 .item:hover',
            ]
        );


        $this->end_controls_section();
    }


    protected function render()
    {

        $data = $this->get_settings_for_display();
        $space_between = $data['space_between'] ?? 30;
        $next_icon = $data['next_icon']['value'] ?? '';
        $prev_icon = $data['prev_icon']['value'] ?? '';
        $scroll_time = $data['scroll-time'] ?? 6000;
        $wid_id = $this->get_id_int();


        $data_swiper = ['spaceBetween' => $space_between, 'slidesPerGroup' => 2, 'watchSlidesProgress' => true];
        if ($data['autoplay'] == 'yes') {$data_swiper['autoplay'] = ['delay' => $scroll_time, 'disableOnInteraction' => false, 'pauseOnMouseEnter' => true];}
        if ($data['show_arrow'] == 'yes') {$data_swiper['navigation'] = ['nextEl' => ".dejavo_next_Arrow.id{$wid_id}", 'prevEl' => ".dejavo_prev_Arrow.id{$wid_id}"];}
        if ($data['show_dots'] == 'yes') {$data_swiper['pagination'] = ['el' => ".swiper-pagination.sp{$wid_id}", 'clickable' => true];}
        $data_swiper['breakpoints'] = ['0' => ['slidesPerView' => 2,'speed' => 300], '576' => ['slidesPerView' => 3 ], '768' => ['slidesPerView' => 4, 'speed' => 500], '1024' => ['slidesPerView' => $data['number']] ];


        $this->add_render_attribute( [
            'swiper-opt' => [
                'class' => 'dej_swiper swiper',
                'id' => 'DejavoSwiper'.$wid_id,
                'dir' => 'rtl',
                'data-swiper' => wp_json_encode($data_swiper)
            ],
        ] );

        ?>

        <div class="logo_slider_1">
            <div class="slides">
                <div <?= $this->get_render_attribute_string( 'swiper-opt' ) ?>>
                    <div class="swiper-wrapper">
                        <?php foreach ($data['sliders'] as $slide) {
                            $link = !empty($slide['link']['url'])  ? $slide['link']['url'] : '#' ?>
                            <div class="item <?php if ($data ['active-grayscale-filter'] == 'yes') { echo ' grayscale-filter '; } ?> swiper-slide">
                                <a href="<?= $link; ?>"><?= wp_get_attachment_image($slide['image']['id'], 'full') ?>
                                <?php if ($data['show_title'] == 'yes') { ?><span class="title"><?= $slide['title'] ?></span><?php } ?></a>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <?php if ($data['show_arrow'] == 'yes') { ?><div class="dejavo_next_Arrow id<?= $wid_id; ?>"><i class="<?= $next_icon ?>"></i></div><div class="dejavo_prev_Arrow id<?= $wid_id; ?>"><i class="<?= $prev_icon ?>"></i></div><?php }  ?>
                <?php if ($data['show_dots'] == 'yes') { ?><div class="swiper-pagination id<?= $wid_id; ?>"></div><?php }  ?>
            </div>
            <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()) { ?><script> dej_initSwipers(); </script> <?php } ?>
        </div>
        <?php

    }
}