<?php
defined('ABSPATH') || exit;
class dej_ProductlistSlider_1 extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'dej_product_list_slider_1';
    }

    public function get_title()
    {
        return esc_html__('اسلایدر لیست محصولات', 'dejavo');
    }

    public function get_icon()
    {
        return 'eicon-post-list';
    }

    public function get_categories()
    {
        return ['dejavo'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {
        $product_cat = [];
        $cats = get_terms("product_cat");
        if (!is_wp_error($cats) && !empty($cats)) {
            foreach ($cats as $cat) {
                $product_cat[$cat->term_id] = $cat->name;
            }
        }
        $product_tag = [];
        $tags = get_terms("product_tag");
        if (!is_wp_error($tags) && !empty($tags)) {
            foreach ($tags as $tag) {
                $product_tag[$tag->term_id] = $tag->name;
            }
        }
        $this->start_controls_section(
            'content_section', [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'default' => esc_html__('محصولات جدید', 'dejavo'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'number',
            [
                'label' => esc_html__('تعداد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 4,
                'max' => 64,
                'step' => 4,
                'default' => 8,
            ]
        );
        $this->add_control(
            'order',
            [
                'label' => esc_html__('ترتیب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC' => esc_html__('نزولی', 'dejavo'),
                    'ASC' => esc_html__('صعودی', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('مرتب سازی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'rand' => esc_html__('تصادفی', 'dejavo'),
                    'date' => esc_html__('تاریخ', 'dejavo'),
                    'modified' => esc_html__('بروزرسانی', 'dejavo'),
                    'meta_value_num' => esc_html__('قیمت', 'dejavo'),
                    'popularity' => esc_html__('محبوبیت', 'dejavo'),
                ],
            ]
        );

        $this->add_control(
            'min_price',
            [
                'label' => esc_html__( 'کمترین قیمت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 1000,
            ]
        );
        $this->add_control(
            'max_price',
            [
                'label' => esc_html__( 'بیشترین قیمت *', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1000,
                'step' => 1000,
            ]
        );
        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('فیلتر دسته بندی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'category',
            [
                'label' => esc_html__('دسته بندی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_cat' => 'yes',
                ],
                'options' => $product_cat,
                'multiple' => true,
            ]
        );
        $this->add_control(
            'show_tag',
            [
                'label' => esc_html__('فیلتر برچسب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'tags',
            [
                'label' => esc_html__('برچسب ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_tag' => 'yes',
                ],
                'options' => $product_tag,
                'multiple' => true,
            ]
        );


        $this->add_control(
            'show_special',
            [
                'label' => esc_html__('فقط نمایش تخفیف دار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_in_stock',
            [
                'label' => esc_html__('فقط نمایش موجود در انبار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'hide_empty_price',
            [
                'label' => esc_html__('مخفی کردن بدون قیمت و رایگان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('لینک دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );

        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('متن دکمه', 'dejavo'),
                'default' => esc_html__('مشاهده همه', 'dejavo'),
                'label_block' => true,

            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'mob_scroll',
            [
                'label' => esc_html__( 'حالت اسکرول افقی در موبایل ؟', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'hide_scrollbar',
            [
                'label' => esc_html__( 'مخفی کردن اسکرول بار در موبایل ؟', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'mob_scroll' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'number-in-page',
            [
                'label' => esc_html__('تعداد ستون', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2,
                'max' => 4,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'number-row',
            [
                'label' => esc_html__('تعداد ردیف', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 4,
                'step' => 1,
                'default' => 2,
            ]
        );
        $this->add_control(
            'number-in-page-laptop',
            [
                'label' => esc_html__('تعداد ستون لپ تاپ کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 4,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'number-in-page-tablet',
            [
                'label' => esc_html__('تعداد ستون تبلت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 2,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'mob_scroll',
                            'operator' => '!==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'number-in-page-mobile',
            [
                'label' => esc_html__('تعداد ستون موبایل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 1.5,
                'step' => 0.1,
                'default' => 1,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'mob_scroll',
                            'operator' => '!==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'number-in-scroll',
            [
                'label' => esc_html__('تعداد در هر اسکرول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control(
            'scroll-time',
            [
                'label' => esc_html__('زمان تاخیر اسکرول خودکار (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3000,
                'max' => 12000,
                'step' => 200,
                'default' => 6000,
            ]
        );
        $this->add_control(
            'scroll-speed',
            [
                'label' => esc_html__('سرعت اسکرول (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 300,
                'max' => 1600,
                'step' => 100,
                'default' => 700,
            ]
        );
        $this->add_control(
            'free-mode',
            [
                'label' => esc_html__('اسکرول آزاد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('نمایش فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_dots',
            [
                'label' => esc_html__('نمایش نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('چرخش خودکار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 50,
                'step' => 1,
                'default' => 7,
            ]
        );

        $this->add_control(
            'img_zoom',
            [
                'label' => esc_html__('بزرگنمایی هاور تصویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => true,
            ]
        );

        $this->add_control(
            'show_icons',
            [
                'label' => esc_html__('نمایش آیکن ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_rating',
            [
                'label' => esc_html__('نمایش امتیاز ستاره ای', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_price',
            [
                'label' => esc_html__('نمایش قیمت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_discount',
            [
                'label' => esc_html__('نمایش تخفیف', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_list_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('فاصله از داخل آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .swiper-slide' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'head-padding',
            [
                'label' => esc_html__('فاصله خارجی عنوان و دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title-padding',
            [
                'label' => esc_html__('فاصله درونی عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_pad',
            [
                'label' => esc_html__('فاصله درونی آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_pad',
            [
                'label' => esc_html__('فاصله درونی دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_list_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_border_radius',
            [
                'label' => esc_html__('کادر گوشه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title, {{WRAPPER}} .dej_heading_1 .title .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'more_border_radius',
            [
                'label' => esc_html__('کادر گوشه مشاهده همه و فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more, {{WRAPPER}} .dej_heading_1 .arrows' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'img_border_radius',
            [
                'label' => esc_html__('کادر تصویر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item .image a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'badge_border_radius',
            [
                'label' => esc_html__('کادر تخفیف', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item .badge' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__('مرز ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .product_list_1',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'item_bor_opt_be',
            [
                'label' => esc_html__('مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .product_list_1 .item',
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'item_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'img_bor_opt_be',
            [
                'label' => esc_html__('مرز تصویر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'img_border',
                'selector' => '{{WRAPPER}} .product_list_1 .item .image a',
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'img_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'title_bor_opt_be',
            [
                'label' => esc_html__('مرز عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'title_border',
                'selector' => '{{WRAPPER}} .dej_heading_1 .title',
            ]
        );

        $this->add_control(
            'title_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .product_list_1',
            ]
        );


        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('رنگ پس زمینه عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'more_color',
            [
                'label' => esc_html__('رنگ متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'more_hover_color',
            [
                'label' => esc_html__('رنگ هاور متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more:hover' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'more_bg',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_more_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrows_color',
            [
                'label' => esc_html__('رنگ فلشها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrows_bg',
            [
                'label' => esc_html__('رنگ پس زمینه فلشها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_item_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'hover_item_bor',
            [
                'label' => esc_html__('رنگ هاور مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_img_item_bor',
            [
                'label' => esc_html__('رنگ هاور مرز تصویر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item:hover .image a' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_item_color',
            [
                'label' => esc_html__('رنگ عنوان آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item .title a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_title_item_color',
            [
                'label' => esc_html__('رنگ هاور عنوان آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item:hover .title a' => 'color: {{VALUE}}',
                ],
            ]
        );




        $this->add_control(
            'head_options',
            [
                'label' => esc_html__('نوار عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'bor_title_line1',
            [
                'label' => esc_html__( 'مرز میانی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'line_border',
                'selector' => '{{WRAPPER}} .dej_heading_1 .line',
            ]
        );

        $this->add_control(
            'bor_title_line2',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__('آیکن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-crown',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'next_icon',
            [
                'label' => esc_html__('آیکن بعدی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-right',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label' => esc_html__('آیکن قبلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-left',
                    'library' => '',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 18,
                ],

                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'h3_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 16,
                ],
                'tablet_default' => [
                    'size' => 15,
                ],

                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'h3_line_height',
            [
                'label' => esc_html__('ارتفاع متن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'h3_font_weight',
            [
                'label' => esc_html__('وزن فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 300,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'size' => 500,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-weight: {{SIZE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'more_font_size',
            [
                'label' => esc_html__('سایز فونت متن مشاهده همه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 14,
                ],
                'tablet_default' => [
                    'size' => 13,
                ],
                'mobile_default' => [
                    'size' => 12,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .product_list_1',
            ]
        );

        $this->add_control(
            'item_shadow_h',
            [
                'label' => esc_html__( 'سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'shadow',
                'selector' => '{{WRAPPER}} .product_list_1 .item',
            ]
        );
        $this->add_control(
            'item_shadow_h2',
            [
                'label' => esc_html__( 'هاور سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_shadow',
                'selector' => '{{WRAPPER}} .product_list_1 .item:hover',
            ]
        );

        $this->end_controls_section();


    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $title = $data['title'];
        $btn_url = $data['btn_link']['url'];
        $img_zoom = $data['img_zoom'] ? 'img_zoom' : '';
        $title_icon = $data['title_icon']['value'] ?? '';
        $next_icon = $data['next_icon']['value'] ?? '';
        $prev_icon = $data['prev_icon']['value'] ?? '';
        $space_between = $data['space_between'] ?? 10;
        $show_icons = $data['show_icons'];
        $show_rating = $data['show_rating'];
        $show_price = $data['show_price'];
        $show_discount = $data['show_discount'];
        $wid_id = $this->get_id_int();

        $number = $data['number'] ?? 12;
        $order = $data['order'] ?? 'DESC';
        $orderby = $data['orderby'] ?? 'date';
        $cats = $data['category'] ?? '';
        $tags = $data['tags'] ?? '';

        $in_stock = $data['show_in_stock'] ?? '';
        $on_sale = $data['show_special'] ?? '';
        $hide_empty_price = $data['hide_empty_price'] ?? '';
        $empty_price_arr = $zero_price_arr = $in_stock_arr = $backorders_arr = $min_max = [];
        $meta_key = ($orderby == 'meta_value_num') ? '_price' : '';
        $max_price = $data['max_price'] ?? '';
        $min_price = $data['min_price'] ?? 0;


        $data_swiper = [];
        $data_swiper['spaceBetween'] = $space_between;

        if ($data['free-mode'] == 'yes') { $data_swiper['freeMode'] = true; }

        if ($data['number-row']) { $data_swiper['grid'] = ['rows' => $data['number-row'] ]; }

        $data_swiper['watchSlidesProgress'] = true;



        if ($data['autoplay'] == 'yes') {
            $data_swiper['autoplay'] = ['delay' => $data['scroll-time'], 'disableOnInteraction' => false, 'pauseOnMouseEnter' => true];
        }

        if ($data['show_arrow'] == 'yes') {
            $data_swiper['navigation'] = ['nextEl' => ".dejavo_next_Arrow.id{$wid_id}", 'prevEl' => ".dejavo_prev_Arrow.id{$wid_id}"];
        }

        if ($data['show_dots'] == 'yes') {
            $data_swiper['pagination'] = ['el' => ".swiper-pagination.sp{$wid_id}", 'clickable' => true];
        }

        $data_swiper['breakpoints'] = ['0' => ['slidesPerView' => $data['number-in-page-mobile'] ,'speed' => 300,'slidesPerGroup' => 1], '576' => ['slidesPerView' => $data['number-in-page-tablet'] ], '768' => ['slidesPerView' => $data['number-in-page-laptop'], 'speed' => $data['scroll-speed']], '992' => ['slidesPerView' => $data['number-in-page'], 'speed' =>  $data['scroll-speed'], 'slidesPerGroup' => $data['number-in-scroll'] ]];

        $dir = is_rtl() ? 'rtl' : '';

        $this->add_render_attribute( [
            'swiper-opt' => [
                'class' => 'dej_swiper swiper',
                'id' => 'DejavoSwiper'.$wid_id,
                'dir' => $dir,
                'data-swiper' => wp_json_encode($data_swiper)
            ],
        ] );

        $hide_scrollbar = '';
        if ($data['hide_scrollbar'] == 'yes') {
            $hide_scrollbar = ' scrollbar-hidden';
        }
        $this->add_render_attribute( [
            'mobile-opt' => [
                'class' => 'mob_wrapper' . $hide_scrollbar,
            ],
        ] );

        if (dej_is_mobile() and $data['mob_scroll']) {
            $wrapper_class = 'mobile-opt';
        } else {
            $wrapper_class = 'swiper-opt';
        }

        $args = [ 'post_type' => 'product', 'post_status' => 'publish', 'posts_per_page' => $number, 'order' => $order, 'orderby' => $orderby, 'meta_key'  => $meta_key];

        if ($data['show_cat'] == 'yes' && !empty($cats)) {
            $args['tax_query'] = [['taxonomy' => 'product_cat', 'field' => 'term_id', 'terms' => $cats]];
        }

        elseif ($data['show_tag'] == 'yes' && !empty($tags)) {
            $args['tax_query'] = [['taxonomy' => 'product_tag', 'field' => 'term_id', 'terms' => $tags]];
        }

        if ($on_sale == 'yes') {
            $args['post__in'] = array_merge( [ 0 ], wc_get_product_ids_on_sale());
        }
        if ($hide_empty_price == 'yes') {
            $empty_price_arr = ['key' => '_price', 'value' => '', 'type' => 'numeric', 'compare' => '!='];
            $zero_price_arr = ['key' => '_price', 'value' => 0, 'type' => 'numeric', 'compare' => '!='];
        }
        if ($max_price) {
            $min_max = ['key' => '_price', 'value' => [$min_price, $max_price], 'compare' => 'BETWEEN', 'type' => 'NUMERIC'];
        }
        if ($in_stock == 'yes') {
            $in_stock_arr = ['key' => '_stock_status', 'value' => 'instock'];
            $backorders_arr = ['key' => '_backorders', 'value' => 'no'];
        }
        $args['meta_query'] = [$empty_price_arr,$zero_price_arr,$in_stock_arr,$backorders_arr, $min_max];
        $loop = new WP_Query($args);
            ?>
            <div class="product_list_1">
                <?php if ($title) { ?>
                    <div class="dej_heading_1">
                        <div class="title">
                            <?php if ($title_icon) { ?><div class="icon"><i class="<?= $title_icon ?>"></i></div><?php } ?>
                            <h3><?= $title ?></h3>
                        </div>
                        <div class="line"></div>
                        <div class="arrow_more">
                            <?php  if (!empty($btn_url)){ ?>
                                <a class="more <?php if($wrapper_class === 'mobile-opt') { echo 'mob_type';} ?>" href="<?= $btn_url ?>"><?= $data['btn_title'] ?></a>
                            <?php }
                            if ($data['show_arrow'] === 'yes' and  $wrapper_class === 'swiper-opt') { ?>
                                <div class="arrows"><div class="dejavo_next_Arrow id<?= $wid_id; ?>"><i class="<?= $next_icon ?>"></i></div><div class="dejavo_prev_Arrow id<?= $wid_id; ?>"><i class="<?= $prev_icon ?>"></i></div></div>
                            <?php }  ?>
                        </div>
                    </div>
                <?php }  ?>
                <div class="slides <?= 'row_' . $data['number-row'] ?>">
                    <div <?= $this->get_render_attribute_string( $wrapper_class ) ?>>
                        <div class="swiper-wrapper">
                            <?php if ($loop->have_posts()) {
                                while ($loop->have_posts()) {
                                    $loop->the_post();
                                    global $product;
                                    $product_title = $product->get_title(); $product_id = $product->get_id(); ?>
                                    <div class="swiper-slide">
                                    <div class="item <?= $img_zoom ?>">
                                        <?php if ($show_discount and $product->is_on_sale()) { woocommerce_show_product_sale_flash(); } ?>
                                        <div class="image">
                                            <a href="<?php the_permalink(); ?>"><?= $product->get_image('woocommerce_gallery_thumbnail') ?></a>
                                        </div>
                                        <div class="info">
                                            <div class="title">
                                                <h4>
                                                    <a href="<?php the_permalink(); ?>"><?= wp_trim_words($product_title, 14, '..') ?></a>
                                                </h4>
                                            </div>
                                            <?php if ($show_rating) {
                                                dejavo_star_rating();
                                            } ?>
                                            <?php if ($show_price) { ?>
                                                <div class="price <?php if ($show_icons) {
                                                    echo ' show_icons';
                                                } ?>"><?php woocommerce_template_loop_price(); ?></div><?php } ?>
                                            <?php if ($show_icons) { ?>
                                                <ul class="icons">
                                                <?php echo sprintf('<li class="hint--top-left" aria-label="%s"><a href="%s" data-quantity="1" class="%s" %s><i class="dej-shopping-bag"></i></a></li>',
                                                    esc_html($product->add_to_cart_text()),
                                                    esc_url($product->add_to_cart_url()),
                                                    esc_attr(implode(' ', array_filter(array(
                                                        '', 'product_type_' . $product->get_type(),
                                                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                                        $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
                                                    )))),
                                                    wc_implode_html_attributes(array(
                                                        'data-product_id' => $product_id,
                                                        'data-product_sku' => $product->get_sku(),
                                                        'aria-label' => $product->add_to_cart_description(),
                                                        'rel' => 'nofollow',
                                                    ))
                                                ); ?>
                                                <?php if (class_exists('DejavoWL')) { ?><li class="hint--top" aria-label="<?= __('علاقه مندی', 'dejavo') ?>"><?= DejavoWL::wl_btn($product_id) ?></li>
                                                <?php } if (class_exists('DejavoCP')) { ?><li class="hint--top" aria-label="<?= __('مقایسه', 'dejavo') ?>"><?= DejavoCP::cp_btn($product_id) ?></li>
                                                <?php } if (class_exists('DejavoQV')) { ?><li class="hint--top-right" aria-label="<?= __('نمایش سریع', 'dejavo') ?>"><?= DejavoQV::qv_btn($product_id) ?></li><?php } ?>
                                                </ul><?php } ?>
                                        </div>
                                    </div>
                                    </div>
                                <?php }
                            }
                            wp_reset_postdata(); ?>
                        </div>
                    </div>
                    <?php if ($data['show_dots'] == 'yes' and $wrapper_class === 'swiper-opt') { ?><div class="swiper-pagination sp<?= $wid_id; ?>"></div><?php }  ?>
                </div>
                <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()) { ?><script> dej_initSwipers(); </script> <?php } ?>

            </div>

            <?php
    }

}
