<?php
defined('ABSPATH') || exit;
class dej_ProductSlider_2 extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'dej_product_slider_2';
    }

    public function get_title()
    {
        return esc_html__('اسلایدر محصولات 2', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-exchange';
    }

    public function get_categories()
    {
        return ['dejavo'];
    }

    public function get_keywords()
    {
        return ['محصولات', 'اسلایدر'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {
        $product_cat = [];
        $cats = get_terms("product_cat");
        if (!is_wp_error($cats) && !empty($cats)) {
            foreach ($cats as $cat) {
                $product_cat[$cat->term_id] = $cat->name;
            }
        }
        $product_tag = [];
        $tags = get_terms("product_tag");
        if (!is_wp_error($tags) && !empty($tags)) {
            foreach ($tags as $tag) {
                $product_tag[$tag->term_id] = $tag->name;
            }
        }

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'default' => esc_html__('اسلایدر محصولات', 'dejavo'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'number',
            [
                'label' => esc_html__('تعداد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 64,
                'step' => 1,
                'default' => 12,
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('مرتب سازی بر اساس', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC' => esc_html__('نزولی', 'dejavo'),
                    'ASC' => esc_html__('صعودی', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('مرتب سازی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'rand' => esc_html__('تصادفی', 'dejavo'),
                    'date' => esc_html__('تاریخ', 'dejavo'),
                    'modified' => esc_html__('بروزرسانی', 'dejavo'),
                    'meta_value_num' => esc_html__('قیمت', 'dejavo'),
                    'popularity' => esc_html__('محبوبیت', 'dejavo'),
                ],
            ]
        );

        $this->add_control(
            'min_price',
            [
                'label' => esc_html__( 'کمترین قیمت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 1000,
            ]
        );
        $this->add_control(
            'max_price',
            [
                'label' => esc_html__( 'بیشترین قیمت *', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1000,
                'step' => 1000,
            ]
        );
        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__( 'فیلتر دسته بندی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'category',
            [
                'label' => esc_html__('دسته بندی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_cat' => 'yes',
                ],
                'options' => $product_cat,
                'multiple' => true,
            ]
        );
        $this->add_control(
            'show_tag',
            [
                'label' => esc_html__( 'فیلتر برچسب', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'tags',
            [
                'label' => esc_html__('برچسب ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_tag' => 'yes',
                ],
                'options' => $product_tag,
                'multiple' => true,
            ]
        );

        $this->add_control(
            'show_special',
            [
                'label' => esc_html__('فقط نمایش تخفیف دار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_in_stock',
            [
                'label' => esc_html__('فقط نمایش موجود در انبار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'hide_empty_price',
            [
                'label' => esc_html__('مخفی کردن بدون قیمت و رایگان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );


        $this->add_control(
            'more_options',
            [
                'label' => esc_html__( 'بنر کناری', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('لینک دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );

        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('متن دکمه', 'dejavo'),
                'default' => esc_html__('مشاهده همه', 'dejavo'),
                'label_block' => true,

            ]
        );



        $this->end_controls_section();


        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'section_style',
            [
                'label' => esc_html__('سبک نمایش ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                    'style1' => esc_html__('یک', 'dejavo'),
                    'style2' => esc_html__('دو', 'dejavo'),
                ],
            ]
        );

        $this->add_control(
            'product_card',
            [
                'label' => esc_html__('کارد محصول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('یک', 'dejavo'),
                    '2' => esc_html__('دو', 'dejavo'),
                    '3' => esc_html__('سه', 'dejavo'),
                    '4' => esc_html__('چهار', 'dejavo'),
                    '5' => esc_html__('پنج', 'dejavo'),
                    '6' => esc_html__('شش', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'mob_card',
            [
                'label' => esc_html__( 'نمایش کارد ویژه موبایل ؟', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'mob_scroll',
            [
                'label' => esc_html__( 'حالت اسکرول افقی در موبایل ؟', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'hide_scrollbar',
            [
                'label' => esc_html__( 'مخفی کردن اسکرول بار در موبایل ؟', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'mob_scroll' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'desktop_cols',
            [
                'label' => esc_html__('تعداد ستون', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 5,
            ]
        );
        $this->add_control(
            'laptop_cols',
            [
                'label' => esc_html__('تعداد ستون لپ تاپ کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'tablet_cols',
            [
                'label' => esc_html__('تعداد ستون تبلت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 2,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'mob_scroll',
                            'operator' => '!==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'mobile_cols',
            [
                'label' => esc_html__('تعداد ستون موبایل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 2.5,
                'step' => 0.1,
                'default' => 2,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'mob_scroll',
                            'operator' => '!==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'number-in-scroll',
            [
                'label' => esc_html__('تعداد در هر اسکرول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 1,
            ]
        );

        $this->add_control(
            'scroll-speed',
            [
                'label' => esc_html__('سرعت اسکرول (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 300,
                'max' => 1600,
                'step' => 100,
                'default' => 500,
            ]
        );
        $this->add_control(
            'free-mode',
            [
                'label' => esc_html__('اسکرول آزاد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('نمایش فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_dots',
            [
                'label' => esc_html__('نمایش نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );


        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 50,
                'step' => 1,
                'default' => 5,
            ]
        );


        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل بخش', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('فاصله از داخل آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__('فاصله از داخل نوار کناری', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .slider_banner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'banner_border_rad',
            [
                'label' => esc_html__('کادر بنر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .slider_img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'head_border_rad',
            [
                'label' => esc_html__('کادر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .heading_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'btn_border_rad',
            [
                'label' => esc_html__('کادر دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .slider_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .product-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__( 'مرز ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .product_slider_2',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'item_bor_opt_be',
            [
                'label' => esc_html__( 'مرز آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .product_slider_2 .product-card',
            ]
        );

        $this->add_control(
            'hover_item_border',
            [
                'label' => esc_html__('رنگ هاور مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .product-card:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'title_bor_opt_be',
            [
                'label' => esc_html__('مرز عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'title_border',
                'selector' => '{{WRAPPER}} .heading_title',
            ]
        );

        $this->add_control(
            'title_btn_bor',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'btn_bor_opt_be',
            [
                'label' => esc_html__('مرز دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_bor',
                'selector' => '{{WRAPPER}} .slider_btn',
            ]
        );
        $this->add_control(
            'hover_btn_bor',
            [
                'label' => esc_html__('رنگ هاور مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider_btn:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'w_bg_head',
            [
                'label' => esc_html__('پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .product_slider_2',
            ]
        );
        $this->add_control(
            'h3-title-color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading_title h3, {{WRAPPER}} .mobile_title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn-color',
            [
                'label' => esc_html__('رنگ دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider_btn a, {{WRAPPER}} .slider_show_more' => 'color: {{VALUE}} ; border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn-hover-color',
            [
                'label' => esc_html__('رنگ هاور دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider_btn a:hover, {{WRAPPER}} .slider_show_more:hover' => 'color: {{VALUE}} ; border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn-color2',
            [
                'label' => esc_html__(' 2 رنگ دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider_show_more' => 'color: {{VALUE}} ; border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn-hover-color2',
            [
                'label' => esc_html__('رنگ هاور دکمه 2', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider_show_more:hover' => 'color: {{VALUE}} ; border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'font-size-btn',
            [
                'label' => esc_html__('سایز فونت دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 14,
                ],
                'tablet_default' => [
                    'size' => 13,
                ],
                'mobile_default' => [
                    'size' => 12,
                ],
                'selectors' => [
                    '{{WRAPPER}} .heading_title a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'font-size-h3',
            [
                'label' => esc_html__( 'سایز فونت عنوان ', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 20,
                ],
                'tablet_default' => [
                    'size' => 18,
                ],
                'mobile_default' => [
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .heading_title h3' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'line-height-h3',
            [
                'label' => esc_html__( 'ارتفاع متن عنوان', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 25,
                ],
                'selectors' => [
                    '{{WRAPPER}} .heading_title h3' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'h3-font-weight',
            [
                'label' => esc_html__( 'وزن فونت عنوان', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' =>[
                        'min' => 400,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'size' => 500,
                ],
                'selectors' => [
                    '{{WRAPPER}} .heading_title h3' => 'font-weight: {{SIZE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'banner_max_width',
            [
                'label' => esc_html__( 'حداکثر عرض بنر', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' =>[
                        'min' => 50,
                        'max' => 500,
                        'step' => 10,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 200,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .slider_img' => 'max-width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow-top',
            [
                'label' => esc_html__('فاصله فلش ها از بالا', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' =>  ['%', 'px', 'em'],
                'range' => [
                    '%' => [
                        'min' => 5,
                        'max' => 95,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 40,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .dejavo_prev_Arrow, {{WRAPPER}} .product_slider_2 .dejavo_next_Arrow' => 'top: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'img_height',
            [
                'label' => esc_html__('تعیین ارتفاع تصاویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 150,
                        'max' => 450,
                        'step' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-card .image' => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );


        $this->add_control(
            'next_icon',
            [
                'label' => esc_html__('آیکن بعدی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-right',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label' => esc_html__('آیکن قبلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-left',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => esc_html__('رنگ فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .dejavo_next_Arrow i, {{WRAPPER}} .product_slider_2 .dejavo_prev_Arrow i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_arrow_color',
            [
                'label' => esc_html__('رنگ هاور فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .dejavo_next_Arrow:hover i, {{WRAPPER}} .product_slider_2 .dejavo_prev_Arrow:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg',
            [
                'label' => esc_html__('رنگ پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .dejavo_next_Arrow, {{WRAPPER}} .product_slider_2 .dejavo_prev_Arrow' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_icon_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .dejavo_next_Arrow:hover, {{WRAPPER}} .product_slider_2 .dejavo_prev_Arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrow_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .dejavo_next_Arrow, {{WRAPPER}} .product_slider_2 .dejavo_prev_Arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => esc_html__('فاصله از داخل فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .dejavo_next_Arrow, {{WRAPPER}} .product_slider_2 .dejavo_prev_Arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bullet_bg',
            [
                'label' => esc_html__('رنگ نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_2 .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .product_slider_2',
            ]
        );
        $this->add_control(
            'item_shadow_h',
            [
                'label' => esc_html__( 'سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'shadow',
                'selector' => '{{WRAPPER}} .product_slider_2 .product-card',
            ]
        );
        $this->add_control(
            'item_shadow_h2',
            [
                'label' => esc_html__( 'هاور سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_shadow',
                'selector' => '{{WRAPPER}} .product_slider_2 .product-card:hover',
            ]
        );

        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $wid_id = $this->get_id_int();
        $product_card = $data['product_card'] ?? '1';
        $section_style = $data['section_style'] ?? 'style1';
        $btn_url = $data['btn_link']['url'];
        $next_icon = $data['next_icon']['value'] ?? 'dej-angle-right';
        $prev_icon = $data['prev_icon']['value'] ?? 'dej-angle-left';
        $space_between = !empty($data['space_between']) ? $data['space_between'] : 3;
        $mobile_cols = !empty($data['mobile_cols']) ? $data['mobile_cols'] : 2;
        $tablet_cols = !empty($data['tablet_cols']) ? $data['tablet_cols'] : 2;
        $laptop_cols = !empty($data['laptop_cols']) ? $data['laptop_cols'] : 3;
        $desktop_cols = !empty($data['desktop_cols']) ? $data['desktop_cols'] : 5;
        $speed = !empty($data['scroll-speed']) ? $data['scroll-speed'] : 500;
        $pergroup = !empty($data['number-in-scroll']) ? $data['number-in-scroll'] : 1;

        $data_swiper = ['spaceBetween' => $space_between, 'watchSlidesProgress' => true ];
        if ($data['free-mode'] == 'yes') { $data_swiper['freeMode'] = true; }
        if ($data['show_arrow'] == 'yes') {$data_swiper['navigation'] = ['prevEl' => ".dejavo_next_Arrow.id{$wid_id}", 'nextEl' => ".dejavo_prev_Arrow.id{$wid_id}"];}
        if ($data['show_dots'] == 'yes') {$data_swiper['pagination'] = ['el' => ".swiper-pagination.sp{$wid_id}", 'clickable' => true];}
        $data_swiper['breakpoints'] = ['0' => ['slidesPerView' => $mobile_cols ,'speed' => 300,'slidesPerGroup' => 1], '576' => ['slidesPerView' => $tablet_cols], '768' => ['slidesPerView' => $laptop_cols, 'speed' => $speed], '992' => ['slidesPerView' => $desktop_cols, 'speed' => $speed, 'slidesPerGroup' => $pergroup ]];


        $this->add_render_attribute( [
            'swiper-opt' => [
                'class' => 'dej_swiper swiper',
                'id' => 'DejavoSwiper'.$wid_id,
                'dir' => 'rtl',
                'data-swiper' => wp_json_encode($data_swiper)
            ],
        ] );

        $hide_scrollbar = '';
        if ($data['hide_scrollbar'] == 'yes') {
            $hide_scrollbar = ' scrollbar-hidden';
        }

        $this->add_render_attribute( [
            'mobile-opt' => [
                'class' => 'mob_wrapper' . $hide_scrollbar,
            ],
        ] );


        if (dej_is_mobile() and $data['mob_scroll']) {
            $wrapper_class = 'mobile-opt';
        } else {
            $wrapper_class = 'swiper-opt';
        }

        $number =!empty($data['number']) ? $data['number'] : 12;
        $order = $data['order'] ?? 'DESC';
        $orderby = $data['orderby'] ?? 'date';
        $cats = $data['category'] ?? '';
        $tags = $data['tags'] ?? '';
        $in_stock = $data['show_in_stock'] ?? '';
        $on_sale = $data['show_special'] ?? '';
        $hide_empty_price = $data['hide_empty_price'] ?? '';
        $empty_price_arr = $zero_price_arr = $in_stock_arr = $min_max = [];
        $meta_key = ($orderby == 'meta_value_num') ? '_price' : '';
        $max_price = $data['max_price'] ?? '';
        $min_price = $data['min_price'] ?? 0;

        $args = [ 'post_type' => 'product', 'post_status' => 'publish', 'posts_per_page' => $number, 'order' => $order, 'orderby' => $orderby, 'meta_key'  => $meta_key];

        if ($data['show_cat'] == 'yes' && !empty($cats)) {
            $args['tax_query'] = [['taxonomy' => 'product_cat', 'field' => 'term_id', 'terms' => $cats]];
        }

        elseif ($data['show_tag'] == 'yes' && !empty($tags)) {
            $args['tax_query'] = [['taxonomy' => 'product_tag', 'field' => 'term_id', 'terms' => $tags]];
        }

        if ($on_sale == 'yes') {
            $args['post__in'] = array_merge( [ 0 ], wc_get_product_ids_on_sale());
        }
        if ($hide_empty_price == 'yes') {
            $empty_price_arr = ['key' => '_price', 'value' => '', 'type' => 'numeric', 'compare' => '!='];
            $zero_price_arr = ['key' => '_price', 'value' => 0, 'type' => 'numeric', 'compare' => '!='];
        }
        if ($max_price) {
            $min_max = ['key' => '_price', 'value' => [$min_price, $max_price], 'compare' => 'BETWEEN', 'type' => 'NUMERIC'];
        }
        if ($in_stock == 'yes') {
            $in_stock_arr = [
                'relation' => 'OR',
                ['key' => '_stock_status', 'value' => 'instock',],
                ['key' => '_backorders', 'value' => 'yes',],
            ];
        }
        $args['meta_query'] = [$empty_price_arr,$zero_price_arr,$in_stock_arr, $min_max];
        $loop = new WP_Query($args);
        ?>

        <div class="product_slider_2 <?php echo $section_style; ?>">
            <?php if ($section_style =='style2') {  if ($data['title']) { ?>
                <div class="mobile_title"><?= $data['title'] ?></div>
            <?php }  ?>
                    <div class="slider_banner">
                        <?php if ($data['image']['id']) { ?>
                            <div class="slider_img">
                                <?= wp_get_attachment_image($data['image']['id'], 'original') ?>
                            </div>
                        <?php } elseif ($data['title']) { ?>
                            <div class="heading_title">
                                <h3><?= $data['title'] ?></h3>
                            </div>
                        <?php } if (!empty($btn_url)) { ?>
                            <div class="slider_btn"> <a href="<?= $btn_url ?>"><?= $data['btn_title'] ?> <i class="dej-angle-small-left"></i></a></div>
                        <?php } ?>
                    </div>
            <?php } ?>
            <div class="slides2">
                <div <?= $this->get_render_attribute_string( $wrapper_class ) ?>>
                    <div class="product-carousel swiper-wrapper">
                        <?php if ($section_style =='style1') { ?>
                            <div class="item swiper-slide">
                                <div class="slider_banner">
                                    <?php if ($data['image']['id']) { ?>
                                        <div class="slider_img">
                                            <?= wp_get_attachment_image($data['image']['id'], 'original') ?>
                                        </div>
                                    <?php } elseif ($data['title']) { ?>
                                        <div class="heading_title">
                                            <h3><?= $data['title'] ?></h3>
                                        </div>
                                    <?php } if (!empty($btn_url)) { ?>
                                        <div class="slider_btn"> <a href="<?= $btn_url ?>"><?= $data['btn_title'] ?> <i class="dej-angle-small-left"></i></a></div>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php } ?>
                        <?php while ($loop->have_posts()){ $loop->the_post(); ?>
                            <div class="item swiper-slide">
                                <?php if (dej_is_mobile() and $data['mob_card']) {
                                    get_template_part('template/product/mob-card',  $product_card );
                                } else {
                                    get_template_part('template/product/card',  $product_card );
                                } ?>
                            </div>
                        <?php }
                        wp_reset_postdata(); ?>
                        <div class="more-item swiper-slide">
                            <?php if (!empty($btn_url)) { ?>
                                <a class="product-card slider_show_more" href="<?= $btn_url ?>">
                                    <i class="dej-arrow-left"></i>
                                    <span><?= $data['btn_title'] ?></span>
                                </a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php if ($data['show_arrow'] == 'yes' and  $wrapper_class === 'swiper-opt') { ?><div class="dejavo_next_Arrow id<?= $wid_id; ?>"><i class="<?= $next_icon ?>"></i></div><div class="dejavo_prev_Arrow id<?= $wid_id; ?>"><i class="<?= $prev_icon ?>"></i></div><?php }  ?>
                <?php if ($data['show_dots'] == 'yes' and $wrapper_class === 'swiper-opt') { ?><div class="swiper-pagination sp<?= $wid_id; ?>"></div><?php }  ?>
            </div>
            <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()) { ?><script> dej_initSwipers(); </script> <?php } ?>
        </div>


        <?php
    }
}
