<?php
defined('ABSPATH') || exit;
class dej_RandomProduct_1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_random_product_1';
    }

    public function get_title()
    {
        return esc_html__('پیشنهاد لحظه ای', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-shuffle';
    }

    public function get_categories()
    {
        return ['dejavo'];
    }

    public function get_keywords()
    {
        return ['رندوم', 'پیشنهاد لحظه ای'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {
        $product_cat = [];
        $cats = get_terms("product_cat");
        if (!is_wp_error($cats) && !empty($cats)) {
            foreach ($cats as $cat) {
                $product_cat[$cat->term_id] = $cat->name;
            }
        }
        $product_tag = [];
        $tags = get_terms("product_tag");
        if (!is_wp_error($tags) && !empty($tags)) {
            foreach ($tags as $tag) {
                $product_tag[$tag->term_id] = $tag->name;
            }
        }

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'default' => esc_html__('پیشنهاد لحظه ای', 'dejavo'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__('تعداد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 12,
                'step' => 1,
                'default' => 6,
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__( 'فیلتر دسته بندی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'category',
            [
                'label' => esc_html__('دسته بندی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_cat' => 'yes',
                ],
                'options' => $product_cat,
                'multiple' => true,
            ]
        );
        $this->add_control(
            'show_tag',
            [
                'label' => esc_html__( 'فیلتر برچسب', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'tags',
            [
                'label' => esc_html__('برچسب ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_tag' => 'yes',
                ],
                'options' => $product_tag,
                'multiple' => true,
            ]
        );

        $this->add_control(
            'show_special',
            [
                'label' => esc_html__('فقط نمایش تخفیف دار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_in_stock',
            [
                'label' => esc_html__('فقط نمایش موجود در انبار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'hide_empty_price',
            [
                'label' => esc_html__('مخفی کردن بدون قیمت و رایگان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .random_product_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .random_product_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );


        $this->add_control(
            'title_border_radius',
            [
                'label' => esc_html__('کادر عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .random_product_1 .widget_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );



        $this->add_control(
            'top_title',
            [
                'label' => esc_html__( 'فاصله عنوان ویجت از بالا', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => 0,
                'selectors' => [
                    '{{WRAPPER}} .random_product_1 .widget_title' => 'top: {{SIZE}}% !important;',
                ],
            ]
        );
        $this->add_control(
            'bottom_title',
            [
                'label' => esc_html__( 'فاصله عنوان ویجت از پایین', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'selectors' => [
                    '{{WRAPPER}} .random_product_1 .widget_title' => 'bottom: {{SIZE}}% !important;',
                ],
            ]
        );
        $this->add_control(
            'right_title',
            [
                'label' => esc_html__( 'فاصله عنوان ویجت از راست', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,

                'selectors' => [
                    '{{WRAPPER}} .random_product_1 .widget_title' => 'right: {{SIZE}}% !important;',
                ],
            ]
        );

        $this->add_control(
            'left_title',
            [
                'label' => esc_html__( 'فاصله عنوان ویجت از چپ', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'selectors' => [
                    '{{WRAPPER}} .random_product_1 .widget_title' => 'left: {{SIZE}}% !important;',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .random_product_1',
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__('مرز ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .random_product_1',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget_title h3' => 'color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('رنگ پس زمینه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget_title' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget_title i' => 'color: {{VALUE}} !important;',
                ],
            ]
        );



        $this->add_responsive_control(
            'h3_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .widget_title h3' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'h3_line_height',
            [
                'label' => esc_html__('ارتفاع متن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .widget_title h3' => 'line-height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_control(
            'h3_font_weight',
            [
                'label' => esc_html__('وزن فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 300,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 500,
                ],
                'selectors' => [
                    '{{WRAPPER}} .widget_title h3' => 'font-weight: {{SIZE}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .widget_title i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );


        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__('آیکن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-bolt',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .random_product_1',
            ]
        );

        $this->end_controls_section();


    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $title = $data['title'];
        $in_stock = $data['show_in_stock'] ?? 'no';
        $on_sale = $data['show_special'] ?? 'no';
        $hide_empty_price = $data['hide_empty_price'] ?? 'no';
        $title_icon = $data['title_icon']['value'] ?? '';
        $empty_price_arr = $zero_price_arr = $in_stock_arr = [];

        $data_swiper = ['spaceBetween' => 0, 'loop' => true, 'watchSlidesProgress' => true, 'slidesPerView' => 1, 'allowTouchMove' => false, 'effect' => 'fade' ];
        $data_swiper['autoplay'] = ['delay' => 5500, 'disableOnInteraction' => false];
        $this->add_render_attribute( [
            'swiper-opt' => [
                'class' => 'dej_swiper swiper',
                'id' => 'DejavoSwiper'.$this->get_id_int(),
                'dir' => 'rtl',
                'data-swiper' => wp_json_encode($data_swiper)
            ],
        ] );

        $args = ['post_type' => 'product', 'post_status' => 'publish', 'posts_per_page' => $data['number'], 'order' => 'rand', 'orderby' => 'rand',];
        if ($data['show_cat'] == 'yes' && !empty($cats)) {
            $args['tax_query'] = [['taxonomy' => 'product_cat', 'field' => 'term_id', 'terms' => $cats]];
        }

        elseif ($data['show_tag'] == 'yes' && !empty($tags)) {
            $args['tax_query'] = [['taxonomy' => 'product_tag', 'field' => 'term_id', 'terms' => $tags]];
        }

        if ($on_sale == 'yes') {
            $args['post__in'] = array_merge( [ 0 ], wc_get_product_ids_on_sale());
        }

        if ($hide_empty_price == 'yes') {
            $empty_price_arr = ['key' => '_price', 'value' => '', 'type' => 'numeric', 'compare' => '!='];
            $zero_price_arr = ['key' => '_price', 'value' => 0, 'type' => 'numeric', 'compare' => '!='];
        }
        if ($in_stock == 'yes') {
            $in_stock_arr = [
                'relation' => 'OR',
                ['key' => '_stock_status', 'value' => 'instock',],
                ['key' => '_backorders', 'value' => 'yes',],
            ];
        }
        $args['meta_query'] = array( $empty_price_arr,$zero_price_arr,$in_stock_arr);
        $loop = new WP_Query($args);
        ?>
        <style>

            .random_product_1 {
                position: relative;
                display: flex;
                justify-content: center;
                border-radius: var(--dej-max-radius);
                overflow: hidden;
                border: 2px solid rgba(148, 147, 147, 0.61);
            }

            .random_product_1 .widget_title {
                position: absolute;
                z-index: 8;
                background: var(--dej-color1) var(--dej-bg1);
                padding: 0 15px;
                display: inline-flex;
                align-items: center;
                gap: 6px;
                flex-direction: row-reverse;
                color: #ffffff;
                border-radius: 0 0 10px 10px;
            }

            .random_product_1 .widget_title h3 {
                font-size: 14px;
                font-weight: 500;
                line-height: 20px;
                padding: 5px 0;
                color: #ffffff;
            }

            .random_product_1 .swiper-slide {
                height: auto;
            }

            .random_product_1 .item {
                display: flex;
                justify-content: center;
                flex-flow: column wrap;
                width: 100%;
                height: 100%;
                border-radius: var(--dej-max-radius);
                background-color: var(--white-color);
                overflow: hidden;
            }

            .random_product_1 .item .title h4 {
                font-size: 14px;
                font-weight: normal;
                line-height: 20px;
                padding: 4px;
                text-align: center;
            }

            .random_product_1 .item .info {
                display: flex;
                justify-content: center;
                align-items: flex-end;
                padding: 8px;
                gap: 3px;
                font-size: 13px;
            }

            .random_product_1 .item .image {
                position: relative;
                padding: 10px;
                width: 100%;
                overflow: hidden;
                display: flex;
                justify-content: center;
                flex-direction: column;
            }

            .random_product_1 .item .image a {
                margin: 15px;
                border-radius: var(--dej-max-radius);
                overflow: hidden;
            }

            .random_product_1 .item .badge {
                color: white;
                padding: 3px 12px;
                border-radius: 10px;
                font-size: 13px;
                font-weight: normal;
                background: var(--dej-color1) var(--dej-bg1);
            }

            .random_product_1 .item img {
                transition: transform 0.5s;
            }

            .random_product_1 .item img:hover {
                transform: scale(0.97);
            }


            .dej_progressbar {
                display: flex;
                height: 4px;
                background: linear-gradient(90deg, #c2c2c2 0%, rgba(194, 194, 194, 0.31) 100%);
                transition: 0.5s linear;
                animation: progressBar 6s infinite;
            }

            @keyframes progressBar {
                0% {
                    width: 0;
                }

                100% {
                    width: 100%;
                }
            }

        </style>
        <div class="random_product_1">
            <?php if ($title) {?><div class="widget_title"><h3><?= $title ?></h3><?php if ($title_icon) {?><i class="<?= $title_icon ?>"></i><?php } ?></div><?php } ?>
            <div <?= $this->get_render_attribute_string( 'swiper-opt' ) ?>>
                <div class="swiper-wrapper">
                    <?php
                    while ($loop->have_posts()){ $loop->the_post(); global $product; $product_title = $product->get_title(); ?>
                        <div class="swiper-slide">
                            <div class="item">
                                <div class="image">
                                    <a href="<?php the_permalink() ?>"><?= $product->get_image('woocommerce_thumbnail') ?></a>
                                    <div class="dej_progressbar" style="width:0"></div>
                                </div>
                                <div class="title">
                                    <h4><a href="<?php the_permalink() ?>"><?= wp_trim_words($product_title, 12, '..') ?></a></h4>
                                </div>
                                <div class="info">
                                    <?php if ($product->is_on_sale()) :  woocommerce_show_product_sale_flash()  ; endif; ?>
                                    <?= $product->get_price_html(); ?>
                                </div>
                            </div>
                        </div>
                    <?php }
                    wp_reset_postdata();  ?>
                </div>

            </div>
            <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()) { ?><script> dej_initSwipers(); </script> <?php } ?>
        </div>

        <?php

    }

}
