<?php
defined('ABSPATH') || exit;
class dej_Title extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_title';
    }

    public function get_title()
    {
        return esc_html__('عنوان', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-t';
    }

    public function get_categories()
    {
        return ['dejavo'];
    }


    public function get_keywords()
    {
        return [ 'عنوان'];
    }

    protected function is_dynamic_content(): bool {
        return false;
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {


        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان اصلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('عنوان فرعی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان فرعی', 'dejavo'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( 'تگ عنوان اصلی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'h3',
                'options' => [
                    'h3' => 'h3',
                    'h1' => 'h1',
                    'h2' => 'h2',
                    'h4' => 'h4',
                    'h5' => 'h5',
                    'p' => 'p',
                ],
            ]
        );
        $this->add_control(
            'sub_tag',
            [
                'label' => esc_html__( 'تگ عنوان فرعی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'h4',
                'options' => [
                    'h4' => 'h4',
                    'h1' => 'h1',
                    'h2' => 'h2',
                    'h3' => 'h3',
                    'h5' => 'h5',
                    'p' => 'p',
                ],
            ]
        );


        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('لینک دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );

        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('متن دکمه', 'dejavo'),
                'default' => esc_html__('مشاهده همه', 'dejavo'),
                'label_block' => true,

            ]
        );


        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__('آیکن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-crown',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__('آیکن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-small-left',
                    'library' => '',
                ],
            ]
        );


        
        $this->end_controls_section();


        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله داخلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_pad',
            [
                'label' => esc_html__('فاصله درونی عنوان ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .titles' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_pad',
            [
                'label' => esc_html__('فاصله درونی آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_pad',
            [
                'label' => esc_html__('فاصله درونی دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'radius',
            [
                'label' => esc_html__('کادر گوشه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_radius',
            [
                'label' => esc_html__('کادر گوشه عنوان اصلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'sub_radius',
            [
                'label' => esc_html__('کادر گوشه عنوان فرعی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .sub_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_radius',
            [
                'label' => esc_html__('کادر گوشه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'btn_radius',
            [
                'label' => esc_html__('کادر گوشه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__( 'مرز ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dej_title',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'bor_title_line1',
            [
                'label' => esc_html__( 'مرز میانی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'line_border',
                'selector' => '{{WRAPPER}} .dej_title .line',
            ]
        );

        $this->add_control(
            'bor_title_line2',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );



        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .dej_title',
            ]
        );



        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان اصلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_title .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'sub_color',
            [
                'label' => esc_html__('رنگ عنوان فرعی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_title .sub_title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('رنگ پس زمینه عنوان ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_title .titles' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_title .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_title .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('رنگ متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_title .btn' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_c',
            [
                'label' => esc_html__('رنگ هاور متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_title .btn:hover' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_title .btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_btn_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_title .btn:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__( 'سایز فونت آیکن ', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 20,
                ],
                'tablet_default' => [
                    'size' => 18,
                ],
                'mobile_default' => [
                    'size' => 17,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_size',
            [
                'label' => esc_html__( 'سایز فونت عنوان اصلی ', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 16,
                ],
                'tablet_default' => [
                    'size' => 15,
                ],

                'selectors' => [
                    '{{WRAPPER}} .dej_title .title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sub_size',
            [
                'label' => esc_html__( 'سایز فونت عنوان فرعی ', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 13,
                ],
                'tablet_default' => [
                    'size' => 12,
                ],

                'selectors' => [
                    '{{WRAPPER}} .dej_title .sub_title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_height',
            [
                'label' => esc_html__( 'ارتفاع متن عنوان اصلی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .title' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sub_height',
            [
                'label' => esc_html__( 'ارتفاع متن عنوان فرعی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .sub_title' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_weight',
            [
                'label' => esc_html__( 'وزن فونت عنوان اصلی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' =>  ['px'],
                'range' => [
                    'px' =>[
                        'min' => 300,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'size' => 500,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .title' => 'font-weight: {{SIZE}};',
                ],
            ]
        );
        $this->add_control(
            'sub_weight',
            [
                'label' => esc_html__( 'وزن فونت عنوان فرعی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' =>  ['px'],
                'range' => [
                    'px' =>[
                        'min' => 300,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'size' => 300,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .sub_title' => 'font-weight: {{SIZE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_size',
            [
                'label' => esc_html__('سایز فونت دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 14,
                ],
                'tablet_default' => [
                    'size' => 13,
                ],
                'mobile_default' => [
                    'size' => 12,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_title .btn' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dej_title',
            ]
        );
        $this->add_control(
            'title_shadow',
            [
                'label' => esc_html__( 'سایه متن عنوان اصلی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Text_Shadow::get_type(),
            [
                'name' => 't_shadow',
                'selector' => '{{WRAPPER}} .dej_title .title',
            ]
        );
        $this->add_control(
            'stitle_shadow',
            [
                'label' => esc_html__( 'سایه متن عنوان فرعی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'st_shadow',
                'selector' => '{{WRAPPER}} .dej_title .sub_title',
            ]
        );
        

        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $title = $data['title'] ?? '';
        $sub_title = $data['sub_title'] ?? '';
        $title_tag = $data['title_tag'] ?? 'h3';
        $sub_tag = $data['sub_tag'] ?? 'h4';
        $btn_url = $data['btn_link']['url'] ?? '#';
        $btn_title = $data['btn_title'] ?? __('مشاهده همه','dejavo');
        $title_icon = $data['title_icon']['value'] ?? 'dej-crown';
        $btn_icon = $data['btn_icon']['value'] ?? 'dej-angle-small-left';
        ?>
            <div class="dej_title">
                <div class="head">
                    <?php if ($title_icon) { ?><div class="icon"><i class="<?= $title_icon ?>"></i></div><?php } ?>
                    <div class="titles">
                        <?php if ($title) { echo '<'. $title_tag .  ' class="title">' . $title . '</' . $title_tag .  '>';  } ?>
                        <?php if ($sub_title) { echo '<'. $sub_tag .  ' class="sub_title">' . $sub_title . '</' . $sub_tag .  '>';  } ?>
                    </div>
                </div>
                <div class="line"></div>
                <?php  if (!empty($btn_url)){ ?>
                    <a class="btn" href="<?= $btn_url ?>"><?= $btn_title ?> <i class="<?= $btn_icon ?>"></i></a>
                <?php } ?>
            </div>
         <?php
    }
}
