<?php
defined('ABSPATH') || exit;
class dej_PostShare extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'dej_post_share';
    }

    public function get_title()
    {
        return esc_html__('اشتراک گذاری', 'dejavo');
    }

    public function get_icon()
    {
        return 'dejbrand-instagram';
    }

    public function get_categories()
    {
        return ['dejavo-post'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('اشتراک گذاری', 'dejavo'),
                'default' => esc_html__('اشتراک گذاری', 'dejavo'),
                'label_block' => true,
            ]
        );
      

        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .post_share',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post_share > span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'a_color',
            [
                'label' => esc_html__('رنگ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social_icons li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_a_color',
            [
                'label' => esc_html__('رنگ هاور', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social_icons li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__( 'مرز', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .post_share',
            ]
        );


        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .post_share' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .post_share' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('اندازه فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 13,
                ],
                'selectors' => [
                    '{{WRAPPER}} .social_icons li a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه آیکن ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'shadow',
                'selector' => '{{WRAPPER}} .social_icons li',
            ]
        );
        $this->add_control(
            'shadow_h2',
            [
                'label' => esc_html__( 'هاور سایه آیکن ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_shadow',
                'selector' => '{{WRAPPER}} .social_icons li:hover',
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        $data = $this->get_settings_for_display();
            ?>
            <div class="post_share">
                <span><?= $data['title'] ?></span>
                <ul class="social_icons">
                    <li><a href="mailto:?&subject=<?= the_title() ?>&body=<?= the_title() ?> <?php the_permalink() ?>"><i
                                    class="dej-envelope"></i></a></li>
                    <li><a href="https://wa.me/?text=<?php the_permalink() ?> <?= the_title() ?>"><i
                                    class="dejbrand-whatsapp"></i></a></li>
                    <li><a href="https://t.me/share/url?url=<?php the_permalink() ?>&text=<?= the_title() ?>"><i
                                    class="dejbrand-telegram"></i></a></li>
                    <li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink() ?>"><i
                                    class="dejbrand-facebook"></i></a></li>
                    <li><a href="https://twitter.com/intent/tweet?url=<?php the_permalink() ?>&text=<?= the_title() ?>"><i
                                    class="dejbrand-twitter"></i></a></li>
                </ul>
            </div>
          
           <?php
    }
}
