<?php
defined('ABSPATH') || exit;

class dej_ProductAttrShort extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_product_attr_short';
    }

    public function get_title()
    {
        return esc_html__('ویژگی های محصول', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-ballot';
    }

    public function get_categories()
    {
        return ['dejavo-single-product'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'attr_count',
            [
                'label' => esc_html__( 'تعداد ویژگی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2,
                'max' => 20,
                'step' => 1,
                'default' => 4,
            ]
        );

        $this->add_control(
            'col_count',
            [
                'label' => esc_html__( 'تعداد ستون', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                ],
            ]
        );
        $this->add_control(
            'lap_col_count',
            [
                'label' => esc_html__( 'تعداد ستون لپ تاپ', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                ],
            ]
        );

        $this->add_control(
            'tab_col_count',
            [
                'label' => esc_html__( 'تعداد ستون تبلت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                ],
            ]
        );

        $this->add_control(
            'mob_col_count',
            [
                'label' => esc_html__( 'تعداد ستون موبایل', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                ],
            ]
        );



        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویژگی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .dej_short_attr .attr',
            ]
        );

        $this->add_control(
            'btn_bg_title',
            [
                'label' => esc_html__('پس زمینه مشاهده همه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .dej_all_attr a',
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__('رنگ نام ویژگی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_short_attr .name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'values_color',
            [
                'label' => esc_html__('رنگ مقدار ویژگی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_short_attr .values' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'all_color',
            [
                'label' => esc_html__('رنگ متن مشاهده همه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_all_attr a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hov_all_color',
            [
                'label' => esc_html__('رنگ هاور مشاهده همه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_all_attr a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dej_short_attr .attr',
            ]
        );



        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_short_attr .attr, {{WRAPPER}} .dej_all_attr a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'name_font_size',
            [
                'label' => esc_html__('اندازه فونت نام', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_short_attr .name' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('اندازه فونت مقدار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_short_attr .values' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dej_short_attr .attr, {{WRAPPER}} .dej_all_attr a',
            ]
        );
        $this->add_control(
            'shadow_h2',
            [
                'label' => esc_html__( 'هاور سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_shadow',
                'selector' => '{{WRAPPER}} .dej_short_attr .attr:hover, {{WRAPPER}} .dej_all_attr a:hover',
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        $data = $this->get_settings_for_display();
        $attr_count = $data['attr_count'] ?? 4;
        $cols = 'mob_col'. $data['mob_col_count'] . ' tab_col'. $data['tab_col_count'] . ' lap_col'. $data['lap_col_count'] . ' col'. $data['col_count'];


        if (is_product()) {
            global $product;
            $attributes = $product->get_attributes();
            if ($attributes and is_array($attributes)) {
                echo '<div class="dej_short_attr d_grid ' . $cols . '">';
                foreach (array_slice($attributes, 0, $attr_count) as $attribute) {
                    $attribute_name = wc_attribute_label($attribute->get_name());
                    $values = [];
                    $values2 = [];
                    echo '<div class="attr"><div class="name">' . $attribute_name . '</div><div class="values">';
                    $attribute_values = wc_get_product_terms($product->get_id(), $attribute->get_name(), array('fields' => 'all'));
                    foreach ($attribute_values as $attribute_value) {
                        $values[] = esc_html($attribute_value->name);
                    }
                    if (isset($attribute['options'])) {
                        foreach ($attribute['options'] as $option) {
                            if (!is_numeric($option)) {
                                $values2[] = $option;
                            }
                        }
                    }
                    $vals= array_unique(array_merge($values2,$values));
                    echo wptexturize(implode(', ', $vals));
                    echo '</div></div>';
                }
                echo '</div><div class="dej_all_attr"><hr class="dej_hr"><a href="#additional_information">مشاهده همه ویژگی‌ها <i class=" dej-angle-small-left"></i></a><hr class="dej_hr"></div>';
                echo '';
            }

        }
    }
}
