<?php
defined('ABSPATH') || exit;
class dej_ProductBrandImage extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_product_brand_img';
    }

    public function get_title()
    {
        return esc_html__('تصویر برند', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-badge';
    }

    public function get_categories()
    {
        return ['dejavo-single-product'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );



        $this->add_control(
            'bor_head_be',
            [
                'label' => esc_html__( 'مرز', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dejavo-brand-image',
            ]
        );


        $this->add_control(
            'bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo-brand-image, {{WRAPPER}} .dejavo-brand-image a img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo-brand-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $sizes = get_intermediate_image_sizes() ?? [];
        $this->add_control(
            'img_size',
            [
                'label' => esc_html__('اندازه تصویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'full',
                'options' => $sizes,
            ]
        );
        $this->add_control(
            'max-width',
            [
                'label' => esc_html__( 'حداکثر عرض', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 250,
                        'step' => 5,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 80,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo-brand-image' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dejavo-brand-image',
            ]
        );

        $this->add_control(
            'shadow_h2',
            [
                'label' => esc_html__( 'هاور سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_shadow',
                'selector' => '{{WRAPPER}} .dejavo-brand-image:hover',
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        $data = $this->get_settings_for_display();
        $sizes = get_intermediate_image_sizes() ?? [];
        $size = $sizes[$data['img_size']] ?? 'full';

        if ( dej_woo_activated() and is_product() and dejavo_product_brand_image($size)) { ?>
                <div class="dejavo-brand-image">
                    <?= dejavo_product_brand_image($size) ?>
                </div>
           <?php
        }
    }
}
