<?php
defined('ABSPATH') || exit;

class dej_ProductCountDown extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_product_countdown';
    }

    public function get_title()
    {
        return esc_html__('شمارشگر معکوس', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-time-quarter-to';
    }

    public function get_categories()
    {
        return ['dejavo-single-product'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('پیشنهاد ویژه', 'dejavo'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('زیر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('زمان باقیمانده', 'dejavo'),
                'label_block' => true,
            ]
        );

        $this->add_responsive_control(
            'f_dir',
            [
                'label' => esc_html__('جهت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'column' => [
                        'title' => esc_html__('عمودی', 'dejavo'),
                        'icon' => 'dej-arrows-alt-v',
                    ],
                    'row' => [
                        'title' => esc_html__('افقی', 'dejavo'),
                        'icon' => 'dej-arrows-alt-h',
                    ],
                ],
                'default' => 'row',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown' => 'flex-direction: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'widget_bg',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .dej_product_countdown',
            ]
        );

        $this->add_control(
            'countdown_bg',
            [
                'label' => esc_html__('رنگ پس زمینه شمارنده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .countdown_box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'numb_countdown_bg',
            [
                'label' => esc_html__('رنگ پس زمینه اعداد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .countdown_box .countdown' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'second_bg',
            [
                'label' => esc_html__('رنگ پس زمینه ثانیه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .countdown_box .countdown.seconds' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .head .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'sub_title_color',
            [
                'label' => esc_html__('رنگ زیر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .head .sub_title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => esc_html__('رنگ متن شمارنده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .cd_text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'num_color',
            [
                'label' => esc_html__('رنگ اعداد شمارنده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .countdown' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'second_color',
            [
                'label' => esc_html__('رنگ عدد ثانیه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .countdown.seconds' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'bor_head_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dej_product_countdown',
            ]
        );


        $this->add_control(
            'bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'bor_head_be2',
            [
                'label' => esc_html__('مرز باکس شمارنده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .dej_product_countdown .countdown_box',
            ]
        );


        $this->add_control(
            'bor_head_af2',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'bor_head_be3',
            [
                'label' => esc_html__('مرز اعداد شمارنده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'num_box_border',
                'selector' => '{{WRAPPER}} .dej_product_countdown .countdown_box .countdown',
            ]
        );


        $this->add_control(
            'bor_head_af3',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'box_border_radius',
            [
                'label' => esc_html__('کادر باکس ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .countdown_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'num_border_radius',
            [
                'label' => esc_html__('کادر اعداد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .countdown_box .countdown' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'title_font_size',
            [
                'label' => esc_html__('اندازه فونت متن عنوان اصلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .head .title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'num_font_size',
            [
                'label' => esc_html__('اندازه فونت اعداد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 12,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 19,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .countdown_box .countdown' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'text_font_size',
            [
                'label' => esc_html__('اندازه متن ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 13,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_product_countdown .countdown_box .cd_text' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dej_product_countdown',
            ]
        );
        $this->add_control(
            'item_shadow_h',
            [
                'label' => esc_html__( 'سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'selector' => '{{WRAPPER}} .dej_product_countdown .countdown_box .countdown',
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        $data = $this->get_settings_for_display();

        if ( is_product() and dejavo_contdown_timer()) {
            ?>
            <div class="dej_product_countdown">
                <div class="head">
                    <?php if ($data['title']) { ?>
                        <div class="title">
                            <i class="dej-badge-percent"></i>
                            <?= $data['title'] ?>
                        </div>
                    <?php }
                    if ($data['sub_title']) { ?>
                        <div class="sub_title">
                            <i class="dej-alarm-clock"></i>
                            <?= $data['sub_title'] ?>
                        </div>
                    <?php } ?>
                </div>
                <div class="countdown_time" data-times="<?= dejavo_contdown_timer(); ?>"></div>
            </div>
            <?php
        }
    }
}
