<?php
defined('ABSPATH') || exit;
class dej_ProductPrice extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_product_price';
    }

    public function get_title()
    {
        return esc_html__('قیمت', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-money';
    }

    public function get_categories()
    {
        return ['dejavo-single-product'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'show_alert',
            [
                'label' => esc_html__('نمایش متن ناموجود ؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-sad',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'out_text',
            [
                'label' => esc_html__('عنوان ناموجود', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('متاسفانه موجودی این محصول به اتمام رسیده است', 'dejavo'),
                'default' => esc_html__('متاسفانه موجودی این محصول به اتمام رسیده است', 'dejavo'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'empty_price',
            [
                'label' => esc_html__('عنوان بدون قیمت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('در حال حاضر در دسترس نیست', 'dejavo'),
                'default' => esc_html__('در حال حاضر در دسترس نیست', 'dejavo'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'contact',
            [
                'label' => esc_html__('زیر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('جهت اطلاع دقیق تر از وضعیت این محصول با ما تماس بگیرید', 'dejavo'),
                'default' => esc_html__('جهت اطلاع دقیق تر از وضعیت این محصول با ما تماس بگیرید', 'dejavo'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'w_bg',
            [
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_single_price' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'out_bg',
            [
                'label' => esc_html__('رنگ پس زمینه ناموجود', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .zero_quantity' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'color',
            [
                'label' => esc_html__('رنگ متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_single_price' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن ناموجود', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .zero_quantity .icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'out_color',
            [
                'label' => esc_html__('رنگ متن ناموجوئ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .zero_quantity .content h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'sub_color',
            [
                'label' => esc_html__('رنگ متن زیرعنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .zero_quantity .content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bor_head_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dej_single_price',
            ]
        );
        $this->add_control(
            'bor_head_be2',
            [
                'label' => esc_html__('مرز ناموجود', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'alert_border',
                'selector' => '{{WRAPPER}} .zero_quantity',
            ]
        );


        $this->add_control(
            'bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_single_price, {{WRAPPER}} .zero_quantity' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_single_price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'font_size',
            [
                'label' => esc_html__('اندازه فونت متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_single_price .woocommerce-Price-amount' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'del_font_size',
            [
                'label' => esc_html__('اندازه فونت قیمت اصلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_single_price del .woocommerce-Price-amount' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'ins_font_size',
            [
                'label' => esc_html__('اندازه فونت قیمت با تخفیف', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_single_price ins .woocommerce-Price-amount' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        $data = $this->get_settings_for_display();
        $icon = $data['icon']['value'] ? '<div class="icon"><i class="' . $data['icon']['value'] . '"></i></div>' : '';
        if (is_product()) {
        global $product;

        $out_of_stock = $data['out_text'] ?? __('متاسفانه موجودی این محصول به اتمام رسیده است', 'dejavo');
        $empty_price = $data['empty_price'] ?? __('در حال حاضر در دسترس نیست', 'dejavo');
        $contact = $data['contact'] ?? __('جهت اطلاع دقیق تر از وضعیت این محصول با ما تماس بگیرید', 'dejavo');
        $zero_quantity = '<div class="zero_quantity">' . $icon . '<div class="content"><h4>' . $out_of_stock . '</h4> <p>' . $contact . '</p></div></div>';
        $without_price = '<div class="zero_quantity">' . $icon . '<div class="content"><h4>' . $empty_price . '</h4> <p>' . $contact . '</p></div></div>';

        if ($data['show_alert']) {
            if ($product->is_type('variable')) {
                $variation_prices = $product->get_variation_prices();
                if (empty($variation_prices['price'])) {
                    echo $without_price;
                } elseif (dejavo_out_of_stock($product)) {
                    echo $zero_quantity;
                } else { ?>
                    <div class="dej_single_price"><?= $product->get_price_html(); ?></div>
                <?php }
            } elseif ($product->is_type('simple') || $product->is_type('external')) {
                if ($product->get_price() == '') {
                    echo $without_price;
                } elseif ($product->get_stock_quantity() == '0' || dejavo_out_of_stock($product)) {
                    echo $zero_quantity;
                } else { ?>
                    <div class="dej_single_price"><?= $product->get_price_html(); ?></div>
                <?php }
            }
        } else { ?>
            <div class="dej_single_price"><?= $product->get_price_html(); ?></div>
        <?php }

        }

    }
}
