<?php
defined('ABSPATH') || exit;
class dej_ProductRecommend extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_product_recommend';
    }

    public function get_title()
    {
        return esc_html__('تعداد پیشنهاد', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-thumbs-up';
    }

    public function get_categories()
    {
        return ['dejavo-single-product'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('از کاربران، این محصول را پیشنهاد کرده اند', 'dejavo'),
                'default' => esc_html__('از کاربران، این محصول را پیشنهاد کرده اند', 'dejavo'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'icon',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-thumbs-up',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .dejavo_recommended_num',
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_recommended_num i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_recommended_num' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bor_head_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dejavo_recommended_num',
            ]
        );

        $this->add_control(
            'bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_recommended_num' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_recommended_num' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_font_size',
            [
                'label' => esc_html__('اندازه فونت متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 13,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_recommended_num' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('اندازه فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_recommended_num i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dejavo_recommended_num',
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        $data = $this->get_settings_for_display();
        $icon = $data['icon']['value'] ?? 'dej-thumbs-up';
        $title = $data['title'] ?? '';
        if (is_product()) {
        global $product;
        if (dej_opt('show_dej_reviews_recommend', true)) { ?>
            <div class="dejavo_recommended_num">
                <i class="<?= $icon ?>"></i>
                <?php echo get_average_recommend($product->get_id()) . '%';
                echo ' (' . get_count_recommended($product->get_id()) . 'نفر) ' . $title; ?>
            </div>
            <?php

        }
        }

    }
}
