<?php
defined('ABSPATH') || exit;

function dej_custom_tab()
{
    global $product;
    $meta = get_post_meta($product->get_id(), 'dej_product_options', true) ?? false;
    if ($meta) {
        $content = $meta['dej_custom_tab_content'] ?? '';
        $title = $meta['dej_custom_tab_title'] ?? '';
        echo '<h2 class="title">' . $title . '</h2>' . $content;
    }
}

function dej_custom_tab2()
{
    global $product;
    $meta = get_post_meta($product->get_id(), 'dej_product_options', true) ?? false;
    if ($meta) {
        $content = $meta['dej_custom_tab_content2'] ?? '';
        $title = $meta['dej_custom_tab_title2'] ?? '';
        echo '<h2 class="title">' . $title . '</h2>' . $content;
    }
}
class dej_ProductTabs extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_product_tabs';
    }

    public function get_title()
    {
        return esc_html__('تب ها', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-browser';
    }

    public function get_categories()
    {
        return ['dejavo-single-product'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'side',
            [
                'label' => esc_html__('نمایش نوار کناری شناور', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'nav_border_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'sec_border_radius',
            [
                'label' => esc_html__('کادر بخش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo-scrollspy section' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_head',
            [
                'label' => esc_html__('مرز آیتم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'nav_border',
                'selector' => '{{WRAPPER}} .dejavo_product_tabs',
            ]
        );
        $this->add_control(
            'bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'sec_bor_head',
            [
                'label' => esc_html__('مرز آیتم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'sec_border',
                'selector' => '{{WRAPPER}} .dejavo-scrollspy section',
            ]
        );
        $this->add_control(
            'sec_bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'nav_bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه نوار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'nav_bg',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .dejavo_product_tabs',
            ]
        );

        $this->add_control(
            'sec_bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه بخش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'sec_bg',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .dejavo-scrollspy section',
            ]
        );

        $this->add_responsive_control(
            'gap_item',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 50,
                'step' => 1,
                'default' => 2,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .nav' => 'gap: {{SIZE}}px;',
                ],
            ]
        );


        $this->add_control(
            'desc_icon',
            [
                'label' => esc_html__('آیکن توضیحات', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-notebook',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'more_info_icon',
            [
                'label' => esc_html__('آیکن توضیحات تکمیلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-list',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'reviews_icon',
            [
                'label' => esc_html__('آیکن نظرات', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-comments',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'seller_icon',
            [
                'label' => esc_html__('آیکن فروشنده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-shop',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'seller_product_icon',
            [
                'label' => esc_html__('آیکن محصولات فروشنده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-shopping-bag-add',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'item_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .link' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_item_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .link:hover, {{WRAPPER}} .dejavo_product_tabs .link.active' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'img_height',
            [
                'label' => esc_html__('تعیین ارتفاع تصاویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 150,
                        'max' => 450,
                        'step' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-card .image' => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .link i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_icon_color',
            [
                'label' => esc_html__('رنگ هاور آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .link:hover i, {{WRAPPER}} .dejavo_product_tabs .link.active i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .link' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_title_color',
            [
                'label' => esc_html__('رنگ هاور عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .link:hover, {{WRAPPER}} .dejavo_product_tabs .link.active' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bor_head_be',
            [
                'label' => esc_html__('مرز آیتم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .dejavo_product_tabs .link',
            ]
        );

        $this->add_control(
            'bor_hover_color',
            [
                'label' => esc_html__('رنگ هاور مرز آیتم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .link:hover, {{WRAPPER}} .dejavo_product_tabs .link.active' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bor_head_af2',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر آیتم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('فاصله آیتم ها از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_pad',
            [
                'label' => esc_html__('فاصله درونی آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_font_size',
            [
                'label' => esc_html__('اندازه فونت متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 14,
                ],
                'tablet_default' => [
                    'size' => 13,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .link' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('اندازه فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 17,
                ],
                'tablet_default' => [
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_product_tabs .link i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'accordion_height',
            [
                'label' => esc_html__('حداکثر ارتفاع توضیحات', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 700,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .p_description:not(.show)' => 'max-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'dokan_product_sec',
            [
                'label' => esc_html__('دکان', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('محصولات دیگر فروشنده', 'dejavo'),
                'default' => esc_html__('محصولات دیگر فروشنده', 'dejavo'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'product_card',
            [
                'label' => esc_html__('سبک نمایش محصول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('یک', 'dejavo'),
                    '2' => esc_html__('دو', 'dejavo'),
                    '3' => esc_html__('سه', 'dejavo'),
                    '4' => esc_html__('چهار', 'dejavo'),
                    '5' => esc_html__('پنج', 'dejavo'),
                    '6' => esc_html__('شش', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'product_number',
            [
                'label' => esc_html__('تعداد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 20,
                'step' => 1,
                'default' => 10,
            ]
        );

        $this->add_control(
            'mob_card',
            [
                'label' => esc_html__('نمایش کارد ویژه موبایل ؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'mob_scroll',
            [
                'label' => esc_html__('حالت اسکرول افقی در موبایل ؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'hide_scrollbar',
            [
                'label' => esc_html__('مخفی کردن اسکرول بار در موبایل ؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'mob_scroll' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'desktop_cols',
            [
                'label' => esc_html__('تعداد ستون', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 4,
            ]
        );
        $this->add_control(
            'laptop_cols',
            [
                'label' => esc_html__('تعداد ستون لپ تاپ کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'tablet_cols',
            [
                'label' => esc_html__('تعداد ستون تبلت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 2,
            ]
        );
        $this->add_control(
            'mobile_cols',
            [
                'label' => esc_html__('تعداد ستون موبایل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 2.5,
                'step' => 0.1,
                'default' => 2,
            ]
        );
        $this->add_control(
            'number-in-scroll',
            [
                'label' => esc_html__('تعداد در هر اسکرول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 1,
            ]
        );

        $this->add_control(
            'scroll-time',
            [
                'label' => esc_html__('زمان تاخیر اسکرول خودکار (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3000,
                'max' => 12000,
                'step' => 200,
                'default' => 6000,
            ]
        );
        $this->add_control(
            'scroll-speed',
            [
                'label' => esc_html__('سرعت اسکرول (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 300,
                'max' => 1600,
                'step' => 100,
                'default' => 700,
            ]
        );
        $this->add_control(
            'free-mode',
            [
                'label' => esc_html__('اسکرول آزاد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('نمایش فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_dots',
            [
                'label' => esc_html__('نمایش نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('چرخش خودکار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 50,
                'step' => 1,
                'default' => 5,
            ]
        );

        $this->add_responsive_control(
            'dokan_padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'dokan_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'dokan_item_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1 .product-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'dokan_title_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title, {{WRAPPER}} .dej_heading_1 .title .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'dokan_more_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'dokan_bor_opt_be',
            [
                'label' => esc_html__('مرز ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'dokan_product_border',
                'selector' => '{{WRAPPER}} .product_slider_1',
            ]
        );

        $this->add_control(
            'dokan_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'dokan_item_bor_opt_be',
            [
                'label' => esc_html__('مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'dokan_item_border',
                'selector' => '{{WRAPPER}} .product_slider_1 .product-card',
            ]
        );

        $this->add_control(
            'dokan_hover_item_border',
            [
                'label' => esc_html__('رنگ هاور مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1 .product-card:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'dokan_item_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'dokan_bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'dokan_bg',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .product_slider_1',
            ]
        );


        $this->add_control(
            'dokan_bg_item',
            [
                'label' => esc_html__('رنگ پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1 .product-card .main-bg, {{WRAPPER}} .product_slider_1 .product-card' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'dokan_hover_bg_item',
            [
                'label' => esc_html__('رنگ هاور پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1 .product-card:hover .main-bg, {{WRAPPER}} .product_slider_1 .product-card:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'dokan_head_options',
            [
                'label' => esc_html__('نوار عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'bor_title_line1',
            [
                'label' => esc_html__( 'مرز میانی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'line_border',
                'selector' => '{{WRAPPER}} .dej_heading_1 .line',
            ]
        );

        $this->add_control(
            'bor_title_line2',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'next_icon',
            [
                'label' => esc_html__('آیکن بعدی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-right',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label' => esc_html__('آیکن قبلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-left',
                    'library' => '',
                ],
            ]
        );


        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__('آیکن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-shopping-bag-add',
                    'library' => '',
                ],
            ]
        );


        $this->add_control(
            'dokan_title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'dokan_title_bg',
            [
                'label' => esc_html__('رنگ پس زمینه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'dokan_icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'dokan_icon_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'dokan_arrows_color',
            [
                'label' => esc_html__('رنگ فلشها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'dokan_arrows_bg',
            [
                'label' => esc_html__('رنگ پس زمینه فلشها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'dokan_bullet_bg',
            [
                'label' => esc_html__('رنگ نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1 .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'dokan_icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'dokan_h3_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 16,
                ],
                'tablet_default' => [
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'dokan_h3_line_height',
            [
                'label' => esc_html__('ارتفاع متن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'dokan_h3_font_weight',
            [
                'label' => esc_html__('وزن فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 300,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'size' => 500,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-weight: {{SIZE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrows_font_size',
            [
                'label' => esc_html__('سایز فونت فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        $data = $this->get_settings_for_display();
        $desc_icon = $data['desc_icon']['value'] ?? 'dej-notebook';
        $more_info_icon = $data['more_info_icon']['value'] ?? 'dej-list';
        $reviews_icon = $data['reviews_icon']['value'] ?? 'dej-comments';
        $seller_icon = $data['seller_icon']['value'] ?? 'dej-shop';
        $seller_product_icon = $data['seller_product_icon']['value'] ?? 'dej-shopping-bag-add';
        $custom_icon1 = $custom_icon2 = '';
        $wid_id = $this->get_id_int();
        $sticky = $data['side'] == 'yes' ? 1 : 0;
        if (is_product()) {
        global $product;
        $meta = get_post_meta($product->get_id(), 'dej_product_options', true) ?? false;
        if ($meta) {
            $custom_icon1 = $meta['dej_custom_tab_icon'] ?? 'dej-add';
            $custom_icon2 = $meta['dej_custom_tab_icon2'] ?? 'dej-add';
        }

        $icons = array('description' => $desc_icon, 'additional_information' => $more_info_icon, 'reviews' => $reviews_icon, 'seller' => $seller_icon, 'more_seller_product' => $seller_product_icon, 'dej_custom_tab' => $custom_icon1, 'dej_custom_tab2' => $custom_icon2, 'shipping' => 'dej-truck-side', 'seller_enquiry_form' => 'dej-comment-user');
        $product_tabs = apply_filters('woocommerce_product_tabs', array());


        if (class_exists('WeDevs_Dokan') and isset($product_tabs["seller"])) {
            ?>
            <section class="dejavo_<?php echo esc_attr('seller'); ?>">
                <?php
                if (isset($product_tabs['seller']['callback'])) {
                    call_user_func($product_tabs['seller']['callback'], 'seller', $product_tabs['seller']);
                }
                ?>
            </section>
            <?php
            unset($product_tabs["seller"]);
        }
        if ($meta) {
            $custom_title1 = $meta['dej_custom_tab_title'] ?? '';
            $custom_title2 = $meta['dej_custom_tab_title2'] ?? '';
            $array1 = array('title' => $custom_title1, 'priority' => 40, 'callback' => 'dej_custom_tab');
            $array2 = array('title' => $custom_title2, 'priority' => 50, 'callback' => 'dej_custom_tab2');

            if ($custom_title1) {
                $product_tabs['dej_custom_tab'] = $array1;
            }
            if ($custom_title2) {
                $product_tabs['dej_custom_tab2'] = $array2;
            }
        }

        $admin_bar = 0;
        $scroll = 80;
        if (is_admin_bar_showing()) {
            $admin_bar = 32;
        }
        $scroll = $scroll + $admin_bar;
        if (!empty($product_tabs)) { ?>

            <style>
                .dejavo_product_tabs {
                    position: sticky;
                    top: 0;
                    background-color: rgba(255, 255, 255, 0.7);
                    backdrop-filter: blur(5px);
                    z-index: 7;
                    padding: 0 4px;
                    border-radius: var(--dej-min-radius);
                    overflow-x: auto;
                    overflow-y: hidden;
                }

                .dejavo_product_tabs .nav {
                    display: flex;
                    gap: 2px;
                    width: auto;
                    white-space: nowrap;
                }

                .dejavo_product_tabs::-webkit-scrollbar {
                    height: 3px;
                }

                .dejavo_product_tabs .nav .link {
                    display: inline-flex;
                    align-items: center;
                    gap: 6px;
                    padding: 14px 6px;
                    border-bottom: 2px solid transparent;
                    font-weight: 500;
                }

                .dejavo_product_tabs .nav .link.active {
                    color: var(--dej-color1);
                    border-color: var(--dej-color1);
                }

                .dejavo-scrollspy section {
                    padding: 20px;
                    margin: 15px 0;
                    border-radius: var(--dej-max-radius);
                    background-color: white;
                }
                .dej_tabs.full {
                    width: 100% !important;
                }
                @media (max-width: 600px) {
                    .dejavo_product_tabs {
                        scrollbar-width: none !important;
                        scrollbar-color: transparent transparent !important;
                    }
                    .dejavo-scrollspy section {
                        padding: 15px 10px;
                    }
                }
            </style>
             <div class="dej_p_tabs">
               <div class="dej_tabs<?php if (!$sticky) {echo ' full';} ?>">
                   <nav class="dejavo_product_tabs">
                       <ul class="nav">
                    <?php foreach ($product_tabs as $key => $product_tab) { ?>
                        <li class="item">
                            <a data-scroll="<?php echo esc_attr($key); ?>" class="link" href="#<?php echo esc_attr($key); ?>">
                                <i class="<?php if (isset($icons[$key])) { echo $icons[$key]; } else { echo 'dej-comment-info'; } ?>"></i>
                                <?php echo wp_kses_post(apply_filters('woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key)); ?>
                            </a>
                        </li>
                    <?php } ?>

                </ul>
                   </nav>
                   <div class="dejavo-scrollspy">
                <?php foreach ($product_tabs as $key => $product_tab) { ?>
                    <section class="<?php echo 'product_' . esc_attr($key); ?>" id="<?php echo esc_attr($key); ?>">
                        <?php

                        if ($key === 'more_seller_product') {

                            $product_card = $data['product_card'];
                            $title_icon = $data['title_icon']['value'] ?? '';
                            $next_icon = $data['next_icon']['value'] ?? '';
                            $prev_icon = $data['prev_icon']['value'] ?? '';
                            $space_between = $data['space_between'] ?? 5;
                            $title = $data['title'] ?? '';


                            $data_swiper = ['spaceBetween' => $space_between, 'watchSlidesProgress' => true];
                            if ($data['free-mode'] == 'yes') {
                                $data_swiper['freeMode'] = true;
                            }
                            if ($data['autoplay'] == 'yes') {
                                $data_swiper['autoplay'] = ['delay' => $data['scroll-time'], 'disableOnInteraction' => true, 'pauseOnMouseEnter' => true];
                            }
                            if ($data['show_arrow'] == 'yes') {
                                $data_swiper['navigation'] = ['nextEl' => ".dejavo_next_Arrow.id{$wid_id}", 'prevEl' => ".dejavo_prev_Arrow.id{$wid_id}"];
                            }
                            if ($data['show_dots'] == 'yes') {
                                $data_swiper['pagination'] = ['el' => ".swiper-pagination.sp{$wid_id}", 'clickable' => true];
                            }
                            $data_swiper['breakpoints'] = ['0' => ['slidesPerView' => $data['mobile_cols'], 'speed' => 300, 'slidesPerGroup' => 1], '576' => ['slidesPerView' => $data['tablet_cols']], '768' => ['slidesPerView' => $data['laptop_cols'], 'speed' => $data['scroll-speed']], '992' => ['slidesPerView' => $data['desktop_cols'], 'speed' => $data['scroll-speed'], 'slidesPerGroup' => $data['number-in-scroll']]];


                            $this->add_render_attribute([
                                'swiper-opt' => [
                                    'class' => 'dej_swiper swiper',
                                    'id' => 'DejavoSwiper' . $wid_id,
                                    'dir' => 'rtl',
                                    'data-swiper' => wp_json_encode($data_swiper)
                                ],
                            ]);

                            $hide_scrollbar = '';
                            if ($data['hide_scrollbar'] == 'yes') {
                                $hide_scrollbar = ' scrollbar-hidden';
                            }
                            $this->add_render_attribute([
                                'mobile-opt' => [
                                    'class' => 'mob_wrapper' . $hide_scrollbar,
                                ],
                            ]);


                            if (dej_is_mobile() and $data['mob_scroll']) {
                                $wrapper_class = 'mobile-opt';
                            } else {
                                $wrapper_class = 'swiper-opt';
                            }

                            $seller_id = get_post_field('post_author', get_the_id());

                            if ($seller_id === 0 || 'more_seller_product' === $seller_id) {
                                $seller_id = $product->post_author;
                            }


                            $loop = [
                                'post_type' => 'product',
                                'posts_per_page' => $data['product_number'],
                                'orderby' => 'rand',
                                'post__not_in' => [$product->get_id()],
                                'author' => $seller_id,
                            ];

                            $products = new WP_Query($loop);
                            if ($products->have_posts()) { ?>
                                <div class="product_slider_1">
                                    <?php if ($title) { ?>
                                        <div class="dej_heading_1">
                                            <div class="title">
                                                <?php if ($title_icon) { ?>
                                                    <div class="icon"><i class="<?= $title_icon ?>"></i></div><?php } ?>
                                                <h3><?= $title ?></h3>
                                            </div>
                                            <div class="line"></div>
                                            <div class="arrow_more">
                                                <?php
                                                if ($data['show_arrow'] == 'yes' and $wrapper_class === 'swiper-opt') { ?>
                                                    <div class="arrows">
                                                        <div class="dejavo_next_Arrow id<?= $wid_id; ?>"><i class="<?= $next_icon ?>"></i></div>
                                                        <div class="dejavo_prev_Arrow id<?= $wid_id; ?>"><i class="<?= $prev_icon ?>"></i></div>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    <?php } ?>
                                    <div class="slides">
                                        <div <?= $this->get_render_attribute_string($wrapper_class) ?>>
                                            <div class="products_slider swiper-wrapper">
                                                <?php while ($products->have_posts()) {
                                                    $products->the_post(); ?>
                                                    <div class="item swiper-slide">
                                                        <?php if($wrapper_class === 'mobile-opt') {
                                                            get_template_part('template/product/mob-card', $product_card);
                                                        } else {
                                                            get_template_part('template/product/card', $product_card);
                                                        } ?>
                                                    </div>
                                                <?php }
                                                wp_reset_postdata(); ?>
                                            </div>
                                        </div>
                                        <?php if ($data['show_dots'] == 'yes' and $wrapper_class === 'swiper-opt') { ?>
                                        <div class="swiper-pagination sp<?= $wid_id; ?>"></div><?php } ?>
                                    </div>
                                </div>
                                <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()) { ?>
                                    <script> dej_initSwipers(); </script> <?php } ?>
                            <?php }

                        } elseif (isset($product_tab['callback'])) {

                            if ($key === 'description') {
                                echo '<div class="p_description">';
                            }

                          wp_kses_post(  wpautop(call_user_func($product_tab['callback'], $key, $product_tab)));

                            if ($key === 'description') {
                                echo '</div>';
                            }
                        }
                        ?>

                    </section>
                <?php } ?>

                       <?php do_action('woocommerce_product_after_tabs'); ?>
                   </div>
               </div>
                 <?php if ($sticky) { ?>
                <div class="dej_sticky_add">
                    <?php wc_get_template_part('sticky'); ?>
                </div>
            <?php } ?>
             </div>
            <script>
                jQuery(document).ready(function($){
                    let nav_tabs = $('.dejavo_product_tabs');
                    $(window).on('load resize', function(){
                        let top = 0;
                        let adminbar_height = 0;
                        let nav_tabs_height;
                        if ($('.dej_sticky_menu').length) {
                            top = $('.dej_sticky_menu').height();
                        }
                        if ($('#wpadminbar').length) {
                            adminbar_height = $('#wpadminbar').height();
                            if ( $(window).width() < 600) {
                                adminbar_height = 0;
                            }
                            top = top + adminbar_height;
                        }
                        if ($('.mobile_sticky').length) {
                            top = $('.mobile_sticky').height();
                            if (top> 0){ top = top + 8 }
                            top = top + adminbar_height;
                        }
                        nav_tabs.css({ top: top });
                        if ($('.dej_sticky_add').length) {
                            $('.dej_sticky_add').css({top: top + 10});
                        }
                        nav_tabs_height = nav_tabs.height();
                        if ($('.dejavo_advanced_reviews .left').length) {
                            $('.dejavo_advanced_reviews .left').css({ top: top + nav_tabs_height + 12});
                        }
                    });
                    let link = $('.dejavo_product_tabs .link');
                    link.on('click', function(e) {
                        e.preventDefault();
                        var target = $($(this).attr('href'));
                        $('html, body').animate({
                            scrollTop: target.offset().top-<?= $scroll ?>
                        }, 600);
                        $(this).addClass('active');
                    });
                    $(window).on('scroll', function(){
                        dejTabs();
                    });
                    function dejTabs() {
                        var sTop = $(window).scrollTop();
                        $('section').each(function() {
                            var id = $(this).attr('id'),
                                offset = $(this).offset().top-<?= $scroll+5 ?>,
                                height = $(this).height();
                            if(sTop >= offset && sTop < offset + height) {
                                link.removeClass('active');
                                nav_tabs.find('[data-scroll="' + id + '"]').addClass('active');
                            }
                        });
                    }
                });
            </script>


            <?php
        }
        }
    }
}
