<?php
defined('ABSPATH') || exit;
class dej_ProductUpdateTime extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_product_update_time';
    }

    public function get_title()
    {
        return esc_html__('آخرین بروز رسانی', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-time-add';
    }

    public function get_categories()
    {
        return ['dejavo-single-product'];
    }
    public function has_widget_inner_wrapper(): bool {
        return false;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'format',
            [
                'label' => esc_html__( 'فرمت تاریخ', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1' => esc_html__( '1403/09/02', 'dejavo' ),
                    '2' => esc_html__( '2 آذر , 1403', 'dejavo' ),
                    '3'  => esc_html__( '2 آذر , 1403, 7:02 بعد از ظهر', 'dejavo' ),
                ],
            ]
        );

        $this->add_control(
            'w_bg',
            [
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .update_time' => 'background: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'color',
            [
                'label' => esc_html__('رنگ متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .update_time' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'bor_head_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .update_time',
            ]
        );



        $this->add_control(
            'bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .update_time, {{WRAPPER}} .zero_quantity' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .update_time' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'font_size',
            [
                'label' => esc_html__('اندازه فونت متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .update_time' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'shadow_h',
            [
                'label' => esc_html__( 'سایه ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .update_time',
            ]
        );
        


        $this->end_controls_section();

    }

    protected function render()
    {
        $data = $this->get_settings_for_display();
        $selected = $data['format'] ?? '2';
        $format = [ '1' => 'Y/m/d',  '2' => 'j F , Y',  '3' => 'j F , Y, g:i A' ];
        if (is_product()) {
        global $product;
        $date = $product->get_date_modified()->date_i18n($format[$selected]);
            echo '<span class="update_time"><i class="dej-time-add"></i>' . __('آخرین بروزرسانی :', 'dejavo') . ' ' . $date . '</span>';

        }

    }
}
