<?php defined('ABSPATH') || exit;
function dejavo_setup()
{
    remove_theme_support('wc-product-gallery-zoom');
    remove_theme_support('wc-product-gallery-lightbox');
    remove_theme_support('wc-product-gallery-slider');
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
    add_theme_support('widgets');
    add_theme_support('woocommerce');
    register_nav_menus(
        array(
            'main_menu' => __('منوی اصلی', 'dejavo'),
            'mob_menu' => __('منوی موبایل', 'dejavo'),
        )
    );
    register_sidebar(
        array(
            'name' => __('سایدبار فروشگاه', 'dejavo'),
            'id' => 'shop',
            'before_widget' => '<div id="%1$s " class="%2$s widget">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title">',
            'after_title' => '</h3>'
        )
    );
    register_sidebar(
        array(
            'name' => __('سایدبار وبلاگ', 'dejavo'),
            'id' => 'blog_sidebar',
            'before_widget' => '<div class="widget">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget_title">',
            'after_title' => '</h3>'
        )
    );
}

add_action('after_setup_theme', 'dejavo_setup');
function dejavo_assets()
{
    wp_register_style( 'dej-slider-1',  DEJ_TUI . '/assets/widget/slider-1.css', [], DEJ_VERSION);
    wp_register_style( 'dej-amazing-offer',  DEJ_TUI . '/assets/widget/amazing-offer.css', [], DEJ_VERSION);
    wp_register_style('dej-story', DEJ_TUI . '/assets/widget/story/story.css', [],DEJ_VERSION);
    wp_register_script('dej-story', DEJ_TUI . '/assets/widget/story/story.js', ['jquery', 'dej-swiper' ], DEJ_VERSION, true);
    if (! class_exists('DejavoQV') and (dej_woo_activated() and is_product()) ) {
        wp_dequeue_style('woocommerce_fancybox_styles');
        wp_dequeue_script('fancybox');
        wp_dequeue_script('zoom');
        wp_enqueue_script( 'dej-slick', DEJ_LIB . 'slick/slick.min.js', [ 'jquery' ], DEJ_VERSION );
        wp_enqueue_style('fancybox', DEJ_LIB . 'fancybox/jquery.fancybox.min.css');
        wp_enqueue_script('fancybox', DEJ_LIB . 'fancybox/jquery.fancybox.min.js', ['jquery'], DEJ_VERSION, true);
        wp_enqueue_script('zoom', DEJ_LIB . 'zoom/jquery.zoom.min.js', ['jquery'], DEJ_VERSION, true);
    }
    wp_dequeue_style('e-animations');
    wp_enqueue_style('dej-animations', DEJ_LIB . 'animations.min.css');
    wp_enqueue_style('dejavo-icons', DEJ_CSS . 'icons.min.css');
    wp_dequeue_script('swiper');
    wp_deregister_script('swiper');
    wp_dequeue_style('swiper');
    wp_dequeue_style('e-swiper');
    wp_deregister_style('swiper');
    wp_register_style('dej-swiper', DEJ_LIB . 'swiper/swiper-bundle.min.css', [], '9.0.5');
    wp_enqueue_style('dej-swiper');
    wp_enqueue_style('dejavo-style', DEJ_CSS . 'style.min.css', [], DEJ_VERSION);
    if (!is_front_page()) {
        wp_enqueue_style('dejavo-woo', DEJ_CSS . 'woo.min.css', [], DEJ_VERSION);
    }
    if (dej_is_mobile()) {
        wp_enqueue_style('dejavo-mobile', DEJ_CSS . 'mobile.css');
    }
    wp_enqueue_style('dejavo-main', DEJ_TUI . '/style.css');
    wp_register_script('dej-swiper', DEJ_LIB . 'swiper/swiper-bundle.min.js', array('jquery'), '9.0.5');
    wp_enqueue_script('dej-swiper');
    wp_enqueue_script('countdown', DEJ_JS . 'jquery.countdown.min.js', array('jquery'), '2.2', true);
    wp_enqueue_script('magnific-popup', DEJ_LIB . 'magnific-popup/jquery.magnific-popup.min.js', array('jquery'), '1.1');
    wp_enqueue_script('magnify', DEJ_JS . 'jquery.magnify.js', array('jquery'), '1', true);
    wp_enqueue_script('Dejavo-Theme', DEJ_JS . 'dejavo.js', array('jquery'), DEJ_VERSION, true);
    wp_localize_script('Dejavo-Theme', 'Dejavo_vars', array(
            'home_url' => home_url(),
            'countdown_d' => __('روز', 'dejavo'),
            'countdown_h' => __('ساعت', 'dejavo'),
            'countdown_m' => __('دقیقه', 'dejavo'),
            'countdown_s' => __('ثانیه', 'dejavo'),
            'shorter_txt' => __('کوتاه کردن', 'dejavo'),
            'see_more' => __('دیدن ادامه', 'dejavo'),
            'max_txt' => __('حداکثر :', 'dejavo'),
            'sending' => __('در حال ارسال ..', 'dejavo'),
            'removing' => __('در حال حذف ..', 'dejavo'),
            'save_p' => __( 'ذخیره گذرواژاه', 'dejavo' ),
            'save_set' => __( 'ذخیره تغییرات', 'dejavo' ),
            'order_track' => __( 'پیگیری سفارش', 'dejavo' ),
        )
    );
    if (class_exists('DejavoVS') ) {
        wp_enqueue_script('wc-add-to-cart-variation');
    }
    if ((dej_woo_activated()) and ( !is_front_page())) {
        wp_enqueue_script('dej-woo', DEJ_JS . 'woo.js', array('jquery'), DEJ_VERSION, true);
    }
    if (dej_woo_activated() and !is_front_page() and ( is_account_page() || is_edit_account_page() || is_page(dej_opt( 'dej_ticket_page' )))) {
        wp_enqueue_style('dej-profile', DEJ_CSS . 'profile.css',[], DEJ_VERSION);
        wp_enqueue_script('dej-profile', DEJ_JS . 'profile.js', array('jquery'), DEJ_VERSION, true);
        if ((is_user_logged_in() || is_user_admin()) and dej_opt('dej_ticket', 1)) {
            wp_register_style('dejst-styles', DEJST_URL . 'asset/css/styles.css', null, DEJ_VERSION);
            wp_enqueue_style('dejst-styles');
            wp_register_script('dejst-scripts', DEJST_URL . 'asset/js/scripts.js', array('jquery'), DEJ_VERSION, true);
            wp_enqueue_script('dejst-scripts');
            wp_localize_script('dejst-scripts', 'dejst_data', array('ajax_url' => admin_url('admin-ajax.php')));
        }
    }
    if (dej_woo_activated() and is_checkout() and dej_opt('dej_show_checkout_map', 1)) {
        wp_enqueue_style('leaflet', DEJ_TUI . '/assets/checkout/leaflet.css');
        wp_enqueue_script('leaflet', DEJ_TUI . '/assets/checkout/leaflet.js', array('jquery'), DEJ_VERSION, true);
        wp_enqueue_script('dej-checkout', DEJ_TUI . '/assets/checkout/checkout.js', array('jquery'), DEJ_VERSION, true);
    }

    wp_dequeue_script('photoswipe-ui-default');
    wp_dequeue_script('photoswipe');
    wp_dequeue_style('photoswipe');
    wp_dequeue_style('photoswipe-default-skin');
    wp_dequeue_style('woocommerce_frontend_styles');
    wp_dequeue_style('woocommerce_chosen_styles');
    wp_dequeue_style('woocommerce_prettyPhoto_css');
    wp_dequeue_script('prettyPhoto-init');
    wp_dequeue_style('global-styles');


    if (dej_woo_activated()) {
        wp_enqueue_script('woocommerce-ajax-add-to-cart', DEJ_JS . 'ajax-add-to-cart.js', [
            'jquery',
            'wc-add-to-cart'
        ], DEJ_VERSION, true );
        wp_localize_script( 'woocommerce-ajax-add-to-cart', 'dejaa_vars', [
                'ajax_url'                => admin_url( 'admin-ajax.php' ),
                'nonce'                   => wp_create_nonce( 'dej-security' ),
                'product_types'           => implode( ',',  [ 'simple', 'variable' ]  ),
                'wc_ajax_url'             => WC_AJAX::get_endpoint( '%%endpoint%%' ),
                'cart_url'                => apply_filters( 'woocommerce_add_to_cart_redirect', wc_get_cart_url(), null ),
                'cart_redirect_after_add' => get_option( 'woocommerce_cart_redirect_after_add' ),
            ]
        );
    }
    if (dej_opt('dej_auth', '1') == '1' and !is_user_logged_in() ) {
        wp_enqueue_script('dejavo-auth', DEJ_JS . 'auth.js', array('jquery'), null, true);
        wp_localize_script('dejavo-auth', 'Dej_Auth', [
                'home_url' => home_url(),
                'send_again' => __('ارسال مجدد کد تایید', 'dejavo'),
                'sending' => __('در حال ارسال ..', 'dejavo'),
                'sent' => __('کد تایید مجددا ارسال شد', 'dejavo'),
                'confirm' => __('تایید کد', 'dejavo'),
                'login' => __('ورود', 'dejavo'),
            ]
        );
    }
}
add_action('wp_enqueue_scripts', 'dejavo_assets');

function dej_dequeue_styles( $enqueue_styles ) {
    unset( $enqueue_styles['woocommerce-general'] );
    unset( $enqueue_styles['woocommerce-layout'] );
    unset( $enqueue_styles['woocommerce-smallscreen'] );
    return $enqueue_styles;
}
add_filter( 'woocommerce_enqueue_styles', 'dej_dequeue_styles' );
require DEJ_INC . 'style.php';
function dejavo_dashboard_style()
{
    wp_enqueue_style('dejavo-dashboard-icons', DEJ_CSS . 'icons.min.css');
    wp_enqueue_style('dejavo-dashboard-style', DEJ_CSS . 'admin.css');
}

add_action('admin_enqueue_scripts', 'dejavo_dashboard_style');

function dej_override_dokan_scripts() {
    if (class_exists('WeDevs_Dokan')) {
        if (is_front_page()) {
            wp_dequeue_script('dokan-modal');
            wp_dequeue_style('dokan-modal');
        }

        wp_dequeue_script('dokan-popup');
        wp_dequeue_style('dokan-magnific-popup');
        wp_dequeue_style('dokan-fontawesome');
        wp_dequeue_style('dokan-rtl-style');
        if (!is_front_page()) {
            wp_enqueue_style('dejavo-dokan', DEJ_CSS . 'dokan.min.css');
        }
    }
}

if (class_exists('WeDevs_Dokan')) {
    function copy_dej_tr_dok(){
        $new_dir = WP_CONTENT_DIR . '/languages/plugins/';
        copy(DEJ_PATH . '/languages/dokan-lite-fa_IR.po', $new_dir . 'dokan-lite-fa_IR.po');
        copy(DEJ_PATH . '/languages/dokan-lite-fa_IR.mo', $new_dir . 'dokan-lite-fa_IR.mo');
        copy(DEJ_PATH . '/languages/dokan-lite-fa_IR.l10n.php', $new_dir . 'dokan-lite-fa_IR.l10n.php');
    }
    add_action( 'wp_ajax_dokan_save_settings', 'copy_dej_tr_dok' );
    add_action('dokan_enqueue_scripts', 'dej_override_dokan_scripts');
    add_filter('woocommerce_is_purchasable', function() { return true; }, 10, 2 );
}


if (!dej_purchasable()) {
    add_filter('woocommerce_is_purchasable', function() { return false; }, 10, 2 );
    remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart');
    add_filter('woocommerce_is_purchasable', '__return_false');
    remove_action('woocommerce_single_variation', 'woocommerce_single_variation_add_to_cart_button', 20);
    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
}
function disable_emojicons_tinymce($plugins)
{
    if (is_array($plugins)) {
        return array_diff($plugins, array('wpemoji'));
    } else {
        return array();
    }
}
function disable_wp_emojicons()
{
    remove_action('admin_print_styles', 'print_emoji_styles');
    remove_action('wp_head', 'print_emoji_detection_script', 7);
    remove_action('admin_print_scripts', 'print_emoji_detection_script');
    remove_action('wp_print_styles', 'print_emoji_styles');
    remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
    remove_filter('the_content_feed', 'wp_staticize_emoji');
    remove_filter('comment_text_rss', 'wp_staticize_emoji');
    add_filter('tiny_mce_plugins', 'disable_emojicons_tinymce');

}
if (!dej_opt('dej_show_wp_emoji', 0)) {
    add_action('init', 'disable_wp_emojicons');
}

if (!dej_opt('dej_show_wp_block', 0)) {
    function disable_woocommerce_block_editor_styles() {
        wp_deregister_style( 'wc-block-editor' );
        wp_dequeue_style( 'wc-block-editor' );
        wp_deregister_style( 'wc-blocks-style' );
        wp_dequeue_style( 'wc-blocks-style' );

    }
    add_filter('use_block_editor_for_post', '__return_false');
    add_filter('use_widgets_block_editor', '__return_false');
    add_filter('gutenberg_use_widgets_block_editor', '__return_false');
    add_action( 'enqueue_block_assets', 'disable_woocommerce_block_editor_styles', 1, 1 );
}

if (is_admin()) {

    function dej_admin_menu()
    {

        add_submenu_page('themes.php', esc_html__('مگامنو المنتوری', 'dejavo'), esc_html__('مگامنو المنتوری', 'dejavo'), 'manage_options', 'edit.php?post_type=dejavo_mega_menus');
        add_menu_page(
            esc_html__('امکانات قالب', 'dejavo'),
            esc_html__('امکانات قالب', 'dejavo'),
            'manage_options',
            'future',
            'dej_admin_menu_content',
            'dashicons-admin-generic',
            '200'
        );
    }

    function dej_admin_menu_content()
    {
        echo '<br />';
        esc_html_e('جهت غیرفعال سازی/ فعالسازی امکانات به تنظیمات قالب >> امکانات مراجعه کنید', 'dejavo');
    }

    add_action('admin_menu', 'dej_admin_menu');


    add_filter('manage_users_columns', 'dej_users_columns');
    function dej_users_columns($cols)
    {
        $cols['phone'] = __('تلفن', 'dejavo');
        return $cols;
    }

    add_filter('manage_users_custom_column', 'dej_users_columns_data', 10, 3);
    function dej_users_columns_data($output, $column_name, $user_id)
    {
        if ($column_name == 'phone') {
            $output = get_user_meta($user_id, 'billing_phone', true);
            if (!$output) {
                $output = '-';
            }
        }
        return $output;
    }

    add_action('csf_dej_options_saved', 'dej_add_to_csf');

    function dej_add_to_csf()
    {
        if (dej_opt('rebuild', 1)) {
            $cart_id = get_option('woocommerce_cart_page_id');
            $checkout_id = get_option('woocommerce_checkout_page_id');
            if ($cart_id) {
                $cart = array(
                    'ID' => $cart_id,
                    'post_content' => '[woocommerce_cart]',
                );
                wp_update_post($cart);
                delete_post_meta($cart_id, '_elementor_edit_mode');
            }
            if ($checkout_id) {
                $checkout = array(
                    'ID' => $checkout_id,
                    'post_content' => '[woocommerce_checkout]',
                );
                wp_update_post($checkout);
                delete_post_meta($checkout_id, '_elementor_edit_mode');
            }
        }
        if (!dej_opt('show_stock', 1)) {
            update_option('woocommerce_stock_format', 'no_amount');
        } else {
            update_option('woocommerce_stock_format', '');
        }
        if (dej_opt('dej_enable_review_rating', 1)) {
            update_option('woocommerce_enable_review_rating', 'yes');
        } else {
            update_option('woocommerce_enable_review_rating', 'no');
        }

        if (dej_opt('add_dej_opt_to_el', 1)) {
            $el_kit_id = get_option('elementor_active_kit');
            $new_el_data = maybe_unserialize(get_post_meta($el_kit_id, '_elementor_page_settings', true));
            $new_el_data['container_width']['size'] = dej_opt('dej_max_width_wrapper', 1320);
            $new_el_data['system_colors'][0]['color'] = dej_opt('dej_main_color', '#f11b1b');
            $new_el_data['system_colors'][1]['color'] = dej_opt('dej_second_color', '#1d3557');
            $new_el_data['custom_colors'][0]['color'] = dej_opt('dej_main_bg')['background-gradient-color'] ?? '#de0000';
            $new_el_data['custom_colors'][1]['color'] = dej_opt('dej_second_bg')['background-gradient-color'] ?? '#0a264f';
            $new_el_data['custom_colors'][2]['color'] = dej_opt('dej_main_bg')['background-color'] ?? '#fc3f3f';
            $new_el_data['custom_colors'][3]['color'] = dej_opt('dej_second_bg')['background-color'] ?? '#2b5fa9';
            update_post_meta($el_kit_id, '_elementor_page_settings', $new_el_data);

            if (did_action('elementor/loaded')) {
                $new = \Elementor\Plugin::instance()->files_manager;
                if ($new) {
                    $new->clear_cache();
                }
            }
        }

        if (dej_opt('dej_reg', 1)) {
            update_option('users_can_register', 1);
            update_option('default_role', 'customer');
            update_option('woocommerce_enable_myaccount_registration', 'yes');
            update_option('woocommerce_enable_signup_and_login_from_checkout', 'no');
        } else {
            update_option('users_can_register', 0);
            update_option('woocommerce_enable_myaccount_registration', 'no');
        }
        if (dej_opt('dej_auth_top_checkout', 1)) {
            update_option('woocommerce_enable_checkout_login_reminder', 'yes');
        } else {
            update_option('woocommerce_enable_checkout_login_reminder', 'no');
        }

        flush_rewrite_rules();
        wp_cache_flush();
    }

    add_action('admin_init', function () {
        remove_submenu_page('tools.php', 'csf-welcome');
        $woo_brand = get_option('woocommerce_brand_permalink');
        if ($woo_brand == 'brand' || !$woo_brand) {
            update_option('woocommerce_brand_permalink', 'brands');
        }
    });

    require DEJ_INC . 'tgm/plugin.php';
}


