<?php defined('ABSPATH') || exit;
if (is_front_page()) {
    return;
}
// ---- آرشیو محصولات -----//
if (dej_opt('dej_loop_shop_per_page', 0)) {
    add_filter('loop_shop_per_page', function () {
        return dej_opt('dej_loop_shop_per_page', 20);
    }, 20);
}
remove_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices');
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

// ----- آرشیو محصولات ------//

// ----- فبلترها -------//
function dejavo_shop_page_url($keep_query = false, $taxonomy = '')
{
    $url = '';
    if (class_exists('Automattic\Jetpack\Constants') && Automattic\Jetpack\Constants::is_defined('SHOP_IS_ON_FRONT')) {
        $url = home_url();
    } elseif (is_post_type_archive('product') || is_page(wc_get_page_id('shop')) || is_shop()) {
        $url = get_permalink(wc_get_page_id('shop'));
    } elseif (is_product_category()) {
        $url = get_term_link(get_query_var('product_cat'), 'product_cat');
    } elseif (is_product_tag()) {
        $url = get_term_link(get_query_var('product_tag'), 'product_tag');
    } elseif (get_queried_object()) {
        $query = get_queried_object();
        if (property_exists($query, 'taxonomy')) {
            $url = get_term_link($query->slug, $query->taxonomy);
        }
    }
    if ($keep_query) {
        if (isset($_GET['min_price'])) {
            $url = add_query_arg('min_price', wc_clean($_GET['min_price']), $url);
        }

        if (isset($_GET['max_price'])) {
            $url = add_query_arg('max_price', wc_clean($_GET['max_price']), $url);
        }

        if (isset($_GET['orderby'])) {
            $url = add_query_arg('orderby', wc_clean($_GET['orderby']), $url);
        }

        if (isset($_GET['stock_status'])) {
            $url = add_query_arg('stock_status', wc_clean($_GET['stock_status']), $url);
        }

        if (isset($_GET['br_filter'])) {
            $url = add_query_arg('br_filter', wc_clean($_GET['br_filter']), $url);
        }
        if (isset($_GET['clr_filter'])) {
            $url = add_query_arg('clr_filter', wc_clean($_GET['clr_filter']), $url);
        }

        if (isset($_GET['filter_cat'])) {
            $url = add_query_arg('filter_cat', wc_clean($_GET['filter_cat']), $url);
        }
        if (isset($_GET['per_row'])) {
            $url = add_query_arg('per_row', wc_clean($_GET['per_row']), $url);
        }
        if (isset($_GET['per_page'])) {
            $url = add_query_arg('per_page', wc_clean($_GET['per_page']), $url);
        }

        if (isset($_GET['shop_view'])) {
            $url = add_query_arg('shop_view', wc_clean($_GET['shop_view']), $url);
        }

        if (isset($_GET['shortcode'])) {
            $url = add_query_arg('shortcode', wc_clean($_GET['shortcode']), $url);
        }

        if (get_search_query()) {
            $url = add_query_arg('s', rawurlencode(wp_specialchars_decode(get_search_query())), $url);
        }

        if (isset($_GET['post_type'])) {
            $url = add_query_arg('post_type', wc_clean(wp_unslash($_GET['post_type'])), $url);

            if ( is_shop()) {
                $url = remove_query_arg('page_id', $url);
            }
        }

        if (isset($_GET['min_rating'])) {
            $url = add_query_arg('min_rating', wc_clean($_GET['min_rating']), $url);
        }

        if ($_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes()) {
            foreach ($_chosen_attributes as $name => $data) {
                if ($name === $taxonomy) {
                    continue;
                }
                $filter_name = sanitize_title(str_replace('pa_', '', $name));
                if (!empty($data['terms'])) {
                    $url = add_query_arg('filter_' . $filter_name, implode(',', $data['terms']), $url);
                }
                if ('or' == $data['query_type']) {
                    $url = add_query_arg('query_type_' . $filter_name, 'or', $url);
                }
            }
        }
    }

    $url = apply_filters('dejavo_shop_page_url', $url, $keep_query, $taxonomy);

    if (is_string($url)) {
        return $url;
    } else {
        return '';
    }
}

function dejavo_shop_filter_query($q)
{
    if ((is_woocommerce() && is_archive()) || is_shop()) {
        $current_stock_status = isset($_GET['stock_status']) ? explode(',', $_GET['stock_status']) : array();
        $filter_brand = isset($_GET['br_filter']) ? explode(',', $_GET['br_filter']) : array();
        $filter_color = isset($_GET['clr_filter']) ? explode(',', $_GET['clr_filter']) : array();
        $search_cat = isset($_GET['search-cats']) ? explode(',', $_GET['search-cats']) : array();
        $product_cat = isset($_GET['filter_cat']) ? explode(',', $_GET['filter_cat']) : array();
        $brand_opt = dej_opt('dej_brand_slug', 'brand');
        $brand = 'pa_' . $brand_opt;

        if (!empty($filter_brand)) {
            $brand_tax_query = array(
                'relation' => 'AND',
                array(
                    'taxonomy' => $brand,
                    'field' => 'term_id',
                    'terms' => $filter_brand,
                )
            );
            $q->set('tax_query', $brand_tax_query);
        }

        $color_opt = dej_opt('dej_color_slug', 'color');
        $color = 'pa_' . $color_opt;

        if (!empty($filter_color)) {
            $color_tax_query = array(
                'relation' => 'AND',
                array(
                    'taxonomy' => $color,
                    'field' => 'term_id',
                    'terms' => $filter_color,
                )
            );
            $q->set('tax_query', $color_tax_query);
        }


        if (in_array('onsale', $current_stock_status)) {
            $product_ids_on_sale = wc_get_product_ids_on_sale();
            $q->set('post__in', $product_ids_on_sale);
        }


        if (in_array('instock', $current_stock_status)) {
            $query_array = array(
                'relation' => 'AND',
                array(
                    'key' => '_stock_status',
                    'value' => 'instock',
                    'compare' => '=',
                )
            );
            $q->set('meta_query', $query_array);
        }

        if (!empty($search_cat) and $search_cat[0] !== '0') {
            $searc_tax_query = array(
                'relation' => 'AND',
                array(
                    'taxonomy' => 'product_cat',
                    'field' => 'id',
                    'terms' => $search_cat,
                )
            );
            $q->set('tax_query', $searc_tax_query);
        }


        if (!empty($product_cat)) {
            $cat_tax_query = array(
                'relation' => 'AND',
                array(
                    'taxonomy' => 'product_cat',
                    'field' => 'term_id',
                    'terms' => $product_cat,
                )
            );
            $q->set('tax_query', $cat_tax_query);
        }

    }
}

add_action('woocommerce_product_query', 'dejavo_shop_filter_query');
function dejavo_widget_get_current_page_url($url)
{
    if (isset($_GET['stock_status'])) {
        $url = add_query_arg('stock_status', wc_clean($_GET['stock_status']), $url);
    }

    if (isset($_GET['br_filter'])) {
        $url = add_query_arg('br_filter', wc_clean($_GET['br_filter']), $url);
    }
    if (isset($_GET['clr_filter'])) {
        $url = add_query_arg('clr_filter', wc_clean($_GET['clr_filter']), $url);
    }

    if (isset($_GET['filter_cat'])) {
        $url = add_query_arg('filter_cat', wc_clean($_GET['filter_cat']), $url);
    }
    return $url;
}

add_filter('woocommerce_widget_get_current_page_url', 'dejavo_widget_get_current_page_url');
function dejavo_current_products_query($taxonomy)
{

    $args = array(
        'posts_per_page' => -1,
        'post_type' => 'product',
        'tax_query' => array(
            array(
                'taxonomy' => $taxonomy,
                'operator' => 'EXISTS',
            ),
        ),
        'fields' => 'ids',
    );

    $cat = get_queried_object();
    if (is_a($cat, 'WP_Term')) {
        $cat_id = $cat->term_id;
        $cat_id_array = get_term_children($cat_id, $cat->taxonomy);
        $cat_id_array[] = $cat_id;
        $args['tax_query'][] = array(
            'taxonomy' => $cat->taxonomy,
            'field' => 'term_id',
            'terms' => $cat_id_array,
        );
    }

    $wp_query = new WP_Query($args);
    wp_reset_postdata();
    return $wp_query->posts;
}

function dejavo_get_products_attr($product_ids, $taxonomy)
{
    $product_ids = implode(',', array_map('intval', $product_ids));
    if (!empty($product_ids)) {
        global $wpdb;
        $attr_ids = $wpdb->get_col(
            "SELECT DISTINCT t.term_id
               FROM {$wpdb->prefix}terms AS t
               INNER JOIN {$wpdb->prefix}term_taxonomy AS tt
               ON t.term_id = tt.term_id
               INNER JOIN {$wpdb->prefix}term_relationships AS tr
               ON tr.term_taxonomy_id = tt.term_taxonomy_id
               WHERE tt.taxonomy = '$taxonomy'
               AND tr.object_id IN ($product_ids)
            "
        );
    }
    return !empty($attr_ids) ? $attr_ids : false;
}

function dejavo_get_filter_url($query_arg_key, $values)
{
    $base_url = dejavo_shop_page_url(true);
    $url = remove_query_arg($query_arg_key, $base_url);
    $current_filter = isset($_GET[$query_arg_key]) ? explode(',', $_GET[$query_arg_key]) : array();
    $option_is_set = in_array($values, $current_filter);

    if (!in_array($values, $current_filter)) {
        $current_filter[] = $values;
    }

    foreach ($current_filter as $key => $value) {
        if ($option_is_set && $value == $values) {
            unset($current_filter[$key]);
        }
    }

    if ($current_filter) {
        asort($current_filter);
        $url = add_query_arg($query_arg_key, implode(',', $current_filter), $url);
    }

    return str_replace('%2C', ',', $url);
}

if (dej_opt('order_stock', 1)) {
    function dej_order_by_stock($posts_clauses)
    {
        global $wpdb;
        if (is_woocommerce() && (is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy())) {
            $posts_clauses['join'] .= " INNER JOIN $wpdb->postmeta istockstatus ON ($wpdb->posts.ID = istockstatus.post_id) ";
            $posts_clauses['orderby'] = " istockstatus.meta_value ASC, " . $posts_clauses['orderby'];
            $posts_clauses['where'] = " AND istockstatus.meta_key = '_stock_status' AND istockstatus.meta_value <> '' " . $posts_clauses['where'];
        }
        return $posts_clauses;
    }

    add_filter('posts_clauses', 'dej_order_by_stock', 200);
}


// ----- فبلترها ------//