<?php
defined('ABSPATH') || exit;
CSF::createOptions($prefix, array(
    'menu_title' => esc_html__('تنظیمات قالب', 'dejavo'),
    'menu_slug' => 'dejavo_options',
    'icon' => 'dej-settings',
    'framework_title' => esc_html__('تنظیمات قالب', 'dejavo'),
    'show_footer' => true,
    'save_defaults' => true,
    'footer_credit' => "<a href='https://www.rtl-theme.com/dashboard/#/downloads'>" . __('لطفا به قالب در پنل راستچین امتیاز بدهید', 'dejavo') . "</a>",
    'footer_text' => '',
));
// تنظیمات اصلی
//
CSF::createSection($prefix, array(
    'id' => 'dej_main_setting',
    'title' => __('تنظیمات اصلی', 'dejavo'),
    'icon' => 'dej-settings',
));

// لوگو و فاو آیکن
//
CSF::createSection($prefix, array(
    'parent' => 'dej_main_setting',
    'title' => __('لوگو و فاو آیکن', 'dejavo'),
    'icon' => 'dej-picture',
    'description' => '',
    'fields' => array(
        array(
            'id' => 'dej_main_logo',
            'type' => 'upload',
            'preview' => true,
            'title' => __('آپلود تصویر لوگو', 'dejavo'),
            'desc' => __('راهنما : عکس با فرمت png بدون پس زمینه با ارتفاع کمتر از 120 پیکسل باشد', 'dejavo'),
            'library' => 'image',
            'button_title' => __('آپلود', 'dejavo'),
        ),

        array(
            'id' => 'dej_main_mob_logo',
            'type' => 'upload',
            'preview' => true,
            'title' => __('آپلود تصویر لوگو ویژه موبایل (غیر ضروری)', 'dejavo'),
            'library' => 'image',
            'button_title' => __('آپلود', 'dejavo'),
        ),

        array(
            'id' => 'dej_favicon',
            'type' => 'upload',
            'preview' => true,
            'title' => __('آپلود فاو آیکن', 'dejavo'),
            'desc' => __('راهنما : عکس با ابعاد مربعی بدون پس زمینه', 'dejavo'),
            'library' => 'image',
            'button_title' => __('آپلود', 'dejavo'),
        ),

        array(
            'id' => 'logo_anime',
            'type' => 'switcher',
            'title' => __('انیمیشن درخشش لوگو ؟', 'dejavo'),
            'default' => true,
            'text_width' => 90,
        ),



    )
));

// عرض سایت
//
CSF::createSection($prefix, array(
    'parent' => 'dej_main_setting',
    'title' => __('عرض سایت', 'dejavo'),
    'icon' => 'dej-arrows-alt-h',
    'fields' => array(

        array(
            'id' => 'dej_max_width_wrapper',
            'type' => 'slider',
            'title' => __('حداکثر عرض', 'dejavo'),
            'subtitle' => 'Min:1024 | Max:1600 | Step:2 | Default:1320',
            'unit' => 'px',
            'min' => 1024,
            'max' => 1600,
            'step' => 2,
            'default' => 1320,
        ),


    )
));


// المنتور
//
CSF::createSection($prefix, array(
    'parent' => 'dej_main_setting',
    'title' => __('المنتور', 'dejavo'),
    'icon' => ' dejbrand-elementor',
    'fields' => array(
        array(
            'id' => 'add_dej_opt_to_el',
            'type' => 'switcher',
            'title' => __('اعمال تنظیمات عرض و رنگ ها در تنظیمات سایت المنتور ؟', 'dejavo'),
            'default' => true,
            'text_width' => 90,
        ),

    )
));

// رنگ بندی
//
CSF::createSection($prefix, array(
    'id' => 'dej_colors',
    'title' => __('رنگ بندی', 'dejavo'),
    'icon' => 'dej-palette',
));

// رنگ ها
//
CSF::createSection($prefix, array(
    'parent' => 'dej_colors',
    'title' => __('رنگ بندی', 'dejavo'),
    'fields' => array(

        array(
            'id' => 'dej_main_color',
            'type' => 'color',
            'title' => __('رنگ اصلی', 'dejavo'),
            'default' => '#f11b1b',
            'output' => array('--dej-color1' => ':root'),
            'output_important' => true,

        ),
        array(
            'id' => 'dej_second_color',
            'type' => 'color',
            'title' => __('رنگ فرعی', 'dejavo'),
            'default' => '#1d3557',
            'output' => array('--dej-color2' => ':root'),
            'output_important' => true,

        ),

        array(
            'id' => 'dej_main_bg',
            'type' => 'background',
            'title' => __('رنگ گرادیانتی اصلی', 'dejavo'),
            'background_image' => false,
            'background_gradient' => true,
            'default' => array(
                'background-color' => '#fc3f3f',
                'background-gradient-color' => '#de0000',
                'background-gradient-direction' => '315deg',
            ),
        ),

        array(
            'id' => 'dej_second_bg',
            'type' => 'background',
            'title' => __('رنگ گرادیانتی فرعی', 'dejavo'),
            'background_image' => false,
            'background_gradient' => true,
            'default' => array(
                'background-color' => '#2b5fa9',
                'background-gradient-color' => '#0a264f',
                'background-gradient-direction' => '315deg',
            ),
        ),

        array(
            'id' => 'dej_fix_cart_bg',
            'type' => 'color',
            'title' => __('رنگ پس زمینه دکمه ثابت سبد خرید', 'dejavo'),
            'output' => '.DejavoFC-count',
            'output_mode' => 'background-color'
        ),
        array(
            'id' => 'dej_fix_cart_i',
            'type' => 'color',
            'title' => __('رنگ آیکن دکمه ثابت سبد خرید', 'dejavo'),
            'output' => '.DejavoFC-count i',
            'output_mode' => 'color'
        ),
        array(
            'id' => 'dej_back_to_top_bg',
            'type' => 'color',
            'title' => __('رنگ پس زمینه دکمه ثابت بازگشت به بالا', 'dejavo'),
            'output' => '.BackToTop',
            'output_mode' => 'background-color'
        ),
        array(
            'id' => 'dej_back_to_top_i',
            'type' => 'color',
            'title' => __('رنگ آیکن دکمه ثابت بازگشت به بالا', 'dejavo'),
            'output' => '.BackToTop i',
            'output_mode' => 'color'
        ),

        array(
            'id' => 'dej_pop_login_bg',
            'type' => 'color',
            'output_mode' => 'background-color',
            'title' => __('رنگ پس زمینه پاپ آپ ورود و عضویت', 'dejavo'),
            'output' => '.dejavo_login',
            'dependency' => array('dej_auth_style', '==', 'pop'),
            'output_important' => true,
        ),

        array(
            'id' => 'dej_pop_input_bg',
            'type' => 'color',
            'output_mode' => 'background-color',
            'title' => __('رنگ پس زمینه ورودی های فرم', 'dejavo'),
            'output' => '.dejavo_login form input',
            'dependency' => array('dej_auth_style', '==', 'pop'),
            'output_important' => true,
        ),

        array(
            'id' => 'shop_bg',
            'type' => 'color',
            'title' => __('رنگ پس زمینه سکشن های آرشیو محصولات', 'dejavo'),
            'output' => array( '.dej_shop_content', '.dej_shop_sidebar .sidebar_content > div', '.term-description' ),
            'output_mode' => 'background-color'
        ),

        array(
            'id' => 'cart_bg',
            'type' => 'color',
            'title' => __('رنگ پس زمینه سبد خرید و پرداخت', 'dejavo'),
            'output' => array( 'body.woocommerce-cart .dejavo_wrapper > .woocommerce', 'body.woocommerce-checkout .dejavo_wrapper > .woocommerce' ),
            'output_mode' => 'background-color'
        ),

    )
));

//
//  پس زمینه سایت
//
CSF::createSection($prefix, array(
    'parent' => 'dej_colors',
    'title' => __('پس زمینه سایت', 'dejavo'),
    'fields' => array(

        array(
            'id' => 'dej_body_bg',
            'type' => 'background',
            'title' => __('پس زمینه سایت', 'dejavo'),
            'background_color' => true,
            'background_image' => true,
            'background-position' => true,
            'background_repeat' => true,
            'background_attachment' => true,
            'background_size' => true,
            'background_origin' => true,
            'background_clip' => true,
            'background_blend_mode' => true,
            'background_gradient' => true,
            'default' => array(
                'background-color' => '#f3f3f3',
                'background-gradient-direction' => '135deg',
                'background-position' => 'center center',
                'background-repeat' => 'repeat-x',
                'background-size' => 'cover',
                'background-origin' => 'border-box',
                'background-clip' => 'padding-box',
                'background-blend-mode' => 'normal',
            ),
            'output' => 'body',
        ),


    )
));

//
//  link_color
//
CSF::createSection($prefix, array(
    'parent' => 'dej_colors',
    'title' => __('رنگ لینک و متن', 'dejavo'),
    'fields' => array(
        array(
            'id' => 'content-link-color',
            'type' => 'link_color',
            'title' => __('رنگ لینک در محتوا', 'dejavo'),
            'output' => '.post_content a, #description a, .elementor-widget-theme-post-content a',
        ),
        array(
            'id' => 'additional-link-color',
            'type' => 'link_color',
            'title' => __('رنگ لینک در جدول مشخصات', 'dejavo'),
            'output' => '#additional_information a',
        ),


        array(
            'id' => 'title-color',
            'type' => 'color',
            'title' => __('رنگ عناوین', 'dejavo'),
            'output' => array('--dej-title-color' => ':root'),
        ),
        array(
            'id' => 'text-color',
            'type' => 'color',
            'title' => __('رنگ متن بدنه', 'dejavo'),
            'output' => array('--dej-text-color1' => ':root'),
        ),
        array(
            'id' => 'text-color2',
            'type' => 'color',
            'title' => __('رنگ عناوین در متن', 'dejavo'),
            'output' => array('--dej-text-color2' => ':root'),
        ),

    )
));


//
//  رنگ حساب
//
CSF::createSection($prefix, array(
    'parent' => 'dej_colors',
    'title' => __('حساب کاربری', 'dejavo'),
    'fields' => array(

        array(
            'id' => 'user-first-color',
            'type' => 'color',
            'output_mode' => 'background-color',
            'default' => '#118ab2',
            'title' => __('رنگ اول', 'dejavo'),
            'output' => array('--dej-profile-color1' => ':root'),
        ),
        array(
            'id' => 'user-second-color',
            'type' => 'color',
            'output_mode' => 'background-color',
            'default' => '#fd6f6f',
            'title' => __('رنگ دوم', 'dejavo'),
            'output' => array('--dej-profile-color2' => ':root'),
        ),

    )
));

//
// فونت
//
CSF::createSection($prefix, array(
    'parent' => 'dej_main_setting',
    'title' => __('فونت', 'dejavo'),
    'icon' => 'dej-pencil',
    'fields' => array(

        array(
            'id' => 'dej_body_font',
            'type' => 'typography',
            'title' => __('فونت بدنه و پاراگراف', 'dejavo'),
            'placeholder' => __('انتخاب فونت', 'dejavo'),
            'default' => array(
                'font-family' => 'IranYekan',
            ),
        ),
        array(
            'id' => 'dej_heading_font',
            'type' => 'typography',
            'title' => __('فونت عناوین', 'dejavo'),
            'placeholder' => __('انتخاب فونت', 'dejavo'),
            'default' => array(
                'font-family' => 'IranSans',
            ),
        ),
    )
));

CSF::createSection($prefix, array(
    'parent' => 'dej_main_setting',
    'title' => __('خمیدگی گوشه ها', 'dejavo'),
    'icon' => 'dej-pencil',
    'fields' => array(

        array(
            'id' => 'dej_max_radius',
            'type' => 'spinner',
            'title' => __('بیشترین', 'dejavo'),
            'subtitle' => 'max:40 | min:0 | step:1',
            'max' => 50,
            'min' => 0,
            'step' => 1,
            'default' => 15,
            'output' => ['--dej-max-radius' => ':root'],
            'unit' => 'px',
        ),
        array(
            'id' => 'dej_min_radius',
            'type' => 'spinner',
            'title' => __('کمترین', 'dejavo'),
            'subtitle' => 'max:20 | min:0 | step:1',
            'max' => 20,
            'min' => 0,
            'step' => 1,
            'default' => 7,
            'output' => ['--dej-min-radius' => ':root'],
            'unit' => 'px',
        ),
    )
));

//
// سربرگ
//
CSF::createSection($prefix, array(
    'id' => 'dej_header',
    'title' => __('سربرگ', 'dejavo'),
    'icon' => ' dej-bell-ring',
    'fields' => array(
        array(
            'id' => 'active_sticky_nav',
            'type' => 'switcher',
            'title' => __('منوی چسبنده ؟', 'dejavo'),
            'default' => true,
            'text_width' => 90,
            'desc' => __('از اضافه کردن  کانتینر های خالی به سربرگ خودداری کنید', 'dejavo'),
        ),

    )
));

//
// پیام بالای سایت
//
CSF::createSection($prefix, array(
    'id' => 'top_alert',
    'title' => __('پیام بالای سایت', 'dejavo'),
    'icon' => ' dej-bell-ring',

    'fields' => array(
        array(
            'id' => 'show_top_alert',
            'type' => 'switcher',
            'title' => __('نمایش پیام ؟', 'dejavo'),
            'default' => false,
            'text_width' => 90,
        ),
        array(
            'id' => 'show_top_alert_close',
            'type' => 'switcher',
            'title' => __('نمایش دکمه بستن ؟', 'dejavo'),
            'default' => true,
            'text_width' => 90,
        ),
        array(
            'id' => 'top_alert_link',
            'type' => 'link',
            'title' => __('پیوند', 'dejavo'),
        ),
        array(
            'id' => 'top_alert_type',
            'type' => 'button_set',
            'title' => __('فرمت نمایش', 'dejavo'),
            'options' => array(
                'text' => 'متنی و دکمه',
                'image' => 'فقط عکس',
            ),
            'default' => 'text',
        ),

        array(
            'id' => 'top_alert_img_bg',
            'type' => 'upload',
            'preview' => true,
            'title' => __('تصویر دسکتاپ', 'dejavo'),
            'library' => 'image',
            'button_title' => 'آپلود',
            'dependency' => array('top_alert_type', '==', 'image'),
            'preview_size' => 'full',
            'preview_height' => 80,
            'preview_width' => 800,
        ),


        array(
            'id' => 'top_alert_mob_img_bg',
            'type' => 'upload',
            'preview' => true,
            'title' => __('تصویر ویژه موبایل', 'dejavo'),
            'library' => 'image',
            'button_title' => 'آپلود',
            'dependency' => array('top_alert_type', '==', 'image'),
            'preview_size' => 'full',
            'preview_height' => 80,
            'preview_width' => 600,
        ),

        array(
            'id' => 'top_alert_bg',
            'type' => 'background',
            'title' => __('پس زمینه', 'dejavo'),
            'background_gradient' => true,
            'dependency' => array('top_alert_type', '==', 'text'),
            'output' => '.dejavo_top_alert',
        ),


        array(
            'id' => 'top_alert_btn',
            'type' => 'text',
            'title' => __('متن دکمه', 'dejavo'),
            'dependency' => array('top_alert_type', '==', 'text'),
        ),

        array(
            'id' => 'top_alert_content',
            'type' => 'textarea',
            'title' => __('پیام', 'dejavo'),
            'dependency' => array('top_alert_type', '==', 'text'),
        ),


    )
));

//
// نوار بالا موبایل
//
CSF::createSection($prefix, array(
    'parent' => 'mobile',
    'title' => __('نوار بالا', 'dejavo'),
    'icon' => ' dej-sensor',
    'fields' => array(

        array(
            'id' => 'show_mobile_top_nav',
            'type' => 'switcher',
            'title' => __('نمایش نوار بالا موبایل ؟', 'dejavo'),
            'default' => true,
            'text_width' => 90,
        ),
        array(
            'id' => 'active_sticky_mobile_top_nav',
            'type' => 'switcher',
            'title' => __('نوار بالا چسبنده ؟', 'dejavo'),
            'default' => true,
            'text_width' => 90,
        ),
        array(
            'id' => 'dej_space_mob_top_nav',
            'type' => 'spinner',
            'title' => __('فاصله از بالا', 'dejavo'),
            'subtitle' => 'max:40 | min:0 | step:1',
            'max' => 40,
            'min' => 0,
            'step' => 1,
            'default' => 10,
            'output' => '.mobile_top_nav',
            'output_mode' => 'top',
            'unit' => 'px',
        ),


        array(
            'id' => 'dej_margin_mob_top_nav',
            'type' => 'spacing',
            'title' => __('فاصله از راست و چپ', 'dejavo'),
            'bottom' => false,
            'top' => false,
            'output' => '.mobile_top_nav',
            'output_mode' => 'margin',
            'default' => array(
                'right' => '10',
                'left' => '10',
                'unit' => 'px',
            ),

        ),

        array(
            'id' => 'dej_radius_mob_top_nav',
            'type' => 'spacing',
            'title' => __('خمیدگی گوشه ها', 'dejavo'),
            'output' => '.mobile_top_nav',
            'output_mode' => 'border-radius',
            'default' => array(
                'top' => '0',
                'right' => '15',
                'bottom' => '15',
                'left' => '15',
                'unit' => 'px',
            ),
        ),
        array(
            'id' => 'dej_bg_mob_top_nav',
            'type' => 'button_set',
            'title' => __('نوع پس زمینه', 'dejavo'),
            'multiple' => false,
            'options' => array(
                'white_bg' => 'سفید',
                'blur_bg' => 'بلر / کدر',
                'main_bg' => 'گرادیانت اصلی',
                'second_bg' => 'گرادیانت فرعی',
                'color1_bg' => 'رنگ اصلی',
                'color2_bg' => 'رنگ فرعی',
                'custom' => 'سفارشی',
            ),
            'default' => 'blur_bg',
        ),
        array(
            'id' => 'dej_custom_bg_mob_top_nav',
            'type' => 'color',
            'title' => __('رنگ سفارشی پس زمینه', 'dejavo'),
            'dependency' => array('dej_bg_mob_top_nav', '==', 'custom', '', 'visible'),
            'output' => '.mobile_top_nav',
            'output_mode' => 'background-color',
        ),


        array(
            'type' => 'subheading',
            'content' => __('آیکن سمت راست', 'dejavo'),
        ),


        array(
            'id' => 'dej_right_mob_icon',
            'type' => 'button_set',
            'title' => __('انتخاب آیکن', 'dejavo'),
            'multiple' => false,
            'options' => array(
                'empty' => 'هیچکدام',
                'menu' => 'فهرست',
                'search' => 'جست و جو',
                'user' => 'حساب کاربری',
                'cart' => 'سبد خرید',
                'wishlist' => 'علاقه مندی',
                'compare' => 'مقایسه',
            ),
            'dependency' => array('show_custom_right_mob_icon', '==', false, '', 'visible'),
            'default' => 'menu',
        ),

        array(
            'id' => 'show_custom_right_mob_icon',
            'type' => 'switcher',
            'title' => __('آیکن سفارشی ؟', 'dejavo'),
            'default' => false,
            'text_width' => 90,
        ),

        array(
            'id' => 'dej_custom_right_mob_icon',
            'type' => 'icon',
            'dependency' => array('show_custom_right_mob_icon', '==', true, '', 'visible'),
            'title' => __('آیکن سفارشی', 'dejavo'),
        ),

        array(
            'id' => 'dej_custom_right_mob_link',
            'type' => 'link',
            'title' => __('لینک', 'dejavo'),
            'dependency' => array('show_custom_right_mob_icon', '==', true, '', 'visible'),
        ),


        array(
            'id' => 'dej_color_right_mob_icon',
            'type' => 'link_color',
            'title' => __('رنگ سفارشی', 'dejavo'),
            'color' => true,
            'hover' => true,
            'output' => '.mobile_top_nav .right_icon a'
        ),


        array(
            'type' => 'subheading',
            'content' => __('آیکن سمت چپ', 'dejavo'),
        ),


        array(
            'id' => 'dej_left_mob_icon',
            'type' => 'button_set',
            'title' => __('انتخاب آیکن', 'dejavo'),
            'multiple' => false,
            'options' => array(
                'empty' => 'هیچکدام',
                'menu' => 'فهرست',
                'search' => 'جست و جو',
                'user' => 'حساب کاربری',
                'cart' => 'سبد خرید',
                'wishlist' => 'علاقه مندی',
                'compare' => 'مقایسه',
            ),

            'dependency' => array('show_custom_left_mob_icon', '==', false, '', 'visible'),
        ),

        array(
            'id' => 'show_custom_left_mob_icon',
            'type' => 'switcher',
            'title' => __('آیکن سفارشی ؟', 'dejavo'),
            'default' => true,
            'text_width' => 90,
        ),

        array(
            'id' => 'dej_custom_left_mob_icon',
            'type' => 'icon',
            'dependency' => array('show_custom_left_mob_icon', '==', true, '', 'visible'),
            'title' => __('آیکن سفارشی', 'dejavo'),
            'default' => 'dej-phone-call',
        ),
        array(
            'id' => 'dej_custom_left_mob_link',
            'type' => 'link',
            'title' => __('لینک', 'dejavo'),
            'dependency' => array('show_custom_left_mob_icon', '==', true, '', 'visible'),
            'default' => array('url' => 'tel:09120000000'),
        ),

        array(
            'id' => 'dej_color_left_mob_icon',
            'type' => 'link_color',
            'title' => __('رنگ سفارشی', 'dejavo'),
            'color' => true,
            'hover' => true,
            'output' => '.mobile_top_nav .left_icon a'
        ),


    )
));
//
// نوار پایین موبایل
//
CSF::createSection($prefix, array(
    'parent' => 'mobile',
    'title' => __('نوار پایین', 'dejavo'),
    'icon' => ' dej-sensor',
    'fields' => array(

        array(
            'id' => 'show_mobile_bottom_nav',
            'type' => 'switcher',
            'title' => __('نمایش نوار پایین چسبنده موبایل ؟', 'dejavo'),
            'default' => true,
            'text_width' => 90,
        ),

        array(
            'id' => 'show_mobile_bottom_nav_counter',
            'type' => 'switcher',
            'title' => __('نمایش شمارنده تعداد ؟', 'dejavo'),
            'default' => true,
            'text_width' => 90,
        ),
        array(
            'id' => 'show_add_to_cart_instead_nav',
            'type' => 'switcher',
            'title' => __('نمایش افزودن به سبد خرید شناور در صفحه محصول ؟', 'dejavo'),
            'default' => false,
            'text_width' => 90,
        ),
        array(
            'id' => 'dej_space_mob_bottom_nav',
            'type' => 'spinner',
            'title' => __('فاصله از پایین', 'dejavo'),
            'subtitle' => 'max:40 | min:0 | step:1',
            'max' => 40,
            'min' => 0,
            'step' => 1,
            'default' => 10,
            'output' => '.mobile_bottom_nav',
            'output_mode' => 'bottom',
            'unit' => 'px',
        ),


        array(
            'id' => 'dej_margin_mob_bottom_nav',
            'type' => 'spacing',
            'title' => __('فاصله از راست و چپ', 'dejavo'),
            'bottom' => false,
            'top' => false,
            'output' => '.mobile_bottom_nav',
            'output_mode' => 'margin',
            'default' => array(
                'right' => '10',
                'left' => '10',
                'unit' => 'px',
            ),

        ),

        array(
            'id' => 'dej_radius_mob_bottom_nav',
            'type' => 'spacing',
            'title' => __('خمیدگی گوشه ها', 'dejavo'),
            'output' => '.mobile_bottom_nav',
            'output_mode' => 'border-radius',
            'default' => array(
                'top' => '15',
                'right' => '15',
                'bottom' => '0',
                'left' => '15',
                'unit' => 'px',
            ),
        ),

        array(
            'id' => 'dej_active_li_radius_nav2',
            'type' => 'spacing',
            'title' => __('خمیدگی گوشه آیکن ها', 'dejavo'),
            'output' => '.mobile_bottom_nav li',
            'output_mode' => 'border-radius',
            'default' => array(
                'top' => '10',
                'right' => '10',
                'bottom' => '10',
                'left' => '10',
                'unit' => 'px',
            ),
        ),
        array(
            'id' => 'dej_bg_mob_bottom_nav',
            'type' => 'button_set',
            'title' => __('نوع پس زمینه', 'dejavo'),
            'multiple' => false,
            'options' => array(
                'white_bg' => 'سفید',
                'blur_bg' => 'بلر / کدر',
                'main_bg' => 'گرادیانت اصلی',
                'second_bg' => 'گرادیانت فرعی',
                'color1_bg' => 'رنگ اصلی',
                'color2_bg' => 'رنگ فرعی',
                'custom' => 'سفارشی',
            ),
            'default' => 'blur_bg',
        ),

        array(
            'id' => 'dej_icons_color_bottom_nav',
            'type' => 'color',
            'title' => __('رنگ آیکن ها', 'dejavo'),
            'output' => '.mobile_bottom_nav li a i',
        ),

        array(
            'id' => 'dej_custom_bg_mob_bottom_nav',
            'type' => 'color',
            'title' => __('رنگ سفارشی پس زمینه', 'dejavo'),
            'dependency' => array('dej_bg_mob_bottom_nav', '==', 'custom'),
            'output' => '.mobile_bottom_nav',
            'output_mode' => 'background-color',
        ),


        array(
            'id' => 'dej_cus_active_li_bg_nav2',
            'type' => 'color',
            'title' => __('پس زمینه آیکن فعال', 'dejavo'),
            'output' => '.mobile_bottom_nav li.active',
            'output_mode' => 'background',
        ),
        array(
            'id' => 'dej_cus_act_li_cl_nav2',
            'type' => 'color',
            'title' => __('رنگ آیکن فعال', 'dejavo'),
            'output' => '.mobile_bottom_nav li.active a i',
        ),


        array(
            'type' => 'notice',
            'style' => 'info',
            'content' => __('جهت حفظ تفارن و ظاهر تعداد آیکن ها فرد باشد 5 یا 7', 'dejavo'),
        ),


        array(
            'id' => 'dej_mob_bottom_nav_icons',
            'type' => 'repeater',
            'max' => 7,
            'title' => __('آیکن ها', 'dejavo'),
            'fields' => array(
                array(
                    'id' => 'title',
                    'type' => 'text',
                    'title' => __('عنوان', 'dejavo'),
                ),
                array(
                    'id' => 'icon',
                    'type' => 'button_set',
                    'title' => __('انتخاب آیکن', 'dejavo'),
                    'multiple' => false,
                    'options' => array(
                        'menu' => 'فهرست',
                        'search' => 'جست و جو',
                        'user' => 'حساب کاربری',
                        'cart2' => 'سبد خرید',
                        'wishlist' => 'علاقه مندی',
                        'compare' => 'مقایسه',
                        'to-top' => 'بازگشت به بالا',
                        'home' => 'خانه',
                    ),
                    'dependency' => array('show_custom_icon', '==', false),
                ),
                array(
                    'id' => 'show_custom_icon',
                    'type' => 'switcher',
                    'title' => __('آیکن سفارشی ؟', 'dejavo'),
                    'default' => true,
                    'text_width' => 90,
                ),

                array(
                    'id' => 'custom_icon',
                    'type' => 'icon',
                    'dependency' => array('show_custom_icon', '==', true),
                    'title' => __('آیکن سفارشی', 'dejavo'),
                ),
                array(
                    'id' => 'custom_link',
                    'type' => 'link',
                    'title' => __('لینک', 'dejavo'),
                    'dependency' => array('show_custom_icon', '==', true),
                ),

                array(
                    'id' => 'color',
                    'type' => 'color',
                    'title' => __('رنگ سفارشی', 'dejavo'),
                ),
                array(
                    'id' => 'active_bg',
                    'type' => 'color',
                    'title' => __('پس زمینه حالت فعال', 'dejavo'),
                ),

            ),
            'default' => array(
                array(
                    'icon' => 'menu',
                    'title' => __('فهرست', 'dejavo'),
                ),
                array(
                    'icon' => 'home',
                    'title' => __('خانه', 'dejavo'),
                ),
                array(
                    'icon' => 'wishlist',
                    'title' => __('علاقه مندی', 'dejavo'),
                ),
                array(
                    'icon' => 'cart2',
                    'title' => __('سبد خرید', 'dejavo'),
                ),
                array(
                    'icon' => 'compare',
                    'title' => __('مقایسه', 'dejavo'),
                ),
                array(
                    'icon' => 'search',
                    'title' => __('جست و جو', 'dejavo'),
                ),
                array(
                    'icon' => 'user',
                    'title' => __('حساب', 'dejavo'),
                ),
            ),
        ),


    )
));


//
// لودینگ
//
CSF::createSection($prefix, array(
    'id' => 'dej_loading',
    'title' => __('لودینگ', 'dejavo'),
    'icon' => 'dej-loading',

    'fields' => array(
        array(
            'id' => 'show_dej_loading',
            'type' => 'switcher',
            'title' => __('نمایش لودینگ ؟', 'dejavo'),
            'default' => true,
            'text_width' => 90,
        ),
        array(
            'id' => 'dej_loading_type',
            'type' => 'button_set',
            'title' => __('سبک نمایش', 'dejavo'),
            'options' => array(
                '1' => 'یک',
                '2' => 'دو',
                '3' => 'سه',
                '4' => 'چهار',
            ),
            'default' => '1',
        ),

        array(
            'id' => 'dej_loading_out',
            'type' => 'button_set',
            'title' => __('سبک خروج', 'dejavo'),
            'options' => array(
                'slide' => 'اسلاید به بالا',
                'fade' => 'محو شدن',
                'window' => 'باز شدن',
            ),
            'default' => 'fade',
        ),


        array(
            'id' => 'dej_loading_bg',
            'type' => 'background',
            'title' => __('پس زمینه', 'dejavo'),
            'background_gradient' => true,
            'output' => '.dejavo_loading',
        ),

    )
));
if (is_admin()) {

//
// موبایل و تبلت
//
    CSF::createSection($prefix, array(
        'id' => 'mobile',
        'title' => __('موبایل و تبلت', 'dejavo'),
        'icon' => 'dej-smartphone',
    ));
//
// امکانات
//
    CSF::createSection($prefix, array(
        'title' => __('امکانات', 'dejavo'),
        'icon' => 'dej-folder-tree',
        'fields' => array(


            array(
                'id' => 'dej_show_sticky_add_tc',
                'type' => 'switcher',
                'title' => __('افزودن به سبد خرید چسبان صفحه محصول', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_show_ajax_search',
                'type' => 'switcher',
                'title' => __('جست و جوی ایجکسی', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_show_wishlist',
                'type' => 'switcher',
                'title' => __('لیست علاقه مندی ها', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_show_compare',
                'type' => 'switcher',
                'title' => __('مقایسه', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_show_quick_view',
                'type' => 'switcher',
                'title' => __('نمایش سریع', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_show_fix_cart',
                'type' => 'switcher',
                'title' => __('سبد خرید شناور', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_show_variation_swatches',
                'type' => 'switcher',
                'title' => __('محصولات متغیر پیشرفته', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_show_back_to_top',
                'type' => 'switcher',
                'title' => __('دکمه بازگشت به بالا', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),


            array(
                'id' => 'dej_show_wp_block',
                'type' => 'switcher',
                'title' => __('ادیتور بلاک وردپرس', 'dejavo'),
                'default' => false,
                'text_width' => 90,
                'desc' => __('توصیه می شود جهت بهبود سرعت غیرفعال باشد', 'dejavo'),
            ),

            array(
                'id' => 'dej_show_wp_emoji',
                'type' => 'switcher',
                'title' => __('اموجی وردپرس', 'dejavo'),
                'default' => false,
                'text_width' => 90,
                'desc' => __('توصیه می شود جهت بهبود سرعت غیرفعال باشد', 'dejavo'),
            ),


        )
    ));

//
// محصولات
//
    CSF::createSection($prefix, array(
        'id' => 'product_options',
        'title' => __('محصولات', 'dejavo'),
        'icon' => 'dej-shopping-bag',
    ));
    CSF::createSection($prefix, array(
        'parent' => 'product_options',
        'title' => __('محصول', 'dejavo'),
        'description' => '',
        'fields' => array(

            array(
                'id' => 'dej_woo_purchasable',
                'type' => 'switcher',
                'title' => __('فعالسازی فروش محصولات ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),



            array(
                'id' => 'dej_enable_review_rating',
                'type' => 'switcher',
                'title' => __('فعالسازی امتیاز ستاره ای ؟', 'dejavo'),
                'desc' => __('این گزینه مقدار "امتیاز‌های محصول" در تنظیمات ووکامرس را تغییر میدهد', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_enable_rating_in_card',
                'type' => 'switcher',
                'title' => __('نمایش امتیاز ستاره ای در کارد ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
                'dependency' => array('dej_enable_review_rating', '==', true),
            ),
            array(
                'id' => 'show_two_pic_in_card',
                'type' => 'switcher',
                'title' => __('نمایش عکس دوم با هاور در کارد محصول ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'show_stock',
                'type' => 'switcher',
                'title' => __('نمایش موجودی انبار ؟', 'dejavo'),
                'desc' => __('این گزینه مقدار "نحوه نمایش موجودی انبار" در تنظیمات ووکامرس را تغییر میدهد', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'show_stock_in_card',
                'type' => 'switcher',
                'title' => __('نمایش میزان فروش در کارد محصول ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
                'dependency' => array('show_stock', '==', true),

            ),
            array(
                'id' => 'show_text_shorter',
                'type' => 'switcher',
                'title' => __('نمایش کوتاه کننده متن در توضیحات کوتاه ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'max_height_text_shorter',
                'type' => 'spinner',
                'title' => __('حداکثر ارتفاع در حالت کوتاه', 'dejavo'),
                'subtitle' => 'max:500 | min:200',
                'max' => 500,
                'min' => 200,
                'step' => 10,
                'default' => 180,
                'dependency' => array('show_text_shorter', '==', true),


            ),

            array(
                'id' => 'dej_replace_price',
                'type' => 'text',
                'title' => __('درج متن سفارشی به جای قیمت تمام محصولات', 'dejavo'),
            ),

            array(
                'id' => 'dej_out_of_stock_text',
                'type' => 'text',
                'title' => __('جایگزین کلمه ( ناموجود )', 'dejavo'),
            ),
            array(
                'id' => 'dej_free_text',
                'type' => 'text',
                'title' => __('جایگزین کلمه ( رایگان )', 'dejavo'),
            ),

            array(
                'id' => 'dej_brand_slug',
                'type' => 'text',
                'title' => __('نامک سفارشی ویژگی برند محصول جهت نمایش تصویر برند و فیلتر برند', 'dejavo'),
                'subtitle' => __('پیشفرض : brand', 'dejavo'),
                'default' => 'brand'
            ),
            array(
                'id' => 'dej_color_slug',
                'type' => 'text',
                'title' => __('نامک سفارشی ویژگی رنگ محصول جهت نمایش فیلتر رنگ و کارد', 'dejavo'),
                'subtitle' => __('پیشفرض : color', 'dejavo'),
                'default' => 'color'
            ),

            array(
                'id' => 'dej_size_slug',
                'type' => 'text',
                'title' => __('نامک سفارشی ویژگی اندازه محصول جهت نمایش در کارد', 'dejavo'),
                'subtitle' => __('پیشفرض : size', 'dejavo'),
                'default' => 'size'
            ),


            array(
                'id' => 'dej_show_vs_in_card',
                'type' => 'switcher',
                'title' => __(' نمایش ویژگی های متغیر در کارد ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_type_vs_in_card',
                'type' => 'button_set',
                'title' => __('نوع نمایش ویژگی های متغییر', 'dejavo'),
                'dependency' => array('dej_show_vs_in_card', '==', true, '', 'visible'),
                'options' => array(
                    'display' => __('فقط نمایش', 'dejavo'),
                    'closable' => __('قابلیت انتخاب و خرید مستقیم', 'dejavo'),
                ),
                'default' => 'display',
            ),

            array(
                'id' => 'dej_attr_button_default',
                'type' => 'switcher',
                'title' => __('فرم نمایش پیشفرض ویژگی متغیر دکمه باشد ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_attr_second_click',
                'type' => 'switcher',
                'title' => __('کلیک دوم برای لغو انتخاب فعال شود؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_attr_tooltip_lib',
                'type' => 'button_set',
                'title' => __('فرمت نمایش', 'dejavo'),
                'options' => array(
                    'hint' => 'hint',
                    'tippy' => 'tippy',
                ),
                'default' => 'hint',
            ),

            array(
                'id' => 'dej_attr_tooltip_position',
                'type' => 'button_set',
                'title' => __('موقعیت', 'dejavo'),
                'options' => array(
                    'top' => __('بالا', 'dejavo'),
                    'right' => __('راست', 'dejavo'),
                    'bottom' => __('پایین', 'dejavo'),
                    'left' => __('چپ', 'dejavo'),
                ),
                'default' => 'top',
            ),
            array(
                'id' => 'dej_attr_style',
                'type' => 'button_set',
                'title' => __('سبک نمایش', 'dejavo'),
                'options' => array(
                    'square' => __('مربع', 'dejavo'),
                    'rounded' => __('دایره', 'dejavo'),
                ),
                'default' => 'rounded',
            ),

            array(
                'id' => 'dej_attr_archive_limit',
                'type' => 'spinner',
                'title' => __('محدودیت نمایش در کارد', 'dejavo'),
                'subtitle' => 'max:20 | min:3',
                'max' => 20,
                'min' => 3,
                'step' => 1,
                'default' => 6,
                'dependency' => array('dej_show_vs_in_card', '==', true, '', 'visible'),

            ),


        )
    ));

    CSF::createSection($prefix, array(
        'parent' => 'product_options',
        'title' => __('آرشیو', 'dejavo'),
        'description' => '',
        'fields' => array(
            array(
                'id'       => 'order_stock',
                'type'     => 'switcher',
                'title'    => __('انتفال محصولات ناموجود به انتهای لیست ؟', 'dejavo'),
                'default'  => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_product_style',
                'type' => 'button_set',
                'title' => __('انتخاب کارد محصول در آرشیو', 'dejavo'),
                'options' => array(
                    '1' => 'یک',
                    '2' => 'دو',
                    '3' => 'سه',
                    '4' => 'چهار',
                    '5' => 'پنج',
                    '6' => 'شش',
                ),
                'default' => '1',
            ),
            array(
                'id' => 'dej_mob_product_card',
                'type' => 'switcher',
                'title' => __('نمایش کارد ویژه موبایل ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_loop_shop_per_page',
                'title' => __('تعداد محصولات در حلقه آرشیو', 'dejavo'),
                'type' => 'slider',
                'min' => 3,
                'max' => 50,
                'step' => 1,
                'default' => 20,
            ),

            array(
                'id' => 'dej_number_col_product_archive',
                'title' => __('تعداد ستون محصولات آرشیو', 'dejavo'),
                'type' => 'slider',
                'min' => 2,
                'max' => 8,
                'step' => 1,
                'default' => 4,
            ),
            array(
                'id' => 'dej_number_col_tab_product_archive',
                'title' => __('تعداد ستون محصولات آرشیو / تبلت', 'dejavo'),
                'type' => 'slider',
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 3,
            ),
            array(
                'id' => 'dej_number_col_mob_product_archive',
                'title' => __('تعداد ستون محصولات آرشیو / موبایل', 'dejavo'),
                'type' => 'slider',
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 2,
            ),
            array(
                'id' => 'dej_number_col_cat_archive',
                'title' => __('تعداد ستون دسته بندی در آرشیو', 'dejavo'),
                'type' => 'slider',
                'min' => 4,
                'max' => 8,
                'step' => 1,
                'default' => 6,
            ),
        )
    ));
    CSF::createSection($prefix, array(
        'parent' => 'product_options',
        'title' => __('نظرات', 'dejavo'),
        'description' => '',
        'fields' => array(

            array(
                'id' => 'show_dej_advanced_reviews',
                'type' => 'switcher',
                'title' => __('نمایش نظرات پیشرفته ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'show_dej_reviews_recommend',
                'type' => 'switcher',
                'title' => __('نمایش گزینه های پیشنهاد ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
                'dependency' => array('show_dej_advanced_reviews', '==', true),
            ),
            array(
                'id' => 'show_dej_reviews_advantage',
                'type' => 'switcher',
                'title' => __('نمایش نقاط ضعف و قوت محصول ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
                'dependency' => array('show_dej_advanced_reviews', '==', true),
            ),
            array(
                'id' => 'show_dej_reviews_slide_opt',
                'type' => 'switcher',
                'title' => __('نمایش گزینه های امتیاز اسلایدی ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
                'dependency' => array('show_dej_advanced_reviews', '==', true),
            ),


            array(
                'id' => 'dej_slider_rating',
                'type' => 'repeater',
                'title' => __('زمینه های امتیاز اسلایدی', 'dejavo'),
                'subtitle' => '',
                'button_title' => __('افزودن', 'dejavo'),
                'dependency' => array('show_dej_advanced_reviews', '==', true),
                'min' => 2,
                'max' => 6,
                'fields' => array(
                    array(
                        'id' => 'dej_slide_rate',
                        'type' => 'text',
                        'title' => __('عنوان', 'dejavo'),
                    ),
                ),
                'default' => array(
                    array(
                        'dej_slide_rate' => 'قیمت و ارزش خرید',
                    ),
                    array(
                        'dej_slide_rate' => 'قابلیت ها و امکانات',
                    ),
                    array(
                        'dej_slide_rate' => 'کیفیت و کارایی',
                    ),
                    array(
                        'dej_slide_rate' => 'ظاهر و زیبایی',
                    ),
                ),
            ),

        )
    ));
    CSF::createSection($prefix, array(
        'parent' => 'product_options',
        'title' => __('لیبل ساز', 'dejavo'),
        'description' => '',
        'fields' => array(

            array(
                'id' => 'show_dej_icon_label',
                'type' => 'switcher',
                'title' => __('نمایش آیکن لیبل در کارد محصول ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_labels',
                'type' => 'repeater',
                'max' => 8,

                'title' => __('لیبل', 'dejavo'),
                'fields' => array(
                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => __('عنوان', 'dejavo'),
                    ),
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => __('آیکن', 'dejavo'),
                    ),
                    array(
                        'id' => 'color',
                        'type' => 'color',
                        'title' => __('رنگ', 'dejavo'),
                    ),
                    array(
                        'id' => 'status',
                        'type' => 'switcher',
                        'title' => __('وضعیت', 'dejavo'),
                        'default' => true,
                    ),

                ),
                'default' => array(
                    array(
                        'title' => 'اورجینال',
                        'icon' => 'dej-badge-check',
                        'color' => '#268131',
                        'status' => true,
                    ),
                    array(
                        'title' => 'غیر اصل',
                        'icon' => 'dej-info',
                        'color' => '#e57b0a',
                        'status' => true,
                    ),
                    array(
                        'title' => 'آماده ارسال',
                        'icon' => 'dej-rocket',
                        'color' => '#0758ce',
                        'status' => true,
                    ),
                    array(
                        'title' => 'پیشنهادی',
                        'icon' => 'dej-gem',
                        'color' => '#8306cc',
                        'status' => true,
                    ),
                    array(
                        'title' => 'کار کرده',
                        'icon' => 'dej-unlock',
                        'color' => '#f21818',
                        'status' => true,
                    ),
                ),
            ),

            array(
                'type'    => 'heading',
                'content' => __('درج لیبل یکسان برای تمام محصولات', 'dejavo'),
            ),
            array(
                'id' => 'fix_labels',
                'type' => 'repeater',
                'max' => 3,

                'title' => __('لیبل', 'dejavo'),

                'fields' => array(
                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => __('عنوان', 'dejavo'),
                    ),
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => __('آیکن', 'dejavo'),
                    ),
                    array(
                        'id' => 'color',
                        'type' => 'color',
                        'title' => __('رنگ', 'dejavo'),
                    ),
                    array(
                        'id' => 'status',
                        'type' => 'switcher',
                        'title' => __('وضعیت', 'dejavo'),
                        'default' => true,
                    ),

                    array(
                        'id' => 'sale',
                        'type' => 'switcher',
                        'title' => __('نمایش برای تخفیف دار؟', 'dejavo'),
                        'default' => false,
                    ),

                ),
            ),


        )
    ));

    CSF::createSection($prefix, array(
        'parent' => 'product_options',
        'description' => '',
        'title' => esc_html__('وضعیت های سفارش', 'dejavo'),
        'fields' => array(

            array(
                'id' => 'dej_cancel_status',
                'type' => 'switcher',
                'title' => __('لغو سفارش توسط کاربر ؟', 'dejavo'),
                'desc'      => __('برای حذف امکان لغو این گزینه باید غیرغعال باشد', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id'         => 'dej_cancel_statuses',
                'type'       => 'checkbox',
                'title'      => __('کدام وضعیت ها امکان لغو توسط کاربر داشته باشند ؟', 'dejavo'),
                'options'    => array(
                    'processing' => dej_opt('dej_processing_status', __('در حال آماده سازی', 'dejavo')),
                    'pending' => dej_opt('dej_pending_status', __('در انتظار پرداخت', 'dejavo')),
                    'on-hold' => dej_opt('dej_hold_status', __('در حال بررسی', 'dejavo')),
                    'failed' => dej_opt('dej_failed_status', __('پرداخت ناموفق', 'dejavo')),
                    'completed' => dej_opt('dej_completed_status', __('ارسال شده', 'dejavo')),
                ),
                'default'    => array( 'pending', 'on-hold', 'failed' ),
                'dependency' => array(
                    'dej_cancel_status', '==', true
                ),
            ),

            array(
                'type'    => 'heading',
                'content' => __('سفارشی سازی عنوان وضعیت های سفارش', 'dejavo'),
            ),
            array(
                'id' => 'dej_completed_status',
                'type' => 'text',
                'title' => __('وضعیت ارسال شده : ', 'dejavo')
            ),
            array(
                'id' => 'dej_processing_status',
                'type' => 'text',
                'title' => __('وضعیت در حال آماده سازی : ', 'dejavo')
            ),
            array(
                'id' => 'dej_hold_status',
                'type' => 'text',
                'title' => __('وضعیت در حال بررسی : ', 'dejavo')
            ),
            array(
                'id' => 'dej_pending_status',
                'type' => 'text',
                'title' => __('وضعیت در انتظار پرداخت : ', 'dejavo')
            ),
            array(
                'id' => 'dej_cancelled_status',
                'type' => 'text',
                'title' => __('وضعیت لفو شده : ', 'dejavo')
            ),
            array(
                'id' => 'dej_refunded_status',
                'type' => 'text',
                'title' => __('وضعیت بازگشت وجه : ', 'dejavo')
            ),
            array(
                'id' => 'dej_failed_status',
                'type' => 'text',
                'title' => __('وضعیت پرداخت ناموفق : ', 'dejavo')
            ),

        )
    ));



    CSF::createSection($prefix, array(
        'parent' => 'product_options',
        'description' => '',
        'title' => esc_html__('پیگیری سفارش', 'dejavo'),
        'fields' => array(

            array(
                'id' => 'dej_track_type',
                'type' => 'button_set',
                'title' => __('سبک نمایش', 'dejavo'),
                'multiple' => false,
                'options' => array(
                    'order_id' => __('فقط شماره سفارش', 'dejavo'),
                    'both' => __('شماره سفارش و موبایل', 'dejavo'),
                ),
                'default' => 'both'
            ),

            array(
                'id' => 'dej_track_detail',
                'type' => 'switcher',
                'title' => __('نمایش جزییات سفارش ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
            ),

            array(
                'type' => 'notice',
                'style' => 'warning',
                'content' => __('جهت ایمنی بیشتر داده مشتری بهتر است وقتی ورودی موبایل فعال نیست نمایش جزییات فعال نباشد', 'dejavo'),
                'dependency' => array(['dej_track_detail', '==', true], ['dej_track_type', '==', 'order_id']),
            ),

        )
    ));

    CSF::createSection($prefix, array(
        'parent' => 'product_options',
        'description' => '',
        'title' => esc_html__('اعلان ها', 'dejavo'),
        'fields' => array(

            array(
                'id' => 'dej_show_warranty',
                'type' => 'switcher',
                'title' => __('نمایش گارانتی یکسان برای تمام محصولات ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_warranty',
                'type' => 'textarea',
                'title' => __('گارانتی', 'dejavo'),
                'dependency' => array('dej_show_warranty', '==', true),
            ),
            array(
                'id' => 'dej_show_duration',
                'type' => 'switcher',
                'title' => __('نمایش زمان ارسال یکسان برای تمام محصولات ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_send_duration',
                'type' => 'text',
                'title' => __('مدت زمان ارسال', 'dejavo'),
                'dependency' => array('dej_show_duration', '==', true),
            ),
            array(
                'id' => 'dej_show_alarm',
                'type' => 'switcher',
                'title' => __('نمایش هشدار یکسان برای تمام محصولات ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_alarm',
                'type' => 'textarea',
                'title' => __('هشدار', 'dejavo'),
                'dependency' => array('dej_show_alarm', '==', true),
            ),
        )
    ));


//
// فرم پرداخت
//
    CSF::createSection($prefix, array(
        'id' => 'checkout',
        'title' => __('پرداخت و سبد خرید', 'dejavo'),
        'description' => '',
        'icon' => 'dej-form',
        'fields' => array(


            array(
                'id'       => 'dej_show_step_buy',
                'type'     => 'switcher',
                'title'    => __( 'نمایش المان مراحل خرید ؟', 'dejavo' ),
                'default'  => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'rebuild',
                'type' => 'switcher',
                'title' => __('بازنشانی محتوای سبد خرید و پرداخت ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'type'    => 'notice',
                'style'   => 'warning',
                'content' => __('برای عملکرد صحیح سبد خرید و پرداخت برگه های آن را المنتوری نکنید و روی ویرایشگر وردپرس تنظیم کنید', 'dejavo'),
            ),
            array(
                'type'    => 'heading',
                'content' => __('درج پیام بالای فرم پرداخت', 'dejavo'),
            ),

            array(
                'id'       => 'dej_checkout_a_title',
                'type'     => 'text',
                'title'    => __('عنوان', 'dejavo'),
            ),
            array(
                'id'       => 'dej_checkout_alarm',
                'type'     => 'wp_editor',
                'title'    => __('محتوای پیام', 'dejavo'),
            ),
            array(
                'id' => 'dej_checkout_a_title_color',
                'type' => 'color',
                'title' => __('رنگ عنوان', 'dejavo'),
                'validate' => 'color',
            ),
            array(
                'id' => 'dej_checkout_alarm_color',
                'type' => 'color',
                'title' => __('رنگ متن', 'dejavo'),
                'validate' => 'color',
            ),

            array(
                'id' => 'dej_checkout_alarm_bg',
                'type' => 'color',
                'title' => __('رنگ پس زمینه', 'dejavo'),
                'validate' => 'color',
            ),
            array(
                'type'    => 'heading',
                'content' => __('درج پیام بالای سبد خرید', 'dejavo'),
            ),
            array(
                'id'       => 'dej_cart_a_title',
                'type'     => 'text',
                'title'    => __('عنوان', 'dejavo'),
            ),
            array(
                'id'       => 'dej_cart_alarm',
                'type'     => 'wp_editor',
                'title'    => __('محتوای پیام', 'dejavo'),
            ),
            array(
                'id'       => 'dej_cart_a_title_color',
                'type'     => 'color',
                'title'    => __('رنگ عنوان', 'dejavo'),
                'validate' => 'color',
            ),
            array(
                'id' => 'dej_cart_alarm_color',
                'type' => 'color',
                'title' => __('رنگ متن', 'dejavo'),
                'validate' => 'color',
            ),
            array(
                'id' => 'dej_cart_alarm_bg',
                'type' => 'color',
                'title' => __('رنگ پس زمینه', 'dejavo'),
                'validate' => 'color',
            ),


            array(
                'type'    => 'heading',
                'content' => __('مدیریت فیلد های فرم پرداخت', 'dejavo'),
            ),


            array(
                'id' => 'dej_no_email_validation',
                'type' => 'switcher',
                'title' => __('غیر ضروری کردن زمینه ایمیل ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_postcode_required',
                'type' => 'switcher',
                'title' => __('غیر ضروری کردن زمینه کد پستی ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_remove_unnecessary_fields',
                'type' => 'switcher',
                'title' => __('حذف زمینه های غیر ضروری (نام شرکت و آدرس 2) ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),


            array(
                'id' => 'dej_reorder_fields',
                'type' => 'switcher',
                'title' => __('مرتب سازی زمینه های استان شهر و آدرس ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_remove_country',
                'type' => 'switcher',
                'title' => __('حذف زمینه کشور ؟', 'dejavo'),
                'desc' => __('حذف کشور ممکن است باعث اختلال در ورود به درگاه شود . در صورت فعالسازی در پیکر بندی ووکامرس کشور را روی ایران تنظیم کنید', 'dejavo'),
                'default' => false,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_show_checkout_national_code',
                'type' => 'switcher',
                'title' => __('نمایش زمینه کد ملی ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),


            array(
                'id' => 'dej_required_checkout_national_code',
                'type' => 'switcher',
                'title' => __('اجباری بودن زمینه کد ملی ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
                'dependency' => array('dej_show_checkout_national_code', '==', true),
            ),

            array(
                'id' => 'dej_show_checkout_map',
                'type' => 'switcher',
                'title' => __('نمایش آدرس روی نقشه ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_required_checkout_map',
                'type' => 'switcher',
                'title' => __('اجباری بودن آدرس روی نقشه ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
                'dependency' => array('dej_show_checkout_map', '==', true),
            ),

            array(
                'id' => 'dej_show_checkout_delivery',
                'type' => 'switcher',
                'title' => __('نمایش تاریخ دریافت ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_required_checkout_delivery',
                'type' => 'switcher',
                'title' => __('اجباری بودن تاریخ دریافت ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
                'dependency' => array('dej_show_checkout_delivery', '==', true),
            ),

            array(
                'id' => 'dej_delivery_dates',
                'type' => 'button_set',
                'title' => __('روزهای قابل انتخاب ؟', 'dejavo'),
                'multiple' => true,
                'dependency' => array('dej_show_checkout_delivery', '==', true),
                'options' => array(
                    'saturday' => 'شنبه',
                    'sunday' => 'یکشنبه',
                    'monday' => 'دوشنبه',
                    'tuesday' => 'سه شنبه',
                    'wednesday' => 'چهارشنبه',
                    'thursday' => 'پنجشنبه',
                    'friday' => 'جمعه',
                ),
                'default' => array('saturday', 'sunday', 'monday', 'tuesday', 'wednesday', 'thursday')
            ),
            array(
                'id' => 'dej_delivery_min_time',
                'type' => 'number',
                'title' => __('حداقل تعداد روز زمان ارسال ؟', 'dejavo'),
                'default' => 4,
                'dependency' => array('dej_show_checkout_delivery', '==', true),
            ),
            array(
                'id' => 'dej_delivery_count',
                'type' => 'number',
                'title' => __('تعداد روز قابل انتخاب ؟', 'dejavo'),
                'default' => 6,
                'dependency' => array('dej_show_checkout_delivery', '==', true),
            ),


        )
    ));

//
// ورود و ثبت نام پیامکی
//

    CSF::createSection($prefix, array(
        'id' => 'login',
        'title' => __('ورود و عضویت', 'dejavo'),
        'description' => '',
        'icon' => 'dej-user',
        'fields' => array(

            array(
                'id' => 'dej_auth_style',
                'type' => 'button_set',
                'title' => __('سبک نمایش', 'dejavo'),
                'multiple' => false,
                'options' => array(
                    'pop' => __('پاپ آپ', 'dejavo'),
                    'slide' => __('اسلاید', 'dejavo'),
                    'page' => __('ورود به صفحه', 'dejavo'),
                ),
                'default' => 'slide'
            ),

            array(
                'id' => 'dej_auth',
                'type' => 'switcher',
                'title' => __('فعالسازی ورود و عضویت ایجکسی قالب ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_reg',
                'type' => 'switcher',
                'title' => __('فعالسازی عضویت ؟', 'dejavo'),
                'default' => true,
                'desc' => __('در صورت غیر فعال بودن این گزینه کاربران فقط می توانند وارد شوند و امکان عضویت لغو می شود', 'dejavo'),
                'text_width' => 90,
            ),



            array(
                'id' => 'dej_auth_checkout',
                'type' => 'switcher',
                'title' => __('اعمال فرم در صفحه پرداخت (ورود اجباری) ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
                'dependency' => array('dej_auth', '==', true),
            ),
            array(
                'id' => 'dej_auth_top_checkout',
                'type' => 'switcher',
                'title' => __('نمایش فرم بالای صفحه پرداخت ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
                'dependency' => array('dej_auth', '==', true),
            ),

            array(
                'id' => 'dej_with_pass',
                'type' => 'switcher',
                'title' => __('فعالسازی تب با رمز ثابت ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
                'dependency' => array('dej_auth', '==', true),
            ),

            array(
                'id' => 'dej_with_code',
                'type' => 'switcher',
                'title' => __('فعالسازی تب با کد تایید ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
                'dependency' => array('dej_auth', '==', true),
            ),
            array(
                'id' => 'dej_remember_login',
                'type' => 'switcher',
                'title' => __('ورود کاربر در مرورگر ذخیره شود ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
                'dependency' => array('dej_auth', '==', true),
            ),
            array(
                'id' => 'dej_auth_title',
                'type' => 'text',
                'dependency' => array('dej_auth', '==', true),
                'title' => __('عنوان سفارشی تب با کد تایید : ', 'dejavo')
            ),

            array(
                'id' => 'dej_pass_title',
                'type' => 'text',
                'dependency' => array('dej_auth', '==', true),
                'title' => __('عنوان سفارشی تب با رمز ثابت : ', 'dejavo')
            ),


            array(
                'id' => 'dej_auth_type',
                'type' => 'button_set',
                'title' => __('روش ارسال کد تایید', 'dejavo'),
                'multiple' => false,
                'dependency' => array('dej_auth', '==', true),
                'options' => array(
                    'email' => __('ایمیل', 'dejavo'),
                    'both' => __('هر دو', 'dejavo'),
                    'sms' => __('پیامک', 'dejavo'),
                ),
                'default' => 'email'
            ),

            array(
                'type' => 'notice',
                'style' => 'warning',
                'content' => __('گزینه ورود و عضویت با ارسال کد تایید به ایمیل نیاز به فعال بودن سرویس ایمیل سرور هاست دارد', 'dejavo'),
                'dependency' => array(['dej_auth_type', 'any', 'email,both'], ['dej_auth', '==', true]),
            ),
            array(
                'id' => 'dej_auth_expire',
                'type' => 'slider',
                'title' => __('زمان اننقضای کد', 'dejavo'),
                'subtitle' => 'Min: 30 | Max: 600 | Step: 5 | Default: 120',
                'min' => 30,
                'max' => 600,
                'step' => 5,
                'default' => 120,
                'dependency' => array('dej_auth', '==', true),
            ),

            array(
                'id' => 'dej_gateway',
                'type' => 'button_set',
                'title' => __('انتخاب پنل ارائه دهنده', 'dejavo'),
                'multiple' => false,
                'dependency' => array('dej_auth', '==', true),
                'options' => array(
                    'kavehnegar' => __('کاوه نگار', 'dejavo'),
                    'ippanel' => __('فراز - آی پی پنل', 'dejavo'),
                    'smsir' => __('اس ام اس دات آی آر', 'dejavo'),
                    'melipayamak' => __('ملی پیامک', 'dejavo'),

                ),
                'default' => 'melipayamak'
            ),

            array(
                'type' => 'notice',
                'style' => 'warning',
                'content' => 'راهنمای melipayamak : نام کاربری و رمز ورود به سامانه و کد متن وب سرویس خدماتی(الگو) که دارای یک متغییر به شکل {0} باشد را پس از تایید از منوی ابزار ویژه ملی پیامک دریافت و در این بخش وارد کنید',
                'dependency' => array(['dej_auth', '==', true], ['dej_gateway', '==', 'melipayamak']),
            ),
            array(
                'type' => 'notice',
                'style' => 'warning',
                'content' => 'راهنمای farazsms - ippanel  : نام کاربری و رمز ورود به سامانه و کد پترن  را پس از تایید از منوی ارسال براساس پترن دریافت و در این بخش وارد کنید. همچنین شماره ارسال پیام را وارد کنید نمونه شماره : +9890000145 .  در پترن حتما از عبارت %verification-code% استفاده شود',
                'dependency' => array(['dej_auth', '==', true], ['dej_gateway', '==', 'ippanel']),
            ),

            array(
                'type' => 'notice',
                'style' => 'warning',
                'content' => 'راهنمای sms.ir : شناسه قالب (در پنل sms.ir > امکانات > ارسال سریع) و کلید API (در پنل sms.ir > برنامه نویسان > لیست کلید های Api) را وارد کنید در قالبی که ایجاد می کنید حتما باید از عبارت #code# استفاده کنید همچمین نیاز به یک شماره پیامکی فعال دارید ',
                'dependency' => array(['dej_auth', '==', true], ['dej_gateway', '==', 'smsir']),
            ),
            array(
                'type' => 'notice',
                'style' => 'warning',
                'content' => 'راهنمای kavehnegar : نام الگوی تایید شده از منوی اعتبارسنجی و API Key را از حساب من اکانت کاوه نگار دریافت و وارد کنید',
                'dependency' => array(['dej_auth', '==', true], ['dej_gateway', '==', 'kavehnegar']),
            ),
            array(
                'id' => 'dej_gateway_username',
                'dependency' => array(['dej_auth', '==', true], ['dej_gateway', 'any', 'ippanel,melipayamak']),
                'type' => 'text',
                'title' => __('نام کاربری', 'dejavo'),
            ),
            array(
                'id' => 'dej_gateway_password',
                'dependency' => array(['dej_auth', '==', true], ['dej_gateway', 'any', 'ippanel,melipayamak']),
                'type' => 'text',
                'title' => __('رمز', 'dejavo'),
            ),

            array(
                'id' => 'dej_gateway_pattern',
                'dependency' => array('dej_auth', '==', true),
                'type' => 'text',
                'title' => __('شناسه الگو / پترن / قالب', 'dejavo'),
                'desc' => __('نمونه : 10761438', 'dejavo'),
            ),

            array(
                'id' => 'dej_gateway_key',
                'dependency' => array(['dej_auth', '==', true], ['dej_gateway', 'any', 'smsir,kavehnegar']),
                'type' => 'text',
                'title' => __('کلید', 'dejavo'),
            ),

            array(
                'id' => 'dej_gateway_sms',
                'dependency' => array(['dej_auth', '==', true], ['dej_gateway', '==', 'ippanel']),
                'type' => 'text',
                'title' => __('شماره خط', 'dejavo'),
            ),

        )
    ));
//
// پروفایل مشتری
//

    CSF::createSection($prefix, array(
        'id' => 'profile',
        'title' => __('حساب کاربری و تیکت', 'dejavo'),
        'description' => '',
        'icon' => 'dej-user',
        'fields' => array(

            array(
                'id' => 'dej_change_avatar',
                'type' => 'switcher',
                'title' => __('امکان تغییر و آپلود عکس پروفایل توسط کاربر ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_change_pass',
                'type' => 'switcher',
                'title' => __('جایگزین زمینه تغییر رمز عبور با روش ایجکسی و بدون نیاز به ورود رمز فعلی ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_disable_downloads',
                'type' => 'switcher',
                'title' => __('غیرفعال کردن نمایش منوی دانلود ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_bank_info',
                'type' => 'switcher',
                'title' => __('نمایش منوی حساب بانکی در پروفایل کاربر ؟', 'dejavo'),
                'desc' => __('جهت بازگشت وجه سفارشهای لغو شده', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_ticket_h1',
                'type' => 'heading',
                'title' => __('تیکت', 'dejavo'),
            ),
            array(
                'id' => 'dej_ticket',
                'type' => 'switcher',
                'title' => __('فعالسازی تیکت ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'ticket_mob_menu',
                'type' => 'switcher',
                'title' => __('نمایش منو تیکت در فهرست موبایل ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'ticket_mob_menu_color',
                'type' => 'color',
                'title' => __('رنگ آیکن تیکت', 'dejavo'),
                'dependency' => array('ticket_mob_menu', '==', true),
            ),

            array(
                'id'          => 'dej_ticket_page',
                'type'        => 'select',
                'title'       => __('صفحه مجزا برای تیکت (اختیاری)', 'dejavo'),
                'placeholder' => __('انتخاب صفحه', 'dejavo'),
                'desc' => __('از این کد کوتاه در برگه استفاده کنید:<code>[dejst-ticket-panel]</code>', 'dejavo'),
                'options'     => 'pages',
                'query_args'  => array(
                    'posts_per_page' => -1,
                )
            ),


            array(
                'id'      => 'dej_ticket_help',
                'type'    => 'textarea',
                'title'   => __('متن راهنما یا قوانین ارسال تیکت کاربر', 'dejavo'),
            ),

            array(
                'id'      => 'dej_ticket_top_message',
                'type'    => 'textarea',
                'title'   => __('متن ثابت بالای پاسخ مدیر', 'dejavo'),

            ),
            array(
                'id'      => 'dej_ticket_bottom_message',
                'type'    => 'textarea',
                'title'   => __('متن ثابت پایین پاسخ مدیر', 'dejavo'),
            ),

            array(
                'id' => 'dej_ticket_file',
                'type' => 'switcher',
                'title' => __('آپلود فایل ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),


            array(
                'id'      => 'dej_ticket_file_format',
                'type'    => 'text',
                'title'   => __('فرمت های مجاز آپلود فایل', 'dejavo'),
                'desc' => __('فرمت های مجاز فایل را با کاما انگلیسی (,) از هم جدا کنید. نمونه: png,jpg,jpeg,gif,zip', 'dejavo'),
                'dependency' => array('dej_ticket_file', '==', true),
            ),

            array(
                'id'      => 'dej_ticket_file_size',
                'type'    => 'slider',
                'title'   => __('حجم مجاز فایل', 'dejavo'),
                'desc' => __('بیشترین حجم مجاز فایل بر حسب مگابایت', 'dejavo'),
                'min'     => 1,
                'max'     => 10,
                'step'    => 1,
                'default' => 2,
                'dependency' => array('dej_ticket_file', '==', true),
            ),


            array(
                'id'      => 'dej_ticket_auto_close',
                'type'    => 'slider',
                'title'   => __('بستن خودکار تیکت', 'dejavo'),
                'desc' => __('بر اساس تعداد روز', 'dejavo'),
                'min'     => 1,
                'max'     => 10,
                'step'    => 1,
                'default' => 3,
            ),

            array(
                'id' => 'dej_ticket_h2',
                'type' => 'heading',
                'title' => __('اعلانات تیکت', 'dejavo'),
            ),


            array(
                'id' => 'dej_ticket_noti_email',
                'type' => 'switcher',
                'title' => __('ارسال اعلان ایمیلی تیکت جدید ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_ticket_noti_email_rep',
                'type' => 'switcher',
                'title' => __('ارسال اعلان ایمیلی برای پاسخ ها ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_ticket_noti_email_rep_admin',
                'type' => 'switcher',
                'title' => __('ارسال اعلان ایمیلی پاسخ های کاربر برای مدیر ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
                'dependency' => [['dej_ticket_noti_email', '==', true], ['dej_ticket_noti_email_rep', '==', true]],
            ),

            array(
                'id'      => 'dej_ticket_admin_email',
                'type'    => 'text',
                'title'   => __('ایمیل دریافت اعلان پیامکی مدیر (اختیاری / پیشفرض : ایمیل ادمین اصلی)', 'dejavo'),
                'dependency' => ['dej_ticket_noti_email', '==', true],
            ),

            array(
                'id' => 'dej_ticket_noti_sms',
                'type' => 'switcher',
                'title' => __('ارسال اعلان پیامکی ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
            ),
            array(
                'id' => 'dej_ticket_noti_sms_rep',
                'type' => 'switcher',
                'title' => __('ارسال اعلان پیامکی برای پاسخ ها ؟', 'dejavo'),
                'default' => false,
                'text_width' => 90,
                'dependency' => ['dej_ticket_noti_sms', '==', true],
            ),
            array(
                'id' => 'dej_ticket_noti_rep_admin',
                'type' => 'switcher',
                'title' => __('ارسال اعلان پیامکی پاسخ های کاربر برای مدیر ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
                'dependency' => [['dej_ticket_noti_sms', '==', true], ['dej_ticket_noti_sms_rep', '==', true]],
            ),

            array(
                'id'      => 'dej_ticket_sms_phone',
                'type'    => 'text',
                'title'   => __('شماره دریافت اعلان پیامکی مدیر', 'dejavo'),
                'desc' => __('نمونه : 09121231111', 'dejavo'),
                'dependency' => ['dej_ticket_noti_sms', '==', true],
            ),

            array(
                'type'    => 'notice',
                'style'   => 'warning',
                'content' =>  __('برای ارسال پیامک از اطلاعات پنل در بخش ورود و عضویت استفاده میشود. نیاز به ورود کد الگو جدید و شماره دریافت پیامک ها است. محتوای الگو در پنل پیامکی باید شامل یک متغیر برای شماره تیکت باشد.', 'dejavo'),
                'dependency' => ['dej_ticket_noti_sms', '==', true],
            ),
            array(
                'id'      => 'dej_ticket_sms_pattern',
                'type'    => 'text',
                'title' => __('کد متن الگو/پترن/قالب', 'dejavo'),
                'desc' => __('نمونه : 862317', 'dejavo'),
                'dependency' => ['dej_ticket_noti_sms', '==', true],
            ),

            array(
                'id'      => 'dej_ticket_sms_pattern_rep',
                'type'    => 'text',
                'title' => __('کد متن الگو/پترن/قالب(پاسخ ها)', 'dejavo'),
                'desc' => __('نمونه : 862317', 'dejavo'),
                'dependency' => ['dej_ticket_noti_sms', '==', true],
            ),



            array(
                'type'    => 'notice',
                'style'   => 'warning',
                'content' =>  __('نمونه محتوای الگو تیکت : تیکت جدیدی با شماره {0} در سایت دژاوو درج شد. yoursite.ir', 'dejavo'),
                'dependency' => ['dej_ticket_noti_sms', '==', true],
            ),
            array(
                'type'    => 'notice',
                'style'   => 'warning',
                'content' =>  __('نمونه محتوای الگو پاسخ : پاسخ جدیدی برای تیکت شماره {0} در سایت دژاوو درج شد. yoursite.ir', 'dejavo'),
                'dependency' => ['dej_ticket_noti_sms', '==', true],
            ),

        )
    ));


    //
// اطلاعیه ها
//

    CSF::createSection($prefix, array(
        'id' => 'notifications',
        'title' => __('اطلاعیه ها', 'dejavo'),
        'description' => '',
        'icon' => 'dej-bell',
        'fields' => array(

            array(
                'id' => 'dej_show_notifications',
                'type' => 'switcher',
                'title' => __('نمایش اطلاعیه ها در پروفایل ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'mob_menu_noti',
                'type' => 'switcher',
                'title' => __('نمایش منو اطلاعیه ها در فهرست موبایل ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'noti_mob_menu_color',
                'type' => 'color',
                'title' => __('رنگ آیکن اطلاعیه', 'dejavo'),
                'dependency' => array('mob_menu_noti', '==', true),
            ),

            array(
                'id' => 'dej_notifications',
                'type' => 'repeater',
                'max' => 5,
                'dependency' => array('dej_show_notifications', '==', true),
                'title' => __('اطلاعیه', 'dejavo'),
                'fields' => array(
                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => __('عنوان', 'dejavo'),
                    ),
                    array(
                        'id' => 'content',
                        'type' => 'wp_editor',
                        'title' => __('محتوا', 'dejavo'),
                    ),
                    array(
                        'id' => 'bg-color',
                        'type' => 'color',
                        'title' => __('رنگ پس زمینه', 'dejavo'),
                    ),
                ),
                'default'   => array(
                    array(
                        'title' => 'خوش آمدید',
                        'content' => 'به فروشگاه اینترنتی' . ' ' . get_bloginfo('name') . ' ' . 'خوش آمدید',
                        'bg-color' => '#333',
                    ),

                )

            ),

        )
    ));

    //
// کد های سفارشی
//

    CSF::createSection($prefix, array(
        'id' => 'code',
        'title' => __('کد های سفارشی', 'dejavo'),
        'icon' => 'dej-edit',
        'fields' => array(

            array(
                'id' => 'dej_custom_js',
                'type' => 'code_editor',
                'title' => __('کد های جاوا اسکریپت', 'dejavo'),
                'subtitle' => '<strong>JS Editor</strong>',
                'settings' => array(
                    'theme' => 'dracula',
                    'mode' => 'javascript',
                ),
            ),

            array(
                'id' => 'dej_custom_css',
                'type' => 'code_editor',
                'title' => __('کد های سی اس اس', 'dejavo'),
                'subtitle' => '<strong>CSS Editor</strong>',
                'settings' => array(
                    'theme' => 'dracula',
                    'mode' => 'css',
                ),
            ),

        )
    ));

//
// درون ریزی / برون بری
//
    CSF::createSection($prefix, array(
        'title' => __('درون ریزی / برون بری', 'dejavo'),
        'icon' => 'dej-shield-check',
        'fields' => array(

            array(
                'type' => 'backup',
            ),

        )
    ));



    function get_el_mega_menu()
    {
        $el_mega_menu = array();
        $el_mega_menus = get_posts(array('posts_per_page' => -1, 'post_type' => 'dejavo_mega_menus'));
        foreach ($el_mega_menus as $value) {
            $el_mega_menu[$value->ID] = $value->post_title;
        }
        return $el_mega_menu;
    }

    $el_mega_menus = get_el_mega_menu();


    $prefix = 'dej_menu_options';

    CSF::createNavMenuOptions($prefix, array(
        'data_type' => 'serialize',
    ));
    CSF::createSection($prefix, array(
        'fields' => array(

            array(
                'id' => 'menu-icon',
                'class' => 'font_menu_icon',
                'type' => 'icon',
                'title' => __('آیکن', 'dejavo'),
            ),

            array(
                'id' => 'menu-icon-color',
                'type' => 'color',
                'title' => __('رنگ آیکن', 'dejavo'),
            ),
            array(
                'id' => 'img_menu_icon',
                'class' => 'img_menu_icon',
                'type' => 'media',
                'title' => __('یا آپلود تصویر ایکن', 'dejavo'),
                'desc' => __('اولویت نمایش با ایکن میباشد.', 'dejavo'),
                'library' => 'image',
            ),
            array(
                'id' => 'menu_type_display',
                'class' => 'menu_type_display',
                'type' => 'select',
                'placeholder' => '',
                'title' => __('نوع نمایش', 'dejavo'),
                'options' => array(
                    'simple_menu' => __('کلاسیک', 'dejavo'),
                    'mega_menu_2le' => __('مگامنو', 'dejavo'),
                    'mega_menu_3le' => __('تب منو', 'dejavo'),
                    'mega_menu_el' => __('مگامنو المنتوری', 'dejavo'),
                ),
            ),
            array(
                'id' => 'display_tabs',
                'class' => 'display_tabs',
                'type' => 'select',
                'placeholder' => '',
                'title' => __('نوع نمایش تب ها', 'dejavo'),
                'dependency' => array('menu_type_display', '==', 'mega_menu_3le'),
                'options' => array(
                    'dej-side-tab' => __('تب عمودی', 'dejavo'),
                    'dej-top-tab' => __('تب افقی', 'dejavo'),
                ),
            ),

            array(
                'id' => 'choose_elementor_mega_menu',
                'class' => 'mega_menu_el',
                'type' => 'select',
                'dependency' => array('menu_type_display', '==', 'mega_menu_el'),
                'title' => __('مگامنو المنتوری', 'dejavo'),
                'placeholder' => __('انتخاب مگامنو', 'dejavo'),
                'chosen' => false,
                'default' => '',
                'options' => $el_mega_menus,

            ),

            array(
                'id' => 'show_separator_menu',
                'class' => 'show_separator_menu',
                'type' => 'switcher',
                'title' => __('جدا کننده منو', 'dejavo'),
                'text_width' => 90,
                'default' => false
            ),

            array(
                'id' => 'mega_menu_bg',
                'type' => 'media',
                'title' => __('تصویر بک گراند', 'dejavo'),
                'desc' => __('طول و عرض پیشنهادی تصویر 250 پیکسل', 'dejavo'),
                'library' => 'image',
                'dependency' => array('menu_type_display', '==', 'mega_menu_2le'),
            ),
            array(
                'id' => 'mega_menu_bg_size',
                'type' => 'text',
                'title' => __('طول و عرض تصویر با درج px اضافه شود', 'dejavo'),
                'desc' => __('این سایز در صورت اضافه کردن تصویر بک گراند فراخوان میشود.', 'dejavo'),
                'dependency' => array('menu_type_display', '==', 'mega_menu_2le'),
            ),
        )
    ));


    $dej_page_opt = 'dej_page_options';
    CSF::createMetabox($dej_page_opt, array(
        'title' => __('تنظیمات صفحه', 'dejavo'),
        'post_type' => 'page',
    ));

    CSF::createSection($dej_page_opt, array(
        'title' => __('تنظیمات اصلی', 'dejavo'),
        'fields' => array(
            array(
                'id' => 'dej_show_header',
                'type' => 'switcher',
                'title' => __('نمایش سربرگ ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),

            array(
                'id' => 'dej_show_footer',
                'type' => 'switcher',
                'title' => __('نمایش پابرگ ؟', 'dejavo'),
                'default' => true,
                'text_width' => 90,
            ),
        )
    ));

//------------------------------------------- تنظیمات دسته بندی ---------------------------//


    $cat_opt = 'dej_category_options';
    CSF::createTaxonomyOptions($cat_opt, array(
        'taxonomy' => ['category', 'product_cat', 'product_tag', 'post_tag'],
        'data_type' => 'serialize',
    ));
    CSF::createSection($cat_opt, array(
        'fields' => array(

            array(
                'id' => 'dej_cat_color',
                'type' => 'color',
                'title' => __('رنگ دسته', 'dejavo'),
            ),
            array(
                'id' => 'dej_cat_desc',
                'type' => 'wp_editor',
                'title' => __('توضیحات', 'dejavo'),
                'sanitize' => false,
            ),

        )
    ));

//------------------------------------------- تنظیمات دسته بندی ---------------------------//

    $dej_product_opt = 'dej_product_options';
    CSF::createMetabox($dej_product_opt, array(
        'title' => esc_html__('تنظیات محصول', 'dejavo'),
        'post_type' => 'product',
    ));

    $dej_labels = dej_opt('dej_labels');
    $dej_labels_info = [];
    if (!empty($dej_labels)) {
        foreach ($dej_labels as $label) {
            $dej_labels_info[] = $label['title'];

        }
    }
    CSF::createSection($dej_product_opt, array(
        'title' => esc_html__('لیبل ها', 'dejavo'),
        'fields' => array(

            array(
                'id' => 'dej_product_lbl_selected',
                'type' => 'checkbox',
                'title' => esc_html__('انتخاب لیبل ها', 'dejavo'),
                'options' => $dej_labels_info,
            ),
        )
    ));
    CSF::createSection($dej_product_opt, array(
        'title' => esc_html__('اعلان ها', 'dejavo'),
        'fields' => array(

            array(
                'id' => 'dej_product_warranty',
                'type' => 'text',
                'title' => __('گارانتی', 'dejavo'),
            ),
            array(
                'id' => 'dej_product_send_duration',
                'type' => 'text',
                'title' => __('مدت زمان ارسال', 'dejavo'),
            ),
            array(
                'id' => 'dej_product_alarm',
                'type' => 'textarea',
                'title' => __('هشدار', 'dejavo'),
            ),
        )
    ));
    CSF::createSection($dej_product_opt, array(
        'title' => esc_html__('عنوان انگلیسی', 'dejavo'),
        'fields' => array(

            array(
                'id' => 'dej_product_en_title',
                'type' => 'text',
                'title' => __('عنوان', 'dejavo'),
            ),

        )
    ));
    CSF::createSection($dej_product_opt, array(
        'title' => esc_html__('ویدیو', 'dejavo'),
        'fields' => array(
            array(
                'id' => 'dej_product_video_link',
                'type' => 'text',
                'title' => __('به صورت لینک', 'dejavo'),
            ),
            array(
                'id' => 'dej_product_video_code',
                'type' => 'code_editor',
                'sanitize' => false,
                'title' => __('به صورت کد اسکریپت', 'dejavo'),
            ),

        )
    ));
    CSF::createSection($dej_product_opt, array(
        'title' => esc_html__('تب سفارشی 1', 'dejavo'),
        'fields' => array(

            array(
                'id' => 'dej_custom_tab_title',
                'type' => 'text',
                'title' => __('عنوان', 'dejavo'),
            ),
            array(
                'id' => 'dej_custom_tab_icon',
                'type' => 'icon',
                'title' => __('آیکن', 'dejavo'),
            ),
            array(
                'id' => 'dej_custom_tab_content',
                'type' => 'wp_editor',
                'title' => __('محتوا', 'dejavo'),
                'sanitize' => false,
            ),

        )
    ));

    CSF::createSection($dej_product_opt, array(
        'title' => esc_html__('تب سفارشی 2', 'dejavo'),
        'fields' => array(
            array(
                'id' => 'dej_custom_tab_title2',
                'type' => 'text',
                'title' => __('عنوان', 'dejavo'),
            ),
            array(
                'id' => 'dej_custom_tab_icon2',
                'type' => 'icon',
                'title' => esc_html__('آیکن', 'dejavo'),
            ),
            array(
                'id' => 'dej_custom_tab_content2',
                'type' => 'wp_editor',
                'title' => esc_html__('محتوا', 'dejavo'),
                'sanitize' => false,
            ),

        )
    ));

}


