<?php
defined('ABSPATH') || exit;
add_action('wp_head', 'dej_custom_style', 50);
function dej_custom_style()
{
    $dejavo_container_max = dej_opt('dej_max_width_wrapper', 1320);
    $dej_main_bg = dej_opt('dej_main_bg');
    $dej_main_dir = $dej_main_bg ? $dej_main_bg['background-gradient-direction'] : '';
    $main_dir = $dej_main_dir !== '' ? $dej_main_dir : '180deg';
    $body_color = dej_opt('dej_body_bg')['background-color'] ?? '';
    $main_c1 = $dej_main_bg['background-color'] !== '' ? $dej_main_bg['background-color'] : '#8929f0';
    $main_c2 = $dej_main_bg['background-gradient-color'] !== '' ? $dej_main_bg['background-gradient-color'] : '#8929f0';
    $dej_second_bg = dej_opt('dej_second_bg', '');
    $second_dir = $dej_second_bg['background-gradient-direction'] !== '' ? $dej_second_bg['background-gradient-direction'] : '180deg';
    $second_c1 = $dej_second_bg['background-color'] !== '' ? $dej_second_bg['background-color'] : '#31a622';
    $second_c2 = $dej_second_bg['background-gradient-color'] !== '' ? $dej_second_bg['background-gradient-color'] : '#147211';
    $show_mobile_bottom_nav = dej_opt('show_mobile_bottom_nav', 1);
    $show_mobile_top_nav = dej_opt('show_mobile_top_nav', 1);
    $dej_custom_css = dej_opt('dej_custom_css', '');
    $body_font = dej_opt('dej_body_font')['font-family'] ?? 'IranYekan';
    $heading_font = dej_opt('dej_heading_font')['font-family'] ?? 'IranSans';
    ?>
    <style type="text/css">
        :root {
            --dej-wrapper-max-width: <?= $dejavo_container_max ?>px;
            --dej-bg1: linear-gradient(<?php echo $main_dir . ',' . $main_c1 .',' . $main_c2 ?>);
            --dej-bg2: linear-gradient(<?php echo $second_dir . ',' . $second_c1 .',' . $second_c2 ?>);
            --body-bg: <?= $body_color ?>;
        <?php if ($body_font) { echo '--dej-font1:' . $body_font . ', sans-serif !important;';}
         if ($heading_font) { echo '--dej-font2:' . $heading_font . ', sans-serif !important;';} ?>
        }
        @media (max-width: <?= $dejavo_container_max ?>px) {
            .dej_profile_header, .dej_profile_wrapper {
                margin: auto 15px;
            }
            .DejavoSA-product {
                padding: 0 10px;
            }
        }
        <?php if (dej_opt('active_sticky_nav') and is_admin_bar_showing()) { ?>
        @media (min-width: 992px) {
            .dej_sticky_menu {
                top: 32px !important;
            }
        }
        <?php
        } ?>
        @media (max-width: 600px) {
        <?php if ($show_mobile_bottom_nav and dej_is_mobile()) { ?>
            .mobile_bottom_nav {
                display: grid;
                opacity: 1;
                visibility: visible;
            }
            #DejavoFC-count, .BackToTop, .DejavoSA-wrapper {
                visibility: hidden;
                opacity: 0;
                display: none
            }

        <?php }  if ($show_mobile_top_nav and dej_is_mobile()) { ?>
            .mobile_top_nav {
                display: grid;
                opacity: 1;
                visibility: visible;
            }
            .elementor-location-header {
                visibility: hidden;
                opacity: 0;
                display: none
            }
            .mobile_sticky {
                height: auto !important;
            }

        <?php }  ?>
        }
        <?php if ($dej_custom_css) { echo $dej_custom_css; } ?>
    </style>
    <?php
}

add_action('wp_footer', 'dej_custom_js', 200);
function dej_custom_js()
{
    $dej_custom_js = dej_opt('dej_custom_js', '');
    if ($dej_custom_js) { ?>
        <script type="text/javascript">
            <?= $dej_custom_js ?>
        </script>
        <?php
    }
}

function dej_swiper_js(){ ?>
    <script type="text/javascript">
        function dej_initSwipers(selector = '.dej_swiper') {
            let swipers = document.querySelectorAll(selector)
            swipers.forEach(swiper => {
                let optionsData = swiper.dataset.swiper ? JSON.parse(swiper.dataset.swiper) : {};
                new Swiper(swiper, optionsData);
            })
        }
       dej_initSwipers();
    </script>
    <?php
}
add_action( 'wp_footer', 'dej_swiper_js',1 );
function dej_login_logo_url()
{
    return home_url();
}

function dej_login_logo()
{
    $logo = dej_opt('dej_main_logo');
    ?>
    <style type="text/css">
        body.login div#login h1 a {
            background-image: url('<?= $logo ?>') !important;
            width: auto !important;
            height: 80px !important;
            background-size: contain !important;
        }

        .login form#loginform {
            border: 6px solid #c3c4c785 !important;
            border-radius: 10px !important;
        }
    </style>
    <?php
}

add_action('login_enqueue_scripts', 'dej_login_logo');
add_filter('login_headerurl', 'dej_login_logo_url');


function dej_text_shorter2 (){
    if (dej_woo_activated() and dej_opt('show_text_shorter', 1) and is_product()) {
        $max_height = dej_opt('max_height_text_shorter', 180);
        ?>
        <script type="text/javascript">
            jQuery(document).ready((function ($) {
                function dej_text_shorter2(el, max_height) {
                    let element = $(el)
                    let text_height = element.innerHeight();

                    if (text_height > max_height) {

                        element.css('max-height', max_height + 'px');

                        element.append('<button class="short_text_btn">' +
                            '<span class="outer"><span>' + Dejavo_vars.see_more + ' </span> <i class="dej-angle-double-small-down"></i>' +
                            '</span></button>');
                    }

                    $(document).on('click touch',el + ' .short_text_btn', function() {
                        $(this).parents(el).toggleClass('show');
                        if ($(this).parents(el).hasClass('show')) {
                            $(this).find('.outer span').text(Dejavo_vars.shorter_txt);
                        } else {
                            $(this).find('.outer span').text(Dejavo_vars.see_more);
                        }
                    });

                }

                dej_text_shorter2('.woocommerce-product-details__short-description', <?= $max_height ?>);
            }));
        </script>
        <style type="text/css">
            .woocommerce-product-details__short-description.show {
                max-height: 100% !important;
                padding-bottom: 35px;
                overflow: hidden;
            }
            .woocommerce-product-details__short-description:not(.show) {
                overflow: hidden;
                padding-bottom: 0;
            }
        </style>

        <?php
    }
}
add_action('wp_footer', 'dej_text_shorter2', 20);