<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme Dejavo
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 *
 * Depending on your implementation, you may want to change the include call:
 *
 * Parent Theme:
 * require_once get_template_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Child Theme:
 * require_once get_stylesheet_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Plugin:
 * require_once dirname( __FILE__ ) . '/path/to/class-tgm-plugin-activation.php';
 */
require_once DEJ_INC . 'tgm/class-tgm-plugin-activation.php';

add_action('tgmpa_register', 'dejavo_register_required_plugins');

/**
 * Register the required plugins for this theme.
 *
 * In this example, we register five plugins:
 * - one included with the TGMPA library
 * - two from an external source, one from an arbitrary source, one from a GitHub repository
 * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
 *
 * The variables passed to the `tgmpa()` function should be:
 * - an array of plugin arrays;
 * - optionally a configuration array.
 * If you are not changing anything in the configuration array, you can remove the array and remove the
 * variable from the function call: `tgmpa( $plugins );`.
 * In that case, the TGMPA default settings will be used.
 *
 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
 */
function dejavo_register_required_plugins()
{
    /*
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(

        array(
            'name' => __('ووکامرس', 'dejavo'),
            'slug' => 'woocommerce',
            'required' => true,
        ),
        array(
            'name' => __('المنتور', 'dejavo'),
            'slug' => 'elementor',
            'required' => true,
        ),
        array(
            'name' => __('المنتور پرو', 'dejavo'), // The plugin name.
            'slug' => 'elementor-pro', // The plugin slug (typically the folder name).
            'source' => 'https://avinasite.ir/up/elementor-pro.zip', // The plugin source.
            'required' => true,
        ),
        array(
            'name' => __('مدیریت هوشمند راست چین', 'dejavo'),
            'slug' => 'RTL-CareUnit',
            'version' => '2.5.2',
            'source' => 'https://files.rtl-theme.com/plugins/rtlRsm/rtlRsm.zip',
            'required' => true,
        ),
        array(
            'name' => __('چند فروشندگی دکان', 'dejavo'),
            'slug' => 'dokan-lite',
            'required' => false,
        ),

        array(
            'name' => __('کیف پول', 'dejavo'),
            'slug' => 'woo-wallet',
            'required' => false,
        ),
        array(
            'name' => __('ووکامرس فارسی', 'dejavo'),
            'slug' => 'persian-woocommerce',
            'required' => false,
        ),

    );

    /*
     * Array of configuration settings. Amend each line as needed.
     *
     * TGMPA will start providing localized text strings soon. If you already have translations of our standard
     * strings available, please help us make TGMPA even better by giving us access to these translations or by
     * sending in a pull-request with .po file(s) with the translations.
     *
     * Only uncomment the strings in the config array if you want to customize the strings.
     */
    $config = array(
        'id' => 'dejavo',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu' => 'tgmpa-install-plugins', // Menu slug.
        'parent_slug' => 'themes.php',            // Parent menu slug.
        'capability' => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices' => true,                    // Show admin notices or not.
        'dismissable' => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg' => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => true,                   // Automatically activate plugins after installation or not.
        'message' => '',                      // Message to output right before the plugins table.


        'strings' => array(
            'page_title' => __('افزونه های مورد نیاز را نصب کنید', 'dejavo'),
            'menu_title' => __('افزونه های مورد نیاز', 'dejavo'), // translators: %s: plugin name.
            'installing' => __('در حال نصب افزونه: %s', 'dejavo'),
            // translators: %s: plugin name. * /
            'updating' => __('در حال به روز رسانی افزونه: %s', 'dejavo'),
            'oops' => __('مشکلی با API افزونه پیش آمد.', 'dejavo'),
            'notice_can_install_required' => _n_noop(
            // translators: 1: plugin name(s). * /
                'قالب دژاوو به این افزونه نیاز دارد : %1$s.',
                'قالب دژاوو به این افزونه ها نیاز دارد : %1$s.',
                'dejavo'
            ),
            'notice_can_install_recommended' => _n_noop(
            // translators: 1: plugin name(s). * /
                'قالب دژاوو این افزونه را توصیه می کند: %1$s.',
                'قالب دژاوو این افزونه ها را توصیه می کند: %1$s.',
                'dejavo'
            ),
            'notice_ask_to_update' => _n_noop(
            // translators: 1: plugin name(s). * /
                'افزونه زیر برای اطمینان از حداکثر سازگاری با این موضوع باید به آخرین نسخه خود به روز شود: %1$s.',
                'Tافزونه های زیر باید به آخرین نسخه خود به روز شوند تا از حداکثر سازگاری با این موضوع اطمینان حاصل شود: %1$s.',
                'dejavo'
            ),
            'notice_ask_to_update_maybe' => _n_noop(
            /// translators: 1: plugin name(s). * /
                'یک بروز رسانی برای آن موجود است : %1$s.',
                'بروز رسانی برای آن موجود است : %1$s.',
                'dejavo'
            ),
            'notice_can_activate_required' => _n_noop(
            // translators: 1: plugin name(s). * /
                'این افزونه مورد نیاز در حال حاضر غیر فعال است : %1$s.',
                'این افزونه های مورد نیاز در حال حاضر غیر فعال اند : %1$s.',
                'dejavo'
            ),
            'notice_can_activate_recommended' => _n_noop(
            // translators: 1: plugin name(s). * /
                'این افزونه پیشنهادی در حال حاضر غیر فعال است : %1$s.',
                'این افزونه های پیشنهادی در حال حاضر غیر فعال اند : %1$s.',
                'dejavo'
            ),
            'install_link' => _n_noop(
                'شروع نصب افزونه ',
                'شروع نصب افزونه ها',
                'dejavo'
            ),
            'update_link' => _n_noop(
                'شروع بروزرسانی',
                'بروز رسانی افزونه ها را شروع کنید',
                'dejavo'
            ),
            'activate_link' => _n_noop(
                'شروع فعالسازی',
                'شروع به فعالسازی افزونه ها کنید',
                'dejavo'
            ),
            'return' => __('بازگشت برای نصب افزونه مورد نیاز', 'dejavo'),
            'plugin_activated' => __('افزونه با موفقیت فعال شد.', 'dejavo'),
            'activated_successfully' => __('افزونه با موفقیت فعال شد : ', 'dejavo'),
            // translators: 1: plugin name. * /
            'plugin_already_active' => __('هیچ اقدامی صورت نگرفت. افزونه %1$s قبلاً فعال بود.', 'dejavo'),
            // translators: 1: plugin name. * /
            'plugin_needs_higher_version' => __('افزونه فعال نشد یک نسخه بالاتر از %s برای این قالب مورد نیاز است. لطفا افزونه را به روز کنید.', 'dejavo'),
            // translators: 1: dashboard link.
            'complete' => __('همه افزونه ها با موفقیت نصب و فعال شدند. %1$s', 'dejavo'),
            'dismiss' => __('این اطلاعیه را رد کنید', 'dejavo'),
            'notice_cannot_install_activate' => __('یک یا چند افزونه مورد نیاز یا توصیه شده برای نصب، به روز رسانی یا فعال سازی وجود دارد.', 'dejavo'),
            'contact_admin' => __('لطفا برای راهنمایی با مدیر این سایت تماس بگیرید.', 'dejavo'),

            'nag_type' => '', // Determines admin notice type - can only be one of the typical WP notice classes, such as 'updated', 'update-nag', 'notice-warning', 'notice-info' or 'error'. Some of which may not work as expected in older WP versions.
        ),

    );

    tgmpa($plugins, $config);
}
