<?php
/**
 * exit()if accessed directly
 */
defined( 'ABSPATH' ) || exit( );

class DejTicketMessage {

	/**
	 * Message
	 * @var
	 */
	protected $_messages;

	/**
	 * Alert types
	 */
	const ERROR = 1;
	const SUCCESS = 2;
	const WARNING = 3;
	const INFO = 4;

	/**
     * Save error
	 * @var
	 */
	public static $has_error;

	/**
	 * Add message to session array
	 *
	 * @param string $message
	 * @param int $type
	 */
	public static function add_message( $message = "", $type = self::SUCCESS, $id = '' ) {
		if ( ! isset( $_SESSION['dejst']['messages'] ) ) {
			$_SESSION['dejst']['messages'] = array();
		}
		if ( $type == self::ERROR ) {
			self::$has_error = true;
		}
		$_SESSION['dejst']['messages'][] = array(
			'body' => $message,
			'type' => $type,
			'id' => $id,
		);
	}

	/**
	 * Show message
	 */
	public static function show_message() {
		if ( isset( $_SESSION['dejst']['messages'] ) && ! empty( $_SESSION['dejst']['messages'] ) ) {
			foreach ( $_SESSION['dejst']['messages'] as $message ) {
				$alert_class = self::get_alert_type( $message['type'] )
				?>
                <div class="<?php echo is_admin() ? 'notice is-dismissible' : 'dejst-alert'; ?> <?php echo $alert_class; ?>">
                    <p><?php echo $message['body']; ?></p>
                    <?php if (isset($message['id']) and !empty($message['id']) ) {
                    $redirect_to = trailingslashit(dejst_get_ticket_page_url()) . '?action=reply&ticket_id=' . $message['id'];
                    ?><a href="<?= $redirect_to ?>">مشاهد تیکت</a> <?php } ?>
                </div>
				<?php
			}
			self::empty_bag();
		}
	}

	/**
	 * Get alert type
	 *
	 * @param $type
	 *
	 * @return string
	 */
	public static function get_alert_type( $type ) {
		switch ( $type ) {
			case self::SUCCESS:
				if ( is_admin() ) {
					return 'notice-success';
				} else {
					return 'success';
				}
				break;
			case self::ERROR:
				if ( is_admin() ) {
					return 'notice-error';
				} else {
					return 'danger';
				}
				break;
			case self::WARNING;
				if ( is_admin() ) {
					return 'notice-warning';
				} else {
					return 'warning';
				}
				break;
			case self::INFO:
				if ( is_admin() ) {
					return 'notice-info';
				} else {
					return 'info';
				}
				break;

		}
	}

	/**
	 * Make session and $has_error variable empty for next use
	 */
	public static function empty_bag() {
		$_SESSION['dejst']['messages'] = [];
		self::$has_error              = false;
	}
}