<?php
/**
 * exit()if accessed directly
 */
defined( 'ABSPATH' ) || exit( );

class DEJST_Remove_Files {

	/**
	 * Remove files period
	 * @var null
	 */
	private $period;

	/**
	 * DEJST_Remove_Files constructor.
	 */
	public function __construct() {
		$period       =  86400 * 7;
		$this->period = time() - $period;
	}

	/**
	 * Retrieve all old ticket post id
	 * @return array|null|object
	 */
	private function get_post_ids() {
		if ( ! intval( $this->period ) ) {
			return null;
		}

		global $wpdb;

		$post_ids = $wpdb->get_results( $wpdb->prepare( "
		SELECT `post_id` FROM `$wpdb->postmeta`
		WHERE `meta_key` = '_dejst_ticket_last_reply_date' 
		AND `meta_value` < %d", $this->period ) );

		$ids = array();
		if ( count( $post_ids ) ) {
			foreach ( $post_ids as $id ) {
				array_push( $ids, $id->post_id );
			}
			return array_unique($ids);
		}

		return null;
	}

	/**
	 * Retrieve all old ticket attachment files
	 * @return array|null
	 */
	private function get_ath_files() {
		$post_ids = $this->get_post_ids();
		if ( ! $post_ids ) {
			return null;
		}

		global $wpdb;

		$in = '(' . implode( ',', $post_ids ) . ')';

		$ath_files = $wpdb->get_results( "
		SELECT `meta_value` FROM `$wpdb->postmeta`
		WHERE `post_id` IN {$in} 
		AND `meta_key` = '_dejst_ticket_ath_file'" );



		$files = [];
		if ( count( $ath_files ) ) {
			foreach ( $ath_files as $file ) {
				array_push( $files, $file->meta_value );
			}
			return $files;
		}

		return null;
	}

	/**
	 * Retrieve all old reply ticket
	 * @return array|null
	 */
	private function get_replies() {
		$post_ids = $this->get_post_ids();
		if ( ! $post_ids ) {
			return null;
		}

		global $wpdb;

		$in = '(' . implode( ',', $post_ids ) . ')';

		$ticket_replies = $wpdb->get_results( "
		SELECT `meta_value` FROM `$wpdb->postmeta`
		WHERE `post_id` IN {$in} 
		AND `meta_key` LIKE '_dejst_ticket_reply%'" );

		$replies = array();
		if ( count( $ticket_replies ) ) {
			foreach ( $ticket_replies as $ticket_reply ) {
				$value = unserialize( $ticket_reply->meta_value );
				array_push( $replies, $value );
			}

			return $replies;
		}

		return null;
	}

	/**
	 * Retrieve all old reply ticket attachment files
	 * @return array|null
	 */
	private function get_reply_ath_files() {
		$ticket_replies = $this->get_replies();

		$ath_files = array();
		if ( $ticket_replies ) {
			foreach ( $ticket_replies as $ticket_reply ) {
				if ( isset($ticket_reply['ath_file']) ) {
					array_push( $ath_files, $ticket_reply['ath_file'] );
				}
			}

			if ( count( $ath_files ) ) {
				return $ath_files;
			}

			return null;
		}

		return null;
	}

	/**
	 * Retrieve all old files
	 * @return array
	 */
	public function get_all_files() {
		$files = array();

		if ( $this->get_ath_files() ) {
			foreach ( $this->get_ath_files() as $file ) {
                array_push( $files, $file );
			}
		}
		if ( $this->get_reply_ath_files() ) {
			foreach ( $this->get_reply_ath_files() as $file ) {
                array_push( $files, $file );
			}
		}
		return $files;
	}

	/**
	 * Delete old meta field
	 */

    public function all_ticket_replies(  ) {
        global $wpdb;
        $replies = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `$wpdb->postmeta` WHERE `meta_key` LIKE '_dejst_ticket_reply%'" ) );
        $values = [];
        if ( sizeof( $replies ) ) {
            foreach ( $replies as $reply ) {
                if ( isset( $reply->meta_value ) ) {
                    $arr = unserialize($reply->meta_value);
                    $arr['key'] = $reply->meta_key;
                    $arr['id'] = $reply->post_id;
                    $values[] = $arr;

                }
            }
        }
        return $values;
    }
	public function delete_meta() {
		$post_ids = $this->get_post_ids();
		if ( ! $post_ids ) {
			return;
		}
		foreach ( $post_ids as $post_id ) {
			delete_post_meta( $post_id, '_dejst_ticket_ath_file' );
		}

        $ticket_replies = $this->all_ticket_replies();

        if ( $ticket_replies ) {
            foreach ( $ticket_replies as $ticket_reply ) {
                if ( isset($ticket_reply['ath_file']) ) {
                    unset($ticket_reply['ath_file']);
                    update_post_meta($ticket_reply['id'], $ticket_reply['key'], $ticket_reply);
                }
            }

        }




	}

	/**
	 * Remove old files
	 */
	public function remove_files() {


        require_once ABSPATH . 'wp-admin/includes/file.php';

        $ath_files = $this->get_ath_files();
		if ( $ath_files ) {
			foreach ( $ath_files as $ath_file ) {

                $path = parse_url($ath_file, PHP_URL_PATH);
                $fullPath = get_home_path() . $path;
				unlink( $fullPath );
			}
		}

		$reply_ath_files = $this->get_reply_ath_files();
		if ( $reply_ath_files ) {
			foreach ( $reply_ath_files as $reply_ath_file ) {
                $path2 = parse_url($reply_ath_file, PHP_URL_PATH);
                $fullPath2 = get_home_path() . $path2;
				unlink( $fullPath2 );
			}
		}
	}
}
