<?php defined( 'ABSPATH' ) || exit();

add_action( 'admin_menu', 'dejst_setting_menu' );
function dejst_setting_menu() {
	add_submenu_page(
		'edit.php?post_type=ticket',
        __('فایل ها', 'dejavo'),
        __('فایل ها', 'dejavo'),
		'manage_options',
		'dejst-files',
		'dejst_files_menu_page'
	);
}
function dejst_files_menu_page() { ?>
    <div class="wrap">
        <h2><?= __('فایل های که از یک هفته پیش به قبل در تیکت ها آپلود شده اند', 'dejavo') ?></h2>
		<?php  if ( isset( $_POST['dejst-remove-files-options'] ) ) {
            if ( ! isset( $_POST['dejst_remove_files_nonce'] ) || ! wp_verify_nonce( $_POST['dejst_remove_files_nonce'], 'dejst_remove_files' ) ) {
                exit( __('خطایی رخ داده است مجدد تلاش کنید', 'dejavo') );
            } else {
                $remove_files = new DEJST_Remove_Files();
                $remove_files->remove_files();
                $remove_files->delete_meta();
                DejTicketMessage::add_message( __('فایل‌ها با موفقیت حذف گردیدند.', 'dejavo') );
            }
        }
        DejTicketMessage::show_message();
        $remove_files = new DEJST_Remove_Files();
        $all_files    = $remove_files->get_all_files();

        if ( count( $all_files ) ) {
            $i = 0; ?>
            <div class="dejst-notice update-message notice inline notice-warning notice-alt" style="border: 1px solid #ffb900; border-right-width: 4px;">
            <p><?= __('پیشنهاد میشود قبل از حذف فایل ها حتما از پوشه uploads یک نسخه پشتیبان تهیه نمایید. فایل های حذف شده قابل بازگردانی نیستند.', 'dejavo') ?></p>
            </div>
            <div class="dejst-files-wrapper">
            <?php foreach ( $all_files as $file ) {
                $i ++;
                echo '<p>' . $i . ' - ' . $file . '</p>';
            } ?>
            </div>
            <form method="post">
            <?php wp_nonce_field( 'dejst_remove_files', 'dejst_remove_files_nonce' );
            submit_button(  __('حذف فایل‌ها', 'dejavo'), 'primary', 'dejst-remove-files-options', true ); ?>
            </form>
       <?php } else {
            echo '<p>' . __('موردی یافت نشد!', 'dejavo') . '</p>';
        }  ?>
    </div>
	<?php
}
