<?php defined( 'ABSPATH' ) || exit();

add_action( 'init', 'dejst_register_pre_answer_post_type' );
add_action( 'admin_menu', 'dejst_pre_answer_submenu_page' );
add_action( 'pre_get_posts', 'dejst_filter_pre_answer_posts' );
add_action( 'current_screen', 'dejst_restrict_edit_pre_answer_post' );

function dejst_register_pre_answer_post_type() {
	$labels = array(
		'name'               => __('پاسخ آماده', 'dejavo'),
		'singular_name'      => __('پاسخ آماده', 'dejavo'),
		'menu_name'          => __('پاسخ آماده‌ها', 'dejavo'),
		'name_admin_bar'     => __('پاسخ آماده', 'dejavo'),
		'add_new'            => __('پاسخ آماده جدید', 'dejavo'),
		'add_new_item'       => __('اضافه کردن پاسخ آماده جدید', 'dejavo'),
		'new_item'           => __('پاسخ آماده جدید', 'dejavo'),
		'edit_item'          => __('ویرایش پاسخ آماده', 'dejavo'),
		'view_item'          => __('نمایش پاسخ آماده', 'dejavo'),
		'all_items'          => __('همه پاسخ آماده‌ها', 'dejavo'),
		'search_items'       => __('جستجوی پاسخ آماده‌ها', 'dejavo'),
		'parent_item_colon'  => __('والد پاسخ آماده‌ها', 'dejavo'),
		'not_found'          => __('پاسخ آمادهی یافت نشد!', 'dejavo'),
		'not_found_in_trash' => __('پاسخ آمادهی در زباله دان یافت نشد!', 'dejavo'),
	);
	$args   = array(
		'labels'              => $labels,
		'description'         => __('پاسخ آماده‌ها', 'dejavo'),
		'public'              => true,
		'publicly_queryable'  => true,
		'show_ui'             => true,
		'show_in_menu'        => false,
		'show_in_nav_menus'        => false,
		'query_var'           => true,
		'rewrite'             => array( 'slug' => 'pre-answer' ),
		'capability_type'     => 'post',
		'has_archive'         => true,
		'hierarchical'        => true,
		'menu_position'       => 25,
		'supports'            => array( 'title', 'editor' ),
		'menu_icon'           => 'dashicons-list-view',
		'taxonomies'          => array( '' ),
		'exclude_from_search' => true,
	);
	register_post_type( 'pre-answer', $args );
}

function dejst_pre_answer_submenu_page() {
	add_submenu_page(
		'edit.php?post_type=ticket',
        __('پاسخ آماده‌ها', 'dejavo'),
        __('پاسخ آماده‌ها', 'dejavo'),
		'edit_posts',
		'edit.php?post_type=pre-answer',
		''
	);
}

/**
 * Filter pre-answer posts by author
 * Restrict users to access others posts
 *
 * @param $query
 */
function dejst_filter_pre_answer_posts( $query ) {
	if ( is_admin() ) {
		$screen = get_current_screen();
		if ( $screen ) {
			if ( $screen->base == 'edit' && $screen->post_type == 'pre-answer' ) {
				$query->set( 'author', get_current_user_id() );
			}
		}
	}
}

/**
 * Restrict users to edit others posts
 */
function dejst_restrict_edit_pre_answer_post() {
	if ( is_admin() ) {
		$screen = get_current_screen();
		if ( $screen->base == 'post' && $screen->post_type == 'pre-answer' ) {
			if ( isset( $_GET['post'] ) && ctype_digit( $_GET['post'] ) ) {
				$post_author_id = get_post_field( 'post_author', $_GET['post'] );
				if ( $post_author_id != get_current_user_id() ) {
					wp_die( __('شما مجوز دسترسی به این صفحه را ندارید!', 'dejavo') );
				}
			}
		}
	}
}