<?php defined( 'ABSPATH' ) || exit();

add_action( 'init', 'dejst_register_ticket_type_tax' );
function dejst_register_ticket_type_tax() {
	$labels = array(
		'name'              => __('بخش ها', 'dejavo'),
		'singular_name'     => __('بخش ها', 'dejavo'),
		'search_items'      => __('جستجوی بخش', 'dejavo'),
		'all_items'         => __('همه بخش ها', 'dejavo'),
		'parent_item'       => __('بخش مادر', 'dejavo'),
		'parent_item_colon' => __('بخش مادر :', 'dejavo'),
		'edit_item'         => __('ویرایش بخش', 'dejavo'),
		'update_item'       => __('به روز رسانی بخش', 'dejavo'),
		'add_new_item'      => __('اضافه کردن بخش جدید', 'dejavo'),
		'new_item_name'     => __('نام بخش جدید', 'dejavo'),
		'menu_name'         => __('بخش ها', 'dejavo'),
		'not_found'         => __('بخشی یافت نشد!', 'dejavo'),
	);
	$args   = array(
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'public'            => true,
		'publicly_queryable' => true,
		'query_var'         => true,
		'rewrite'           => [ 'slug' => 'ticket-type' ],
        'default_term' => [
            'name' => __('فروش', 'dejavo'),
            'slug' => __('sell', 'dejavo'),
            'description' => __('پیشفرض', 'dejavo'),
        ],
	);
	register_taxonomy( 'ticket-type', array( 'ticket' ), $args );
}

