<?php defined( 'ABSPATH' ) || exit();
add_action( 'woocommerce_account_tickets_endpoint', 'dejst_woo_tickets_endpoint_content' );

function dejst_woo_tickets_endpoint_content() {
    if ( ! is_user_logged_in() ) {
        echo '<p class="dejst-alert dejst-alert-warning">' . __('برای ثبت تیکت بایستی وارد اکانت خود شوید!', 'dejavo') . '</p>';
        return false;
    }
    if ( isset( $_GET['action'] ) && ! empty( $_GET['action'] ) ) {
        if ( $_GET['action'] == 'new' ) {
            dejst_send_ticket();
            include( DEJST_TPL_PATH . 'user/new.php' );
        } elseif ( $_GET['action'] == 'reply' ) {
            dejst_reply_ticket();
            include( DEJST_TPL_PATH . 'user/reply.php' );
        }
    } else {
        include( DEJST_TPL_PATH . 'user/all.php' );
    }
}

function dejst_send_ticket() {
	if ( isset( $_POST['submit-new-ticket'] ) ) {
		if ( ! isset( $_POST['dejst_new_ticket_field'] ) || ! wp_verify_nonce( $_POST['dejst_new_ticket_field'], 'dejst_new_ticket' ) ) {
			exit( __('خطا . صفحه را مجدد بارگزاری کنید', 'dejavo') );
		} else {
			$ticket_title    = sanitize_text_field( $_POST['ticket-title'] );
			$ticket_type     = $_POST['ticket-type'];
			$product_id      = $_POST['product-id'];
			$product_title   = isset( $_POST['product-title'] ) ? $_POST['product-title'] : '';
			$ticket_priority = $_POST['ticket-priority'];
			$ticket_content  =  implode( "\n", array_map( 'sanitize_text_field', explode( "\n", $_POST['ticket-content'] ) ) );
            $ticket_content = preg_replace( '#<script(.*?)>(.*?)</script>#is', '', $ticket_content );


			if ( ! isset( $ticket_title ) || empty( $ticket_title ) ) {
				DejTicketMessage::add_message( __('لطفا عنوان تیکت را وارد کنید!', 'dejavo'), 1 );
                return;
			} else {
				if ( strlen( $ticket_title ) > 128 ) {
					DejTicketMessage::add_message( __('عنوان تیکت خیلی طولانی می‌باشد!', 'dejavo'), 1 );
                    return;
				}
			}

			if ( strlen( $product_title ) > 512 ) {
				DejTicketMessage::add_message( __('عنوان محصول خیلی طولانی می‌باشد!', 'dejavo'), 1 );
                return;
			}

			if ( ! isset( $ticket_content ) || empty( $ticket_content ) ) {
				DejTicketMessage::add_message( __('لطفا متن تیکت را وارد کنید!', 'dejavo'), 1 );
                return;
			} else {
				if ( strlen( strip_tags( $ticket_content ) ) > 8192 ) {
					DejTicketMessage::add_message( __('متن تیکت خیلی طولانی می‌باشد!', 'dejavo'), 1 );
                    return;
				}
			}


			$ticket_post = [
				'post_type'    => 'ticket',
				'post_title'   => $ticket_title,
				'post_content' => $ticket_content,
				'post_status'  => 'open',
				'post_author'  => get_current_user_id(),
				'meta_input'   => [
					'_dejst_ticket_priority'   => $ticket_priority,
					'_dejst_ticket_product_id' => $product_id ? $product_id : '',
				],
			];


			$term = get_term( $ticket_type, 'ticket-type' );

			if ( isset( $_FILES['ticket-file']['name'] ) && ! empty( $_FILES['ticket-file']['name'] ) ) {
				$file_url = dejst_handle_upload();
				if ( $file_url ) {
					$ticket_id = wp_insert_post( $ticket_post );
                    if ($ticket_id) {
                        if ($term) {
                            wp_set_object_terms($ticket_id, array($term->name), 'ticket-type');
                        }
                        update_post_meta($ticket_id, '_dejst_ticket_ath_file', $file_url);
                        update_post_meta($ticket_id, '_dejst_ticket_last_reply_date', current_time('U'));
                        // Send notification to user
                        do_action('dejst_send_email', $ticket_id);
                        do_action('dejst_send_sms', $ticket_id);
                        DejTicketMessage::add_message(  __('تیکت شما با موفقیت ارسال گردید.', 'dejavo'), 2, $ticket_id);
                    }
				}
			} else {
				$ticket_id = wp_insert_post( $ticket_post );
                if ($ticket_id) {
                    if ( $term ) {
                        wp_set_object_terms( $ticket_id, array( $term->name ), 'ticket-type' );
                    }
                    update_post_meta( $ticket_id, '_dejst_ticket_last_reply_date', current_time('U') );
                    // Send notification to user
                    do_action('dejst_send_email', $ticket_id);
                    do_action('dejst_send_sms', $ticket_id);
                    DejTicketMessage::add_message(  __('تیکت شما با موفقیت ارسال گردید.', 'dejavo'), 2, $ticket_id);
                }
			}
		}
	}
}


function dejst_reply_ticket() {
	if ( isset( $_POST['submit-reply-ticket'] ) ) {
		if ( ! isset( $_POST['dejst_reply_ticket_field'] ) || ! wp_verify_nonce( $_POST['dejst_reply_ticket_field'], 'dejst_reply_ticket' ) ) {
			exit( __('خطا . صفحه را مجدد بارگزاری کنید', 'dejavo') );
		} else {
			$ticket_id  = $_POST['ticket-id'];
            $ticket    = get_post( $ticket_id );
			if ( ! intval( $ticket_id ) || get_current_user_id() != $ticket->post_author ) {
				return false;
			}
			$ticket_content = implode( "\n", array_map( 'sanitize_text_field', explode( "\n", $_POST['ticket-content'] ) ) );
			// Sanitize content from script tag (XSS attack)
			$ticket_content = preg_replace( '#<script(.*?)>(.*?)</script>#is', '', $ticket_content );
			$ticket_content = stripslashes( $ticket_content );


			if ( ! isset( $ticket_content ) || empty( $ticket_content ) ) {
				DejTicketMessage::add_message(  __('لطفا متن تیکت را وارد کنید!', 'dejavo'), 1 );
                return false;
			} else {
				if ( strlen( strip_tags( $ticket_content ) ) > 8192 ) {
					DejTicketMessage::add_message(  __('متن تیکت خیلی طولانی می‌باشد!', 'dejavo'), 1 );
                    return false;
				}
			}


			$reply = array(
				'author_id' => get_current_user_id(),
				'content'   => $ticket_content,
				'date'      => current_time('U'),
			);


			$reply_count = dejst_get_reply_count( $ticket_id );

			if ( isset( $_FILES['ticket-file']['name'] ) && ! empty( $_FILES['ticket-file']['name'] ) ) {
				$file_url = dejst_handle_upload();
				if ( $file_url ) {
					wp_update_post( array(
						'ID'          => $ticket_id,
						'post_status'  => 'open',
					) );
					$reply['ath_file'] = $file_url;
					update_post_meta( $ticket_id, '_dejst_ticket_reply' . ( $reply_count + 1 ), $reply );
					update_post_meta( $ticket_id, '_dejst_ticket_last_reply_date', current_time('U') );
					DejTicketMessage::add_message(  __('پاسخ شما با موفقیت ارسال گردید.', 'dejavo'), 2 );

					// Send notification to user
					do_action( 'dejst_send_email', $ticket_id, true );
					do_action( 'dejst_send_sms',  $ticket_id, true );
				}
			} else {
				wp_update_post( array(
					'ID'          => $ticket_id,
                    'post_status'  => 'open',
				) );
				update_post_meta( $ticket_id, '_dejst_ticket_reply' . ( $reply_count + 1 ), $reply );
				update_post_meta( $ticket_id, '_dejst_ticket_last_reply_date', current_time('U') );
				DejTicketMessage::add_message(  __('پاسخ شما با موفقیت ارسال گردید.', 'dejavo'), 2 );

				// Send notification to user

                do_action('dejst_send_email', $ticket_id, true);
                do_action('dejst_send_sms', $ticket_id, true);

			}
		}
	}
}


function dejst_handle_upload() {
	// Change upload directory
	add_filter( 'upload_dir', 'dejst_alter_the_upload_dir' );

	if ( ! function_exists( 'wp_handle_upload' ) ) {
		require_once( ABSPATH . 'wp-admin/includes/file.php' );
	}

	$uploaded_file = $_FILES['ticket-file'];

	$max_size = dej_opt( 'dej_ticket_file_size', 2 );
	if ( $max_size ) {
		if ( ( $uploaded_file['size'] / 1024 ) * 0.001 > $max_size ) {
			DejTicketMessage::add_message(  __('حداکثر حجم مجاز فایل ', 'dejavo') . ' <strong>' . $max_size . '</strong> ' . __('مگابایت میباشد!', 'dejavo'), 1 );

			return false;
		}
	}

	$upload_overrides = array(
		'test_form' => false,
	);

	if ( dejst_get_mimes() ) {
		$upload_overrides['mimes'] = dejst_get_mimes();
	}

	$move_file = wp_handle_upload( $uploaded_file, $upload_overrides );

	if ( $move_file && ! isset( $move_file['error'] ) ) {
		return $move_file['url'];
	} else {
		DejTicketMessage::add_message( $move_file['error'], 1 );
		return false;
	}
}