<div class="dejst-wrapper">
    <h3 class="dejst-title1">
        <span><?= __('همه تیکت‌ها', 'dejavo') ?></span>
        <a href="<?php echo add_query_arg( array( 'action' => 'new' ), remove_query_arg( array( 'page-number',
			'status' ) ) ); ?>" class="dejavo_outline_btn float-left"><?= __('ارسال تیکت جدید', 'dejavo') ?></a>
    </h3>
    <hr class="dejst-hr">
    <div class="dejst-filter clearfix">
        <form id="dejst-filter" method="get">
            <select name="status" class="dejst-custom-select">
                <option value="all"><?= __('همه وضعیت‌ها', 'dejavo') ?></option>
				<?php
				foreach ( dejst_get_ticket_statuses() as $key => $value ) {
					$status = 'all';
					if ( isset( $_GET['status'] ) && ! empty( $_GET['status'] ) && in_array( $_GET['status'], array_keys( dejst_get_ticket_statuses() ) ) ) {
						$status = $_GET['status'];
					}
					$selected = $status == $key ? 'selected' : '';
					echo '<option value="' . $key . '" ' . $selected . '>' . $value . '</option>';
				}
				?>
            </select>
            <button type="submit" class="dejavo_btn"><?= __('فیلتر', 'dejavo') ?></button>
        </form>
    </div>
	<?php
	$tickets = dejst_get_user_tickets();

	if ( $tickets && sizeof( $tickets ) ) {
		?>
        <table class="dejst-tickets-table dejst-table dejst-table-striped dejst-table-bordered">
            <thead class="dejst-thead-light">
            <tr>
                <th class="dejst-id-column" scope="col"><?= __('شناسه', 'dejavo') ?></th>
                <th class="dejst-title-column" scope="col"><?= __('عنوان - پاسخ ها', 'dejavo') ?></th>
                <th class="dejst-product-column" scope="col"><?= __('محصول', 'dejavo') ?></th>
                <th class="dejst-status-column" scope="col"><?= __('وضعیت', 'dejavo') ?></th>
                <th class="dejst-date-column" scope="col"><?= __('تاریخ', 'dejavo') ?></th>
            </tr>
            </thead>
            <tbody>
			<?php
			foreach ( $tickets as $ticket ) {
                $replies = dejst_get_ticket_replies( $ticket->ID );
				?>
                <tr>

                    <td class="dejst-id-column">
                        <a href="<?php echo add_query_arg( array( 'action'    => 'reply',
                            'ticket_id' => $ticket->ID ), remove_query_arg( array( 'page-number',
                            'status' ) ) ); ?>">
                            #<?= $ticket->ID ?>
                        </a>
                    </td>
                    <td class="dejst-title-column">
                        <a href="<?php echo add_query_arg( array( 'action'    => 'reply',
						                                          'ticket_id' => $ticket->ID ), remove_query_arg( array( 'page-number',
							'status' ) ) ); ?>">
							<?php echo $ticket->post_title . ' <span>(' . sizeof( $replies ) . ')</span>';  ?>
                        </a>
                    </td>
                    <td class="dejst-product-column">
						<?php
						$product_id = get_post_meta( $ticket->ID, '_dejst_ticket_product_id', true );
						if ( $product_id ) {
							echo '<a class="dejst-pr-title" href="' . get_permalink( $product_id ) . '" target="_blank">' . get_the_title( $product_id ) . '</a>';
						}
						?>
                    </td>
                    <td class="dejst-status-column">
						<?php
						$status = get_post_status( $ticket->ID );
						foreach ( dejst_get_ticket_statuses() as $key => $value ) {
							if ( $status == $key ) {
								echo '<span class="dejst-badge ' . $key . '">' . $value . '</span>';
								break;
							}
						}


						?>
                    </td>
                    <td class="dejst-date-column">
                        <p>
                            <span><?= __('ارسال: ', 'dejavo') ?></span>
                            <time class="dejst-text-muted" title="<?php echo date_i18n( 'Y/m/d H:i:s', get_the_time( 'U', $ticket->ID ) ); ?>">
								<?php echo dejst_time_ago( get_the_time( 'U', $ticket->ID ) ); ?>
                            </time>
                        </p>
                        <p>
							<?php


							if ( sizeof( $replies ) ) {
                                $time = $replies[ sizeof( $replies ) - 1 ]['date'];
								echo '<span>' . __('آخرین پاسخ: ', 'dejavo') . '</span>';
								echo '<time class="dejst-text-muted" title="' . date_i18n( 'Y/m/d H:i:s', $replies[ sizeof( $replies ) - 1 ]['date'] ) . '">';
								echo dejst_time_ago( $time );
							}
							?>
                        </p>
                    </td>
                </tr>
				<?php
			}
			wp_reset_query();
			?>
            </tbody>
        </table>
		<?php
		$page_number = 1;
		if ( isset( $_GET['page-number'] ) && ctype_digit( $_GET['page-number'] ) ) {
			$page_number = $_GET['page-number'];
		}
		$args = array(
			'base' => preg_replace('/\?.*/', '', get_pagenum_link()) . '%_%',
			'format'    => '?page-number=%#%',
			'total'     => ceil(  dejst_get_ticket_count()  / 5 ),
			'current'   => max( 1, $page_number ),
			'show_all'  => false,
			'prev_next' => false,
			'type'      => 'list',
			'posts_per_page'  => 5,
		);


		echo paginate_links( $args );
		?>
		<?php
	} else {
		echo '<div class="dejst-alert info">'. __('موردی یافت نشد!', 'dejavo') . '</div>';
	}
	?>
</div>