<div class="dejst-wrapper">
    <h3 class="dejst-title1">
        <span><?= __('ارسال تیکت جدید', 'dejavo') ?></span>
        <a href="<?php echo remove_query_arg( array( 'action' ) ); ?>" class="dejavo_outline_btn float-left"><?= __('مشاهده همه تیکت‌ها', 'dejavo') ?></a>
    </h3>
    <hr class="dejst-hr">
	<?php
	if ( dej_opt( 'dej_ticket_help' ) ) {
		echo '<div class="dejst-help-info">' . wpautop( esc_html( dej_opt( 'dej_ticket_help' ) ) ) . '</div>';
	}
	?>
    <form method="post" enctype="multipart/form-data">
		<?php DejTicketMessage::show_message(); ?>
        <div class="dejst-row">
            <div class="dejst-col-12 dejst-col-lg-6 dejst-form-group">
                <label for="ticket-title" class="dejst-label"><?= __('عنوان تیکت را وارد نمایید: ', 'dejavo') ?></label>
                <input type="text" class="dejst-form-control" name="ticket-title" id="ticket-title">
            </div>
            <div class="dejst-col-12 dejst-col-lg-6 dejst-form-group">
                <label for="ticket-type" class="dejst-label"><?= __('بخش مربوطه را انتخاب نمایید: ', 'dejavo') ?></label>
                <select class="dejst-custom-select" name="ticket-type" id="ticket-type">
                    <option value=""><?= __('لطفا انتخاب کنید', 'dejavo') ?></option>
					<?php
					$terms = get_terms( 'ticket-type', array( 'hide_empty' => 0 ) );
                    $term_list = '';
					if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {

						foreach ( $terms as $term ) {
                            if ($term->slug == 'sell') {
                                $default  =' selected="selected" ';
                            } else {
                                $default  = '';
                            }

							$term_list .= '<option' . $default . '  value="' . $term->term_id .  '">' . $term->name . '</option>';
						}
					}
					$term_list .= '</select>';
					echo $term_list;
					?>
                </select>
            </div>
            <div class="dejst-product-title-wrapper dejst-col-12 dejst-col-lg-6 dejst-form-group">
                <label for="product-title" class="dejst-label"><?= __('عنوان محصول را وارد نمایید:', 'dejavo') ?></label>
                <input type="hidden" name="product-id" id="product-id">
                <input type="text" class="dejst-form-control" name="product-title" id="product-title" autocomplete="off">
                <img class="dejst-loader" src="<?php echo DEJST_IMG_URL; ?>loader.svg" alt="" width="18" height="18">
                <div class="dejst-ajax-result"></div>
                <?php wp_nonce_field('dejst_ajax_nonce', '_dejst_nonce'); ?>

            </div>
            <div class="dejst-col-12 dejst-col-lg-6 dejst-form-group">
                <label for="ticket-priority" class="dejst-label"><?= __('اولویت تیکت را انتخاب نمایید:', 'dejavo') ?></label>
                <select class="dejst-custom-select" name="ticket-priority" id="ticket-priority">
                    <option value="low"><?= __('کم', 'dejavo') ?></option>
                    <option value="medium" selected><?= __('متوسط', 'dejavo') ?></option>
                    <option value="high"><?= __('زیاد', 'dejavo') ?></option>
                </select>
            </div>
        </div>
        <div class="dejst-row">
            <div class="dejst-col-12 dejst-form-group">
                <label for="ticket-content" class="dejst-label"><?= __('متن تیکت را وارد نمایید: ', 'dejavo') ?></label>
				<textarea class="dejst-form-control" name="ticket-content" id="ticket-content" rows="10"></textarea>
            </div>
        </div>
		<?php if ( dej_opt( 'dej_ticket_file', 1 ) ) { ?>
            <div class="dejst-row">
                <div class="dejst-col-12 dejst-form-group">
                    <div class="dejst-custom-file">
                        <input type="file" class="dejst-custom-file-input" id="ticket-file" name="ticket-file">
                        <label class="dejst-custom-file-label" for="ticket-file"><?= __('فایل ضمیمه را انتخاب کنید', 'dejavo') ?></label>
                    </div>
					<?php if ( dej_opt( 'dej_ticket_file_format' ) ): ?>
                        <div class="dejst-text-muted"><?= __('فرمت‌های مجاز: ', 'dejavo') ?>
                            <bdi dir="ltr">.<?php echo str_replace( ',', ', .', dej_opt( 'dej_ticket_file_format' ) ); ?></bdi>
                        </div>
					<?php endif; ?>
					<?php if ( dej_opt( 'dej_ticket_file_size', 2 ) ): ?>
                        <div class="dejst-text-muted"><?= __('حداکثر حجم مجاز: ', 'dejavo') ?> <?php echo dej_opt( 'dej_ticket_file_size', 2 ); ?> <?= __('مگابایت', 'dejavo') ?> </div>
					<?php endif; ?>
                </div>
            </div>
		<?php } ?>
        <div class="dejst-row">
            <div class="dejst-col-12 dejst-form-group">
				<?php wp_nonce_field( 'dejst_new_ticket', 'dejst_new_ticket_field' ); ?>
                <button type="submit" name="submit-new-ticket" class="dejavo_btn"><?= __('ارسال تیکت', 'dejavo') ?></button>
            </div>
        </div>
    </form>
</div>