<?php
if ( ! isset( $_GET['ticket_id'] ) || ! ctype_digit( $_GET['ticket_id'] ) ) {
	return;
}

$ticket_id = $_GET['ticket_id'];
$ticket    = get_post( $ticket_id );
$author    = $ticket->post_author;

$terms     = wp_get_post_terms( $ticket_id, 'ticket-type' );
$term      = null;
if ( count( $terms ) ) {
	$term = $terms[0]->term_id;
}

$status     = $ticket->post_status;
$product_id = get_post_meta( $ticket_id, '_dejst_ticket_product_id', true );
$ath_file   = get_post_meta( $ticket_id, '_dejst_ticket_ath_file', true );

if ( get_current_user_id() != $ticket->post_author ) {
    echo '<div class="dejst-alert info">'. __('موردی یافت نشد!', 'dejavo') . '</div>';
    return;
}

?>
<div class="dejst-wrapper">
    <h3 class="title dejst-title">
        <?php echo $ticket->post_title; ?>
        <?php echo '<bdi class="dejst-text-muted" dir="ltr">#' . $ticket_id . '</bdi> '; ?>

    </h3>
    <div class="dejst-start-ticket dejst-card">
        <div class="content">

            <div class="dejst-row">

                <div class="dejst-col-6 dejst-col-md-3">
                    <div>
                        <strong><?= __('اولویت: ', 'dejavo') ?> </strong>
                        <br>
						<?php
						$priority = get_post_meta( $ticket_id, '_dejst_ticket_priority', true );
						echo '<span class="dejst-text-muted">';
						switch ( $priority ) {
							case 'low':
								echo  __('کم', 'dejavo');
								break;
							default:
							case 'medium':
								echo  __('متوسط', 'dejavo');
								break;
							case 'high':
								echo  __('زیاد', 'dejavo');
								break;
						}
						echo '</span>';
						?>
                    </div>
                </div>
                <div class="dejst-col-6 dejst-col-md-3">
                    <div>
                        <strong><?= __('بخش: ', 'dejavo') ?> </strong>
                        <br>
						<?php
						$terms = wp_get_post_terms( $ticket_id, 'ticket-type' );
						if ( $terms && is_array( $terms ) ) {
							if ( isset( $terms[0]->name ) ) {
								echo '<span class="dejst-text-muted">' . $terms[0]->name . '</span>';
							}
						}
						?>
                    </div>
                </div>
                <div class="dejst-col-6 dejst-col-md-3">
                    <div>
                        <strong><?= __('وضعیت: ', 'dejavo') ?> </strong>
                        <br>
                        <?php

                        foreach ( dejst_get_ticket_statuses() as $key => $value ) {
                            if ( $status == $key ) {
                                echo '<span class="dejst-badge ' . $key . '">' . $value . '</span>';
                                break;
                            }
                        }
                        ?>
                    </div>
                </div>
                <div class="dejst-col-6 dejst-col-md-3">
                    <p>
                            <strong><?= __('محصول: ', 'dejavo') ?> </strong>
                            <br>
                            <?php
                                if ( is_numeric( $product_id ) ) {
                                    echo '<a class="dejst-pr-title" href="' . get_the_permalink( $product_id ) . '" target="_blank">' . get_the_title( $product_id ) . '</a>';
                                } else {
                                    echo $product_id;
                                }
                            ?>
                        </p>
                </div>

            </div>
        </div>
    </div>
    <div class="item dejst-card user">
        <div class="head">
            <?php
            $user_info = get_userdata( $author );
            echo get_avatar($author, 50);
            echo '<strong>' . $user_info->display_name . '</strong>';
            ?>
            <time>	<?php echo date_i18n( 'Y/m/d H:i', get_the_time( 'U', $ticket->post_date ) ); ?></time>
        </div>
        <div class="content">

            <div class="text-justify"><?php echo apply_filters( 'the_content', $ticket->post_content ); ?></div>
            <?php

            if ( $ath_file ) {
                echo '<a href="' . esc_url( $ath_file ) . '" class="dejst-ath-file" title="' . __('فایل ضمیمه', 'dejavo') . '" target="_blank"><i class="dej-clip"></i> ' . __('فایل ضمیمه', 'dejavo') . '</a>';
            }
            ?>
        </div>
    </div>


	<?php
	$replies = dejst_get_ticket_replies( $ticket_id );

	// Sort replies by date
	dejst_aasort( $replies, "date" );


	if ( sizeof( $replies ) ) {
		foreach ( $replies as $reply ) {
			if ( ! is_array( $reply ) ) {
				continue;
			}

			if ( array_key_exists( 'content', $reply ) ) {
				if ( ! $reply['content'] ) {
					continue;
				}
			} else {
				continue;
			}
            $author_id = $reply['author_id'];
            $is_editor = user_can($author_id, 'edit_posts');
            $class = $is_editor ? 'editor' : 'user';
			?>
            <div class="item dejst-card <?= $class ?>">
                <div class="head clearfix">
					<?php
					$author_id = $reply['author_id'];
					$user_info = get_userdata( $author_id );
                    echo get_avatar($author_id, 50);
					echo '<strong>' . $user_info->display_name . '</strong>';
					?>
                    <time><?php echo date_i18n( 'Y/m/d - H:i', $reply['date'] ); ?></time>
                </div>
                <div class="content">
					<?php
					if ( user_can( $author_id, 'delete_others_pages' ) ) {
						echo  wpautop( dej_opt( 'dej_ticket_top_message', ' ' ) );
					}
					?>
                    <div class="text-justify"><?php echo apply_filters( 'the_content', $reply['content'] ); ?></div>
					<?php
					if ( user_can( $author_id, 'delete_others_pages' ) ) {
                        echo  wpautop( dej_opt( 'dej_ticket_bottom_message', ' ' ) );
					}
                    if ( array_key_exists( 'ath_file', $reply ) ) {
                        echo '<a href="' . esc_url( $reply['ath_file'] ) . '" class="dejst-ath-file" title="' . __('فایل ضمیمه', 'dejavo') . '" target="_blank"><i class="dej-clip"></i> ' . __('فایل ضمیمه', 'dejavo') . '</a>';
                    }
					?>
                </div>
            </div>
			<?php
		}
	}

    if ($status == 'closed') {
        ?>

        <div class="dejst-alert info">
            <p><?= __('بسته شده', 'dejavo') ?></p>
        </div>
            <?php

    }
    else {
	?>

    <h3 class="dejst-title1">
        <span><?= __('ارسال پاسخ تیکت', 'dejavo') ?></span>
        <a href="<?php echo remove_query_arg( array( 'action',
            'ticket_id' ) ); ?>" class="dejavo_outline_btn dejst-btn-secondary dejst-btn-sm float-left"><?= __('مشاهده همه تیکت‌ها', 'dejavo') ?></a>
    </h3>
    <hr class="dejst-hr">
    <form method="post" enctype="multipart/form-data">
        <?php DejTicketMessage::show_message(); ?>
        <input type="hidden" name="ticket-id" value="<?php echo esc_attr( $ticket_id ); ?>">
        <input type="hidden" name="product-id" value="<?php echo esc_attr( $product_id ); ?>">
        <div class="dejst-row">
            <div class="dejst-col-12 dejst-form-group">
                <label for="ticket-content" class="dejst-label"><?= __('متن تیکت را وارد نمایید: ', 'dejavo') ?></label>
               <textarea class="dejst-form-control" name="ticket-content" id="ticket-content" rows="10"></textarea>
            </div>
        </div>
        <?php if ( dej_opt( 'dej_ticket_file', 1 ) ) { ?>
            <div class="dejst-row">
                <div class="dejst-col-12 dejst-form-group">
                    <div class="dejst-custom-file">
                        <input type="file" class="dejst-custom-file-input" id="ticket-file" name="ticket-file">
                        <label class="dejst-custom-file-label" for="ticket-file"><?= __('فایل ضمیمه را انتخاب کنید', 'dejavo') ?></label>
                    </div>
                    <?php if ( dej_opt( 'dej_ticket_file_format' ) ): ?>
                        <div class="dejst-text-muted"><?= __('فرمت‌های مجاز: ', 'dejavo') ?>
                            <bdi dir="ltr">.<?php echo str_replace( ',', ', .', dej_opt( 'dej_ticket_file_format' ) ); ?></bdi>
                        </div>
                    <?php endif; ?>
                    <?php if ( dej_opt( 'dej_ticket_file_size', 2 ) ): ?>
                        <div class="dejst-text-muted"><?= __('حداکثر حجم مجاز: ', 'dejavo') . dej_opt( 'dej_ticket_file_size', 2 ) . __('مگابایت', 'dejavo') ?> </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php } ?>
        <div class="dejst-row">
            <div class="dejst-col-12 dejst-form-group">
                <?php wp_nonce_field( 'dejst_reply_ticket', 'dejst_reply_ticket_field' ); ?>
                <button type="submit" name="submit-reply-ticket" class="dejavo_btn dejst-btn-success"><?= __('ارسال پاسخ', 'dejavo') ?></button>
            </div>
        </div>
    </form>
    <?php } ?>
</div>