<?php defined( 'ABSPATH' ) || exit();
final class DejavoTicket {
	private static $instance = null;

	public static function get_instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	public function __construct() {
        $this->define_constants();
		$this->_include();

        add_action('admin_enqueue_scripts', [$this, 'load_admin_scripts']);
        $this->admin_footer();

        if ( ! wp_next_scheduled( 'dejst_auto_close_ticket_event' ) ) {
			wp_schedule_event( current_time('U'), 'daily', 'dejst_auto_close_ticket_event' );
		}
        add_action( 'dejst_auto_close_ticket_event', [ $this, 'auto_close_ticket'] );

    }

	private function define_constants() {

		define( 'DEJST_INC_PATH',  DEJST_PATH . 'inc/');
		define( 'DEJST_CLASS_PATH',  DEJST_PATH . 'class/');
		define( 'DEJST_TPL_PATH',  DEJST_PATH . 'tem/');
		define( 'DEJST_CSS_URL',  DEJST_URL . 'asset/css/');
		define( 'DEJST_JS_URL', DEJST_URL . 'asset/js/');
		define( 'DEJST_IMG_URL',  DEJST_URL . 'asset/images/');
	}


	private function _include() {
        require( DEJST_CLASS_PATH . 'flash-message.php' );
        require( DEJST_CLASS_PATH . 'remove-files.php' );
        require( DEJST_CLASS_PATH . 'send-email.php' );
		require_once( ABSPATH . 'wp-admin/includes/screen.php' );

		include( DEJST_INC_PATH . 'functions.php' );
		include( DEJST_INC_PATH . 'taxonomy.php' );
		include( DEJST_INC_PATH . 'pre-answer.php' );
		include( DEJST_INC_PATH . 'files.php' );
		include( DEJST_INC_PATH . 'user.php' );
	}

	public function auto_close_ticket() {

		$period = dej_opt( 'dej_ticket_auto_close', 3 );

		$period_s = $period * 86400;

		$args  = [
			'post_type'      => 'ticket',
			'posts_per_page' => -1,
			'post_status'    => ['open', 'in_progress', 'answered' ],
			'meta_query'     => [
				[    'key'     => '_dejst_ticket_last_reply_date',
					'value'   => current_time('U') - $period_s,
					'compare' => '<',
				],
			],
		];
		$posts = new WP_Query( $args );

		if ( $posts->have_posts() ) {
			while ( $posts->have_posts() ) {
				$posts->the_post();
				dejst_set_post_status( 'closed', $posts->post->ID );
			}
		}
	}

	public function load_admin_scripts() {
		wp_enqueue_media();
		wp_register_style( 'dejst-styles', DEJST_CSS_URL . 'admin-styles.css', null, DEJ_VERSION );
		wp_enqueue_style( 'dejst-styles' );
		wp_register_script( 'dejst-scripts', DEJST_JS_URL . 'admin-scripts.js', array( 'jquery' ), DEJ_VERSION, true );
		wp_enqueue_script( 'dejst-scripts' );
		wp_localize_script( 'dejst-scripts', 'dejst_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
	}

	private function admin_footer() {
		add_action( 'admin_footer', function () {
			$screen = get_current_screen();
			if ( $screen->base == 'post' && $screen->post_type == 'pre-answer' ) {
				?>
                <script>
                    jQuery(document).ready(function ($) {
                        var menu_posts_ticket = $('#menu-posts-ticket');
                        menu_posts_ticket.addClass('wp-has-current-submenu wp-menu-open');
                        menu_posts_ticket.find('a.menu-icon-ticket').addClass('wp-has-current-submenu wp-menu-open');
                        $('a[href="<edit.php?post_type=pre-answer"]').parentsUntil('ul.wp-submenu').addClass('current');
                    });
                </script>
				<?php
			}
		} );
	}
}

DejavoTicket::get_instance();