<?php
defined('ABSPATH') || exit;
class dejavo_banner extends WP_Widget {


	public function __construct() {
		parent::__construct(
			'dejavo_banner', // Base ID
            __('بنر (دژاوو)', 'dejavo'), // Name
			array( 'description' => __( 'بنر سایدبار', 'dejavo' ), ) // Args
		);
	}


	public function widget( $args, $instance ) {
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		$discount = $instance['discount'];
		$title_btn = $instance['title_btn'];
		$cap_space = $instance['cap_space'] ?? 5;
		$link_btn = $instance['link_btn'];
		$img_url = $instance['img_url'];

		echo $args['before_widget'];  ?>
        <style>
            .widget_banner {
                position: relative;
                display: flex;
                margin: 0 auto;
            }

            .widget_banner .info {
                position: absolute;
                bottom: 15%;
                z-index: 5;
                display: block;
                align-items: center;
                padding: 1em;
            }

            .widget_banner .img {
                overflow: hidden;
                position: relative;
                display: block;
                border-radius: var(--dej-max-radius);
                width: 100%;
            }

            .widget_banner .img img {
                width: 100%;
            }

            .widget_banner .img:before {
                content: "";
                width: 100%;
                height: 100%;
                position: absolute;
                background-color: rgba(0, 0, 0, 0.4);
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                z-index: 2;
            }

            .widget_banner .info h6 {
                font-size: 1.2em;
                font-weight: 500;
                color: var(--white-color);
                margin-bottom: 10px;
            }

            .widget_banner .info h4 {
                font-size: 1.6em;
                font-weight: 800;
                color: var(--white-color);
                margin-bottom: 10px;
            }

            .widget_banner .buy {
                background-color: var(--white-color);
                padding: 4px 15px;
                border-radius: var(--dej-max-radius);
                font-size: 13px;
            }

            .widget_banner .buy:hover {
                background: var(--dej-color1) var(--dej-bg1);
                color: var(--white-color);
            }
        </style>
		<div class="widget_banner">
        <?php if (!empty($img_url)) { ?><div class="img"><img src="<?php echo $img_url; ?>" alt=""></div><?php } ?>
			<div style="bottom:<?= $cap_space ?>%" class="info">
          <?php if (!empty($title)) { ?><h6><?php echo $title ?></h6><?php } ?>
          <?php if (!empty($discount)) { ?><h4> <?php echo $discount ?></h4><?php } ?>
          <?php if (!empty($link_btn)) { ?><a href="<?php echo $link_btn ?>" class="btn buy"><?php echo $title_btn ?></a><?php } ?>
			</div>
		</div>
			<?php

			echo $args['after_widget'];
		}


	public function form( $instance ) {

		$title = !empty($instance[ 'title' ]) ?  $instance[ 'title' ] :  __('فروش ویژه', 'dejavo');
		$discount = !empty($instance[ 'discount' ]) ?  $instance[ 'discount' ] :  __('تا 40 درصد تخفیف', 'dejavo');
		$title_btn = !empty($instance[ 'title_btn' ]) ?  $instance[ 'title_btn' ] :  __('اکنون خرید کنید', 'dejavo');
		$link_btn = !empty($instance[ 'link_btn' ]) ?  $instance[ 'link_btn' ] :  '#';
		$img_url = !empty($instance[ 'img_url' ]) ?  $instance[ 'img_url' ] :  '';
		$cap_space = !empty($instance[ 'cap_space' ]) ?  $instance[ 'cap_space' ] :  5;

		?>

        <p>
            <label for="<?= $this->get_field_id( 'image_uri' ); ?>"><?php _e( 'تصویر', 'dejavo' ); ?></label>
            <img class="<?= $this->id ?>_img" src="<?= (!empty($instance['img_url'])) ? $instance['img_url'] : ''; ?>" style="margin:5px;padding:0;max-width:100%;display:block"/>
            <input type="text" class="widefat <?= $this->id ?>_url" name="<?= $this->get_field_name( 'img_url' ); ?>" value="<?= $instance['img_url'] ?? ''; ?>" style="margin-top:5px;" />
            <input type="button" id="<?= $this->id ?>" class="button button-primary js_custom_upload_media" value="<?php _e( 'آپلود / انتخاب تصویر', 'dejavo' ); ?>" style="margin-top:5px;" />
        </p>
		<p>
			<label for="<?php echo $this->get_field_name( 'title' ); ?>"><?php _e( 'عنوان', 'dejavo' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_name( 'discount' ); ?>"><?php _e( 'عنوان دوم (درصد تخفیف)', 'dejavo' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'discount' ); ?>" name="<?php echo $this->get_field_name( 'discount' ); ?>" type="text" value="<?php echo esc_attr( $discount ); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_name( 'title_btn' ); ?>"><?php _e( 'عنوان دکمه', 'dejavo' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title_btn' ); ?>" name="<?php echo $this->get_field_name( 'title_btn' ); ?>" type="text" value="<?php echo esc_attr( $title_btn ); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_name( 'link_btn' ); ?>"><?php _e( 'لینک' , 'dejavo'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'link_btn' ); ?>" name="<?php echo $this->get_field_name( 'link_btn' ); ?>" type="text" value="<?php echo esc_attr( $link_btn ); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_name( 'cap_space' ); ?>"><?php _e( 'درصد فاصله متن از پایین', 'dejavo' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'cap_space' ); ?>" name="<?php echo $this->get_field_name( 'cap_space' ); ?>" type="text" value="<?php echo esc_attr( $cap_space ); ?>" />
		</p>

		<?php
	}


	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['discount'] = ( !empty( $new_instance['discount'] ) ) ? strip_tags( $new_instance['discount'] ) : '';
		$instance['title_btn'] = ( !empty( $new_instance['title_btn'] ) ) ? strip_tags( $new_instance['title_btn'] ) : '';
		$instance['link_btn'] = ( !empty( $new_instance['link_btn'] ) ) ? strip_tags( $new_instance['link_btn'] ) : '';
		$instance['img_url'] = ( !empty( $new_instance['img_url'] ) ) ? strip_tags( $new_instance['img_url'] ) : '';
		$instance['cap_space'] = ( !empty( $new_instance['cap_space'] ) ) ? strip_tags( $new_instance['cap_space'] ) : 5;

		return $instance;
	}

}


function register_dejavo_banner() {
	register_widget( 'dejavo_banner' );
}
add_action( 'widgets_init', 'register_dejavo_banner' );


add_action('admin_enqueue_scripts', 'banner_script');
function banner_script() {
wp_enqueue_media();
wp_enqueue_script('banner_script', DEJ_TUI . '/assets/js/widget.js', false, '1.0', true);
}
