<?php  defined('ABSPATH') || exit;
class DejavoColorWidget extends WP_Widget {

	public function __construct() {
		parent::__construct(
			'dejavo_color_widget', // Base ID
            __('فیلتر رنگ (دژاوو)','dejavo'), // Name
			array( 'description' => __( 'فیلتر رنگ', 'dejavo' ), ) // Args
		);
    }

	public function widget( $args, $instance ) {
        if( is_shop() || is_product_taxonomy() ) {


            $color_opt = dej_opt('dej_color_slug', 'color');
            $color = 'pa_'. $color_opt;

            $current_products = dejavo_current_products_query( $color );
            $result_colors = dejavo_get_products_attr( $current_products, $color );
            $current_filter_clr = isset( $_GET['clr_filter'] ) ? explode( ',', $_GET['clr_filter'] ) : array();

            if (  !empty( $result_colors ) and ! is_wp_error( $result_colors ) and is_array($result_colors) ) {
            
            echo $args['before_widget'];
            $title = apply_filters( 'widget_title', $instance['widget_title'] );
            if ( ! empty( $title ) ) {
                echo $args['before_title'] . $title . $args['after_title'];
            }

            $style = dej_opt('dej_attr_style', 'rounded');
            $active_icon = '<i class="dej-check"></i>';
            ?>
            <ul class="dejavo_filter_color <?= $style ?>">
                <?php
                foreach ($result_colors as $color) {
                    $term = get_term($color);
                    $my_color = get_term_meta($term->term_id, 'DejavoVS_color', true);
                    $tooltip = get_term_meta($term->term_id, 'DejavoVS_tooltip', true) ?: $term->name . ' ('. $term->count . ') ';
                    ?>
                    <li style="background-color:<?php if ($my_color) { echo $my_color; } else { echo 'white'; } ?>;" class="hint--top <?php echo in_array( $term->term_id, $current_filter_clr ) ? 'active' : ''; ?>" aria-label="<?= esc_attr($tooltip) ?>">
                        <a rel="nofollow" href="<?= dejavo_get_filter_url( 'clr_filter' , $term->term_id ) ?>"><?php echo in_array( $term->term_id, $current_filter_clr ) ? $active_icon : ''; ?></a>
                    </li>                <?php  }   ?>
            </ul>

            <?php
            echo $args['after_widget'];
            }
        }
    }


	public function form( $instance ) {

        $widget_title = isset( $instance['widget_title'] ) ? esc_attr( $instance['widget_title'] ) : __('فیلتر بر اساس رنگ', 'dejavo');
        ?>
        <p>
            <label for="<?php echo $this->get_field_name( 'widget_title' ); ?>"><?php _e( 'عنوان', 'dejavo' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'widget_title' ); ?>" name="<?php echo $this->get_field_name( 'widget_title' ); ?>" type="text" value="<?php echo esc_attr( $widget_title ); ?>" />
        </p>
        <p>
            <?php _e( 'نامک ویژگی رنگ را color تنظیم کنید یا مقدار سفارشی را از تنظمات قالب وارد کنید (پیشفرض : color)' ); ?>
        </p>
        <?php
    }

	public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['widget_title'] = ( ! empty( $new_instance['widget_title'] ) ) ? strip_tags( $new_instance['widget_title'] ) : '';
        return $instance;
	}

}

function register_color_widget() {
	register_widget( 'DejavoColorWidget' );
}
add_action( 'widgets_init', 'register_color_widget' );

