<?php
defined('ABSPATH') || exit;
class Dejavo_On_Sale_widget extends WP_Widget {
    
	public function __construct() {
		parent::__construct(
			'dejavo_on_sale_widget', // Base ID
            __('فیلتر محصولات تخفیف دار (دژاوو)','dejavo'), // Name
			array( 'description' => __( 'فیلتر محصولات تخفیف دار', 'dejavo' ), ) // Args
		);
	}

	public function widget( $args, $instance ) {
        if( is_shop() || is_product_taxonomy() ) {
            echo $args['before_widget'];
            $class_active = 'woocommerce-widget-layered-nav-list__item--chosen chosen';
            $current_stock_status = isset( $_GET['stock_status'] ) ? explode( ',', $_GET['stock_status'] ) : array();
            ?>
            <ul class="woocommerce-widget-layered-nav-list not_titled">
                <li class="woocommerce-widget-layered-nav-list__item wc-layered-nav-term <?php echo in_array( 'onsale', $current_stock_status ) ? $class_active : ''; ?>"><a rel="nofollow" href="<?php echo  dejavo_get_filter_url( 'stock_status','onsale' ); ?>"><?php echo $instance['on_sale_txt']; ?></a></li>
            </ul>

            <?php
            echo $args['after_widget'];
        }
    }

	public function form( $instance ) {

        $on_sale_txt = isset( $instance['on_sale_txt'] ) ? esc_attr( $instance['on_sale_txt'] ) : __('محصولات تخفیف دار', 'dejavo');
        ?>

        <p> <label for="<?php echo $this->get_field_name( 'on_sale_txt' ); ?>"><?php _e( 'عنوان', 'dejavo' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'on_sale_txt' ); ?>" name="<?php echo $this->get_field_name( 'on_sale_txt' ); ?>" type="text" value="<?php echo esc_attr( $on_sale_txt ); ?>" />
        </p>
        <?php
    }

	public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['on_sale_txt'] = ( ! empty( $new_instance['on_sale_txt'] ) ) ? strip_tags( $new_instance['on_sale_txt'] ) : '';
        return $instance;
	}

}

function register_on_sale_widget() {
	register_widget( 'Dejavo_On_Sale_widget' );
}
add_action( 'widgets_init', 'register_on_sale_widget' );

