<?php
defined('ABSPATH') || exit;
if (!is_user_logged_in() and ( dej_woo_activated() and !is_account_page() and !is_checkout()) ) {
    $login_style = dej_opt('dej_auth_style', 'slide') ?? 'slide';
    $dej_auth = dej_opt('dej_auth') ?? false;
    if ($login_style == 'pop') {
        ?>
        <div id="dejavo_login" class="dejavo_login mfp-with-anim mfp-hide">
            <?php
            $main_logo = dej_opt('dej_main_logo');
            if ($main_logo) { ?><a class="logo" href="<?php bloginfo('url'); ?>"><img alt="<?php bloginfo('name') ?>" src="<?= $main_logo ?>"></a><?php }
            if ($dej_auth) {
                DejavoAuth::AuthForm();
            } else { ?>
                <div class="slide-login">
                    <div class="dejavo_tabs">

                        <input class="state" type="radio" title="tab-one" name="tabs-state" id="tab-one" checked/>
                        <input class="state" type="radio" title="tab-two" name="tabs-state" id="tab-two"/>

                        <div class="tabs flex-tabs">
                            <label for="tab-one" id="tab-one-label" class="tab"><i
                                        class="dej-user"></i><?php _e('ورود به سایت', 'dejavo'); ?></label>
                            <?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')) { ?>
                                <label for="tab-two" id="tab-two-label" class="tab"><i
                                            class="dej-user-add"></i><?php _e('ثبت نام در سایت', 'dejavo'); ?></label>
                            <?php } ?>


                            <div id="tab-one-panel" class="panel active">
                                <?php do_action('woocommerce_before_customer_login_form'); ?>
                                <form data-no-optimize="1" class="login" method="post">

                                    <?php do_action('woocommerce_login_form_start'); ?>

                                    <p class="form-row form-group">
                                        <label for="username"><?php esc_html_e('Username or email address', 'woocommerce'); ?>
                                            &nbsp;<span class="required">*</span></label>
                                        <input type="text" class="input-text form-control" name="username" id="username"
                                               autocomplete="username"
                                               value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>"/><?php // @codingStandardsIgnoreLine ?>
                                    </p>
                                    <p class="form-row form-group">
                                        <label for="password"><?php esc_html_e('Password', 'woocommerce'); ?>&nbsp;<span
                                                    class="required">*</span></label>
                                        <input class="input-text form-control" type="password" name="password"
                                               id="password" autocomplete="current-password"/>
                                    </p>

                                    <?php do_action('woocommerce_login_form'); ?>

                                    <p class="form-row form-group">
                                        <label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
                                            <input class="woocommerce-form__input woocommerce-form__input-checkbox"
                                                   name="rememberme" type="checkbox" id="rememberme" value="forever"/>
                                            <span><?php esc_html_e('Remember me', 'woocommerce'); ?></span>
                                        </label>
                                        <?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>
                                        <button type="submit" class="btn dejavo_btn" name="login"
                                                value="<?php esc_attr_e('Log in', 'woocommerce'); ?>"><?php esc_html_e('Log in', 'woocommerce'); ?></button>
                                    </p>
                                    <p class="woocommerce-LostPassword lost_password">
                                        <a href="<?php echo esc_url(wp_lostpassword_url()); ?>"><?php esc_html_e('Lost your password?', 'woocommerce'); ?></a>
                                    </p>

                                    <?php do_action('woocommerce_login_form_end'); ?>

                                </form>
                                <?php do_action('woocommerce_after_customer_login_form'); ?>

                            </div>
                            <div id="tab-two-panel" class="panel">
                                <?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')) { ?>
                                    <form method="post"
                                          class="register" <?php do_action('woocommerce_register_form_tag'); ?> >

                                        <?php do_action('woocommerce_register_form_start'); ?>

                                        <?php if ('no' === get_option('woocommerce_registration_generate_username')) { ?>

                                            <p class="form-row form-group">
                                                <label for="reg_username"><?php esc_html_e('Username', 'woocommerce'); ?>
                                                    &nbsp;<span class="required">*</span></label>
                                                <input type="text" class="input-text form-control" name="username"
                                                       id="reg_username" autocomplete="username"
                                                       value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>"/><?php // @codingStandardsIgnoreLine ?>
                                            </p>

                                        <?php } ?>

                                        <p class="form-row form-group">
                                            <label for="reg_email"><?php esc_html_e('Email address', 'woocommerce'); ?>
                                                &nbsp;<span class="required">*</span></label>
                                            <input type="email" class="input-text form-control" name="email"
                                                   id="reg_email" autocomplete="email"
                                                   value="<?php echo (!empty($_POST['email'])) ? esc_attr(wp_unslash($_POST['email'])) : ''; ?>"/><?php // @codingStandardsIgnoreLine ?>
                                        </p>

                                        <?php if ('no' === get_option('woocommerce_registration_generate_password')) { ?>

                                            <p class="form-row form-group">
                                                <label for="reg_password"><?php esc_html_e('Password', 'woocommerce'); ?>
                                                    &nbsp;<span class="required">*</span></label>
                                                <input type="password" class="input-text form-control" name="password"
                                                       id="reg_password" autocomplete="new-password"/>
                                            </p>

                                        <?php } else { ?>

                                            <p><?php esc_html_e('A link to set a new password will be sent to your email address.', 'woocommerce'); ?></p>

                                        <?php }
                                        if (!class_exists('WeDevs_Dokan')) {
                                            do_action('woocommerce_register_form');
                                        } ?>

                                        <p class="woocommerce-form-row form-row">
                                            <?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>
                                            <button type="submit" class="btn dejavo_btn" name="register"
                                                    value="<?php esc_attr_e('Register', 'woocommerce'); ?>"><?php esc_html_e('Register', 'woocommerce'); ?></button>
                                            <?php if (class_exists('WeDevs_Dokan')) { ?>
                                        <p class="text-divider">یا</p> <a
                                            href="<?php echo wc_get_page_permalink('myaccount'); ?>"
                                            class="btn btn-vendor w-100 mt-4" name="register" value="">ثبت نام
                                        فروشنده</a> <?php } ?>
                                        </p>

                                        <?php do_action('woocommerce_register_form_end'); ?>

                                    </form>
                                <?php } ?>                    </div>

                        </div>

                    </div>
                </div>
            <?php } ?>
        </div>

    <?php } elseif ($login_style == 'slide') { ?>
        <div class="dejavo_login_side" tabindex="-1">
            <div class="dej_header_sidebar">
                <h5 class="title"><?php echo dej_opt('dej_reg', 1) ? __('ورود / عضویت', 'dejavo') : __('ورود', 'dejavo') ?></h5>
                <a href="javascript:void(0);" class="Dejavo_close"><i class="dej-cross-small"></i></a>
            </div>
            <?php if ($dej_auth) {
                DejavoAuth::AuthForm();
            } else { ?>
                <div class="slide-login">
                    <div class="dejavo_tabs">

                        <input class="state" type="radio" title="tab-one" name="tabs-state" id="tab-one" checked/>
                        <input class="state" type="radio" title="tab-two" name="tabs-state" id="tab-two"/>

                        <div class="tabs flex-tabs">
                            <label for="tab-one" id="tab-one-label" class="tab"><i
                                        class="dej-user"></i><?php _e('ورود به سایت', 'dejavo'); ?></label>
                            <?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')) { ?>
                                <label for="tab-two" id="tab-two-label" class="tab"><i
                                            class="dej-user-add"></i><?php _e('ثبت نام در سایت', 'dejavo'); ?></label>
                            <?php } ?>


                            <div id="tab-one-panel" class="panel active">
                                <?php do_action('woocommerce_before_customer_login_form'); ?>
                                <form data-no-optimize="1" class="login" method="post">

                                    <?php do_action('woocommerce_login_form_start'); ?>

                                    <p class="form-row form-group">
                                        <label for="username"><?php esc_html_e('Username or email address', 'woocommerce'); ?>
                                            &nbsp;<span class="required">*</span></label>
                                        <input type="text" class="input-text form-control" name="username" id="username"
                                               autocomplete="username"
                                               value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>"/><?php // @codingStandardsIgnoreLine ?>
                                    </p>
                                    <p class="form-row form-group">
                                        <label for="password"><?php esc_html_e('Password', 'woocommerce'); ?>&nbsp;<span
                                                    class="required">*</span></label>
                                        <input class="input-text form-control" type="password" name="password"
                                               id="password" autocomplete="current-password"/>
                                    </p>

                                    <?php do_action('woocommerce_login_form'); ?>

                                    <p class="form-row form-group">
                                        <label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
                                            <input class="woocommerce-form__input woocommerce-form__input-checkbox"
                                                   name="rememberme" type="checkbox" id="rememberme" value="forever"/>
                                            <span><?php esc_html_e('Remember me', 'woocommerce'); ?></span>
                                        </label>
                                        <?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>
                                        <button type="submit" class="btn dejavo_btn" name="login"
                                                value="<?php esc_attr_e('Log in', 'woocommerce'); ?>"><?php esc_html_e('Log in', 'woocommerce'); ?></button>
                                    </p>
                                    <p class="woocommerce-LostPassword lost_password">
                                        <a href="<?php echo esc_url(wp_lostpassword_url()); ?>"><?php esc_html_e('Lost your password?', 'woocommerce'); ?></a>
                                    </p>

                                    <?php do_action('woocommerce_login_form_end'); ?>

                                </form>
                                <?php do_action('woocommerce_after_customer_login_form'); ?>

                            </div>
                            <div id="tab-two-panel" class="panel">
                                <?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')) { ?>
                                    <form method="post"
                                          class="register" <?php do_action('woocommerce_register_form_tag'); ?> >

                                        <?php do_action('woocommerce_register_form_start'); ?>

                                        <?php if ('no' === get_option('woocommerce_registration_generate_username')) { ?>

                                            <p class="form-row form-group">
                                                <label for="reg_username"><?php esc_html_e('Username', 'woocommerce'); ?>
                                                    &nbsp;<span class="required">*</span></label>
                                                <input type="text" class="input-text form-control" name="username"
                                                       id="reg_username" autocomplete="username"
                                                       value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>"/><?php // @codingStandardsIgnoreLine ?>
                                            </p>

                                        <?php } ?>

                                        <p class="form-row form-group">
                                            <label for="reg_email"><?php esc_html_e('Email address', 'woocommerce'); ?>
                                                &nbsp;<span class="required">*</span></label>
                                            <input type="email" class="input-text form-control" name="email"
                                                   id="reg_email" autocomplete="email"
                                                   value="<?php echo (!empty($_POST['email'])) ? esc_attr(wp_unslash($_POST['email'])) : ''; ?>"/><?php // @codingStandardsIgnoreLine ?>
                                        </p>

                                        <?php if ('no' === get_option('woocommerce_registration_generate_password')) { ?>

                                            <p class="form-row form-group">
                                                <label for="reg_password"><?php esc_html_e('Password', 'woocommerce'); ?>
                                                    &nbsp;<span class="required">*</span></label>
                                                <input type="password" class="input-text form-control" name="password"
                                                       id="reg_password" autocomplete="new-password"/>
                                            </p>

                                        <?php } else { ?>

                                            <p><?php esc_html_e('A link to set a new password will be sent to your email address.', 'woocommerce'); ?></p>

                                        <?php }
                                        if (!class_exists('WeDevs_Dokan')) {
                                            do_action('woocommerce_register_form');
                                        } ?>

                                        <p class="woocommerce-form-row form-row">
                                            <?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>
                                            <button type="submit" class="btn dejavo_btn" name="register"
                                                    value="<?php esc_attr_e('Register', 'woocommerce'); ?>"><?php esc_html_e('Register', 'woocommerce'); ?></button>
                                            <?php if (class_exists('WeDevs_Dokan')) { ?>
                                        <p class="text-divider">یا</p> <a
                                            href="<?php echo wc_get_page_permalink('myaccount'); ?>"
                                            class="btn btn-vendor w-100 mt-4" name="register" value="">ثبت نام
                                        فروشنده</a> <?php } ?>
                                        </p>

                                        <?php do_action('woocommerce_register_form_end'); ?>

                                    </form>
                                <?php } ?>                    </div>

                        </div>

                    </div>
                </div>
            <?php } ?>
        </div>
        <?php
    }
}
