<?php defined('ABSPATH') || exit;
$related = get_posts(array('category__in' => wp_get_post_categories(get_the_ID()), 'numberposts' => 6, 'post__not_in' => array(get_the_ID())));
if ($related) { ?>
    <div class="post_related">

        <div class="dej_heading_1">
            <div class="title">
                <h3><?php _e('مطالب مرتبط', 'dejavo'); ?></h3>
            </div>

            <div class="arrow_more">
                <div class="arrows">
                    <div class="dejavo_next_Arrow p_related"><i class="dej-angle-right"></i></div>
                    <div class="dejavo_prev_Arrow p_related"><i class="dej-angle-left"></i></div>
                </div>
            </div>
        </div>

        <div class="slides">
            <div dir="rtl" class="swiper Swiper_post_related">
                <div class="post_slider swiper-wrapper">
                    <?php foreach ($related as $post) {
                        setup_postdata($post); ?>
                        <div class="swiper-slide">
                            <?php get_template_part('template/post/card'); ?>
                        </div>
                    <?php }
                    wp_reset_postdata(); ?>
                </div>
            </div>

        </div>
        <script>
            var swiper = new Swiper(".Swiper_post_related", {
                speed: 400,
                spaceBetween: 10, slidesPerView: 3, watchSlidesProgress: true,
                navigation: {nextEl: ".dejavo_next_Arrow.p_related", prevEl: ".dejavo_prev_Arrow.p_related",},
                breakpoints: {
                    0: {slidesPerView: 2, speed: 300,},
                    640: {slidesPerView: 3,},
                },
                autoplay: {
                    delay: 5000,
                },
            });
        </script>
    </div>


<?php }
